/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ISentryExecutorService;
import io.sentry.ISentryLifecycleToken;
import io.sentry.util.AutoClosableReentrantLock;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class SentryExecutorService
implements ISentryExecutorService {
    @NotNull
    private final ScheduledExecutorService executorService;
    @NotNull
    private final AutoClosableReentrantLock lock = new AutoClosableReentrantLock();

    @TestOnly
    SentryExecutorService(@NotNull ScheduledExecutorService executorService) {
        this.executorService = executorService;
    }

    public SentryExecutorService() {
        this(Executors.newSingleThreadScheduledExecutor(new SentryExecutorServiceThreadFactory()));
    }

    @Override
    @NotNull
    public Future<?> submit(@NotNull Runnable runnable) {
        return this.executorService.submit(runnable);
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Callable<T> callable) {
        return this.executorService.submit(callable);
    }

    @Override
    @NotNull
    public Future<?> schedule(@NotNull Runnable runnable, long delayMillis) {
        return this.executorService.schedule(runnable, delayMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close(long timeoutMillis) {
        block9: {
            try (@NotNull ISentryLifecycleToken ignored = this.lock.acquire();){
                if (this.executorService.isShutdown()) break block9;
                this.executorService.shutdown();
                try {
                    if (!this.executorService.awaitTermination(timeoutMillis, TimeUnit.MILLISECONDS)) {
                        this.executorService.shutdownNow();
                    }
                }
                catch (InterruptedException e) {
                    this.executorService.shutdownNow();
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    @Override
    public boolean isClosed() {
        try (@NotNull ISentryLifecycleToken ignored = this.lock.acquire();){
            boolean bl = this.executorService.isShutdown();
            return bl;
        }
    }

    private static final class SentryExecutorServiceThreadFactory
    implements ThreadFactory {
        private int cnt;

        private SentryExecutorServiceThreadFactory() {
        }

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            Thread ret = new Thread(r, "SentryExecutorServiceThreadFactory-" + this.cnt++);
            ret.setDaemon(true);
            return ret;
        }
    }
}

