/*
 * Decompiled with CFR 0.152.
 */
package com.posthog.java;

import com.posthog.java.Sender;
import com.posthog.java.shaded.org.json.JSONObject;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class QueueManager
implements Runnable {
    private QueuePtr queue = new QueuePtr();
    private volatile boolean stop = false;
    private Instant sendAfter;
    private Sender sender;
    private int maxQueueSize;
    private Duration maxTimeInQueue;
    private int sleepMs;

    private QueueManager(Builder builder) {
        this.sender = builder.sender;
        this.maxQueueSize = builder.maxQueueSize;
        this.maxTimeInQueue = builder.maxTimeInQueue;
        this.sleepMs = builder.sleepMs;
    }

    public void stop() {
        this.stop = true;
    }

    public void add(JSONObject eventJson) {
        this.queue.add(eventJson);
    }

    public int queueSize() {
        return this.queue.size();
    }

    public void sendAll() {
        List<JSONObject> toSend = this.queue.retrieveAndReset();
        this.updateSendAfter();
        if (!toSend.isEmpty()) {
            this.sender.send(toSend);
        }
    }

    private void updateSendAfter() {
        this.sendAfter = Instant.now().plus(this.maxTimeInQueue);
    }

    private void sleep() {
        try {
            Thread.sleep(this.sleepMs);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.stop = true;
        }
    }

    @Override
    public void run() {
        this.updateSendAfter();
        while (!this.stop) {
            if (this.queue.size() < this.maxQueueSize && Instant.now().isBefore(this.sendAfter)) {
                this.sleep();
                continue;
            }
            this.sendAll();
        }
        this.sendAll();
    }

    public static class Builder {
        private final Sender sender;
        private int maxQueueSize = 50;
        private Duration maxTimeInQueue = Duration.ofSeconds(1L);
        private int sleepMs = 100;

        public Builder(Sender sender) {
            this.sender = sender;
        }

        public Builder maxQueueSize(int maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
            return this;
        }

        public Builder maxTimeInQueue(Duration duration) {
            this.maxTimeInQueue = duration;
            return this;
        }

        public Builder sleepMs(int sleepMs) {
            this.sleepMs = sleepMs;
            return this;
        }

        public QueueManager build() {
            return new QueueManager(this);
        }
    }

    class QueuePtr {
        public List<JSONObject> ptr = new LinkedList<JSONObject>();

        public synchronized int size() {
            return this.ptr.size();
        }

        public synchronized boolean isEmpty() {
            return this.ptr.isEmpty();
        }

        public synchronized void add(JSONObject json) {
            this.ptr.add(json);
        }

        public synchronized List<JSONObject> retrieveAndReset() {
            if (this.isEmpty()) {
                return Collections.emptyList();
            }
            List<JSONObject> cur = this.ptr;
            this.ptr = new LinkedList<JSONObject>();
            return cur;
        }
    }
}

