/*
 * Decompiled with CFR 0.152.
 */
package com.posthog.java;

import com.posthog.java.DefaultPostHogLogger;
import com.posthog.java.HttpSender;
import com.posthog.java.PostHogLogger;
import com.posthog.java.QueueManager;
import com.posthog.java.Sender;
import com.posthog.java.shaded.org.json.JSONException;
import com.posthog.java.shaded.org.json.JSONObject;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class PostHog {
    private final QueueManager queueManager;
    private Thread queueManagerThread;
    private final Sender sender;
    private final PostHogLogger logger;

    private PostHog(BuilderBase builder) {
        this.queueManager = builder.queueManager;
        this.sender = builder.sender;
        this.logger = builder.logger;
        this.startQueueManager();
    }

    public void shutdown() {
        this.queueManager.stop();
        try {
            this.queueManagerThread.join();
        }
        catch (InterruptedException e) {
            this.logger.error("Error shutting down PostHog", e);
        }
    }

    private void startQueueManager() {
        this.queueManagerThread = new Thread((Runnable)this.queueManager, "PostHog QueueManager thread");
        this.queueManagerThread.start();
    }

    private void enqueue(String distinctId, String event, Map<String, Object> properties) {
        JSONObject eventJson = this.getEventJson(event, distinctId, properties);
        this.queueManager.add(eventJson);
    }

    public void capture(String distinctId, String event, Map<String, Object> properties) {
        this.enqueue(distinctId, event, properties);
    }

    public void capture(String distinctId, String event) {
        this.enqueue(distinctId, event, null);
    }

    public void identify(String distinctId, Map<String, Object> properties, Map<String, Object> propertiesSetOnce) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (properties != null) {
            props.put("$set", properties);
        }
        if (propertiesSetOnce != null) {
            props.put("$set_once", propertiesSetOnce);
        }
        this.enqueue(distinctId, "$identify", props);
    }

    public void identify(String distinctId, Map<String, Object> properties) {
        this.identify(distinctId, properties, null);
    }

    public void alias(final String distinctId, final String alias) {
        HashMap<String, Object> props = new HashMap<String, Object>(){
            {
                this.put("distinct_id", distinctId);
                this.put("alias", alias);
            }
        };
        this.enqueue(distinctId, "$create_alias", (Map<String, Object>)props);
    }

    public void set(String distinctId, final Map<String, Object> properties) {
        HashMap<String, Object> props = new HashMap<String, Object>(){
            {
                this.put("$set", properties);
            }
        };
        this.enqueue(distinctId, "$set", (Map<String, Object>)props);
    }

    public void setOnce(String distinctId, final Map<String, Object> properties) {
        HashMap<String, Object> props = new HashMap<String, Object>(){
            {
                this.put("$set_once", properties);
            }
        };
        this.enqueue(distinctId, "$set_once", (Map<String, Object>)props);
    }

    private JSONObject getEventJson(String event, String distinctId, Map<String, Object> properties) {
        JSONObject eventJson = new JSONObject();
        try {
            eventJson.put("uuid", UUID.randomUUID().toString());
            eventJson.put("timestamp", Instant.now().toString());
            eventJson.put("distinct_id", distinctId);
            eventJson.put("event", event);
            eventJson.put("$lib", "posthog-java");
            if (properties != null) {
                eventJson.put("properties", properties);
            }
        }
        catch (JSONException e) {
            this.logger.error("Error creating event JSON", e);
        }
        return eventJson;
    }

    public boolean isFeatureFlagEnabled(String featureFlag, String distinctId) {
        if (this.getFeatureFlags(distinctId).get(featureFlag) == null) {
            return false;
        }
        return Boolean.parseBoolean(this.getFeatureFlags(distinctId).get(featureFlag));
    }

    public String getFeatureFlag(String featureFlag, String distinctId) {
        return this.getFeatureFlags(distinctId).get(featureFlag);
    }

    public String getFeatureFlagPayload(String featureFlag, String distinctId) {
        return this.getFeatureFlagPayloads(distinctId).get(featureFlag);
    }

    private HashMap<String, String> getFeatureFlags(String distinctId) {
        JSONObject response = this.sender.post("/decide/?v=3", distinctId);
        HashMap<String, String> featureFlags = new HashMap<String, String>();
        JSONObject flags = response.getJSONObject("featureFlags");
        for (String flag : flags.keySet()) {
            featureFlags.put(flag, flags.get(flag).toString());
        }
        return featureFlags;
    }

    private HashMap<String, String> getFeatureFlagPayloads(String distinctId) {
        JSONObject response = this.sender.post("/decide/?v=3", distinctId);
        HashMap<String, String> flagPayloads = new HashMap<String, String>();
        JSONObject payloads = response.getJSONObject("featureFlagPayloads");
        for (String flag : payloads.keySet()) {
            String payload = payloads.get(flag).toString();
            flagPayloads.put(flag, payload);
        }
        return flagPayloads;
    }

    private static abstract class BuilderBase {
        protected QueueManager queueManager;
        protected Sender sender;
        protected PostHogLogger logger = new DefaultPostHogLogger();

        private BuilderBase() {
        }
    }

    public static class BuilderWithCustomQueueManager
    extends BuilderBase {
        public BuilderWithCustomQueueManager(QueueManager queueManager, Sender ... sender) {
            this.queueManager = queueManager;
            if (sender.length > 0) {
                this.sender = sender[0];
            }
        }

        public PostHog build() {
            return new PostHog(this);
        }
    }

    public static class Builder
    extends BuilderBase {
        private final String apiKey;
        private String host = "https://app.posthog.com";

        public Builder(String apiKey) {
            this.apiKey = apiKey;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder logger(PostHogLogger logger) {
            this.logger = logger;
            return this;
        }

        public PostHog build() {
            this.sender = new HttpSender.Builder(this.apiKey).host(this.host).logger(this.logger).build();
            this.queueManager = new QueueManager.Builder(this.sender).build();
            return new PostHog(this);
        }
    }
}

