/*
 * Decompiled with CFR 0.152.
 */
package com.posthog.java;

import com.posthog.java.DefaultPostHogLogger;
import com.posthog.java.PostHogLogger;
import com.posthog.java.Sender;
import com.posthog.java.shaded.okhttp3.Call;
import com.posthog.java.shaded.okhttp3.MediaType;
import com.posthog.java.shaded.okhttp3.OkHttpClient;
import com.posthog.java.shaded.okhttp3.Request;
import com.posthog.java.shaded.okhttp3.RequestBody;
import com.posthog.java.shaded.okhttp3.Response;
import com.posthog.java.shaded.org.json.JSONException;
import com.posthog.java.shaded.org.json.JSONObject;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

public class HttpSender
implements Sender {
    private final String apiKey;
    private final String host;
    private final OkHttpClient client;
    private final int maxRetries;
    private final Duration initialRetryInterval;
    private final PostHogLogger logger;

    private HttpSender(Builder builder) {
        this.apiKey = builder.apiKey;
        this.host = builder.host;
        this.maxRetries = builder.maxRetries;
        this.initialRetryInterval = builder.initialRetryInterval;
        this.logger = builder.logger;
        this.client = new OkHttpClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean send(List<JSONObject> events) {
        if (events == null || events.isEmpty()) {
            return null;
        }
        String json = this.getRequestBody(events);
        Response response = null;
        int retries = 0;
        MediaType JSON = MediaType.parse("application/json; charset=utf-8");
        RequestBody body = RequestBody.create(json, JSON);
        while (true) {
            Request request = new Request.Builder().url(this.host + "/batch").post(body).build();
            Call call = this.client.newCall(request);
            try {
                response = call.execute();
                if (response.isSuccessful()) {
                    Boolean bl = true;
                    return bl;
                }
                if (response.code() >= 400 && response.code() < 500) {
                    System.out.println("Giving up on sending events to PostHog because of a HTTP Client error.");
                    Boolean bl = false;
                    return bl;
                }
            }
            catch (IOException e) {
                this.logger.error("Error sending events to PostHog", e);
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
            if (++retries > this.maxRetries) {
                System.out.println("Giving up on sending events to PostHog after " + retries + " retries.");
                return false;
            }
            long retryInterval = this.initialRetryInterval.toMillis() * (long)Math.pow(3.0, retries);
            this.logger.debug("Retrying sending events to PostHog after " + retries + " retries. Waiting for " + retryInterval + "ms before retrying.");
            try {
                Thread.sleep(retryInterval);
                continue;
            }
            catch (Exception e) {
                this.logger.error("Error sending events to PostHog", e);
                continue;
            }
            break;
        }
    }

    private String getRequestBody(List<JSONObject> events) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("api_key", this.apiKey);
            jsonObject.put("batch", events);
        }
        catch (JSONException e) {
            this.logger.error("Error creating event JSON", e);
        }
        return jsonObject.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject post(String route, String distinctId) {
        JSONObject bodyJSON = new JSONObject();
        try {
            bodyJSON.put("api_key", this.apiKey);
            bodyJSON.put("distinct_id", distinctId);
        }
        catch (JSONException e) {
            this.logger.error("Error creating event JSON", e);
        }
        Response response = null;
        MediaType JSON = MediaType.parse("application/json; charset=utf-8");
        RequestBody body = RequestBody.create(bodyJSON.toString(), JSON);
        Request request = new Request.Builder().url(this.host + route).post(body).build();
        Call call = this.client.newCall(request);
        try {
            response = call.execute();
            if (response.isSuccessful()) {
                JSONObject jSONObject = new JSONObject(response.body().string());
                return jSONObject;
            }
            if (response.code() >= 400 && response.code() < 500) {
                this.logger.error("Error calling API: " + response.body().string());
                JSONObject jSONObject = null;
                return jSONObject;
            }
        }
        catch (IOException e) {
            this.logger.error("Error calling API", e);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        return null;
    }

    public static class Builder {
        private final String apiKey;
        private String host = "https://app.posthog.com";
        private int maxRetries = 3;
        private Duration initialRetryInterval = Duration.ofMillis(500L);
        private PostHogLogger logger = new DefaultPostHogLogger();

        public Builder(String apiKey) {
            this.apiKey = apiKey;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder maxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder initialRetryInterval(Duration initialRetryInterval) {
            this.initialRetryInterval = initialRetryInterval;
            return this;
        }

        public Builder logger(PostHogLogger logger) {
            this.logger = logger;
            return this;
        }

        public HttpSender build() {
            return new HttpSender(this);
        }
    }
}

