/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.util;

import com.alibabacloud.intellij.cosy.chat.enums.TriggerPlaceEnum;
import com.alibabacloud.intellij.cosy.chat.model.LineRange;
import com.alibabacloud.intellij.cosy.chat.processor.ActionTriggerHelper;
import com.alibabacloud.intellij.cosy.constants.LingmaUrls;
import com.alibabacloud.intellij.cosy.util.CosyBrowserUtil;
import com.alibabacloud.intellij.cosy.util.EditorUtil;
import com.alibabacloud.intellij.cosy.util.FileUtil;
import com.alibabacloud.intellij.cosy.util.ProjectUtils;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import org.apache.commons.lang3.StringUtils;

public class UrlUtil {
    private static final Logger log = Logger.getInstance(UrlUtil.class);
    private static final String URL_REGEX = "^(http|https)://\\S*$";
    private static final Pattern URL_PATTERN = Pattern.compile("^(http|https)://\\S*$");
    private static final Pattern LINE_NUMBER_REGEX = Pattern.compile("^L(\\d+)-L(\\d+)$");

    public static boolean verifyDomain(String domainUrl) {
        Matcher matcher = URL_PATTERN.matcher(domainUrl);
        if (matcher.matches()) {
            return true;
        }
        log.info(String.format("Domain is not valid: %s", domainUrl));
        return false;
    }

    public static boolean performHyperlink(Project project, HyperlinkEvent e, JComponent component) {
        String command;
        if (project == null) {
            project = component != null ? ProjectUtil.guessCurrentProject((JComponent)component) : ProjectUtils.getActiveProject();
        }
        if (StringUtils.isEmpty((CharSequence)(command = e.getDescription()))) {
            return false;
        }
        if (command.startsWith("http")) {
            BrowserUtil.browse((String)command);
            return true;
        }
        if (command.startsWith("action:")) {
            if (project == null) {
                log.warn("project is null");
                return false;
            }
            String actionId = command.substring("action:".length());
            ActionTriggerHelper.triggerSelectionAction(project, actionId, TriggerPlaceEnum.TOOL_WINDOW.getName(), component, null);
            return true;
        }
        if (command.startsWith("url:")) {
            String refId = command.substring("url:".length());
            LingmaUrls url = LingmaUrls.fromRefId(refId);
            if (url != null) {
                return CosyBrowserUtil.browse(url);
            }
            log.warn("can not find url refId: " + refId);
        } else if (command.startsWith("file://")) {
            if (project == null) {
                log.warn("project is null");
                return false;
            }
            String filePath = command.substring("file://".length());
            if (StringUtils.isNotBlank((CharSequence)filePath)) {
                String baseDir;
                LineRange lineRange = null;
                int lineIndex = filePath.lastIndexOf("#");
                if (lineIndex > 0) {
                    lineRange = UrlUtil.parseUrlLineRange(filePath);
                    filePath = filePath.substring(0, lineIndex);
                }
                if (!FileUtil.isAbsolutePath(filePath = filePath.replace('/', File.separatorChar)) && (baseDir = ProjectUtils.getProjectBaseDir(ProjectUtils.getActiveProject())) != null) {
                    filePath = new File(baseDir, filePath).getAbsolutePath();
                }
                EditorUtil.openEditorFile(project, filePath, lineRange, component);
            }
        }
        return false;
    }

    private static LineRange parseUrlLineRange(String path) {
        int lineIndex = path.lastIndexOf("#");
        if (lineIndex <= 0) {
            return null;
        }
        String lineStr = path.substring(lineIndex + 1);
        if (StringUtils.isBlank((CharSequence)lineStr)) {
            return null;
        }
        try {
            Matcher matcher = LINE_NUMBER_REGEX.matcher(lineStr);
            if (matcher.matches()) {
                int startLine = Integer.parseInt(matcher.group(1));
                int endLine = Integer.parseInt(matcher.group(2));
                return new LineRange(startLine, endLine);
            }
        }
        catch (Exception e) {
            log.warn("parse url line range error: " + path, (Throwable)e);
        }
        return null;
    }
}

