/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.util;

import com.alibabacloud.intellij.cosy.search.asyn.Debouncer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class TypingSpeeder {
    private static final int MAX_DEBOUNCE_TIME = 1500;
    private static final int MAX_INTERVAL = 1000;
    private Debouncer typeResetDebouncer = new Debouncer();
    private AtomicLong startTime = new AtomicLong(System.currentTimeMillis());
    private AtomicLong lastTime = new AtomicLong(System.currentTimeMillis());
    private AtomicLong endTime = new AtomicLong(System.currentTimeMillis());
    private AtomicLong charactersTyped = new AtomicLong(0L);
    private AtomicBoolean firstTyped = new AtomicBoolean(true);
    private AtomicReference<String> lastTypedChars = new AtomicReference<Object>(null);
    private AtomicReference<String> currentTypedChars = new AtomicReference<Object>(null);
    private AtomicInteger lastTypedCharRow = new AtomicInteger(-1);
    private AtomicInteger currentTypedCharRow = new AtomicInteger(-1);

    public TypingSpeeder() {
        this.reset();
    }

    public void reset() {
        long time = System.currentTimeMillis();
        this.startTime.getAndSet(time);
        this.lastTime.getAndSet(time);
        this.endTime.getAndSet(time);
        this.firstTyped.getAndSet(true);
        this.charactersTyped.getAndSet(0L);
        this.currentTypedChars.set(null);
    }

    public void clear() {
        this.reset();
        this.lastTypedChars.set(null);
        this.lastTypedCharRow.set(-1);
        this.currentTypedCharRow.set(-1);
    }

    public double getAvgSpeed() {
        double timeInSeconds = this.endTime.get() - this.startTime.get();
        if (timeInSeconds == 0.0 || this.charactersTyped.get() == 0L) {
            return -1.0;
        }
        double avgTime = timeInSeconds / (double)this.charactersTyped.get();
        if (avgTime > 1000.0) {
            return -1.0;
        }
        return avgTime;
    }

    public double getLastSpeed() {
        double result = this.endTime.get() - this.lastTime.get();
        if (result == 0.0 || result > 1000.0) {
            return -1.0;
        }
        return result;
    }

    public String getLastTypedChars() {
        return this.lastTypedChars.get();
    }

    public String getCurrentTypedChars() {
        return this.currentTypedChars.get();
    }

    public Integer getTypedCharRowDiff() {
        if (this.lastTypedCharRow.get() < 0 || this.currentTypedCharRow.get() < 0) {
            return null;
        }
        return this.currentTypedCharRow.get() - this.lastTypedCharRow.get();
    }

    public long getTypedLength() {
        return this.charactersTyped.get();
    }

    public synchronized void keyTyped(String typedChars) {
        if (typedChars.length() != 1) {
            return;
        }
        if (this.firstTyped.getAndSet(false)) {
            this.startTime.getAndSet(System.currentTimeMillis());
        } else {
            this.charactersTyped.incrementAndGet();
        }
        long last = this.endTime.getAndSet(System.currentTimeMillis());
        this.lastTime.getAndSet(last);
        this.typeResetDebouncer.debounce(this::reset, 1500L, TimeUnit.MILLISECONDS);
    }

    public synchronized void recordTyping(Editor editor, String typedChars) {
        Integer lastRow;
        if (typedChars.length() != 1) {
            return;
        }
        LogicalPosition position = editor.getCaretModel().getLogicalPosition();
        int line = position.line;
        String lastChars = this.currentTypedChars.getAndSet(typedChars);
        if (lastChars != null) {
            this.lastTypedChars.getAndSet(lastChars);
        }
        if ((lastRow = Integer.valueOf(this.currentTypedCharRow.getAndSet(line))) != null) {
            this.lastTypedCharRow.getAndSet(lastRow);
        }
    }
}

