/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.util;

import com.alibabacloud.intellij.cosy.ui.search.I18NConstant;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

public class SwingUtil {
    private static final Logger logger = Logger.getInstance(SwingUtil.class);
    private static final int LICENSE_POPUP_MIN_WIDTH = 200;
    private static final String HIGHLIGHT_TAG_NAME = "em";
    private static final String ELLIPSIS_STRING = "...";

    public static javax.swing.text.Document highlightDocument(@NotNull String originalText, SimpleAttributeSet highlightAttributes, SimpleAttributeSet normalAttributes) {
        if (originalText == null) {
            SwingUtil.$$$reportNull$$$0(0);
        }
        DefaultStyledDocument document = null;
        try {
            Document doc = Jsoup.parse((String)originalText);
            document = new DefaultStyledDocument();
            int staroffset = 0;
            if (doc.body() != null && doc.body().childNodes() != null) {
                for (Node node : doc.body().childNodes()) {
                    if (node instanceof Element && HIGHLIGHT_TAG_NAME.equals(((Element)node).tagName())) {
                        document.insertString(staroffset, ((Element)node).text(), highlightAttributes);
                    } else if (node instanceof TextNode) {
                        document.insertString(staroffset, ((TextNode)node).text(), normalAttributes);
                    } else {
                        document.insertString(staroffset, node.toString().replace("\n", " "), normalAttributes);
                    }
                    staroffset = document.getLength();
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return document;
    }

    public static javax.swing.text.Document highlightCutterDocument(@NotNull String originalText, SimpleAttributeSet highlightAttributes, SimpleAttributeSet normalAttributes, JComponent component, int padding) {
        DefaultStyledDocument document;
        block4: {
            if (originalText == null) {
                SwingUtil.$$$reportNull$$$0(1);
            }
            double maxWidth = component.getSize().width == 0 ? component.getPreferredSize().getWidth() : component.getSize().getWidth();
            Font font = component.getFont();
            Rectangle2D ellipsisRec = SwingUtil.getStringFontSize(ELLIPSIS_STRING, font);
            double ellipsisWidth = ellipsisRec.getWidth();
            double remainWidth = maxWidth - (double)component.getInsets().left - (double)component.getInsets().right - (double)padding - ellipsisWidth;
            document = null;
            try {
                Document doc = Jsoup.parse((String)originalText);
                document = new DefaultStyledDocument();
                int staroffset = 0;
                if (doc.body() == null || doc.body().childNodes() == null) break block4;
                for (Node node : doc.body().childNodes()) {
                    remainWidth = node instanceof Element && HIGHLIGHT_TAG_NAME.equals(((Element)node).tagName()) ? SwingUtil.insertDocument(document, font, staroffset, ((Element)node).text(), highlightAttributes, remainWidth) : (node instanceof TextNode ? SwingUtil.insertDocument(document, font, staroffset, ((TextNode)node).text(), normalAttributes, remainWidth) : SwingUtil.insertDocument(document, font, staroffset, node.toString().replace("\n", " "), normalAttributes, remainWidth));
                    staroffset = document.getLength();
                    if (!(remainWidth <= 0.0)) continue;
                    document.insertString(staroffset, ELLIPSIS_STRING, normalAttributes);
                    break;
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return document;
    }

    private static double insertDocument(javax.swing.text.Document document, Font font, int offset, String text, AttributeSet attrs, double remainWidth) throws BadLocationException {
        char ch;
        double charWidth;
        StringBuilder sb = new StringBuilder();
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n && (remainWidth -= (charWidth = SwingUtil.getStringFontSize(String.valueOf(ch = cArray[i]), font).getWidth())) >= 0.0; ++i) {
            sb.append(ch);
        }
        if (sb.length() > 0) {
            document.insertString(offset, sb.toString(), attrs);
        }
        return remainWidth;
    }

    public static Rectangle2D getStringFontSize(String text, Font font) {
        if ("".equals(text)) {
            return new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
        }
        AffineTransform affinetransform = new AffineTransform();
        FontRenderContext frc = new FontRenderContext(affinetransform, true, true);
        return font.getStringBounds(text, frc);
    }

    public static BufferedImage makeRoundedCorner(BufferedImage image, int cornerRadius, Component targetComponent) {
        Container parent = SwingUtilities.getUnwrappedParent(targetComponent);
        return SwingUtil.makeRoundedCorner(image, cornerRadius, parent.getBackground());
    }

    public static BufferedImage makeRoundedCorner(BufferedImage image, int cornerRadius, Color bgColor) {
        int w = image.getWidth();
        int h = image.getHeight();
        BufferedImage output = new BufferedImage(w, h, 2);
        Graphics2D g2 = output.createGraphics();
        g2.setComposite(AlphaComposite.Src);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setColor(bgColor);
        g2.fill(new RoundRectangle2D.Float(0.0f, 0.0f, w, h, cornerRadius, cornerRadius));
        g2.setComposite(AlphaComposite.SrcAtop);
        g2.drawImage((Image)image, 0, 0, null);
        g2.dispose();
        return output;
    }

    public static String getCutterText(JComponent component, String content, int padding) {
        double charWidth;
        double maxWidth = component.getSize().width == 0 ? component.getPreferredSize().getWidth() : component.getSize().getWidth();
        Font font = component.getFont();
        Rectangle2D ellipsisRec = SwingUtil.getStringFontSize(ELLIPSIS_STRING, font);
        double ellipsisWidth = ellipsisRec.getWidth();
        double remainWidth = maxWidth - (double)component.getInsets().left - (double)component.getInsets().right - (double)padding - ellipsisWidth;
        StringBuilder sb = new StringBuilder();
        double bufferWidth = 0.0;
        for (char ch : content.toCharArray()) {
            charWidth = SwingUtil.getStringFontSize(String.valueOf(ch), font).getWidth();
            if (!((bufferWidth += charWidth) < remainWidth)) continue;
            sb.append(ch);
        }
        if (!sb.toString().equals(content)) {
            char ch;
            remainWidth -= ellipsisWidth;
            bufferWidth = 0.0;
            sb = new StringBuilder();
            char[] cArray = content.toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n && (bufferWidth += (charWidth = SwingUtil.getStringFontSize(String.valueOf(ch = cArray[i]), font).getWidth())) < remainWidth; ++i) {
                sb.append(ch);
            }
            sb.append(ELLIPSIS_STRING);
        }
        return sb.toString();
    }

    public static JBPopup createLicensePopup(String license) {
        String message = StringUtils.isNotBlank((CharSequence)license) ? String.format("%s: %s", I18NConstant.DATA_LICENSE_TEXT, license) : I18NConstant.INVALID_DATA_LICENSE_TEXT;
        return SwingUtil.createSingleMessagePopup(message, new SingleLineTextListCellRenderer(200));
    }

    public static JBPopup createSingleMessagePopup(String message, ListCellRenderer<String> render) {
        List<String> datas = Collections.singletonList(message);
        IPopupChooserBuilder builder = JBPopupFactory.getInstance().createPopupChooserBuilder(datas);
        builder.setRenderer(render);
        return builder.createPopup();
    }

    public static void setComponentBackgroudColor(JComponent component, Color bgColor, Class<?> ... excludeClasses) {
        LinkedList<JComponent> componentList = new LinkedList<JComponent>();
        componentList.offer(component);
        while (componentList.size() > 0) {
            JComponent child = (JComponent)componentList.poll();
            if (child == null) continue;
            child.setBackground(bgColor);
            for (Component com : child.getComponents()) {
                if (!(com instanceof JComponent) || excludeClasses != null && !Arrays.stream(excludeClasses).noneMatch(e -> e.isInstance(com))) continue;
                componentList.offer((JComponent)com);
            }
        }
    }

    public static void foreachChildComponent(JComponent component, Consumer<JComponent> handler) {
        LinkedList<JComponent> componentList = new LinkedList<JComponent>();
        componentList.offer(component);
        while (componentList.size() > 0) {
            JComponent child = (JComponent)componentList.poll();
            if (child == null) continue;
            handler.accept(child);
            for (Component com : child.getComponents()) {
                if (!(com instanceof JComponent)) continue;
                componentList.offer((JComponent)com);
            }
        }
    }

    public static boolean isScrollBarAtBottom(JScrollPane scrollPane) {
        JViewport viewport = scrollPane.getViewport();
        Rectangle viewRect = viewport.getViewRect();
        Component view = viewport.getView();
        Dimension viewSize = view.getSize();
        int viewportBottom = viewRect.y + viewRect.height;
        return viewportBottom >= viewSize.height;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "originalText";
        objectArray2[1] = "com/alibabacloud/intellij/cosy/util/SwingUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightDocument";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightCutterDocument";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class SingleLineTextListCellRenderer
    implements ListCellRenderer<String> {
        int minWidth;

        public SingleLineTextListCellRenderer(int minWidth) {
            this.minWidth = minWidth;
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
            JPanel panel = new JPanel(new BorderLayout()){

                @Override
                public Dimension getPreferredSize() {
                    Dimension dim = super.getPreferredSize();
                    if (dim.width < minWidth) {
                        dim.width = minWidth;
                    }
                    return dim;
                }
            };
            JLabel label = new JLabel(value);
            label.setBorder(BorderFactory.createEmptyBorder(4, 10, 4, 10));
            panel.add((Component)label, "Center");
            return panel;
        }
    }
}

