/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.util;

import com.alibabacloud.intellij.cosy.common.BuildFeature;
import com.alibabacloud.intellij.cosy.common.CosyConfig;
import com.alibabacloud.intellij.cosy.constants.InputConstants;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.cosy.ui.search.model.SuggestPrompt;
import com.alibabacloud.intellij.cosy.util.LoginUtil;
import com.intellij.openapi.project.Project;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SuggestPromptUtil {
    public static Map<String, SuggestPrompt> getAgentSuggestPrompt(Project project) {
        if (CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false)) {
            return new HashMap<String, SuggestPrompt>();
        }
        return InputConstants.AGENT_SUGGEST_PROMPT_MAP;
    }

    public static Map<String, SuggestPrompt> getScopeSuggestPrompt(Project project) {
        AuthStatus authStatus = LoginUtil.getAuthStatusCacheFirst(project);
        if (StringUtils.isNotBlank((CharSequence)authStatus.getOrgName())) {
            return InputConstants.SCOPE_SUGGEST_PROMPT_MAP;
        }
        return new HashMap<String, SuggestPrompt>();
    }

    public static Map<String, SuggestPrompt> getAllSuggestPromptOfTag(Project project) {
        HashMap<String, SuggestPrompt> allSuggestPromptMap = new HashMap<String, SuggestPrompt>();
        allSuggestPromptMap.putAll(InputConstants.WELCOMING_SUGGEST_PROMPT_MAP);
        allSuggestPromptMap.putAll(SuggestPromptUtil.getAgentSuggestPrompt(project));
        allSuggestPromptMap.putAll(SuggestPromptUtil.getScopeSuggestPrompt(project));
        return allSuggestPromptMap;
    }

    public static Map<String, SuggestPrompt> getAllSuggestPrompt(Project project) {
        HashMap<String, SuggestPrompt> allSuggestPromptMap = new HashMap<String, SuggestPrompt>();
        allSuggestPromptMap.putAll(InputConstants.WELCOMING_SUGGEST_PROMPT_MAP);
        allSuggestPromptMap.putAll(InputConstants.CONTEXT_SUGGEST_PROMPT_MAP);
        allSuggestPromptMap.putAll(InputConstants.WELCOMING_HELP_MAP);
        allSuggestPromptMap.putAll(SuggestPromptUtil.getAgentSuggestPrompt(project));
        allSuggestPromptMap.putAll(SuggestPromptUtil.getScopeSuggestPrompt(project));
        return allSuggestPromptMap;
    }
}

