/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class StringUtils {
    private static Logger logger = Logger.getInstance(StringUtils.class);
    public static String FOUR_SPACE_TAB = "    ";
    public static String TAB = "\t";
    public static String TAB_SPACE_PATTERN = "[\t ]*";
    public static final String HTML_TAG_PATTERN = "\\<.*?>";
    public static final String WHITESPACE_PATTERN = "\\s+";
    private static final int INDENT_COUNT = 4;

    public static String countLeadingLength(String str, String pattern) {
        Pattern p = Pattern.compile("^" + pattern);
        Matcher m = p.matcher(str);
        if (m.find()) {
            return m.group();
        }
        return "";
    }

    public static String tabContent(String leadingContent) {
        if (leadingContent.matches("(" + FOUR_SPACE_TAB + ")+")) {
            return FOUR_SPACE_TAB;
        }
        return TAB;
    }

    public static String removeAngleBrackets(String clazz) {
        if (clazz.contains("<")) {
            return clazz.substring(0, clazz.indexOf(60));
        }
        return clazz;
    }

    public static String removeBrackets(String clazz) {
        if (clazz.contains("[")) {
            return clazz.substring(0, clazz.indexOf(91));
        }
        return clazz;
    }

    public static String extractClassNameFromFullPath(String fullPath) {
        if (fullPath == null) {
            return null;
        }
        if (!fullPath.contains(".")) {
            return fullPath;
        }
        return fullPath.substring(fullPath.lastIndexOf(".") + 1);
    }

    public static boolean isJavaLineEnding(String lineContent) {
        return org.apache.commons.lang3.StringUtils.isBlank((CharSequence)lineContent) || lineContent.endsWith(";") || lineContent.endsWith("{") || lineContent.endsWith("*/") || lineContent.startsWith("//");
    }

    @Contract(pure=true)
    @NotNull
    public static String removeHtmlTags(@NotNull String text) {
        if (text == null) {
            StringUtils.$$$reportNull$$$0(0);
        }
        String string = text.replaceAll(HTML_TAG_PATTERN, "");
        if (string == null) {
            StringUtils.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String removeWhitespace(@NotNull String text) {
        if (text == null) {
            StringUtils.$$$reportNull$$$0(2);
        }
        String string = text.replaceAll(WHITESPACE_PATTERN, "");
        if (string == null) {
            StringUtils.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static final String removeHtmlTagsAndWhitespace(String text) {
        return StringUtils.removeHtmlTags(StringUtils.removeWhitespace(text));
    }

    public static final String convertShortNumber(long number) {
        Object numberStr = String.valueOf(number);
        Locale locale = Locale.getDefault();
        if (Locale.CHINESE.equals(locale)) {
            if (((String)numberStr).length() > 5) {
                numberStr = ((String)numberStr).substring(0, ((String)numberStr).length() - 4) + "\u4e07";
            }
        } else if (((String)numberStr).length() > 6) {
            String formatNum = String.format("%.1f", Float.valueOf((float)number / 1000000.0f));
            numberStr = formatNum + "m";
        } else if (((String)numberStr).length() > 3) {
            String formatNum = String.format("%.1f", Float.valueOf((float)number / 1000.0f));
            numberStr = formatNum + "k";
        }
        return numberStr;
    }

    public static int countHeadWhitespaceLength(@NotNull String text) {
        char ch;
        int offset;
        if (text == null) {
            StringUtils.$$$reportNull$$$0(4);
        }
        int length = text.length();
        for (offset = 0; offset < length && (ch = text.charAt(offset)) != '\n' && Character.isWhitespace(ch); ++offset) {
        }
        return offset;
    }

    public static boolean isTabSpace(char c, boolean withNewline) {
        return c == ' ' || c == '\t' || withNewline && c == '\n';
    }

    public static boolean isTabsSpaces(String text, boolean withNewlines) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (StringUtils.isTabSpace(c, withNewlines)) continue;
            return false;
        }
        return true;
    }

    public static List<String> replaceHeadTabs(@NotNull List<String> lines, boolean useTabs, int tabWidth) {
        if (lines == null) {
            StringUtils.$$$reportNull$$$0(5);
        }
        return lines.stream().map(line -> StringUtils.replaceHeadTabs(line, useTabs, tabWidth)).collect(Collectors.toList());
    }

    public static String replaceHeadTabs(String line, boolean useTabs, int tabWidth) {
        int tabCount = StringUtil.countChars((CharSequence)line, (char)'\t', (int)0, (boolean)true);
        if (tabCount > 0 && !useTabs) {
            String tabSpaces = StringUtil.repeatSymbol((char)' ', (int)(tabCount * tabWidth));
            return tabSpaces + line.substring(tabCount);
        }
        return line;
    }

    public static String upperFirstLetter(String content) {
        if (content == null || content.isEmpty()) {
            return content;
        }
        return content.substring(0, 1).toUpperCase() + content.substring(1);
    }

    public static Long getNumberFromString(String line) {
        try {
            return Long.parseLong(line);
        }
        catch (NumberFormatException e) {
            logger.warn("Failed to parse number from string: " + line + " try using pattern.");
            try {
                return Long.parseLong(line.replaceAll("\\D+", ""));
            }
            catch (NumberFormatException e1) {
                logger.warn("Failed to parse number using regex: " + line);
                return null;
            }
        }
    }

    public static String makeIndentationConsistent(String rawText, String modelText) {
        String modelTextIndent;
        String rawTextIndent = StringUtils.getMinIndentation(rawText);
        if (rawTextIndent.equals(modelTextIndent = StringUtils.getMinIndentation(modelText))) {
            return modelText;
        }
        ArrayList<CallSite> finalLines = new ArrayList<CallSite>();
        for (String modelLine : modelText.split("\\r?\\n")) {
            if (!modelLine.startsWith(modelTextIndent)) continue;
            finalLines.add((CallSite)((Object)(rawTextIndent + modelLine.substring(modelTextIndent.length()))));
        }
        return StringUtil.join(finalLines, (String)"\n");
    }

    public static String getMinIndentation(String text) {
        String[] lines = text.split("\\r?\\n");
        ArrayList<Integer> lineIndents = new ArrayList<Integer>();
        int minIndent = Integer.MAX_VALUE;
        int indentChar = 32;
        for (String line : lines) {
            if (line.trim().isEmpty()) continue;
            int indent = StringUtils.countIndent(line);
            if (indent > 0) {
                indentChar = line.charAt(0);
            }
            lineIndents.add(indent);
            minIndent = Math.min(minIndent, indent);
        }
        int commonIndent = StringUtils.findCommonIndent(lineIndents);
        if (commonIndent > 0 && commonIndent < Integer.MAX_VALUE) {
            if (indentChar == 9 && commonIndent % 4 == 0) {
                int tabCount = commonIndent / 4;
                return StringUtil.repeatSymbol((char)'\t', (int)tabCount);
            }
            return StringUtil.repeatSymbol((char)' ', (int)commonIndent);
        }
        return "";
    }

    private static int countIndent(String line) {
        int indent = 0;
        for (char c : line.toCharArray()) {
            if (c == ' ') {
                ++indent;
                continue;
            }
            if (c != '\t') break;
            indent += 4;
        }
        return indent;
    }

    private static int findCommonIndent(List<Integer> lineIndents) {
        if (CollectionUtils.isEmpty(lineIndents)) {
            return 0;
        }
        int commonIndent = lineIndents.get(0);
        for (int i = 1; i < lineIndents.size(); ++i) {
            commonIndent = Math.min(commonIndent, lineIndents.get(i));
        }
        return commonIndent;
    }

    public static boolean matchCopyContent(String source, String target) {
        String[] targetLines;
        String targetTrim;
        if (source == null || target == null) {
            return false;
        }
        String sourceTrim = source.trim();
        if (sourceTrim.equals(targetTrim = target.trim())) {
            return true;
        }
        String[] sourceLines = sourceTrim.split("\\r?\\n");
        if (sourceLines.length != (targetLines = targetTrim.split("\\r?\\n")).length) {
            return false;
        }
        for (int i = 0; i < sourceLines.length; ++i) {
            String sourceLine = sourceLines[i];
            String targetLine = targetLines[i];
            if (sourceLine.trim().equals(targetLine.trim())) continue;
            return false;
        }
        return true;
    }

    public static long getNotEmptyLineCount(String text) {
        if (text == null) {
            return 0L;
        }
        return Arrays.stream(text.split("\n")).filter(line -> !line.trim().isEmpty()).count();
    }

    public static String replaceFirst(String content, String oldText, String newText) {
        if (content == null || oldText == null || newText == null) {
            logger.info("content == null || oldText == null || newText == null when replaceFirst");
            return content;
        }
        int firstOccurrence = content.indexOf(oldText);
        if (firstOccurrence != -1) {
            String replacedPart = content.substring(0, firstOccurrence) + newText;
            String restOfTheString = content.substring(firstOccurrence + oldText.length());
            return replacedPart + restOfTheString;
        }
        logger.info("Failed to replace first occurrence of '" + oldText + "' in '" + content + "'");
        return content;
    }

    public static String removeEmojis(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        return text.replaceAll("[^\\p{L}\\p{M}\\p{N}\\p{P}\\p{Z}\\p{Cf}\\p{Cs}\\s~$^+`=|<>]", "");
    }

    public static String truncateMiddle(String inputStr, int maxLength) {
        if (inputStr == null || maxLength <= 0) {
            throw new IllegalArgumentException("Invalid input: string is null or maxLength is non-positive.");
        }
        if (inputStr.length() <= maxLength) {
            return inputStr;
        }
        int sideLength = (maxLength - 3) / 2;
        String frontPart = inputStr.substring(0, sideLength + maxLength % 2);
        String backPart = inputStr.substring(inputStr.length() - sideLength);
        return frontPart + "..." + backPart;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/alibabacloud/intellij/cosy/util/StringUtils";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/alibabacloud/intellij/cosy/util/StringUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "removeHtmlTags";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "removeWhitespace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "removeHtmlTags";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeWhitespace";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "countHeadWhitespaceLength";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "replaceHeadTabs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

