/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.util;

import com.alibabacloud.intellij.cosy.common.CosyCacheKeys;
import com.alibabacloud.intellij.cosy.common.CosyConfig;
import com.alibabacloud.intellij.cosy.util.JavaPsiUtils;
import com.alibabacloud.intellij.cosy.util.ReflectUtil;
import com.intellij.execution.filters.ExceptionWorker;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralValue;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPlainText;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class PsiUtils {
    private static final Logger log = Logger.getInstance(PsiUtils.class);
    public static final String IDENTIFIER = "IDENTIFIER";
    public static final String DEFAULT_CLASS_NAME = "DemoClass";
    private static final List<String> commentFlags = Arrays.asList("/", "#", "\"\"\"", "'''");
    private static final TokenSet INVALID_COMMON_TOKENSET = TokenSet.create((IElementType[])new IElementType[]{TokenType.BAD_CHARACTER, TokenType.WHITE_SPACE, TokenType.NEW_LINE_INDENT, TokenType.ERROR_ELEMENT});
    private static final String[] FILE_TYPE_CLASSES = new String[]{"com.intellij.ide.highlighter.JavaFileType", "com.jetbrains.python.PythonFileType", "com.goide.GoFileType"};

    public static String parsePsiType(PsiType psiType) {
        if (psiType == null) {
            return "";
        }
        return psiType.getPresentableText();
    }

    public static boolean isPrivateModifier(PsiModifierListOwner psiModifierListOwner) {
        if (psiModifierListOwner == null || psiModifierListOwner.getModifierList() == null) {
            return false;
        }
        return psiModifierListOwner.getModifierList().hasModifierProperty("private".trim());
    }

    public static boolean isPublicModifier(PsiModifierListOwner psiModifierListOwner) {
        if (psiModifierListOwner == null || psiModifierListOwner.getModifierList() == null) {
            return false;
        }
        return psiModifierListOwner.getModifierList().hasModifierProperty("public".trim());
    }

    public static boolean isProtectedModifier(PsiModifierListOwner psiModifierListOwner) {
        if (psiModifierListOwner == null || psiModifierListOwner.getModifierList() == null) {
            return false;
        }
        return psiModifierListOwner.getModifierList().hasModifierProperty("protected".trim());
    }

    public static PsiMethod[] getMethodsFromPsiClass(PsiClass psiClass, boolean isStatic, String prefix, Predicate<PsiModifierListOwner> visibilityPredicator) {
        if (psiClass == null) {
            return new PsiMethod[0];
        }
        if (prefix == null) {
            prefix = "";
        }
        String finalPrefix = prefix;
        PsiMethod[] methods = new PsiMethod[]{};
        try {
            methods = Arrays.stream(psiClass.getAllMethods()).filter(psiMethod -> {
                if (!psiMethod.getName().toLowerCase().startsWith(finalPrefix)) {
                    return false;
                }
                return !isStatic || psiMethod.hasModifier(JvmModifier.STATIC);
            }).filter(visibilityPredicator).collect(Collectors.toList()).toArray(new PsiMethod[0]);
        }
        catch (PsiInvalidElementAccessException psiInvalidElementAccessException) {
            log.warn("Get all methods encountered PsiInvalidElementAccessException" + psiInvalidElementAccessException.getMessage());
        }
        return methods;
    }

    public static PsiField[] getFieldsFromPsiClass(PsiClass psiClass, boolean isStatic, String prefix, Predicate<PsiModifierListOwner> visibilityPredicator) {
        if (psiClass == null) {
            return new PsiField[0];
        }
        if (prefix == null) {
            prefix = "";
        }
        String finalPrefix = prefix;
        PsiField[] fields = Arrays.stream(psiClass.getAllFields()).filter(psiField -> {
            if (!psiField.getName().toLowerCase().startsWith(finalPrefix)) {
                return false;
            }
            return !isStatic || psiField.hasModifier(JvmModifier.STATIC);
        }).filter(visibilityPredicator).collect(Collectors.toList()).toArray(new PsiField[0]);
        return fields;
    }

    public static PsiElement skipEmptyAndJavaTokenForward(PsiElement psiElement) {
        if (psiElement == null) {
            return null;
        }
        for (PsiElement next = psiElement.getNextSibling(); next != null; next = next.getNextSibling()) {
            boolean notIdentifierToken = next instanceof PsiJavaToken && !IDENTIFIER.equals(((PsiJavaToken)next).getTokenType().toString());
            boolean isEmpty = next.getText().isEmpty();
            boolean isWhitespace = next instanceof PsiWhiteSpace;
            boolean isComment = next instanceof PsiComment;
            if (isEmpty || isWhitespace || isComment || notIdentifierToken) {
                continue;
            }
            return next;
        }
        return null;
    }

    public static PsiClass getContainingClass(PsiElement psiElement) {
        return (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class);
    }

    public static String getPackageName(PsiClass psiClass) {
        PsiFile psiFile = psiClass.getContainingFile();
        if (psiFile instanceof PsiJavaFile) {
            return ((PsiJavaFile)psiFile).getPackageName();
        }
        return "";
    }

    public static Predicate<PsiModifierListOwner> generateVisibilityPredicator(PsiClass psiClass, PsiClass contextClass) {
        Predicate<PsiModifierListOwner> defaultPublicPredicator = new Predicate<PsiModifierListOwner>(){

            @Override
            public boolean test(PsiModifierListOwner psiModifierListOwner) {
                return PsiUtils.isPublicModifier(psiModifierListOwner);
            }
        };
        if (psiClass == null || contextClass == null) {
            return defaultPublicPredicator;
        }
        String psiClassName = psiClass.getQualifiedName();
        String psiClassPackage = PsiUtils.getPackageName(psiClass);
        String contextClassName = contextClass.getQualifiedName();
        String contextClassPackage = PsiUtils.getPackageName(contextClass);
        final boolean hasEmpty = StringUtils.isEmpty((CharSequence)psiClassPackage) || StringUtils.isEmpty((CharSequence)contextClassPackage) || StringUtils.isEmpty((CharSequence)psiClassName) || StringUtils.isEmpty((CharSequence)contextClassName);
        final boolean isPackageMatch = contextClassPackage.equals(psiClassPackage);
        final boolean isClassNameMatch = contextClassPackage.equals(psiClassName);
        Predicate<PsiModifierListOwner> predicator = new Predicate<PsiModifierListOwner>(){

            @Override
            public boolean test(PsiModifierListOwner psiModifierListOwner) {
                if (hasEmpty || !isPackageMatch) {
                    return PsiUtils.isPublicModifier(psiModifierListOwner);
                }
                if (isPackageMatch && !isClassNameMatch) {
                    return !PsiUtils.isPrivateModifier(psiModifierListOwner);
                }
                return true;
            }
        };
        return predicator;
    }

    public static boolean isNotInClassElement(PsiElement element, @NotNull Editor editor) {
        PsiErrorElement el;
        String filePath;
        VirtualFile virtualFile;
        if (editor == null) {
            PsiUtils.$$$reportNull$$$0(0);
        }
        if ((virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument())) != null && !(filePath = virtualFile.getPath()).endsWith(".java")) {
            return false;
        }
        if (PsiUtils.instanceOf((Object)element, "com.intellij.psi.PsiIdentifier") && element.getParent() instanceof PsiErrorElement && (el = (PsiErrorElement)element.getParent()).getErrorDescription().contains("'class' or 'interface' expected")) {
            return true;
        }
        if (element instanceof PsiWhiteSpace && PsiUtils.instanceOf((Object)element.getParent(), "com.intellij.psi.PsiJavaFile")) {
            String text = editor.getDocument().getText();
            int offset = editor.getCaretModel().getOffset();
            int classIdx = text.lastIndexOf("class", offset);
            int bracketIdx = text.indexOf("}", offset);
            return classIdx <= -1 || bracketIdx <= -1;
        }
        return false;
    }

    public static boolean checkCaretAround(Editor editor) {
        int offset = editor.getCaretModel().getOffset();
        LogicalPosition logicalPosition = editor.getCaretModel().getLogicalPosition();
        int lineStartOffset = editor.getDocument().getLineStartOffset(logicalPosition.line);
        int lineEndOffset = editor.getDocument().getLineEndOffset(logicalPosition.line);
        int caretOffset = offset - lineStartOffset;
        String lineText = editor.getDocument().getText(new TextRange(lineStartOffset, lineEndOffset));
        if (caretOffset > 0 && caretOffset < lineText.length()) {
            char afterChar = lineText.charAt(caretOffset);
            char beforeChar = lineText.charAt(caretOffset - 1);
            if (PsiUtils.isValidCodeTokenChar(afterChar) && (PsiUtils.isValidCodeTokenChar(beforeChar) || beforeChar == '(')) {
                log.info("invalid position in word middle");
                return false;
            }
            if (caretOffset > 1) {
                char moreBeforeChar = lineText.charAt(caretOffset - 2);
                if (PsiUtils.isValidCodeTokenChar(afterChar) && (beforeChar == '=' || beforeChar == ' ' && moreBeforeChar == '=')) {
                    log.info("invalid position after = xxxx");
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isJavaMethodNewLine(Editor editor, PsiElement element, int newOffset, int previousOffset) {
        String text;
        TextRange range;
        if (element.getPrevSibling() != null && PsiUtils.instanceOf((Object)element.getPrevSibling(), "com.intellij.psi.impl.source.tree.java.MethodElement", "com.intellij.psi.impl.source.PsiMethodImpl") && previousOffset >= (range = element.getPrevSibling().getTextRange()).getEndOffset() && previousOffset > 0 && newOffset > previousOffset && "}".equals((text = editor.getDocument().getText(new TextRange(previousOffset - 1, newOffset))).trim())) {
            log.info("check method end of newline, not trigger.");
            return true;
        }
        return false;
    }

    private static boolean isValidCodeTokenChar(char ch) {
        return Character.isJavaIdentifierPart(ch) || ch == '_' || ch == '$';
    }

    public static boolean isPythonIdentifier(String name) {
        try {
            Class<?> clazz = ReflectUtil.classForName("com.jetbrains.python.PyNames");
            Method method = clazz.getDeclaredMethod("isIdentifier", String.class);
            Object obj = method.invoke(null, name);
            if (obj != null) {
                return (Boolean)obj;
            }
        }
        catch (Exception e) {
            log.error("fail to check isPythonIdentifier.", (Throwable)e);
        }
        return false;
    }

    public static boolean isCommentElement(PsiElement element, @NotNull Editor editor) {
        TextRange range;
        if (editor == null) {
            PsiUtils.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiComment || PsiUtils.instanceOf((Object)element, "com.goide.psi.impl.GoCommentImpl")) {
            return true;
        }
        if (element.getParent() != null && PsiUtils.instanceOf((Object)element.getParent(), "com.intellij.psi.javadoc.PsiDocTag", "com.intellij.psi.PsiComment")) {
            return true;
        }
        if (commentFlags.stream().anyMatch(e -> element.getText().contains((CharSequence)e))) {
            return true;
        }
        if (element.getPrevSibling() != null && element.getPrevSibling() instanceof PsiComment && (range = element.getPrevSibling().getTextRange()) != null) {
            if (range.contains(editor.getCaretModel().getOffset())) {
                return true;
            }
            if (editor.getDocument().getLineNumber(range.getEndOffset()) == editor.getDocument().getLineNumber(editor.getCaretModel().getOffset())) {
                return true;
            }
        }
        return element.getPrevSibling() != null && commentFlags.stream().anyMatch(e -> element.getPrevSibling().getText().contains((CharSequence)e)) && !PsiUtils.instanceOf((Object)element.getPrevSibling(), "com.intellij.psi.PsiMethod") && editor.getDocument().getLineNumber(element.getPrevSibling().getTextOffset()) == editor.getDocument().getLineNumber(editor.getCaretModel().getOffset());
    }

    public static boolean isImportElement(PsiElement element, @NotNull Editor editor) {
        if (editor == null) {
            PsiUtils.$$$reportNull$$$0(2);
        }
        if (element != null && PsiUtils.instanceOf((Object)element.getParent(), "com.intellij.psi.impl.source.PsiImportList", "com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl", "com.goide.psi.impl.GoImportDeclarationImpl")) {
            return true;
        }
        String lineCode = PsiUtils.getLineTextAtCaret(editor);
        return lineCode.startsWith("import ") || lineCode.startsWith("from ") || lineCode.startsWith("using ");
    }

    public static String getLineTextAtCaret(@NotNull Editor editor) {
        if (editor == null) {
            PsiUtils.$$$reportNull$$$0(3);
        }
        int caretPosition = editor.getCaretModel().getOffset();
        int lineNumber = editor.getDocument().getLineNumber(caretPosition);
        int startOffset = editor.getDocument().getLineStartOffset(lineNumber);
        int endOffset = editor.getDocument().getLineEndOffset(lineNumber);
        return editor.getDocument().getText(new TextRange(startOffset, endOffset));
    }

    public static String getLineTextAtCaret(@NotNull Editor editor, int caretPosition) {
        if (editor == null) {
            PsiUtils.$$$reportNull$$$0(4);
        }
        if (caretPosition > editor.getDocument().getTextLength()) {
            caretPosition = editor.getDocument().getTextLength();
        }
        int lineNumber = editor.getDocument().getLineNumber(caretPosition);
        int startOffset = editor.getDocument().getLineStartOffset(lineNumber);
        int endOffset = editor.getDocument().getLineEndOffset(lineNumber);
        return editor.getDocument().getText(new TextRange(startOffset, endOffset));
    }

    public static boolean isLiteralElement(Editor editor, PsiElement element) {
        if (PsiUtils.instanceOf((Object)element, "com.jetbrains.python.psi.PyStringElement", "com.intellij.psi.PsiLiteralValue")) {
            return true;
        }
        if (PsiUtils.instanceOf((Object)element.getParent(), "com.jetbrains.python.psi.PyLiteralExpression", "com.goide.psi.impl.GoStringLiteralImpl")) {
            return true;
        }
        if (element.getParent() instanceof CompositeElement && ((CompositeElement)element.getParent()).getPsi() instanceof PsiLiteralValue) {
            return true;
        }
        String text = element.getText();
        if (StringUtils.isNotBlank((CharSequence)text) && text.startsWith("\"") && text.endsWith("\"")) {
            return true;
        }
        Character typeChar = (Character)CosyCacheKeys.KEY_INPUT_TYPE_CHAR.get((UserDataHolder)editor);
        return typeChar != null && (typeChar.charValue() == '\"' || typeChar.charValue() == '\'');
    }

    public static PsiElement getCaratElement(Editor editor) {
        if (editor.getProject() == null) {
            return null;
        }
        CaretModel caretModel = editor.getCaretModel();
        int offset = caretModel.getOffset();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)editor.getProject()).getPsiFile(editor.getDocument());
        PsiElement psiElement = null;
        if (psiFile != null && offset > 0) {
            psiElement = PsiUtils.findElementAtOffset(psiFile, offset);
        }
        return psiElement;
    }

    public static String getPsiMethodContent(Project project, PsiFile psiFile, SelectionModel selectionModel) {
        String result = selectionModel.getSelectedText();
        if (psiFile == null) {
            return result;
        }
        try {
            Class.forName("com.intellij.psi.PsiMethod");
            return JavaPsiUtils.getPsiMethodContent(project, psiFile, selectionModel);
        }
        catch (ClassNotFoundException e) {
            return result;
        }
    }

    public static String getPsiClassName(PsiFile psiFile, SelectionModel selectionModel) {
        if (psiFile == null) {
            return DEFAULT_CLASS_NAME;
        }
        try {
            Class.forName("com.intellij.psi.PsiClass");
            return JavaPsiUtils.getPsiClassName(psiFile, selectionModel);
        }
        catch (ClassNotFoundException e) {
            return DEFAULT_CLASS_NAME;
        }
    }

    public static String getPsiDocContent(Project project, PsiFile psiFile, SelectionModel selectionModel) {
        if (psiFile == null) {
            return selectionModel.getSelectedText();
        }
        int start = selectionModel.getSelectionStart();
        int end = selectionModel.getSelectionEnd();
        PsiElement startElement = psiFile.findElementAt(start);
        PsiElement endElement = psiFile.findElementAt(end);
        PsiComment endComment = (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)endElement, PsiComment.class, (boolean)false);
        PsiComment startComment = (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiComment.class, (boolean)false);
        if (endComment != null) {
            try {
                Class.forName("com.intellij.psi.PsiMethod");
                return JavaPsiUtils.getFollowingMethodSignatureFromComment(endComment);
            }
            catch (ClassNotFoundException e) {
                return endComment.getText();
            }
        }
        if (startComment != null) {
            try {
                Class.forName("com.intellij.psi.PsiMethod");
                return JavaPsiUtils.getFollowingMethodSignatureFromComment(startComment);
            }
            catch (ClassNotFoundException e) {
                return startComment.getText();
            }
        }
        return selectionModel.getSelectedText();
    }

    private static String getFullDocComment(PsiComment psiComment) {
        if (psiComment == null) {
            return "";
        }
        PsiDocComment psiDocComment = (PsiDocComment)PsiTreeUtil.getParentOfType((PsiElement)psiComment, PsiDocComment.class, (boolean)true);
        return Objects.requireNonNullElse(psiDocComment, psiComment).getText();
    }

    public static Boolean containsCode(Project project, PsiFile psiFile, SelectionModel selectionModel) {
        if (psiFile == null) {
            return false;
        }
        int start = selectionModel.getSelectionStart();
        int end = selectionModel.getSelectionEnd();
        int pivot = start;
        while (pivot < end) {
            PsiElement curElement = psiFile.findElementAt(pivot);
            if (curElement == null) {
                return false;
            }
            if (curElement.getText().length() > 1 && !PsiUtils.isInvalidCodeElement(curElement)) {
                log.info("Valid element: " + curElement.getText() + ", type=" + curElement.getNode().getElementType());
                return true;
            }
            pivot = curElement.getTextRange().getEndOffset();
        }
        return false;
    }

    public static boolean isInvalidCodeElement(PsiElement curElement) {
        try {
            Class.forName("com.intellij.psi.PsiJavaToken");
            return JavaPsiUtils.isInvalidCodeElement(curElement);
        }
        catch (ClassNotFoundException e) {
            return INVALID_COMMON_TOKENSET.contains(curElement.getNode().getElementType()) || curElement instanceof PsiComment || curElement instanceof PsiWhiteSpace || curElement instanceof PsiPlainText || curElement instanceof PsiLiteralValue || curElement instanceof PsiErrorElement;
        }
    }

    public static PsiElement findPrevAtOffset(PsiFile psiFile, int caretOffset, Class ... toSkip) {
        PsiElement element;
        if (caretOffset < 0) {
            return null;
        }
        int lineStartOffset = 0;
        Document document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
        if (document != null) {
            int lineNumber = document.getLineNumber(caretOffset);
            lineStartOffset = document.getLineStartOffset(lineNumber);
        }
        do {
            element = psiFile.findElementAt(--caretOffset);
        } while (caretOffset >= lineStartOffset && (element == null || PsiUtils.instanceOf((Object)element, toSkip)));
        return PsiUtils.instanceOf((Object)element, toSkip) ? null : element;
    }

    public static PsiElement findNonWhitespaceAtOffset(PsiFile psiFile, int caretOffset) {
        PsiElement element = PsiUtils.findNextAtOffset(psiFile, caretOffset, PsiWhiteSpace.class);
        if (element == null) {
            element = PsiUtils.findPrevAtOffset(psiFile, caretOffset - 1, PsiWhiteSpace.class);
        }
        return element;
    }

    public static PsiElement findElementAtOffset(PsiFile psiFile, int caretOffset) {
        PsiElement element = PsiUtils.findPrevAtOffset(psiFile, caretOffset, new Class[0]);
        if (element == null) {
            element = PsiUtils.findNextAtOffset(psiFile, caretOffset, new Class[0]);
        }
        return element;
    }

    public static PsiElement findNextAtOffset(PsiFile psiFile, int caretOffset, Class ... toSkip) {
        PsiElement element = psiFile.findElementAt(caretOffset);
        if (element == null) {
            return null;
        }
        Document document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
        int lineEndOffset = 0;
        if (document != null) {
            int lineNumber = document.getLineNumber(caretOffset);
            lineEndOffset = document.getLineEndOffset(lineNumber);
        }
        while (caretOffset < lineEndOffset && PsiUtils.instanceOf((Object)element, toSkip)) {
            element = psiFile.findElementAt(++caretOffset);
        }
        return PsiUtils.instanceOf((Object)element, toSkip) ? null : element;
    }

    public static boolean instanceOf(Object obj, Class ... possibleClasses) {
        if (obj == null || possibleClasses == null) {
            return false;
        }
        for (Class cls : possibleClasses) {
            if (!cls.isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    public static boolean instanceOf(Object obj, String ... possibleClassNames) {
        if (obj == null || possibleClassNames == null) {
            return false;
        }
        String objClassName = obj.getClass().getName();
        for (String className : possibleClassNames) {
            try {
                if (className.equals(objClassName)) {
                    return true;
                }
                Class<?> clazz = ReflectUtil.classForName(className);
                if (!clazz.isInstance(obj)) continue;
                return true;
            }
            catch (ClassNotFoundException clazz) {
            }
            catch (Exception e) {
                log.debug("fail to instanceOf Class:" + className);
            }
        }
        return false;
    }

    public static FileType getFileType() {
        LanguageFileType fileType = FileTypes.PLAIN_TEXT;
        for (String fileTypeClass : FILE_TYPE_CLASSES) {
            try {
                Class<?> clazz = ReflectUtil.classForName(fileTypeClass);
                fileType = (FileType)ReflectUtil.getStaticField(clazz, "INSTANCE");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return fileType;
    }

    public static String getLanguageByIDE() {
        if (CosyConfig.IDE_NAME.toLowerCase().contains("idea")) {
            return "java";
        }
        if (CosyConfig.IDE_NAME.toLowerCase().contains("pycharm")) {
            return "python";
        }
        if (CosyConfig.IDE_NAME.toLowerCase().contains("clion")) {
            return "c";
        }
        if (CosyConfig.IDE_NAME.toLowerCase().contains("webstorm")) {
            return "javascript";
        }
        if (CosyConfig.IDE_NAME.toLowerCase().contains("goland")) {
            return "go";
        }
        return null;
    }

    public static String getLanguageByCurrentFile(Editor editor) {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        VirtualFile virtualFile = fileDocumentManager.getFile(editor.getDocument());
        if (virtualFile == null) {
            return null;
        }
        String path = virtualFile.getPath();
        int dotIndex = path.lastIndexOf(".");
        if (dotIndex > 0) {
            return path.substring(dotIndex + 1);
        }
        return null;
    }

    public static String findErrorLineContent(Project project, Editor editor, int line) {
        return PsiUtils.findErrorLineContentByDefault(project, editor, line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String findErrorLineContentByDefault(Project project, Editor editor, int line) {
        while (line < editor.getDocument().getLineCount()) {
            String lineContent = editor.getDocument().getText(new TextRange(editor.getDocument().getLineStartOffset(line), editor.getDocument().getLineEndOffset(line)));
            ExceptionWorker.ParsedLine myInfo = ExceptionWorker.parseExceptionLine((String)lineContent);
            if (myInfo == null || myInfo.fileName == null) {
                ++line;
                continue;
            }
            String fileName = myInfo.fileName;
            int documentLine = myInfo.lineNumber;
            String classFullPath = lineContent.substring(myInfo.classFqnRange.getStartOffset(), myInfo.classFqnRange.getEndOffset());
            ArrayList<VirtualFile> vFiles = new ArrayList<VirtualFile>(FilenameIndex.getVirtualFilesByName((Project)project, (String)fileName, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project)));
            if (CollectionUtils.isEmpty(vFiles)) {
                ++line;
                continue;
            }
            VirtualFile vFile = PsiUtils.findMostRelatedVirtualFile(vFiles, classFullPath);
            log.info("Find stacktrace related vfs " + vFile.getName());
            try {
                String content = new String(vFile.contentsToByteArray(true));
                Language language = LanguageUtil.getFileLanguage((VirtualFile)vFile);
                String languageStr = null;
                if (language != null) {
                    languageStr = language.getDisplayName().toLowerCase();
                }
                StringBuilder sb = PsiUtils.getStringBuilder(content, documentLine, languageStr);
                String string = sb.toString();
                return string;
            }
            catch (IOException e) {
                log.error("vFile parse exception. ", (Throwable)e);
            }
            finally {
                ++line;
            }
        }
        return null;
    }

    public static VirtualFile findMostRelatedVirtualFile(List<VirtualFile> virtualFiles, String classFullPath) {
        if (CollectionUtils.isEmpty(virtualFiles) || classFullPath == null) {
            return null;
        }
        for (VirtualFile virtualFile : virtualFiles) {
            String vFileDotPath;
            String vPath = virtualFile.getPath();
            int extPos = vPath.lastIndexOf(".");
            if (extPos > 0) {
                vPath = vPath.substring(0, extPos);
            }
            if (!(vFileDotPath = vPath.replace("/", ".")).endsWith(classFullPath)) continue;
            return virtualFile;
        }
        return virtualFiles.get(0);
    }

    @NotNull
    public static StringBuilder getStringBuilder(String content, int documentLine, String languageStr) {
        String[] contentLines = content.split("\n");
        StringBuilder sb = new StringBuilder();
        sb.append("```");
        if (StringUtils.isNotBlank((CharSequence)languageStr)) {
            sb.append(languageStr);
        }
        sb.append("\n");
        sb.append(PsiUtils.findCompleteCodeBlock(contentLines, documentLine, "{", "}", 10));
        sb.append("\n");
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            PsiUtils.$$$reportNull$$$0(5);
        }
        return stringBuilder;
    }

    public static String findCompleteCodeBlock(String[] contentLines, int documentLine, String blockStartSymbol, String blockEndSymbol, int maxSearchLine) {
        int j;
        boolean found = false;
        for (int i = 0; documentLine - i >= 0 && i < maxSearchLine; ++i) {
            String line = contentLines[documentLine - i];
            if (!line.endsWith(blockStartSymbol)) continue;
            found = true;
            break;
        }
        if (found) {
            String line;
            for (j = 0; documentLine + j <= contentLines.length - 1 && j < maxSearchLine && !(line = contentLines[documentLine + j]).endsWith(blockEndSymbol); ++j) {
            }
        } else {
            j = maxSearchLine;
        }
        StringBuilder sb = new StringBuilder();
        for (int k = Math.max(documentLine - i, 0); k <= Math.min(documentLine + j, contentLines.length - 1); ++k) {
            sb.append(contentLines[k]);
            sb.append("\n");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/alibabacloud/intellij/cosy/util/PsiUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/alibabacloud/intellij/cosy/util/PsiUtils";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isNotInClassElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isCommentElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isImportElement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLineTextAtCaret";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

