/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.util;

import com.alibabacloud.intellij.cosy.common.CosyConfig;
import com.intellij.openapi.diagnostic.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.SequenceInputStream;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FileUtils;

public class ProcessReader
extends Thread {
    private static final Logger log = Logger.getInstance(ProcessReader.class);
    Process process;
    Boolean isRealtimePrint;
    StringBuilder buffer = new StringBuilder();
    Lock deleteLock = new ReentrantLock();

    public ProcessReader(Process process) {
        this.process = process;
        this.isRealtimePrint = false;
    }

    public ProcessReader(Process process, boolean isRealtimePrint) {
        this.process = process;
        this.isRealtimePrint = isRealtimePrint;
    }

    @Override
    public void run() {
        try (SequenceInputStream stream = new SequenceInputStream(this.process.getInputStream(), this.process.getErrorStream());
             BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            while (!this.isInterrupted()) {
                String line = reader.readLine();
                if (line == null) {
                    break;
                }
                if (this.isRealtimePrint.booleanValue()) {
                    log.info(line);
                    if (!line.contains("dgraph-io/badger")) continue;
                    this.clearLingmaStorage();
                    continue;
                }
                this.buffer.append(line).append('\n');
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearLingmaStorage() {
        if (!this.deleteLock.tryLock()) {
            return;
        }
        try {
            File homeDir = CosyConfig.getHomeDirectory().toFile();
            if (homeDir.exists()) {
                File tmpDir = new File(homeDir, "tmp");
                log.info("clear lingma storage temp dir:" + tmpDir);
                if (tmpDir.exists()) {
                    boolean success = FileUtils.deleteQuietly((File)tmpDir);
                    log.info("clear lingma storage success:" + success);
                }
            }
        }
        catch (Exception e) {
            log.warn("fail to clear lingma storage:" + e.getMessage(), (Throwable)e);
        }
        finally {
            this.deleteLock.unlock();
        }
    }

    public String getOutput() {
        return this.buffer.toString();
    }
}

