/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.util;

import com.alibabacloud.intellij.cosy.common.CosyCacheKeys;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthWhitelistStatusEnum;
import com.alibabacloud.intellij.cosy.service.UserAuthService;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.topic.AuthStateChangeNotifier;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LoginUtil {
    private static Lock authReportLock = new ReentrantLock();
    private static Condition waitLoginState = authReportLock.newCondition();
    private static AtomicReference<AuthStatus> loginResult = new AtomicReference();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitAuthLogin(long time, TimeUnit unit) throws Exception {
        authReportLock.lock();
        try {
            boolean bl = waitLoginState.await(time, unit);
            return bl;
        }
        finally {
            authReportLock.unlock();
        }
    }

    public static void notifyAuthLogin() {
        authReportLock.lock();
        try {
            waitLoginState.signalAll();
        }
        finally {
            authReportLock.unlock();
        }
    }

    public static AuthStatus getAuthStatus(Project project) {
        AuthStatus status = UserAuthService.getInstance().getState(project);
        if (status != null) {
            CosyCacheKeys.KEY_AUTH_STATUS.set((UserDataHolder)ApplicationManager.getApplication(), (Object)status);
        } else {
            status = (AuthStatus)CosyCacheKeys.KEY_AUTH_STATUS.get((UserDataHolder)ApplicationManager.getApplication());
        }
        return status == null || status.getStatus() == null ? AuthStatus.NOT_LOGIN : status;
    }

    public static AuthStatus getAuthStatusCacheFirst(Project project) {
        AuthStatus status = (AuthStatus)CosyCacheKeys.KEY_AUTH_STATUS.get((UserDataHolder)ApplicationManager.getApplication());
        if (status == null && (status = UserAuthService.getInstance().getState(project)) != null) {
            CosyCacheKeys.KEY_AUTH_STATUS.set((UserDataHolder)ApplicationManager.getApplication(), (Object)status);
        }
        return status == null || status.getStatus() == null ? AuthStatus.NOT_LOGIN : status;
    }

    public static void setLoginResult(AuthStatus authStatus) {
        loginResult.getAndSet(authStatus);
        CosyCacheKeys.KEY_AUTH_STATUS.set((UserDataHolder)ApplicationManager.getApplication(), (Object)authStatus);
    }

    public static AuthStatus getLoginResult() {
        return loginResult.get();
    }

    public static void updateAuthStatus(Project project, AuthStatus status, boolean notifyWhenStatusNull) {
        AuthStatus oldStatus = (AuthStatus)CosyCacheKeys.KEY_AUTH_STATUS.get((UserDataHolder)ApplicationManager.getApplication());
        if (!notifyWhenStatusNull && oldStatus == null) {
            CosyCacheKeys.KEY_AUTH_STATUS.set((UserDataHolder)ApplicationManager.getApplication(), (Object)status);
            return;
        }
        if (oldStatus == null || !Objects.equals(oldStatus.getStatus(), status.getStatus()) || !Objects.equals(oldStatus.getWhitelist(), status.getWhitelist())) {
            CosyCacheKeys.KEY_AUTH_STATUS.set((UserDataHolder)ApplicationManager.getApplication(), (Object)status);
            ((AuthStateChangeNotifier)project.getMessageBus().syncPublisher(AuthStateChangeNotifier.AUTH_CHANGE_NOTIFICATION)).notifyChangeAuth(status);
        } else {
            CosyCacheKeys.KEY_AUTH_STATUS.set((UserDataHolder)ApplicationManager.getApplication(), (Object)status);
        }
    }

    public static void resetLoginResult() {
        loginResult.set(null);
    }

    public static String getWhitelistText(AuthStatus status) {
        String whiteListText = CosyBundle.message("settings.login.account.tips.whitelist.unknown", new Object[0]);
        if (status.getWhitelist() != null) {
            if (status.getWhitelist().intValue() == AuthWhitelistStatusEnum.NOT_WHITELIST.getValue()) {
                whiteListText = CosyBundle.message("settings.login.account.tips.whitelist.not.apply", new Object[0]);
            } else if (status.getWhitelist().intValue() == AuthWhitelistStatusEnum.NO_LICENCE.getValue()) {
                whiteListText = CosyBundle.message("settings.login.account.tips.whitelist.not.apply", new Object[0]);
            } else if (status.getWhitelist().intValue() == AuthWhitelistStatusEnum.PASS.getValue()) {
                whiteListText = CosyBundle.message("settings.login.account.tips.whitelist.passed", new Object[0]);
            } else if (status.getWhitelist().intValue() == AuthWhitelistStatusEnum.WAIT_PASS.getValue()) {
                whiteListText = CosyBundle.message("settings.login.account.tips.whitelist.wait.pass", new Object[0]);
            }
        }
        return whiteListText;
    }
}

