/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class LanguageUtil {
    public static final String PLAINTEXT = "plaintext";
    public static Map<String, String> LANGUAGE_TO_EXT = new HashMap<String, String>(){
        {
            this.put("java", "java");
            this.put("python", "py");
            this.put("javascript", "js");
            this.put("typescript", "ts");
            this.put("tsx", "tsx");
            this.put("go", "go");
            this.put("c", "c");
            this.put("cpp", "cpp");
            this.put("c++", "cpp");
            this.put("xml", "xml");
            this.put("html", "html");
            this.put("sql", "sql");
            this.put("sqlite", "sql");
            this.put("php", "php");
            this.put("kotlin", "kt");
            this.put("yaml", "yml");
            this.put("properties", "properties");
            this.put("csharp", "cs");
            this.put("c_sharp", "cs");
            this.put("css", "css");
            this.put("scss", "scss");
            this.put("vue", "vue");
        }
    };

    public static String guessExtensionByMarkdownLanguage(String language) {
        if (language == null) {
            return "";
        }
        return LANGUAGE_TO_EXT.getOrDefault(language.toLowerCase(), language.toLowerCase());
    }

    public static String getLanguageByFilePath(String filePath) {
        String name = filePath.toLowerCase(Locale.ROOT);
        String fileName = FilenameUtils.getName((String)name);
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return null;
        }
        if (name.endsWith(".applescript")) {
            return "AppleScript";
        }
        if (name.endsWith(".asm")) {
            return "Assembly";
        }
        if (name.endsWith(".awk")) {
            return "Awk";
        }
        if (name.endsWith(".bat") || name.endsWith(".cmd")) {
            return "Batch";
        }
        if (name.endsWith(".c") || name.endsWith(".h")) {
            return "C";
        }
        if (name.endsWith(".cs")) {
            return "CSharp";
        }
        if (name.endsWith(".clj")) {
            return "Clojure";
        }
        if (name.endsWith(".cmake")) {
            return "CMake";
        }
        if (name.endsWith(".coffee")) {
            return "CoffeeScript";
        }
        if (name.endsWith(".lisp") || name.endsWith(".cl") || name.endsWith(".lsp")) {
            return "CommonLisp";
        }
        if (name.endsWith(".cpp") || name.endsWith(".cxx") || name.endsWith(".cc") || name.endsWith(".hpp")) {
            return "Cpp";
        }
        if (name.endsWith(".css") || name.endsWith(".scss")) {
            return "CSS";
        }
        if (name.endsWith(".cu")) {
            return "CUDA";
        }
        if (name.endsWith(".dart")) {
            return "Dart";
        }
        if ("dockerfile".equals(name)) {
            return "Dockerfile";
        }
        if (name.endsWith(".ex") || name.endsWith(".exs")) {
            return "Elixir";
        }
        if (name.endsWith(".erl")) {
            return "Erlang";
        }
        if (name.endsWith(".fs")) {
            return "FSharp";
        }
        if (name.endsWith(".go")) {
            return "Go";
        }
        if (name.endsWith(".groovy")) {
            return "Groovy";
        }
        if (name.endsWith(".hs")) {
            return "Haskell";
        }
        if (name.endsWith(".html") || name.endsWith(".htm") || name.endsWith(".phtml")) {
            return "HTML";
        }
        if (name.endsWith(".java")) {
            return "Java";
        }
        if (name.endsWith(".jsp")) {
            return "JSP";
        }
        if (name.endsWith(".js") || name.endsWith(".jsx")) {
            return "JavaScript";
        }
        if (name.endsWith(".json")) {
            return "JSON";
        }
        if (name.endsWith(".jl")) {
            return "Julia";
        }
        if (name.endsWith(".kt")) {
            return "Kotlin";
        }
        if (name.endsWith(".lua")) {
            return "Lua";
        }
        if ("makefile".equals(name)) {
            return "Makefile";
        }
        if (name.endsWith(".mpl")) {
            return "Maple";
        }
        if (name.endsWith(".md") || name.endsWith(".markdown")) {
            return "Markdown";
        }
        if (name.endsWith(".m")) {
            return "Mathematica";
        }
        if (name.endsWith(".matlab")) {
            return "MATLAB";
        }
        if (name.endsWith(".ml") || name.endsWith(".mli")) {
            return "OCaml";
        }
        if (name.endsWith(".pl")) {
            return "Perl";
        }
        if (name.endsWith(".php")) {
            return "PHP";
        }
        if (name.endsWith(".ps1")) {
            return "PowerShell";
        }
        if (name.endsWith(".pl")) {
            return "Prolog";
        }
        if (name.endsWith(".proto")) {
            return "ProtocolBuffer";
        }
        if (name.endsWith(".py")) {
            return "Python";
        }
        if (name.endsWith(".r")) {
            return "R";
        }
        if (name.endsWith(".rst")) {
            return "RestructuredText";
        }
        if (name.endsWith(".rmd")) {
            return "RMarkdown";
        }
        if (name.endsWith(".rb")) {
            return "Ruby";
        }
        if (name.endsWith(".rs")) {
            return "Rust";
        }
        if (name.endsWith(".sas")) {
            return "SAS";
        }
        if (name.endsWith(".scala")) {
            return "Scala";
        }
        if (name.endsWith(".sh")) {
            return "Shell";
        }
        if (name.endsWith(".sql")) {
            return "SQL";
        }
        if (name.endsWith(".csh") || name.endsWith(".tcsh")) {
            return "Tcsh";
        }
        if (name.endsWith(".thrift")) {
            return "Thrift";
        }
        if (name.endsWith(".ts") || name.endsWith(".tsx")) {
            return "TypeScript";
        }
        if (name.endsWith(".vhd") || name.endsWith(".vhdl")) {
            return "VHDL";
        }
        if (name.endsWith(".vb")) {
            return "VisualBasic";
        }
        if (name.endsWith(".y")) {
            return "Yacc";
        }
        if (name.endsWith(".yaml") || name.endsWith(".yml")) {
            return "YAML";
        }
        if (name.endsWith(".xml")) {
            return "XML";
        }
        if (name.endsWith(".vue")) {
            return "Vue";
        }
        if (name.endsWith(".zig")) {
            return "Zig";
        }
        if (name.endsWith(".g")) {
            return "Antlr";
        }
        if (name.endsWith(".v")) {
            return "Verilog";
        }
        if (fileName.contains("dockerfile")) {
            return "Dockerfile";
        }
        if (fileName.contains("makefile")) {
            return "Makefile";
        }
        if (name.endsWith(".sparql")) {
            return "Sparql";
        }
        if (name.endsWith(".v")) {
            return "Verilog";
        }
        if (name.endsWith(".scm")) {
            return "Scheme";
        }
        if (name.endsWith(".pas")) {
            return "Pascal";
        }
        if (name.endsWith(".ftl")) {
            return "FreeMarker";
        }
        if (name.endsWith(".ets")) {
            return "ArkTS";
        }
        if (name.endsWith(".txt") || name.endsWith(".log")) {
            return PLAINTEXT;
        }
        String fileExt = FilenameUtils.getExtension((String)name);
        if (StringUtils.isBlank((CharSequence)fileExt)) {
            return PLAINTEXT;
        }
        return fileExt;
    }
}

