/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.util;

import com.alibabacloud.intellij.cosy.util.PsiUtils;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class JavaPsiUtils {
    private static final Set<String> INVALID_METHOD_NAMES = new HashSet<String>(Arrays.asList("equals", "hashCode", "toString"));
    private static final TokenSet INVALID_JAVA_TOKENSET = TokenSet.orSet((TokenSet[])new TokenSet[]{ElementType.ALL_LITERALS, ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET, JavaDocTokenType.ALL_JAVADOC_TOKENS, TokenSet.create((IElementType[])new IElementType[]{TokenType.WHITE_SPACE, TokenType.BAD_CHARACTER, TokenType.NEW_LINE_INDENT, TokenType.ERROR_ELEMENT})});
    private static final Pattern PATTERN = Pattern.compile("\\s*(\\w*)\\(\\):(-?\\d*), (\\w*\\.java)\\n");

    public static boolean isInvalidCodeElement(PsiElement curElement) {
        return INVALID_JAVA_TOKENSET.contains(curElement.getNode().getElementType());
    }

    public static String getPsiMethodContent(Project project, PsiFile psiFile, SelectionModel selectionModel) {
        String result = selectionModel.getSelectedText();
        int start = selectionModel.getSelectionStart();
        int end = selectionModel.getSelectionEnd();
        PsiElement startElement = psiFile.findElementAt(start);
        PsiMethod startMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiMethod.class);
        PsiElement endElement = psiFile.findElementAt(end);
        PsiMethod endMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)endElement, PsiMethod.class);
        if (startMethod == null && endMethod == null) {
            return result;
        }
        if (startMethod != null && endMethod == null) {
            return startMethod.getText();
        }
        if (startMethod == null && endMethod != null) {
            return endMethod.getText();
        }
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        if (document != null) {
            result = document.getText(new TextRange(startMethod.getTextRange().getStartOffset(), endMethod.getTextRange().getEndOffset()));
        }
        return result;
    }

    public static String getPsiClassName(PsiFile psiFile, SelectionModel selectionModel) {
        int start = selectionModel.getSelectionStart();
        int end = selectionModel.getSelectionEnd();
        PsiElement startElement = psiFile.findElementAt(start);
        PsiElement endElement = psiFile.findElementAt(end);
        PsiClass startClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiClass.class, (boolean)false);
        PsiClass endClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)endElement, PsiClass.class, (boolean)false);
        if (startClass != null && startClass.equals(endClass)) {
            return startClass.getName();
        }
        return "DemoClass";
    }

    public static FileType getJavaFileType() {
        return JavaFileType.INSTANCE;
    }

    public static String getFollowingMethodSignatureFromComment(PsiComment psiComment) {
        if (psiComment == null) {
            return "";
        }
        if (psiComment.getParent() instanceof PsiMethod) {
            String methodSignature = JavaPsiUtils.getMethodSignature((PsiMethod)psiComment.getParent());
            return psiComment.getText() + "\n" + methodSignature;
        }
        return psiComment.getText();
    }

    private static String getMethodSignature(PsiMethod method) {
        StringBuilder sb = new StringBuilder();
        PsiIdentifier nameIdentifier = method.getNameIdentifier();
        sb.append(method.getModifierList().getText());
        if (method.getReturnTypeElement() != null) {
            sb.append(" ").append(method.getReturnTypeElement().getText());
        }
        if (nameIdentifier != null) {
            sb.append(" ").append(nameIdentifier.getText());
        }
        sb.append("(");
        PsiParameter[] parameters = method.getParameterList().getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            PsiParameter parameter = parameters[i];
            if (parameter.getTypeElement() == null) continue;
            sb.append(parameter.getTypeElement().getText()).append(" ").append(parameter.getName());
            if (i >= parameters.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    public static boolean isInvalidJavaMethod(@NotNull PsiElement element) {
        PsiMethod method;
        if (element == null) {
            JavaPsiUtils.$$$reportNull$$$0(0);
        }
        if (INVALID_METHOD_NAMES.contains((method = (PsiMethod)element).getName())) {
            return true;
        }
        if (method.isConstructor()) {
            return true;
        }
        if (JavaPsiUtils.isAbstractMethod(method)) {
            return true;
        }
        if (!PsiUtils.instanceOf((Object)method.getParent(), "com.intellij.psi.PsiClass")) {
            return false;
        }
        PsiClass clazz = (PsiClass)method.getParent();
        PsiField[] fields = clazz.getAllFields();
        if (fields.length == 0) {
            return false;
        }
        String methodName = method.getName().toLowerCase(Locale.ROOT);
        for (PsiField field : fields) {
            String fieldName = field.getName().toLowerCase(Locale.ROOT);
            String setMethodName = "set" + fieldName;
            String getMethodName = "get" + fieldName;
            String isMethodName = "is" + fieldName;
            if (!setMethodName.equals(methodName) && !getMethodName.equals(methodName) && !isMethodName.equals(methodName) && !methodName.equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAbstractMethod(@NotNull PsiMethod method) {
        if (method == null) {
            JavaPsiUtils.$$$reportNull$$$0(1);
        }
        if (method.hasModifierProperty("abstract")) {
            return true;
        }
        PsiClass aClass = method.getContainingClass();
        return aClass != null && aClass.isInterface() && !JavaPsiUtils.isDefaultMethod(aClass, method);
    }

    public static boolean isDefaultMethod(@NotNull PsiClass aClass, @NotNull PsiMethod method) {
        if (aClass == null) {
            JavaPsiUtils.$$$reportNull$$$0(2);
        }
        if (method == null) {
            JavaPsiUtils.$$$reportNull$$$0(3);
        }
        return method.hasModifierProperty("default") && PsiUtil.getLanguageLevel((PsiElement)aClass).isAtLeast(LanguageLevel.JDK_1_8);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        objectArray2[1] = "com/alibabacloud/intellij/cosy/util/JavaPsiUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isInvalidJavaMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAbstractMethod";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isDefaultMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

