/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.util;

import com.intellij.ide.IconProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.awt.Image;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class IconUtil {
    private static final Logger log = Logger.getInstance(IconUtil.class);
    private static final int SIZE = 16;

    public static Icon getIcon(String url) {
        byte[] data = null;
        try {
            URL imageUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)imageUrl.openConnection();
            conn.setConnectTimeout(500);
            InputStream inStream = conn.getInputStream();
            data = IOUtils.toByteArray((InputStream)inStream);
        }
        catch (Exception e) {
            log.warn(String.format("Can not get image from url  [%s] ", url));
            return null;
        }
        ImageIcon icon = new ImageIcon(data);
        if (icon.getIconHeight() != 16) {
            Image image = icon.getImage();
            Image smallImage = image.getScaledInstance(16, 16, 4);
            icon = new ImageIcon(smallImage);
        }
        return icon;
    }

    public static Icon getFileTypeIcon(@Nullable Project project, String filePath) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(filePath);
        if (virtualFile == null) {
            return null;
        }
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        FileType fileType = fileTypeManager.getFileTypeByFile(virtualFile);
        Icon icon = null;
        if (project != null) {
            IconProvider iconProvider;
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
            Iterator iterator = IconProvider.EXTENSION_POINT_NAME.getExtensionList().iterator();
            while (iterator.hasNext() && (icon = (iconProvider = (IconProvider)iterator.next()).getIcon((PsiElement)psiFile, 0)) == null) {
            }
        }
        if (icon == null) {
            icon = fileType.getIcon();
        }
        return icon;
    }
}

