/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.util;

import com.alibabacloud.intellij.cosy.common.CosyCacheKeys;
import com.alibabacloud.intellij.cosy.util.CollectionUtil;
import com.intellij.ide.ui.AntialiasingType;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.font.FontRenderContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FontUtil {
    @Nullable
    private static final Method getEditorFontSize2DMethod;
    private static Font editFont;

    public static FontMetrics fontMetrics(@NotNull Editor editor, @NotNull Font font) {
        if (editor == null) {
            FontUtil.$$$reportNull$$$0(0);
        }
        if (font == null) {
            FontUtil.$$$reportNull$$$0(1);
        }
        FontRenderContext editorContext = FontInfo.getFontRenderContext((Component)editor.getContentComponent());
        FontRenderContext context = new FontRenderContext(editorContext.getTransform(), AntialiasingType.getKeyForCurrentScope((boolean)false), editorContext.getFractionalMetricsHint());
        Map cachedMap = (Map)CosyCacheKeys.KEY_CACHED_FONTMETRICS.get((UserDataHolder)editor, Collections.emptyMap());
        FontMetrics fontMetrics = (FontMetrics)cachedMap.get(font);
        if (fontMetrics == null || !context.equals(fontMetrics.getFontRenderContext())) {
            fontMetrics = FontInfo.getFontMetrics((Font)font, (FontRenderContext)context);
            CosyCacheKeys.KEY_CACHED_FONTMETRICS.set((UserDataHolder)editor, CollectionUtil.mergeMaps(cachedMap, Map.of(font, fontMetrics)));
        }
        return fontMetrics;
    }

    public static FontMetrics fontMetrics(@NotNull JComponent component, @NotNull Font font) {
        if (component == null) {
            FontUtil.$$$reportNull$$$0(2);
        }
        if (font == null) {
            FontUtil.$$$reportNull$$$0(3);
        }
        FontRenderContext editorContext = FontInfo.getFontRenderContext((Component)component);
        FontRenderContext context = new FontRenderContext(editorContext.getTransform(), AntialiasingType.getKeyForCurrentScope((boolean)false), editorContext.getFractionalMetricsHint());
        return FontInfo.getFontMetrics((Font)font, (FontRenderContext)context);
    }

    @NotNull
    public static Font getFont(@NotNull Editor editor, @NotNull String text) {
        if (editor == null) {
            FontUtil.$$$reportNull$$$0(4);
        }
        if (text == null) {
            FontUtil.$$$reportNull$$$0(5);
        }
        Font font = editor.getColorsScheme().getFont(EditorFontType.PLAIN).deriveFont(2);
        Font fallbackFont = UIUtil.getFontWithFallbackIfNeeded((Font)font, (String)text);
        Font font2 = fallbackFont.deriveFont(FontUtil.fontSize(editor));
        if (font2 == null) {
            FontUtil.$$$reportNull$$$0(6);
        }
        return font2;
    }

    public static float fontSize(@NotNull Editor editor) {
        if (editor == null) {
            FontUtil.$$$reportNull$$$0(7);
        }
        EditorColorsScheme scheme = editor.getColorsScheme();
        if (getEditorFontSize2DMethod != null) {
            try {
                return ((Float)getEditorFontSize2DMethod.invoke((Object)scheme, new Object[0])).floatValue();
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return scheme.getEditorFontSize();
    }

    public static int calculateWidth(@NotNull Editor editor, @NotNull String text, @NotNull List<String> textLines) {
        if (editor == null) {
            FontUtil.$$$reportNull$$$0(8);
        }
        if (text == null) {
            FontUtil.$$$reportNull$$$0(9);
        }
        if (textLines == null) {
            FontUtil.$$$reportNull$$$0(10);
        }
        FontMetrics metrics = FontUtil.fontMetrics(editor, FontUtil.getFont(editor, text));
        int maxWidth = 0;
        for (String line : textLines) {
            maxWidth = Math.max(maxWidth, metrics.stringWidth(line));
        }
        return maxWidth;
    }

    @NotNull
    public static Font getFontWithFallbackIfNeeded(@NotNull Font font, @NotNull String text) {
        if (font == null) {
            FontUtil.$$$reportNull$$$0(11);
        }
        if (text == null) {
            FontUtil.$$$reportNull$$$0(12);
        }
        if (!SystemInfo.isMac && font.canDisplayUpTo(text) != -1) {
            return FontUtil.getFontWithFallback(font);
        }
        Font font2 = font;
        if (font2 == null) {
            FontUtil.$$$reportNull$$$0(13);
        }
        return font2;
    }

    @NotNull
    public static FontUIResource getFontWithFallback(@NotNull Font font) {
        if (font == null) {
            FontUtil.$$$reportNull$$$0(14);
        }
        return FontUtil.getFontWithFallback(font.getFamily(), font.getStyle(), font.getSize());
    }

    @NotNull
    public static FontUIResource getFontWithFallback(String familyName, int style, int size) {
        Font fontWithFallback = SystemInfo.isMac ? new Font(familyName, style, size) : (editFont != null ? editFont : new StyleContext().getFont(familyName, style, size));
        return fontWithFallback instanceof FontUIResource ? (FontUIResource)fontWithFallback : new FontUIResource(fontWithFallback);
    }

    public static String getStringAdaptiveWidth(JComponent component, String text, int maxWidth, boolean fromTail) {
        FontMetrics metrics = FontUtil.fontMetrics(component, component.getFont());
        int textLength = metrics.stringWidth(text);
        if (textLength <= maxWidth) {
            return text;
        }
        StringBuilder sb = new StringBuilder();
        if (fromTail) {
            int charWidth;
            for (int i = text.length() - 1; i >= 0 && (maxWidth -= (charWidth = metrics.stringWidth(String.valueOf(text.charAt(i))))) >= 0; --i) {
                sb.insert(0, text.charAt(i));
            }
            if (!sb.toString().equals(text)) {
                sb.insert(0, "...");
            }
        } else {
            char ch;
            int charWidth;
            char[] cArray = text.toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n && (maxWidth -= (charWidth = metrics.stringWidth(String.valueOf(ch = cArray[i])))) >= 0; ++i) {
                sb.append(ch);
            }
            if (!sb.toString().equals(text)) {
                sb.append("...");
            }
        }
        return sb.toString();
    }

    static {
        Method method = null;
        if (ApplicationInfo.getInstance().getBuild().getBaselineVersion() >= 221) {
            try {
                method = EditorColorsScheme.class.getMethod("getEditorFontSize2D", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        getEditorFontSize2DMethod = method;
        JTextArea area = new JTextArea();
        editFont = area.getFont();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/alibabacloud/intellij/cosy/util/FontUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/alibabacloud/intellij/cosy/util/FontUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFont";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontWithFallbackIfNeeded";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fontMetrics";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFont";
                break;
            }
            case 6: 
            case 13: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fontSize";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "calculateWidth";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFontWithFallbackIfNeeded";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFontWithFallback";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

