/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.util;

import com.alibaba.fastjson.JSON;
import com.alibabacloud.intellij.cosy.util.ProjectUtils;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testFramework.LightVirtualFile;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class FileUtil {
    private static final Logger log = Logger.getInstance(FileUtil.class);
    public static final long MAX_FILE_SIZE = 0x100000L;
    public static final List<String> VALID_FILE_LANGUAGES = Arrays.asList("java", "python");
    public static final Pattern JAVA_CLASS_PATTERN = Pattern.compile(".*(class|interface|enum)\\s+([\\w$_]+)\\s+.*");
    private static final Pattern CODE_BLOCK_PATTERN = Pattern.compile("<code>(.*?)</code>(</a>)?");
    private static final Pattern MD_URL_PATTERN = Pattern.compile("\\[(.*?)\\]\\((.*?)\\)");
    private static final Cache<String, Pair<String, String>> FILE_URL_CACHE = Caffeine.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).expireAfterAccess(30L, TimeUnit.MINUTES).maximumSize(5000L).build();

    public static boolean isLargeFile(@Nullable VirtualFile file) {
        return file == null || file.getLength() > 0x100000L;
    }

    public static boolean checkAllFilesExist(List<String> filePaths, String root) {
        try {
            for (String filePath : filePaths) {
                if (Paths.get(root, filePath).toFile().exists()) continue;
                log.info(String.format("File [%s] exists in zip but not in local file system", filePath));
                return Boolean.FALSE;
            }
        }
        catch (Exception e) {
            log.warn("Check file exist failed" + e.getMessage());
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static void deleteRecursive(File path) {
        File[] files = path.listFiles();
        log.info("Cleaning out folder:" + path);
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    log.info("Deleting file:" + file);
                    FileUtil.deleteRecursive(file);
                    file.delete();
                    continue;
                }
                file.delete();
            }
        }
        path.delete();
    }

    public static final String getPathExt(String filePath) {
        String ext = null;
        int index = filePath.lastIndexOf(46);
        if (index > 0) {
            ext = filePath.substring(index + 1);
        }
        return ext;
    }

    public static String getLanguageFileType(Project project) {
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        FileEditor selectEditor = fileEditorManager.getSelectedEditor();
        if (selectEditor == null) {
            return "";
        }
        VirtualFile file = selectEditor.getFile();
        if (file == null) {
            return "";
        }
        Language language = LanguageUtil.getFileLanguage((VirtualFile)file);
        if (language == null) {
            return "";
        }
        log.info("Current code language: " + language.getDisplayName());
        return language.getDisplayName();
    }

    public static boolean createPrivacyPolicyFile(File targetFile) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("timestamp", System.currentTimeMillis());
        try {
            FileUtils.write((File)targetFile, (CharSequence)JSON.toJSONString(map), (String)"UTF-8");
            return true;
        }
        catch (IOException e) {
            log.warn("fail to create privacy policy file:" + targetFile + " cause by " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static String getJavaFileNameFromContent(String content) {
        Matcher matcher = JAVA_CLASS_PATTERN.matcher(content);
        if (matcher.find()) {
            return matcher.group(2);
        }
        return null;
    }

    public static String generateFileNameWhenNewFile(String ext, String content, String fullPath, String fileName, String separator, boolean isTestcase) {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return "new_file_" + System.currentTimeMillis() + (String)(ext == null ? "" : "." + ext);
        }
        if (StringUtils.isBlank((CharSequence)ext)) {
            String newFileName = FileUtil.getJavaFileNameFromContent(content);
            if (newFileName != null) {
                fileName = newFileName;
            }
        } else if ("java".equals(ext)) {
            String newFileName = FileUtil.getJavaFileNameFromContent(content);
            String originalFileName = fullPath.substring(fullPath.lastIndexOf(separator) + 1);
            if (newFileName != null) {
                fileName = newFileName;
            } else {
                fileName = originalFileName.substring(0, originalFileName.lastIndexOf("."));
                if (isTestcase) {
                    fileName = (String)fileName + "Test";
                }
            }
        } else if ("py".equals(ext)) {
            if (isTestcase) {
                fileName = "test_" + (String)fileName;
                log.info("Generate python new test file name: " + (String)fileName);
            }
        } else if ("go".equals(ext) && isTestcase) {
            fileName = (String)fileName + "_test";
            log.info("Generate golang new test file name: " + (String)fileName);
        }
        return fileName;
    }

    public static String generatePathWhenNewFile(String ext, String path, boolean isTestcase) {
        if ("java".equals(ext) && isTestcase) {
            String separator = FileUtil.getFileSeparator(path);
            return path.replace(String.format("src%smain%sjava", separator, separator), String.format("src%stest%sjava", separator, separator));
        }
        return path;
    }

    public static VirtualFile buildVirtualFile(String fileName, FileType fileType, String content, final boolean writable) {
        return new LightVirtualFile(fileName, fileType, content, StandardCharsets.UTF_8, 0L){

            public boolean isWritable() {
                return writable;
            }
        };
    }

    public static String getFileSeparator(String pathExample) {
        if ("\\".equals(File.separator) && !pathExample.contains(File.separator) && pathExample.contains("/")) {
            return "/";
        }
        return File.separator;
    }

    public static boolean isAbsolutePath(String filePath) {
        if (filePath == null) {
            return false;
        }
        return (filePath = filePath.replace('/', File.separatorChar)).matches("^[A-Za-z]:\\\\.*") && SystemInfo.isWindows || filePath.startsWith("/");
    }

    public static String existFileAfterRepair(String rootPath, String filePath) {
        List<String> paths = FileUtil.getRepairFilePath(filePath);
        paths.sort((o1, o2) -> {
            if (o1.length() == o2.length()) {
                return 0;
            }
            return o1.length() > o2.length() ? 1 : -1;
        });
        for (String path : paths) {
            File file;
            String targetPath = path;
            int extParamIndex = targetPath.lastIndexOf("#");
            if (extParamIndex > 0) {
                targetPath = targetPath.substring(0, extParamIndex);
            }
            if (!(file = new File(rootPath, targetPath)).exists()) continue;
            return path;
        }
        return null;
    }

    public static List<String> getRepairFilePath(String filePath) {
        ArrayList<String> result = new ArrayList<String>();
        if ((filePath = filePath.replace('/', File.separatorChar)).contains(File.separator)) {
            String[] split = filePath.split("[/\\\\]+");
            LinkedList<String> list = new LinkedList<String>();
            for (int i = split.length - 1; i >= 0; --i) {
                list.offerFirst(split[i]);
                result.add(StringUtils.join(list, (String)File.separator));
            }
        } else {
            result.add(filePath);
        }
        return result;
    }

    public static String detectFileUrl(Project project, String html) {
        String rootPath = ProjectUtils.getProjectBaseDir(project);
        StringBuilder sb = new StringBuilder();
        Matcher m = CODE_BLOCK_PATTERN.matcher(html);
        while (m.find()) {
            String fileName;
            String content = m.group(1);
            if (m.groupCount() > 2 && m.group(2).equals("</a>")) {
                m.appendReplacement(sb, m.group());
                continue;
            }
            String cacheKey = String.format("%s_%s", rootPath, content);
            Pair cache = (Pair)FILE_URL_CACHE.getIfPresent((Object)cacheKey);
            if (cache != null) {
                m.appendReplacement(sb, "");
                sb.append(String.format("<a href=\"file://%s\">%s</a>", cache.getKey(), cache.getValue()));
                continue;
            }
            String existPath = FileUtil.existFileAfterRepair(rootPath, content);
            if (StringUtils.isNotBlank((CharSequence)existPath)) {
                FILE_URL_CACHE.put((Object)cacheKey, (Object)Pair.of((Object)existPath, (Object)existPath));
                m.appendReplacement(sb, "");
                sb.append(String.format("<a href=\"file://%s\">%s</a>", existPath, existPath));
                continue;
            }
            Matcher urlMatcher = MD_URL_PATTERN.matcher(content);
            if (urlMatcher.matches()) {
                String existPathTmp;
                fileName = urlMatcher.group(1);
                String linkPath = urlMatcher.group(2);
                if (linkPath.startsWith("file://")) {
                    linkPath = linkPath.substring("file://".length());
                }
                if (StringUtils.isNotBlank((CharSequence)(existPathTmp = FileUtil.existFileAfterRepair(rootPath, linkPath)))) {
                    FILE_URL_CACHE.put((Object)cacheKey, (Object)Pair.of((Object)existPathTmp, (Object)fileName));
                    m.appendReplacement(sb, "");
                    sb.append(String.format("<a href=\"file://%s\">%s</a>", existPathTmp, fileName));
                    continue;
                }
            } else {
                PsiFile[] files;
                fileName = content;
                if (fileName.contains(File.separator)) {
                    fileName = FilenameUtils.getName((String)fileName);
                }
                if ((files = FilenameIndex.getFilesByName((Project)project, (String)fileName, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project))).length == 1) {
                    String filePath = files[0].getVirtualFile().getPresentableUrl();
                    FILE_URL_CACHE.put((Object)cacheKey, (Object)Pair.of((Object)filePath, (Object)content));
                    m.appendReplacement(sb, "");
                    sb.append(String.format("<a href=\"file://%s\">%s</a>", filePath, content));
                    continue;
                }
                if (files.length > 1 && content.contains(File.separator)) {
                    boolean found = false;
                    for (PsiFile fileTmp : files) {
                        String filePath = fileTmp.getVirtualFile().getPresentableUrl();
                        if (!filePath.endsWith(content)) continue;
                        FILE_URL_CACHE.put((Object)cacheKey, (Object)Pair.of((Object)filePath, (Object)content));
                        m.appendReplacement(sb, "");
                        sb.append(String.format("<a href=\"file://%s\">%s</a>", filePath, content));
                        found = true;
                        break;
                    }
                    if (found) continue;
                }
            }
            m.appendReplacement(sb, m.group());
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

