/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.util;

import com.alibabacloud.intellij.cosy.chat.model.LineRange;
import com.alibabacloud.intellij.cosy.common.CosySetting;
import com.alibabacloud.intellij.cosy.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.cosy.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.util.ApplicationUtil;
import com.alibabacloud.intellij.cosy.util.LanguageUtil;
import com.alibabacloud.intellij.cosy.util.ProjectUtils;
import com.intellij.ide.DataManager;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorUtil {
    private static final Logger LOGGER = Logger.getInstance(EditorUtil.class);

    public static boolean isFocusedEditor(@NotNull Editor editor) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        if (ApplicationUtil.isRemoteIDE()) {
            return true;
        }
        return editor.getContentComponent().isFocusOwner();
    }

    public static boolean isSelectedEditor(@NotNull Editor editor) {
        Project project;
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(1);
        }
        if ((project = editor.getProject()) == null || project.isDisposed()) {
            return false;
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
        if (editorManager == null) {
            return false;
        }
        if (editorManager instanceof FileEditorManagerImpl) {
            Editor editor1 = ((FileEditorManagerImpl)editorManager).getSelectedTextEditor(true);
            return editor1 != null && editor1.equals(editor);
        }
        FileEditor current = editorManager.getSelectedEditor();
        return current instanceof TextEditor && editor.equals(((TextEditor)current).getEditor());
    }

    public static long getDocumentModificationStamp(@NotNull Document document) {
        if (document == null) {
            EditorUtil.$$$reportNull$$$0(2);
        }
        return document instanceof DocumentEx ? (long)((DocumentEx)document).getModificationSequence() : document.getModificationStamp();
    }

    public static int whitespacePrefixLength(@NotNull String lineContent) {
        int i;
        if (lineContent == null) {
            EditorUtil.$$$reportNull$$$0(3);
        }
        int maxLength = lineContent.length();
        for (i = 0; i < maxLength; ++i) {
            char c = lineContent.charAt(i);
            if (c == ' ' || c == '\t') continue;
            return i;
        }
        return i;
    }

    @Nullable
    public static Editor getSelectedEditorSafely(@NotNull Project project) {
        if (project == null) {
            EditorUtil.$$$reportNull$$$0(4);
        }
        try {
            FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
            return editorManager != null ? editorManager.getSelectedTextEditor() : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean isUnsupportedEditorState(@NotNull Editor editor) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(5);
        }
        if (editor.getCaretModel().getCaretCount() > 1) {
            return true;
        }
        return editor.getSelectionModel().hasSelection();
    }

    public static int indentLine(Project project, @NotNull Editor editor, int lineNumber, int indent, int caretOffset) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(6);
        }
        return EditorUtil.indentLine(project, editor, lineNumber, indent, caretOffset, EditorActionUtil.shouldUseSmartTabs((Project)project, (Editor)editor));
    }

    public static int indentLine(Project project, @NotNull Editor editor, int lineNumber, int indent, int caretOffset, boolean shouldUseSmartTabs) {
        int newCaretOffset;
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(7);
        }
        EditorSettings editorSettings = editor.getSettings();
        int tabSize = editorSettings.getTabSize(project);
        Document document = editor.getDocument();
        CharSequence text = document.getImmutableCharSequence();
        int spacesEnd = 0;
        int lineStart = 0;
        int lineEnd = 0;
        int tabsEnd = 0;
        if (lineNumber < document.getLineCount()) {
            lineStart = document.getLineStartOffset(lineNumber);
            lineEnd = document.getLineEndOffset(lineNumber);
            boolean inTabs = true;
            for (spacesEnd = lineStart; spacesEnd <= lineEnd && spacesEnd != lineEnd; ++spacesEnd) {
                char c = text.charAt(spacesEnd);
                if (c == '\t') continue;
                if (inTabs) {
                    inTabs = false;
                    tabsEnd = spacesEnd;
                }
                if (c != ' ') break;
            }
            if (inTabs) {
                tabsEnd = lineEnd;
            }
        }
        if ((newCaretOffset = caretOffset) >= lineStart && newCaretOffset < lineEnd && spacesEnd == lineEnd) {
            spacesEnd = newCaretOffset;
            tabsEnd = Math.min(spacesEnd, tabsEnd);
        }
        int oldLength = EditorUtil.getSpaceWidthInColumns(text, lineStart, spacesEnd, tabSize);
        tabsEnd = EditorUtil.getSpaceWidthInColumns(text, lineStart, tabsEnd, tabSize);
        int newLength = oldLength + indent;
        if (newLength < 0) {
            newLength = 0;
        }
        if ((tabsEnd += indent) < 0) {
            tabsEnd = 0;
        }
        if (!shouldUseSmartTabs) {
            tabsEnd = newLength;
        }
        StringBuilder buf = new StringBuilder(newLength);
        int i = 0;
        while (i < newLength) {
            if (tabSize > 0 && editorSettings.isUseTabCharacter(project) && i + tabSize <= tabsEnd) {
                buf.append('\t');
                i += tabSize;
                continue;
            }
            buf.append(' ');
            ++i;
        }
        int newSpacesEnd = lineStart + buf.length();
        if (newCaretOffset >= spacesEnd) {
            newCaretOffset += buf.length() - spacesEnd - lineStart;
        } else if (newCaretOffset >= lineStart && newCaretOffset > newSpacesEnd) {
            newCaretOffset = newSpacesEnd;
        }
        return newCaretOffset;
    }

    private static int getSpaceWidthInColumns(CharSequence seq, int startOffset, int endOffset, int tabSize) {
        int result = 0;
        for (int i = startOffset; i < endOffset; ++i) {
            if (seq.charAt(i) == '\t') {
                result = (result / tabSize + 1) * tabSize;
                continue;
            }
            ++result;
        }
        return result;
    }

    public static Editor getActiveEditor() {
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return null;
        }
        Component focusOwner = IdeFocusManager.getGlobalInstance().getFocusOwner();
        DataContext dataContext = DataManager.getInstance().getDataContext(focusOwner);
        return ApplicationManager.getApplication().isDisposed() ? null : (Editor)CommonDataKeys.EDITOR.getData(dataContext);
    }

    public static Point getEditorCaretPosition(@NotNull Editor editor) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(8);
        }
        try {
            Point cursorPosition = editor.logicalPositionToXY(editor.getCaretModel().getCurrentCaret().getLogicalPosition());
            Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
            Rectangle contentArea = editor.getScrollingModel().getVisibleAreaOnScrollingFinished();
            int x = (int)visibleArea.getX() + cursorPosition.x;
            int y = (int)visibleArea.getY() + cursorPosition.y;
            if ((double)x < contentArea.getX()) {
                x = (int)contentArea.getX();
            } else if ((double)x > contentArea.getMaxX()) {
                x = (int)contentArea.getMaxX();
            }
            if ((double)y < contentArea.getY()) {
                y = (int)contentArea.getY();
            } else if ((double)y > contentArea.getMaxY()) {
                y = (int)contentArea.getMaxY();
            }
            return new Point(x, y);
        }
        catch (Exception e) {
            LOGGER.error("fail to get editor caret position. ", (Throwable)e);
            return null;
        }
    }

    public static Point getEditorCaretScreenPosition(@NotNull Editor editor) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(9);
        }
        Point cursorAbsoluteLocation = editor.visualPositionToXY(editor.getCaretModel().getVisualPosition());
        Point editorLocation = editor.getComponent().getLocationOnScreen();
        Point editorContentLocation = editor.getContentComponent().getLocationOnScreen();
        return new Point(editorContentLocation.x + cursorAbsoluteLocation.x, editorLocation.y + cursorAbsoluteLocation.y - editor.getScrollingModel().getVerticalScrollOffset());
    }

    public static String getEditorFilePath(@NotNull Editor editor) {
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(10);
        }
        String filePath = null;
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        VirtualFile virtualFile = fileDocumentManager.getFile(editor.getDocument());
        if (virtualFile != null) {
            filePath = virtualFile.getPath();
        }
        return filePath;
    }

    public static boolean isActiveProjectEditor(@NotNull Editor editor) {
        Project project;
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(11);
        }
        return (project = ProjectUtils.getActiveProject()) != null && project.getBasePath() != null && editor.getProject() != null && project.getBasePath().equals(editor.getProject().getBasePath());
    }

    public static String getCopyPasteText() {
        CopyPasteManager copyPasteManager = CopyPasteManager.getInstance();
        Transferable contents = copyPasteManager.getContents();
        if (contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                return (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public static boolean isAvailableLanguage(@NotNull Editor editor) {
        Project project;
        if (editor == null) {
            EditorUtil.$$$reportNull$$$0(12);
        }
        if ((project = editor.getProject()) == null) {
            return false;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)editor.getProject()).getPsiFile(editor.getDocument());
        if (file == null) {
            return false;
        }
        CosySetting setting = CosyPersistentSetting.getInstance().getState();
        if (setting != null && setting.getParameter() != null && setting.getParameter().getCloud() != null && setting.getParameter().getCloud().getDisableLanguages() != null) {
            List<String> disableLanguages = setting.getParameter().getCloud().getDisableLanguages();
            Set languageSet = disableLanguages.stream().map(String::toLowerCase).collect(Collectors.toSet());
            String currentLanguage = LanguageUtil.getLanguageByFilePath(file.getVirtualFile().getPath());
            if (StringUtils.isNotBlank((CharSequence)currentLanguage) && languageSet.contains(currentLanguage.toLowerCase(Locale.ROOT))) {
                return false;
            }
            String ext = FilenameUtils.getExtension((String)file.getVirtualFile().getPath());
            if (StringUtils.isNotBlank((CharSequence)ext) && languageSet.contains(ext.toLowerCase(Locale.ROOT))) {
                return false;
            }
        }
        return true;
    }

    public static void openEditorFile(@NotNull Project project, String filePath, @Nullable LineRange lineRange, JComponent ownedComponent) {
        if (project == null) {
            EditorUtil.$$$reportNull$$$0(13);
        }
        if (StringUtils.isNotBlank((CharSequence)filePath)) {
            File file = new File(filePath);
            if (!file.exists()) {
                NotificationFactory.showToast(ownedComponent, MessageType.ERROR, CosyBundle.message("notifications.not.found.file", new Object[0]) + filePath);
                return;
            }
            VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
            if (virtualFile == null) {
                NotificationFactory.showToast(ownedComponent, MessageType.ERROR, CosyBundle.message("notifications.not.found.file", new Object[0]) + filePath);
                return;
            }
            if (virtualFile.isDirectory()) {
                EditorUtil.openDirectoryInProjectView(project, virtualFile);
                return;
            }
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, virtualFile);
            Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
            if (editor == null) {
                NotificationFactory.showToast(ownedComponent, MessageType.ERROR, CosyBundle.message("notifications.not.found.file", new Object[0]) + filePath);
                return;
            }
            if (lineRange == null) {
                return;
            }
            Integer startLine = lineRange.getStartLine();
            Integer endLine = lineRange.getEndLine();
            int totalLines = editor.getDocument().getLineCount();
            if (startLine == null || startLine < 0 || startLine > totalLines) {
                startLine = 0;
            }
            if (endLine == null || endLine < 0 || endLine >= totalLines) {
                endLine = totalLines - 1;
            }
            CaretModel caretModel = editor.getCaretModel();
            caretModel.moveToLogicalPosition(new LogicalPosition(startLine.intValue(), 0));
            SelectionModel selectionModel = editor.getSelectionModel();
            selectionModel.setSelection(caretModel.getOffset(), editor.getDocument().getLineEndOffset(endLine.intValue()));
            editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
    }

    public static void openDirectoryInProjectView(Project project, VirtualFile directory) {
        ProjectView projectView = ProjectView.getInstance((Project)project);
        projectView.select(null, directory, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineContent";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/alibabacloud/intellij/cosy/util/EditorUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isFocusedEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isSelectedEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getDocumentModificationStamp";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "whitespacePrefixLength";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getSelectedEditorSafely";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isUnsupportedEditorState";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "indentLine";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditorCaretPosition";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditorCaretScreenPosition";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditorFilePath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isActiveProjectEditor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableLanguage";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "openEditorFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

