/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.util;

import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public class ColorUtil {
    public static Color getEditorBackgroundColor() {
        return new JBColor(() -> {
            EditorColorsManager colorsManager = EditorColorsManager.getInstance();
            EditorColorsScheme colorsScheme = colorsManager.getGlobalScheme();
            return colorsScheme.getDefaultBackground();
        });
    }

    public static Color getChatCardBackgroundColor() {
        Color newNotificationColor = UIManager.getColor("NotificationsToolwindow.newNotification.background");
        if (newNotificationColor != null) {
            return JBColor.namedColor((String)"NotificationsToolwindow.newNotification.background", (Color)newNotificationColor);
        }
        return new JBColor(() -> {
            Color color = ColorUtil.getToolWindowBackgroundColor();
            float[] hsl = new float[3];
            Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsl);
            Color schemaColor = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR);
            if (schemaColor == null) {
                float newLight = (float)((int)(hsl[2] * 100.0f) - 3) / 100.0f;
                if (newLight < 0.0f) {
                    newLight = (float)((int)(hsl[2] * 100.0f) + 3) / 100.0f;
                }
                hsl[2] = newLight;
            } else {
                float newLight = (float)((int)(hsl[2] * 100.0f) + 3) / 100.0f;
                if (newLight > 1.0f) {
                    newLight = (float)((int)(hsl[2] * 100.0f) - 3) / 100.0f;
                }
                hsl[2] = newLight;
            }
            return Color.getHSBColor(hsl[0], hsl[1], hsl[2]);
        });
    }

    public static Color getTabbedUnderlineColor() {
        return JBColor.namedColor((String)"TabbedPane.underlineColor", (Color)new JBColor(new Color(255, 0, 0), new Color(238, 0, 0)));
    }

    public static Color getTabbedHoverBgColor() {
        return JBColor.namedColor((String)"TabbedPane.hoverColor", (Color)new JBColor(new Color(255, 0, 0), new Color(238, 0, 0)));
    }

    public static Color getTabbedBgColor() {
        return JBColor.namedColor((String)"TabbedPane.background", (Color)new JBColor(new Color(255, 0, 0), new Color(238, 0, 0)));
    }

    public static Color getTabbedSelectForegroundColor() {
        return JBColor.namedColor((String)"TabbedPane.selectedTabTitleNormalColor", (Color)new JBColor(new Color(255, 0, 0), new Color(238, 0, 0)));
    }

    public static Color getChatCardChildBackgroundColor() {
        return ColorUtil.getChatCardBackgroundColor();
    }

    public static Color getSelectedListItemColor() {
        return UIUtil.getListSelectionForeground((boolean)true);
    }

    public static Color getToolWindowBackgroundColor() {
        return JBColor.namedColor((String)"ToolWindow.background", (Color)UIUtil.getPanelBackground());
    }

    public static Color getButtonHoverBackgroundColor() {
        return JBColor.namedColor((String)"ActionButton.hoverBackground", (Color)new JBColor(new Color(255, 0, 0), new Color(238, 0, 0)));
    }

    public static Color getDisabledTextFieldBackgroundColor() {
        return JBColor.namedColor((String)"TextField.disabledBackground", (Color)new JBColor((Color)Gray._242, (Color)Gray._242));
    }

    public static Color getEnabledTextFieldBackgroundColor() {
        return JBColor.namedColor((String)"TextField.background", (Color)new JBColor(new Color(69, 73, 74), new Color(69, 73, 74)));
    }

    public static Color getTextForegroundColor() {
        return new JBColor(UIUtil::getTextAreaForeground);
    }

    public static Color getTextPaneForegroundColor() {
        return JBColor.namedColor((String)"TextPane.foreground", (Color)ColorUtil.getTextForegroundColor());
    }

    public static Color getLabelForegroundColor() {
        return JBColor.namedColor((String)"Label.foreground", (Color)ColorUtil.getTextPaneForegroundColor());
    }

    public static Color getAuxiliaryForegroundColor() {
        return JBColor.namedColor((String)"Label.infoForeground", (Color)JBColor.namedColor((String)"ToolTip.infoForeground", (Color)new JBColor(new Color(255, 0, 0), new Color(238, 0, 0))));
    }

    public static Color getInactiveForegroundColor() {
        return JBColor.namedColor((String)"TextArea.inactiveForeground", (Color)new JBColor(new Color(255, 0, 0), new Color(238, 0, 0)));
    }

    public static Color getLinkForegroundColor() {
        return JBColor.namedColor((String)"Hyperlink.linkColor", (Color)new JBColor(new Color(255, 0, 0), new Color(238, 0, 0)));
    }

    public static Color getItemSelectionBackground() {
        return new JBColor(() -> UIUtil.getListSelectionBackground((boolean)true));
    }

    public static Color getListBackground() {
        return new JBColor(UIUtil::getListBackground);
    }

    public static Color getListForeground() {
        return new JBColor(UIUtil::getListForeground);
    }

    public static Color getPopupMenuSelectionBackground() {
        return JBColor.namedColor((String)"PopupMenu.selectionBackground", (Color)ColorUtil.getItemSelectionBackground());
    }

    @NotNull
    public static Color getListHoverBackground() {
        JBColor jBColor = JBColor.namedColor((String)"List.hoverBackground", (Color)new JBColor(15595004, 4606541));
        if (jBColor == null) {
            ColorUtil.$$$reportNull$$$0(0);
        }
        return jBColor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/alibabacloud/intellij/cosy/util/ColorUtil", "getListHoverBackground"));
    }
}

