/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.util;

import com.alibabacloud.intellij.cosy.chat.enums.ChatTaskEnum;
import com.alibabacloud.intellij.cosy.chat.model.ChatContext;
import com.alibabacloud.intellij.cosy.chat.model.ChatContextFeature;
import com.alibabacloud.intellij.cosy.chat.model.task.dto.SimpleTextDto;
import com.alibabacloud.intellij.cosy.constants.CosyKey;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatAskTag;
import com.alibabacloud.intellij.cosy.ui.search.model.GenerateInput;
import com.alibabacloud.intellij.cosy.util.FileUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;

public class ChatTaskUtil {
    public static GenerateInput getInitInput(Project project) {
        ChatContext chatContext = ChatContext.builder().fileLanguage(FileUtil.getLanguageFileType(project)).filePath("").sessionId(UUID.randomUUID().toString()).range(null).methodContent(null).docContent(null).sourceCode(null).inputComplete(false).build();
        GenerateInput genInput = new GenerateInput("", null, chatContext);
        SimpleTextDto simpleTextDto = new SimpleTextDto();
        genInput.setQuestionObject(simpleTextDto);
        HashMap map = (HashMap)ApplicationManager.getApplication().getUserData(CosyKey.PROJECT_FREE_INPUT_SELECTION_CODE_MAP);
        if (map == null) {
            map = new HashMap();
            ApplicationManager.getApplication().putUserData(CosyKey.PROJECT_FREE_INPUT_SELECTION_CODE_MAP, map);
        } else {
            map.remove(project.getName());
        }
        return genInput;
    }

    public static String getQuickAskChatTask(GenerateInput input) {
        boolean isReply = ChatTaskUtil.isReply(input);
        boolean isRetry = ChatTaskEnum.RETRY_TASK.getName().equals(input.getChatTask());
        boolean isFreeInput = ChatTaskEnum.FREE_INPUT.name().equals(input.getChatTask());
        return isReply && !isRetry && !isFreeInput ? ChatTaskEnum.REPLY_TASK.getName() : input.getChatTask();
    }

    public static boolean isReply(GenerateInput input) {
        return input.getChatHistory() != null && input.getChatHistory().getAskAnswerList() != null && !input.getChatHistory().getAskAnswerList().isEmpty();
    }

    public static List<ChatContextFeature> getFeatureFromTag(List<ChatAskTag> chatAskTags) {
        ArrayList<ChatContextFeature> features = new ArrayList<ChatContextFeature>();
        if (CollectionUtils.isEmpty(chatAskTags)) {
            return features;
        }
        for (ChatAskTag chatAskTag : chatAskTags) {
            ChatContextFeature feature = new ChatContextFeature();
            feature.setId(chatAskTag.getId());
            feature.setName(chatAskTag.getText());
            feature.setType(chatAskTag.getType());
            features.add(feature);
        }
        return features;
    }
}

