/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibabacloud.intellij.cosy.chat.enums.ChatTaskEnum;
import com.alibabacloud.intellij.cosy.chat.model.ChatAskInput;
import com.alibabacloud.intellij.cosy.chat.model.ChatContextFeature;
import com.alibabacloud.intellij.cosy.chat.model.task.dto.BaseChatTaskDto;
import com.alibabacloud.intellij.cosy.chat.model.task.dto.CodeRelatedDto;
import com.alibabacloud.intellij.cosy.chat.model.task.dto.TestcaseGenerationDto;
import com.alibabacloud.intellij.cosy.constants.CosyKey;
import com.alibabacloud.intellij.cosy.constants.InputConstants;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ChatRecord;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatAskTag;
import com.alibabacloud.intellij.cosy.ui.search.model.SuggestPrompt;
import com.alibabacloud.intellij.cosy.util.SuggestPromptUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ChatSessionUtil {
    private static final Logger log = Logger.getInstance(ChatSessionUtil.class);
    private static String CHAT_CONTEXT_FIELD_TEXT_FIELD = "text";
    private static String CHAT_CONTEXT_FIELD_DISPLAY_TEXT = "displayText";

    public static ChatAskInput getChatAskInputFromRecord(ChatRecord chatRecord, Project project) {
        if (chatRecord == null || chatRecord.getChatContext() == null) {
            return null;
        }
        JSONObject chatContextJson = JSON.parseObject((String)chatRecord.getChatContext());
        String text = null;
        if (chatContextJson != null) {
            if (ChatTaskEnum.REPLY_TASK.getName().equals(chatRecord.getChatTask()) || ChatTaskEnum.RETRY_TASK.getName().equals(chatRecord.getChatTask())) {
                text = chatContextJson.getString(CHAT_CONTEXT_FIELD_DISPLAY_TEXT);
                if (StringUtils.isBlank((CharSequence)text)) {
                    text = chatRecord.getQuestion();
                }
            } else {
                text = chatContextJson.getString(CHAT_CONTEXT_FIELD_TEXT_FIELD);
            }
        }
        List<ChatAskTag> tags = ChatSessionUtil.getChatTagsFromRecord(chatRecord, project);
        return new ChatAskInput(text, tags);
    }

    public static String getExtraTextFromRecord(ChatRecord chatRecord) {
        CodeRelatedDto codeRelatedDto;
        if (chatRecord == null) {
            return null;
        }
        if (chatRecord.getChatTask() == null || chatRecord.getChatContext() == null) {
            return chatRecord.getQuestion();
        }
        String chatTask = chatRecord.getChatTask();
        String code = null;
        if (ChatTaskEnum.GENERATE_TESTCASE.getName().equals(chatTask)) {
            TestcaseGenerationDto testcaseGenerationDto = (TestcaseGenerationDto)JSON.parseObject((String)chatRecord.getChatContext(), TestcaseGenerationDto.class);
            if (testcaseGenerationDto != null) {
                code = testcaseGenerationDto.getSelectionCode();
            }
        } else if (InputConstants.SIMPLE_CODE_RELATED_TASKS.contains(chatTask) && (codeRelatedDto = (CodeRelatedDto)JSON.parseObject((String)chatRecord.getChatContext(), CodeRelatedDto.class)) != null) {
            code = codeRelatedDto.getCode();
        }
        StringBuilder textBuilder = new StringBuilder();
        if (StringUtils.isNotBlank(code)) {
            textBuilder.append("```\n");
            textBuilder.append(code);
            textBuilder.append("```\n");
        }
        return textBuilder.toString();
    }

    public static List<ChatAskTag> getChatTagsFromRecord(ChatRecord chatRecord, Project project) {
        if (chatRecord == null) {
            return null;
        }
        if (chatRecord.getChatTask() == null || chatRecord.getChatContext() == null) {
            return null;
        }
        BaseChatTaskDto baseChatTaskDto = (BaseChatTaskDto)JSON.parseObject((String)chatRecord.getChatContext(), BaseChatTaskDto.class);
        if (baseChatTaskDto == null) {
            return null;
        }
        ArrayList<ChatAskTag> tags = new ArrayList<ChatAskTag>();
        if (CollectionUtils.isNotEmpty(baseChatTaskDto.getFeatures())) {
            List<ChatContextFeature> features = baseChatTaskDto.getFeatures();
            for (ChatContextFeature feature : features) {
                ChatAskTag chatAskTag = ChatAskTag.buildTag(feature.getId(), feature.getName());
                tags.add(chatAskTag);
            }
        } else {
            SuggestPrompt suggestPrompt;
            String text = InputConstants.CHAT_TASK_QUERY_MAP.get(chatRecord.getChatTask());
            if (StringUtils.isNotBlank((CharSequence)text) && text.length() > 1 && (suggestPrompt = SuggestPromptUtil.getAllSuggestPrompt(project).get(text.substring(1))) != null) {
                tags.add(ChatAskTag.buildTag(suggestPrompt.getId(), text));
            }
        }
        return tags;
    }

    public static void updateAnsweringStatus(String requestId) {
        if (StringUtils.isBlank((CharSequence)requestId)) {
            log.warn("requestId is blank when updateAnsweringStatus");
            return;
        }
        ConcurrentHashMap<String, Long> requestAnsweringMap = (ConcurrentHashMap<String, Long>)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_ANSWERING);
        if (requestAnsweringMap == null) {
            requestAnsweringMap = new ConcurrentHashMap<String, Long>();
        }
        requestAnsweringMap.put(requestId, System.currentTimeMillis());
    }
}

