/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.util;

import com.alibabacloud.intellij.cosy.common.CosyConfig;
import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.util.FileUtil;
import com.alibabacloud.intellij.cosy.util.ProcessUtils;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class ApplicationUtil {
    private static final Logger log = Logger.getInstance(ApplicationUtil.class);

    public static String getApplicationVersion() {
        if (ApplicationManager.getApplication() == null) {
            return "";
        }
        return ApplicationInfo.getInstance().getFullVersion();
    }

    public static void killCosyProcess() {
        List<Long> cosyPidList = ProcessUtils.findCosyPidList();
        String pidListStr = StringUtils.join(cosyPidList, (String)",");
        log.info(String.format("Found cosy pid list: %s", pidListStr == null ? "null" : pidListStr));
        if (CollectionUtils.isNotEmpty(cosyPidList)) {
            for (Long pid : cosyPidList) {
                Cosy.INSTANCE.killProcessAndDeleteInfoFile(pid);
            }
        }
    }

    public static void clearBinaryDirectory() {
        File homeDir = CosyConfig.getHomeDirectory().toFile();
        if (homeDir.exists()) {
            FileUtil.deleteRecursive(homeDir);
        }
    }

    public static boolean isSupportedIDE(@Nullable Project project) {
        if (ApplicationUtil.isRemoteIDE()) {
            return true;
        }
        return !LightEdit.owns((Project)project);
    }

    public static boolean isRemoteIDE() {
        return "true".equals(System.getProperty("org.jetbrains.projector.server.enable"));
    }
}

