/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.update;

import com.alibabacloud.intellij.cosy.common.BuildFeature;
import com.alibabacloud.intellij.cosy.common.CosyConfig;
import com.alibabacloud.intellij.cosy.common.CosySetting;
import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.UpdateResult;
import com.alibabacloud.intellij.cosy.search.enums.UpgradeChecklEnum;
import com.alibabacloud.intellij.cosy.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.cosy.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.cosy.ui.search.Constants;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.update.PluginDiskInstaller;
import com.alibabacloud.intellij.cosy.util.ProjectUtils;
import com.alibabacloud.intellij.cosy.util.ReflectUtil;
import com.alibabacloud.intellij.cosy.util.ThreadUtil;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import icons.CommonIcons;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class LingmaPluginUpdateChecker {
    private static final Logger LOGGER = Logger.getInstance(LingmaPluginUpdateChecker.class);
    private static final Alarm DELAY_ALARM = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private static final long DEFAULT_DELAY_TIME = TimeUnit.MINUTES.toMillis(1L);
    private static final long AUTO_CHECK_DELAY_TIME = TimeUnit.HOURS.toMillis(24L);
    private static final long RETRY_DELAY_TIME = TimeUnit.MINUTES.toMillis(1L);

    public static void delayCheckUpdate() {
        LingmaPluginUpdateChecker.delayCheckUpdate(DEFAULT_DELAY_TIME, 3L);
    }

    public static void delayCheckUpdate(long delayTime, long retryCount) {
        DELAY_ALARM.addRequest(() -> {
            block4: {
                try {
                    if (CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false)) {
                        LOGGER.info("Starting to checking update for vpc version");
                        LingmaPluginUpdateChecker.checkUpdateFromServer((ProgressIndicator)new EmptyProgressIndicator());
                    } else {
                        LOGGER.info("Starting to checking update for cloud version");
                        LingmaPluginUpdateChecker.checkUpdateFromMarketplace((ProgressIndicator)new EmptyProgressIndicator());
                    }
                    LingmaPluginUpdateChecker.delayCheckUpdate(AUTO_CHECK_DELAY_TIME, retryCount);
                }
                catch (Exception e) {
                    LOGGER.warn("check update failed", (Throwable)e);
                    if (retryCount <= 0L) break block4;
                    LingmaPluginUpdateChecker.delayCheckUpdate(RETRY_DELAY_TIME, retryCount - 1L);
                }
            }
        }, delayTime);
    }

    public static void checkUpdateFromServer(@NotNull ProgressIndicator indicator) {
        CosySetting cosySetting;
        if (indicator == null) {
            LingmaPluginUpdateChecker.$$$reportNull$$$0(0);
        }
        if ((cosySetting = CosyPersistentSetting.getInstance().getState()) != null && UpgradeChecklEnum.FORBID_CHECK.getLabel().equals(cosySetting.getUpgradeStrategy())) {
            LOGGER.info("ignore auto checking plugin upgrade when checking update");
            return;
        }
        try {
            Project project = ProjectUtils.getActiveProject();
            if (project == null) {
                LOGGER.warn("invalid active project");
                return;
            }
            if (Cosy.INSTANCE.checkCosy(project)) {
                UpdateResult result = Cosy.INSTANCE.getLanguageService(project).ideUpdate(true, 3000L);
                if (result != null && result.isHasUpdate()) {
                    LOGGER.info("found available plugin from server:" + result.getVersion());
                } else {
                    LOGGER.info("no available plugin from server");
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("check update from server failed", (Throwable)e);
        }
    }

    public static void checkUpdateFromMarketplace(@NotNull ProgressIndicator indicator) {
        CosySetting cosySetting;
        if (indicator == null) {
            LingmaPluginUpdateChecker.$$$reportNull$$$0(1);
        }
        if ((cosySetting = CosyPersistentSetting.getInstance().getState()) != null && UpgradeChecklEnum.FORBID_CHECK.getLabel().equals(cosySetting.getUpgradeStrategy())) {
            LOGGER.info("ignore auto checking plugin upgrade when checking update");
            return;
        }
        PluginId pluginId = PluginManager.getPluginByClassName((String)LingmaPluginUpdateChecker.class.getName());
        String pluginIdString = pluginId != null ? pluginId.getIdString() : Constants.PLUGIN_ID;
        ThreadUtil.execute(() -> {
            try {
                Collection<PluginDownloader> availableUpdates = LingmaPluginUpdateChecker.findUpdatedPlugins(indicator);
                for (PluginDownloader pluginDownloader : availableUpdates) {
                    LOGGER.info("found available plugin:" + pluginDownloader.getId().getIdString() + " version:" + pluginDownloader.getPluginVersion());
                }
                PluginDownloader pluginDownloader = availableUpdates.stream().filter(p -> pluginIdString.equals(p.getId().getIdString())).findFirst().orElse(null);
                if (pluginDownloader != null) {
                    if (cosySetting == null || UpgradeChecklEnum.AUTO_INSTALL.getLabel().equals(cosySetting.getUpgradeStrategy())) {
                        LOGGER.info("automation install plugin version:" + pluginDownloader.getPluginVersion());
                        LingmaPluginUpdateChecker.installUpdateRightNow(null, pluginDownloader);
                    } else if (UpgradeChecklEnum.MANUAL_INSTALL.getLabel().equals(cosySetting.getUpgradeStrategy())) {
                        LOGGER.info("manual install plugin version:" + pluginDownloader.getPluginVersion());
                        SwingUtilities.invokeLater(() -> {
                            Project[] projects;
                            for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
                                if (!project.isOpen()) continue;
                                StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> LingmaPluginUpdateChecker.notifyUpdateAvailable(project, pluginDownloader));
                            }
                        });
                    }
                } else {
                    LOGGER.info("no plugin version found");
                }
            }
            catch (Exception e) {
                LOGGER.warn("check update failed", (Throwable)e);
            }
        });
    }

    @RequiresEdt
    private static void notifyUpdateAvailable(@NotNull Project project, PluginDownloader pluginDownloader) {
        if (project == null) {
            LingmaPluginUpdateChecker.$$$reportNull$$$0(2);
        }
        Notification notification = NotificationFactory.STICKY_NOTIFICATION_GROUP.createNotification(CosyBundle.message("cosy.plugin.name", new Object[0]), CosyBundle.message("notifications.update.check.content", new Object[0]), NotificationType.INFORMATION, (paramNotification, paramHyperlinkEvent) -> {});
        notification.setIcon(CommonIcons.AI);
        notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)CosyBundle.message("notifications.update.check.btn.install", new Object[0]), () -> ApplicationManager.getApplication().executeOnPooledThread(() -> LingmaPluginUpdateChecker.installUpdateRightNow(project, pluginDownloader))));
        notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)CosyBundle.message("notifications.update.check.btn.dismiss", new Object[0]), () -> {}));
        notification.notify(project);
    }

    private static void installUpdateRightNow(final Project project, final PluginDownloader pluginDownloader) {
        if (project == null) {
            LingmaPluginUpdateChecker.doInstallUpdate(project, pluginDownloader, (ProgressIndicator)new EmptyProgressIndicator());
        } else {
            new Task.Backgroundable(project, CosyBundle.message("notifications.update.installing.title", new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    LingmaPluginUpdateChecker.doInstallUpdate(project, pluginDownloader, indicator);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/alibabacloud/intellij/cosy/update/LingmaPluginUpdateChecker$1", "run"));
                }
            }.queue();
        }
    }

    private static void doInstallUpdate(Project project, PluginDownloader pluginDownloader, ProgressIndicator indicator) {
        try {
            LOGGER.info("start installing:" + pluginDownloader.getPluginVersion());
            Class<?> clazz = ReflectUtil.classForName("com.intellij.openapi.updateSettings.impl.UpdateInstaller");
            Method method = ReflectUtil.getMethod(clazz, "installPluginUpdates", Collection.class, ProgressIndicator.class);
            Boolean installResult = (Boolean)method.invoke(null, Collections.singletonList(pluginDownloader), indicator);
            LOGGER.info("finished installing:" + installResult);
            if (project != null) {
                PluginDiskInstaller.notifyUpdateFinished(project);
            } else {
                Project[] projects;
                for (Project p : projects = ProjectManager.getInstance().getOpenProjects()) {
                    if (!p.isOpen()) continue;
                    PluginDiskInstaller.notifyUpdateFinished(p);
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("install update failed:" + pluginDownloader.getPluginVersion(), (Throwable)e);
        }
    }

    private static Collection<PluginDownloader> findUpdatedPlugins(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            LingmaPluginUpdateChecker.$$$reportNull$$$0(3);
        }
        if (ApplicationInfo.getInstance().getBuild().getBaselineVersion() <= 211) {
            return LingmaPluginUpdateChecker.findUpdatedPluginsForOldVersion(indicator);
        }
        return LingmaPluginUpdateChecker.findUpdatedPluginsForNewVersion(indicator);
    }

    private static Collection<PluginDownloader> findUpdatedPluginsForOldVersion(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            LingmaPluginUpdateChecker.$$$reportNull$$$0(4);
        }
        try {
            Method checkPluginsUpdate = ReflectUtil.getMethod(UpdateChecker.class, "checkPluginsUpdate", ProgressIndicator.class);
            if (checkPluginsUpdate == null) {
                return Collections.emptyList();
            }
            Object checkPluginsUpdateResult = checkPluginsUpdate.invoke(null, indicator);
            if (checkPluginsUpdateResult == null) {
                return Collections.emptyList();
            }
            Method getAvailableUpdates = ReflectUtil.getMethod(checkPluginsUpdateResult.getClass(), "getAvailableUpdates", new Class[0]);
            if (getAvailableUpdates == null) {
                return Collections.emptyList();
            }
            Object availableUpdates = getAvailableUpdates.invoke(checkPluginsUpdateResult, new Object[0]);
            if (availableUpdates == null) {
                return Collections.emptyList();
            }
            return (Collection)availableUpdates;
        }
        catch (Exception e) {
            LOGGER.warn("checkPluginsUpdate failed", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static Collection<PluginDownloader> findUpdatedPluginsForNewVersion(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            LingmaPluginUpdateChecker.$$$reportNull$$$0(5);
        }
        try {
            Method getInternalPluginUpdates = ReflectUtil.getMethod(UpdateChecker.class, "getInternalPluginUpdates", BuildNumber.class, ProgressIndicator.class);
            if (getInternalPluginUpdates == null) {
                return Collections.emptyList();
            }
            Object internalPluginResults = getInternalPluginUpdates.invoke(null, null, indicator);
            if (internalPluginResults == null) {
                return Collections.emptyList();
            }
            Method getPluginUpdates = ReflectUtil.getMethod(internalPluginResults.getClass(), "getPluginUpdates", new Class[0]);
            if (getPluginUpdates == null) {
                return Collections.emptyList();
            }
            Object pluginUpdates = getPluginUpdates.invoke(internalPluginResults, new Object[0]);
            if (pluginUpdates == null) {
                return Collections.emptyList();
            }
            Method getAllEnabled = ReflectUtil.getMethod(pluginUpdates.getClass(), "getAllEnabled", new Class[0]);
            if (getAllEnabled == null) {
                return Collections.emptyList();
            }
            Object allEnabled = getAllEnabled.invoke(pluginUpdates, new Object[0]);
            if (allEnabled == null) {
                return Collections.emptyList();
            }
            return (Collection)allEnabled;
        }
        catch (Exception e) {
            LOGGER.warn("checkPluginsUpdate failed", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/alibabacloud/intellij/cosy/update/LingmaPluginUpdateChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkUpdateFromServer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkUpdateFromMarketplace";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyUpdateAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findUpdatedPlugins";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findUpdatedPluginsForOldVersion";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findUpdatedPluginsForNewVersion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

