/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.statusbar;

import com.alibabacloud.intellij.cosy.common.CosyCacheKeys;
import com.alibabacloud.intellij.cosy.common.CosySetting;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStateEnum;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthWhitelistStatusEnum;
import com.alibabacloud.intellij.cosy.search.asyn.Debouncer;
import com.alibabacloud.intellij.cosy.service.UserAuthService;
import com.alibabacloud.intellij.cosy.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.topic.AuthLoginNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.AuthLogoutNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.AuthStateChangeNotifier;
import com.alibabacloud.intellij.cosy.ui.statusbar.CosyStatusInfoDisplayAction;
import com.alibabacloud.intellij.cosy.util.LoginUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.EditorBasedStatusBarPopup;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBusConnection;
import icons.LingmaIcons;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CosyStatusBarWidget
extends EditorBasedStatusBarPopup {
    private static final Logger LOGGER = Logger.getInstance(CosyStatusBarWidget.class);
    private static Debouncer stateChangeDebouncer = new Debouncer();
    MessageBusConnection messageBusConnection;
    boolean isGenerating;
    Project project;

    public CosyStatusBarWidget(@NotNull Project project, boolean writeableFileRequired) {
        if (project == null) {
            CosyStatusBarWidget.$$$reportNull$$$0(0);
        }
        super(project, writeableFileRequired);
        this.project = project;
        this.messageBusConnection = project.getMessageBus().connect();
        this.messageBusConnection.subscribe(AuthLoginNotifier.AUTH_LOGIN_NOTIFICATION, this::notifyLoginAuth);
        this.messageBusConnection.subscribe(AuthLogoutNotifier.AUTH_LOGOUT_NOTIFICATION, this::notifyLogoutAuth);
        this.messageBusConnection.subscribe(AuthStateChangeNotifier.AUTH_CHANGE_NOTIFICATION, this::notifyChangeAuth);
    }

    private void notifyLoginAuth(AuthStatus status) {
        CosyCacheKeys.KEY_AUTH_STATUS.set((UserDataHolder)ApplicationManager.getApplication(), (Object)status);
        CosyStatusBarWidget.updateStatusBar(null, this.project);
    }

    private void notifyLogoutAuth(AuthStatus status) {
        CosyCacheKeys.KEY_AUTH_STATUS.set((UserDataHolder)ApplicationManager.getApplication(), (Object)status);
        CosyStatusBarWidget.updateStatusBar(null, this.project);
    }

    private void notifyChangeAuth(AuthStatus status) {
        CosyStatusBarWidget.updateStatusBar(null, this.project);
    }

    @NotNull
    protected EditorBasedStatusBarPopup.WidgetState getWidgetState(@Nullable VirtualFile virtualFile) {
        AuthStatus authStatus = LoginUtil.getAuthStatusCacheFirst(this.project);
        Object tooltip = CosyBundle.message("cosy.plugin.name", new Object[0]);
        if (authStatus.getStatus().intValue() != AuthStateEnum.LOGIN.getValue()) {
            tooltip = (String)tooltip + ": " + CosyBundle.message("statusbar.tool.title.not.logged", new Object[0]);
        }
        if (this.isGenerating) {
            tooltip = CosyBundle.message("statusbar.state.generating", new Object[0]);
        }
        EditorBasedStatusBarPopup.WidgetState state = new EditorBasedStatusBarPopup.WidgetState((String)tooltip, "", true);
        state.setIcon(this.isGenerating ? LingmaIcons.StatusBarLoadingIcon : this.getStatusBarIcon(authStatus));
        EditorBasedStatusBarPopup.WidgetState widgetState = state;
        if (widgetState == null) {
            CosyStatusBarWidget.$$$reportNull$$$0(1);
        }
        return widgetState;
    }

    public void setGeneratingStatus(boolean isGenerating) {
        this.isGenerating = isGenerating;
    }

    public static void setStatusBarGenerating(Project project, boolean generating, boolean useDebounce) {
        if (useDebounce) {
            stateChangeDebouncer.debounce(() -> SwingUtilities.invokeLater(() -> {
                LOGGER.info("reset statusbar loading:" + generating);
                CosyStatusBarWidget.updateStatusBar((Consumer<CosyStatusBarWidget>)((Consumer)widget -> widget.setGeneratingStatus(generating)), project);
            }), 3000L, TimeUnit.MILLISECONDS);
        } else {
            CosyStatusBarWidget.updateStatusBar((Consumer<CosyStatusBarWidget>)((Consumer)widget -> widget.setGeneratingStatus(generating)), project);
        }
    }

    public static void clearStatusBarDebouncer() {
        stateChangeDebouncer.shutdown();
    }

    public static void updateStatusBar(Consumer<CosyStatusBarWidget> consumer, Project project) {
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(Objects.requireNonNull(project));
        if (statusBar != null) {
            Optional.ofNullable((CosyStatusBarWidget)statusBar.getWidget("com.alibabacloud.intellij.cosy.widget")).ifPresent(widget -> {
                if (consumer != null) {
                    consumer.consume((Object)widget);
                }
                widget.update(() -> widget.myStatusBar.updateWidget("com.alibabacloud.intellij.cosy.widget"));
            });
        }
    }

    @Nullable
    protected ListPopup createPopup(DataContext dataContext) {
        return this.createPopup(dataContext, true);
    }

    @NotNull
    protected StatusBarWidget createInstance(@NotNull Project project) {
        if (project == null) {
            CosyStatusBarWidget.$$$reportNull$$$0(2);
        }
        return new CosyStatusBarWidget(project, false);
    }

    @NonNls
    @NotNull
    public String ID() {
        return "com.alibabacloud.intellij.cosy.widget";
    }

    private ListPopup createPopup(DataContext context, boolean withStatusItem) {
        ActionGroup group;
        AuthStatus status = UserAuthService.getInstance().getState(this.project);
        if (status != null) {
            CosyCacheKeys.KEY_AUTH_STATUS.set((UserDataHolder)ApplicationManager.getApplication(), (Object)status);
        } else {
            status = (AuthStatus)CosyCacheKeys.KEY_AUTH_STATUS.get((UserDataHolder)ApplicationManager.getApplication());
        }
        boolean loggedIn = status != null && status.getStatus() != null && AuthStateEnum.LOGIN.getValue() == status.getStatus().intValue();
        String popupGroup = loggedIn ? "cosyStatusBarPopupLoggedGroup" : "cosyStatusBarPopupNoLoginGroup";
        AnAction defaultGroup = ActionManager.getInstance().getAction(popupGroup);
        if (!(defaultGroup instanceof ActionGroup)) {
            return null;
        }
        if (withStatusItem) {
            DefaultActionGroup statusGroup = new DefaultActionGroup();
            statusGroup.add((AnAction)new CosyStatusInfoDisplayAction());
            statusGroup.addSeparator();
            this.appendCompletionActionPopup(statusGroup);
            statusGroup.addSeparator();
            statusGroup.addAll(new AnAction[]{defaultGroup});
            group = statusGroup;
        } else {
            group = (ActionGroup)defaultGroup;
        }
        return JBPopupFactory.getInstance().createActionGroupPopup(CosyBundle.message("statusbar.popup.title", new Object[0]), group, context, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, withStatusItem);
    }

    private void appendCompletionActionPopup(DefaultActionGroup statusGroup) {
        AnAction completionTitleDisplayAction = ActionManager.getInstance().getAction("CosyCompletionTitleDisplayAction");
        AnAction localCompletionAction = ActionManager.getInstance().getAction("CosyLocalCompletionAction");
        AnAction cloudCompletionAction = ActionManager.getInstance().getAction("CosyCloudCompletionAction");
        if (localCompletionAction != null && cloudCompletionAction != null) {
            if (completionTitleDisplayAction != null) {
                statusGroup.add(completionTitleDisplayAction);
            }
            statusGroup.add(localCompletionAction);
            statusGroup.add(cloudCompletionAction);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.messageBusConnection != null) {
            this.messageBusConnection.disconnect();
        }
    }

    public Icon getStatusBarIcon(AuthStatus authStatus) {
        if (authStatus == null) {
            return LingmaIcons.StatusBarNoLoggedIcon;
        }
        Integer status = authStatus.getStatus();
        Integer whitelist = authStatus.getWhitelist();
        if (status == null || status.intValue() != AuthStateEnum.LOGIN.getValue()) {
            return LingmaIcons.StatusBarNoLoggedIcon;
        }
        CosySetting setting = CosyPersistentSetting.getInstance().getState();
        if (whitelist == null || whitelist.intValue() != AuthWhitelistStatusEnum.PASS.getValue()) {
            if (setting != null && setting.getParameter().getLocal().getEnable().booleanValue()) {
                return LingmaIcons.StatusBarLocalIcon;
            }
            return LingmaIcons.StatusBarDisabledIcon;
        }
        if (setting != null && setting.getParameter().getCloud().getEnable().booleanValue() && setting.getParameter().getCloud().getAutoTrigger().getEnable().booleanValue()) {
            return LingmaIcons.StatusBarCloudIcon;
        }
        if (setting != null && setting.getParameter().getLocal().getEnable().booleanValue()) {
            return LingmaIcons.StatusBarLocalIcon;
        }
        return LingmaIcons.StatusBarDisabledIcon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/alibabacloud/intellij/cosy/ui/statusbar/CosyStatusBarWidget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/alibabacloud/intellij/cosy/ui/statusbar/CosyStatusBarWidget";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWidgetState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

