/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.renderer;

import com.alibabacloud.intellij.cosy.search.enums.SearchValueTypeEnum;
import com.alibabacloud.intellij.cosy.search.result.SearchValue;
import com.alibabacloud.intellij.cosy.ui.search.I18NConstant;
import com.alibabacloud.intellij.cosy.ui.search.SearchMainPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.inputfield.SearchBar;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.SwingUtil;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.text.Matcher;
import com.intellij.util.text.MatcherHolder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.CommonIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class SearchValueListCellRenderer
extends DefaultListCellRenderer {
    private static final int NLP_TIPS_OFFSET = 5;
    private static final int MIN_RESERVED_TEXT_WIDTH = 30;
    SearchBar searchBar;
    SearchMainPanel mainPanel;

    public SearchValueListCellRenderer(SearchBar searchBar, SearchMainPanel mainPanel) {
        this.searchBar = searchBar;
        this.mainPanel = mainPanel;
    }

    @Override
    public Component getListCellRendererComponent(JList<?> paramJList, Object paramObject, int paramInt, boolean isSelected, boolean cellHasFocus) {
        if (!(paramObject instanceof SearchValue)) {
            return super.getListCellRendererComponent(paramJList, paramObject, paramInt, isSelected, cellHasFocus);
        }
        OpaquePanel opaquePanel = new OpaquePanel((LayoutManager)new BorderLayout());
        opaquePanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 0));
        int rightWidth = this.createNlpTips(opaquePanel, paramObject, isSelected);
        Component component = new TypeAndNameRenderer(this.searchBar, rightWidth).getListCellRendererComponent(paramJList, paramObject, paramInt, isSelected, cellHasFocus);
        Color bgColor = component.getBackground();
        opaquePanel.add(component, (Object)"West");
        opaquePanel.setBackground(isSelected ? ColorUtil.getItemSelectionBackground() : bgColor);
        return opaquePanel;
    }

    private int createNlpTips(OpaquePanel opaquePanel, Object paramObject, boolean isSelected) {
        int rightWidth = 0;
        if (paramObject instanceof SearchValue) {
            SearchValue searchValue = (SearchValue)paramObject;
            if (SearchValueTypeEnum.NLP.getType().equalsIgnoreCase(searchValue.getType()) && isSelected && (!this.searchBar.isTextFieldRewrite() || this.searchBar.hasOtherSearchValue(searchValue)) && this.searchBar.getSearchValueCount() > 0) {
                Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR);
                Icon icon = null;
                icon = color == null ? CommonIcons.lightPromptIcon : CommonIcons.promptIcon;
                JLabel label = new JLabel(I18NConstant.SEARCH_SUGGEST_NLP_TIP, icon, 2);
                label.setForeground((Color)new JBColor(new Color(0xC0C0C0), new Color(8891869)));
                label.setBorder((Border)JBUI.Borders.empty((int)0, (int)5));
                opaquePanel.add((Component)label, (Object)"East");
                rightWidth = label.getPreferredSize().width;
            }
        }
        return rightWidth;
    }

    @NotNull
    private Icon getTypeIcon(@NotNull SearchValue paramSearchValue) {
        String paramType;
        if (paramSearchValue == null) {
            SearchValueListCellRenderer.$$$reportNull$$$0(0);
        }
        if ((paramType = paramSearchValue.getType()) != null) {
            switch (paramType.toLowerCase()) {
                case "class": 
                case "class_dec": {
                    Icon icon = PlatformIcons.CLASS_ICON;
                    if (icon == null) {
                        SearchValueListCellRenderer.$$$reportNull$$$0(1);
                    }
                    return icon;
                }
                case "method": 
                case "method_dec": {
                    Icon icon = PlatformIcons.METHOD_ICON;
                    if (icon == null) {
                        SearchValueListCellRenderer.$$$reportNull$$$0(2);
                    }
                    return icon;
                }
            }
        }
        Icon icon = IconUtil.getEmptyIcon((boolean)false);
        if (icon == null) {
            SearchValueListCellRenderer.$$$reportNull$$$0(3);
        }
        return icon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramSearchValue";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/alibabacloud/intellij/cosy/ui/search/renderer/SearchValueListCellRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/alibabacloud/intellij/cosy/ui/search/renderer/SearchValueListCellRenderer";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTypeIcon";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    class TypeAndNameRenderer
    extends ColoredListCellRenderer {
        private static final String NLP_ITEM_ELLIPSIS = "...";
        private static final int NLP_ITEM_SUB_PADDING = 60;
        SearchBar searchBar;
        int rightWidth;

        private TypeAndNameRenderer(SearchBar searchBar, int rightWidth) {
            this.searchBar = searchBar;
            this.rightWidth = rightWidth;
        }

        protected void customizeCellRenderer(@NotNull JList param1JList, Object paramObject, int paramInt, boolean isSelected, boolean cellHasFocus) {
            if (param1JList == null) {
                TypeAndNameRenderer.$$$reportNull$$$0(0);
            }
            Matcher matcher = MatcherHolder.getAssociatedMatcher((JComponent)param1JList);
            Color color2 = UIUtil.getListBackground();
            Color color1 = param1JList.getForeground();
            this.setPaintFocusBorder(cellHasFocus && UIUtil.isToUseDottedCellBorder());
            if (paramObject instanceof SearchValue) {
                SearchValue searchValue = (SearchValue)paramObject;
                String packageName = searchValue.getPack();
                String type = searchValue.getType();
                SimpleTextAttributes simpleTextAttributes = new SimpleTextAttributes(0, color1);
                String niceName = this.truncateText(searchValue, this.rightWidth, isSelected);
                SpeedSearchUtil.appendColoredFragmentForMatcher((String)niceName, (SimpleColoredComponent)this, (SimpleTextAttributes)simpleTextAttributes, (Matcher)matcher, (Color)color2, (boolean)isSelected);
                simpleTextAttributes = new SimpleTextAttributes(0, (Color)JBColor.GRAY);
                if (!SearchValueTypeEnum.NLP.getType().equals(type)) {
                    this.setIcon(SearchValueListCellRenderer.this.getTypeIcon((SearchValue)paramObject));
                    SpeedSearchUtil.appendColoredFragmentForMatcher((String)(" (" + packageName + ")"), (SimpleColoredComponent)this, (SimpleTextAttributes)simpleTextAttributes, null, (Color)color2, (boolean)isSelected);
                }
            }
            this.setBackground(isSelected ? ColorUtil.getItemSelectionBackground() : color2);
        }

        private String truncateText(SearchValue searchValue, int rightWidth, boolean isSelected) {
            String content = searchValue.getNiceName();
            if (rightWidth > 0 && isSelected && SearchValueTypeEnum.NLP.getType().equals(searchValue.getType())) {
                int searchBarWidth = Math.max(this.searchBar.getSize().width, this.searchBar.getPreferredSize().width);
                int popupWidth = SearchValueListCellRenderer.this.mainPanel.getListComponent() == null ? 0 : SearchValueListCellRenderer.this.mainPanel.getListComponent().getPreferredSize().width;
                int reservedWidth = (int)SwingUtil.getStringFontSize(NLP_ITEM_ELLIPSIS, this.getFont()).getWidth();
                int remainWidth = Math.max(popupWidth, searchBarWidth) - rightWidth - reservedWidth - 60;
                remainWidth = Math.max(30, remainWidth);
                StringBuilder sb = new StringBuilder();
                int bufferWidth = 0;
                for (char ch : content.toCharArray()) {
                    int charWidth = (int)SwingUtil.getStringFontSize(String.valueOf(ch), this.getFont()).getWidth();
                    if ((bufferWidth += charWidth) >= remainWidth) continue;
                    sb.append(ch);
                }
                if (!sb.toString().equals(content)) {
                    sb.append(NLP_ITEM_ELLIPSIS);
                }
                return sb.toString();
            }
            return content;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "param1JList", "com/alibabacloud/intellij/cosy/ui/search/renderer/SearchValueListCellRenderer$TypeAndNameRenderer", "customizeCellRenderer"));
        }
    }
}

