/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.renderer;

import com.alibabacloud.intellij.cosy.ui.search.generate.AskInputPanel;
import com.alibabacloud.intellij.cosy.ui.search.generate.GenerateContentForm;
import com.alibabacloud.intellij.cosy.ui.search.model.SuggestPrompt;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.SwingUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.text.Matcher;
import com.intellij.util.text.MatcherHolder;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class InputSuggestPromptListCellRender
extends DefaultListCellRenderer {
    private static final int MIN_RESERVED_TEXT_WIDTH = 30;
    AskInputPanel inputPanel;
    GenerateContentForm mainPanel;

    public InputSuggestPromptListCellRender(AskInputPanel inputPanel, GenerateContentForm mainPanel) {
        this.inputPanel = inputPanel;
        this.mainPanel = mainPanel;
    }

    @Override
    public Component getListCellRendererComponent(JList<?> paramJList, Object paramObject, int paramInt, boolean isSelected, boolean cellHasFocus) {
        if (!(paramObject instanceof SuggestPrompt)) {
            return super.getListCellRendererComponent(paramJList, paramObject, paramInt, isSelected, cellHasFocus);
        }
        OpaquePanel opaquePanel = new OpaquePanel((LayoutManager)new BorderLayout());
        opaquePanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 0));
        Component component = new SuggestPromptCellRender(this.inputPanel).getListCellRendererComponent(paramJList, paramObject, paramInt, isSelected, cellHasFocus);
        Color bgColor = component.getBackground();
        opaquePanel.add(component, (Object)"West");
        opaquePanel.setBackground(isSelected ? ColorUtil.getItemSelectionBackground() : bgColor);
        return opaquePanel;
    }

    class SuggestPromptCellRender
    extends ColoredListCellRenderer {
        private static final String PROMPT_ELLIPSIS = "...";
        private static final int NLP_ITEM_SUB_PADDING = 60;
        AskInputPanel inputPanel;

        private SuggestPromptCellRender(AskInputPanel inputPanel) {
            this.inputPanel = inputPanel;
        }

        protected void customizeCellRenderer(@NotNull JList param1JList, Object paramObject, int paramInt, boolean isSelected, boolean cellHasFocus) {
            if (param1JList == null) {
                SuggestPromptCellRender.$$$reportNull$$$0(0);
            }
            Matcher matcher = MatcherHolder.getAssociatedMatcher((JComponent)param1JList);
            Color color2 = ColorUtil.getListBackground();
            Color color1 = ColorUtil.getListForeground();
            this.setPaintFocusBorder(cellHasFocus && UIUtil.isToUseDottedCellBorder());
            if (paramObject instanceof SuggestPrompt) {
                SuggestPrompt suggestPrompt = (SuggestPrompt)paramObject;
                String text = suggestPrompt.getText();
                SimpleTextAttributes simpleTextAttributes = new SimpleTextAttributes(0, color1);
                String niceName = this.truncateText(text, isSelected);
                SpeedSearchUtil.appendColoredFragmentForMatcher((String)niceName, (SimpleColoredComponent)this, (SimpleTextAttributes)simpleTextAttributes, (Matcher)matcher, (Color)color2, (boolean)isSelected);
            }
            this.setBackground(isSelected ? ColorUtil.getItemSelectionBackground() : color2);
        }

        private String truncateText(String text, boolean isSelected) {
            if (isSelected) {
                int searchBarWidth = Math.max(this.inputPanel.getSize().width, this.inputPanel.getPreferredSize().width);
                int popupWidth = InputSuggestPromptListCellRender.this.mainPanel.getListComponent() == null ? 0 : InputSuggestPromptListCellRender.this.mainPanel.getListComponent().getPreferredSize().width;
                int reservedWidth = (int)SwingUtil.getStringFontSize(PROMPT_ELLIPSIS, this.getFont()).getWidth();
                int remainWidth = Math.max(popupWidth, searchBarWidth) - reservedWidth - 60;
                remainWidth = Math.max(30, remainWidth);
                StringBuilder sb = new StringBuilder();
                int bufferWidth = 0;
                for (char ch : text.toCharArray()) {
                    int charWidth = (int)SwingUtil.getStringFontSize(String.valueOf(ch), this.getFont()).getWidth();
                    if ((bufferWidth += charWidth) >= remainWidth) continue;
                    sb.append(ch);
                }
                if (!sb.toString().equals(text)) {
                    sb.append(PROMPT_ELLIPSIS);
                }
                return sb.toString();
            }
            return text;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "param1JList", "com/alibabacloud/intellij/cosy/ui/search/renderer/InputSuggestPromptListCellRender$SuggestPromptCellRender", "customizeCellRenderer"));
        }
    }
}

