/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.listener;

import com.alibabacloud.intellij.cosy.ui.search.SearchMainPanel;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;

public class SearchTextFieldListener
implements FocusListener {
    private String BLANK_TEXT = "";
    private String defaultText;
    private JTextField jTextField;
    private SearchMainPanel searchMainPanel;

    public SearchTextFieldListener(JTextField jTextField, String defaultText) {
        this.jTextField = jTextField;
        this.defaultText = defaultText;
        jTextField.setText(defaultText);
        jTextField.setForeground(Color.GRAY);
    }

    public SearchTextFieldListener(JTextField jTextField, SearchMainPanel searchMainPanel, String defaultText) {
        this.jTextField = jTextField;
        this.searchMainPanel = searchMainPanel;
        this.defaultText = defaultText;
        jTextField.setText(defaultText);
        jTextField.setForeground(Color.GRAY);
        jTextField.setText(defaultText);
    }

    @Override
    public void focusGained(FocusEvent e) {
        String text = this.jTextField.getText();
        if (this.defaultText.equals(text)) {
            this.jTextField.setText(this.BLANK_TEXT);
        }
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        this.jTextField.setForeground(editorColorsScheme.getDefaultForeground());
    }

    @Override
    public void focusLost(FocusEvent e) {
        String text = this.jTextField.getText();
        if (StringUtils.isEmpty((CharSequence)text)) {
            this.jTextField.setForeground(Color.GRAY);
            this.jTextField.setText(this.defaultText);
        }
    }
}

