/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.generate;

import com.alibabacloud.intellij.cosy.chat.model.ChatAskInput;
import com.alibabacloud.intellij.cosy.chat.model.task.DisplayTask;
import com.alibabacloud.intellij.cosy.layout.WrapForKeywordLayout;
import com.alibabacloud.intellij.cosy.search.enums.TrackEventTypeEnum;
import com.alibabacloud.intellij.cosy.service.TelemetryService;
import com.alibabacloud.intellij.cosy.ui.search.component.DisplayLabel;
import com.alibabacloud.intellij.cosy.ui.search.generate.GenerateContentForm;
import com.alibabacloud.intellij.cosy.ui.search.model.GenerateInput;
import com.alibabacloud.intellij.cosy.util.ChatTaskUtil;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.intellij.openapi.project.Project;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class QuickAskPanel
extends JPanel {
    private final JPanel questionTagPanel;
    private final Project project;
    private final GenerateContentForm parentComponent;

    public QuickAskPanel(Project project, GenerateContentForm parentComponent, GenerateInput input, List<DisplayTask> displayTasks) {
        super(new BorderLayout());
        this.project = project;
        this.parentComponent = parentComponent;
        this.questionTagPanel = new JPanel(new WrapForKeywordLayout(8, 8));
        this.questionTagPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
        this.add((Component)this.questionTagPanel, "Center");
        this.setOpaque(false);
        this.questionTagPanel.setOpaque(false);
        for (DisplayTask displayTask : displayTasks) {
            String displayText = displayTask.getDisplayTextLocale();
            DisplayLabel label = new DisplayLabel(displayText, ColorUtil.getToolWindowBackgroundColor(), null);
            label.setExtraData(displayTask);
            label.setChatTask(displayTask.getChatTask());
            label.setCursor(Cursor.getPredefinedCursor(12));
            this.registerTagAction(label, input);
            this.questionTagPanel.add(label);
        }
    }

    private void registerTagAction(final DisplayLabel label, final GenerateInput input) {
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (QuickAskPanel.this.project != null && input != null) {
                    if (label.getChatTask() != null) {
                        input.setChatTask(label.getChatTask());
                    }
                    DisplayTask displayTask = (DisplayTask)label.getExtraData();
                    String requestId = UUID.randomUUID().toString();
                    TelemetryService.getInstance().telemetryChatTask(QuickAskPanel.this.project, TrackEventTypeEnum.CHAT_TRIGGER_QUICK_ASK, requestId, input.getChatContext().getSessionId(), ChatTaskUtil.getQuickAskChatTask(input), input);
                    ChatAskInput chatAskInput = new ChatAskInput();
                    chatAskInput.setText(displayTask.getDisplayTextLocale());
                    input.setChatAskInput(chatAskInput);
                    QuickAskPanel.this.parentComponent.prepareAndAsynchronousChat(input, displayTask.getPrompt(), displayTask.getDisplayTextLocale(), requestId);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                label.setBackground(ColorUtil.getEditorBackgroundColor());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                label.setBackground(ColorUtil.getToolWindowBackgroundColor());
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        Dimension qaSize = this.questionTagPanel.getPreferredSize();
        return new Dimension(size.width, qaSize.height);
    }
}

