/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.generate;

import com.alibabacloud.intellij.cosy.layout.ChatTagLayout;
import com.alibabacloud.intellij.cosy.ui.search.generate.ChatAskTagPanel;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatAskTag;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;

public class InputTagsPanel
extends JPanel {
    private static final int MIN_ROW_HEIGHT = 24;

    public InputTagsPanel() {
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.setBackground(ColorUtil.getEditorBackgroundColor());
        this.setLayout(new ChatTagLayout(8, 8, true, 24));
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(ColorUtil.getEditorBackgroundColor());
    }

    public void addTag(ChatAskTag tag) {
        if (StringUtils.isBlank((CharSequence)tag.getText())) {
            return;
        }
        ChatAskTagPanel askTag = new ChatAskTagPanel(tag);
        int insertIndex = 0;
        for (int i = this.getComponentCount() - 1; i >= 0; --i) {
            Component component = this.getComponent(i);
            if (component instanceof ChatAskTagPanel) continue;
            insertIndex = i;
            break;
        }
        this.add((Component)askTag, insertIndex);
        this.revalidate();
        this.repaint();
    }

    public List<ChatAskTag> getTags() {
        ArrayList<ChatAskTag> tags = new ArrayList<ChatAskTag>();
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof ChatAskTagPanel)) continue;
            ChatAskTagPanel askTag = (ChatAskTagPanel)component;
            tags.add(askTag.getTag());
        }
        return tags;
    }

    public void removeTags() {
        ArrayList<Component> tagComponents = new ArrayList<Component>();
        for (int i = this.getComponentCount() - 1; i >= 0; --i) {
            Component component = this.getComponent(i);
            if (!(component instanceof ChatAskTagPanel)) continue;
            tagComponents.add(component);
        }
        if (!tagComponents.isEmpty()) {
            for (Component component : tagComponents) {
                this.remove(component);
            }
            this.revalidate();
            this.repaint();
        }
    }

    public void removeLast() {
        for (int i = this.getComponentCount() - 1; i >= 0; --i) {
            Component component = this.getComponent(i);
            if (!(component instanceof ChatAskTagPanel)) continue;
            this.remove(component);
            this.revalidate();
            this.repaint();
            break;
        }
    }
}

