/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.generate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibabacloud.intellij.cosy.chat.enums.AgentTagEnum;
import com.alibabacloud.intellij.cosy.chat.enums.ChatTaskEnum;
import com.alibabacloud.intellij.cosy.chat.enums.ScopeTagEnum;
import com.alibabacloud.intellij.cosy.chat.enums.TriggerPlaceEnum;
import com.alibabacloud.intellij.cosy.chat.factory.ChatContextDtoBuilderFactory;
import com.alibabacloud.intellij.cosy.chat.model.AskAnswer;
import com.alibabacloud.intellij.cosy.chat.model.ChatAskInput;
import com.alibabacloud.intellij.cosy.chat.model.ChatAskParam;
import com.alibabacloud.intellij.cosy.chat.model.ChatContext;
import com.alibabacloud.intellij.cosy.chat.model.ChatHistory;
import com.alibabacloud.intellij.cosy.chat.model.ChatReplyRequestParam;
import com.alibabacloud.intellij.cosy.chat.model.ChatStopParam;
import com.alibabacloud.intellij.cosy.chat.model.ChatSystemEventParam;
import com.alibabacloud.intellij.cosy.chat.model.result.ChatAskResult;
import com.alibabacloud.intellij.cosy.chat.model.result.ChatReplyListResult;
import com.alibabacloud.intellij.cosy.chat.model.task.DisplayTask;
import com.alibabacloud.intellij.cosy.chat.model.task.dto.CodeRelatedDto;
import com.alibabacloud.intellij.cosy.chat.model.task.dto.SimpleTextDto;
import com.alibabacloud.intellij.cosy.chat.model.task.dto.TestcaseGenerationDto;
import com.alibabacloud.intellij.cosy.chat.processor.ActionTriggerHelper;
import com.alibabacloud.intellij.cosy.common.CosyCacheKeys;
import com.alibabacloud.intellij.cosy.constants.ActionConstants;
import com.alibabacloud.intellij.cosy.constants.CosyKey;
import com.alibabacloud.intellij.cosy.constants.InputConstants;
import com.alibabacloud.intellij.cosy.constants.ShortcutConstants;
import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStateEnum;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthWhitelistStatusEnum;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ChatRecord;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ChatSession;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ChatStep;
import com.alibabacloud.intellij.cosy.search.enums.TrackEventTypeEnum;
import com.alibabacloud.intellij.cosy.search.result.SearchContext;
import com.alibabacloud.intellij.cosy.search.util.BackgroundAdaptUtil;
import com.alibabacloud.intellij.cosy.search.util.PopUtil;
import com.alibabacloud.intellij.cosy.service.CosyService;
import com.alibabacloud.intellij.cosy.service.TelemetryService;
import com.alibabacloud.intellij.cosy.service.UserAuthService;
import com.alibabacloud.intellij.cosy.service.impl.CosyServiceImpl;
import com.alibabacloud.intellij.cosy.ui.BaseComponent;
import com.alibabacloud.intellij.cosy.ui.notifications.GrantAuthorNotification;
import com.alibabacloud.intellij.cosy.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.cosy.ui.search.I18NConstant;
import com.alibabacloud.intellij.cosy.ui.search.SearchToolWindowFactory;
import com.alibabacloud.intellij.cosy.ui.search.SwingManager;
import com.alibabacloud.intellij.cosy.ui.search.color.CosyColor;
import com.alibabacloud.intellij.cosy.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.SystemMessageCard;
import com.alibabacloud.intellij.cosy.ui.search.component.WelcomeBgPanel;
import com.alibabacloud.intellij.cosy.ui.search.enums.ChatStageParseKey;
import com.alibabacloud.intellij.cosy.ui.search.enums.ChatSystemEventEnum;
import com.alibabacloud.intellij.cosy.ui.search.generate.AskInputPanel;
import com.alibabacloud.intellij.cosy.ui.search.generate.ChatQuestionForm;
import com.alibabacloud.intellij.cosy.ui.search.generate.GenerateAnswerPanel;
import com.alibabacloud.intellij.cosy.ui.search.generate.InputTagsPanel;
import com.alibabacloud.intellij.cosy.ui.search.generate.NewFileAction;
import com.alibabacloud.intellij.cosy.ui.search.generate.ShowDiffAction;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatAskTag;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatReferenceChunk;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatReferenceItem;
import com.alibabacloud.intellij.cosy.ui.search.model.CodeWithExt;
import com.alibabacloud.intellij.cosy.ui.search.model.CosySseErrorMessage;
import com.alibabacloud.intellij.cosy.ui.search.model.GenerateInput;
import com.alibabacloud.intellij.cosy.ui.search.model.SuggestPrompt;
import com.alibabacloud.intellij.cosy.ui.search.renderer.InputSuggestPromptListCellRender;
import com.alibabacloud.intellij.cosy.ui.search.topic.AnyGenerateNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.AuthLoginNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.AuthLogoutNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.AuthStateChangeNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.GenerateAskNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.GenerateStepCallbackNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.GenerateStreamPauseNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.GenerateStreamPushNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.GenerateStreamStopNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.LingmaCodeDiffNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.LingmaCodeNewFileNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.LingmaOpenToolWindowNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.LingmaTabChangeNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.SuggestPromptNotifier;
import com.alibabacloud.intellij.cosy.util.ChatAskTagUtil;
import com.alibabacloud.intellij.cosy.util.ChatSessionUtil;
import com.alibabacloud.intellij.cosy.util.ChatTaskUtil;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.EditorUtil;
import com.alibabacloud.intellij.cosy.util.FileUtil;
import com.alibabacloud.intellij.cosy.util.LanguageUtil;
import com.alibabacloud.intellij.cosy.util.LoginUtil;
import com.alibabacloud.intellij.cosy.util.RecentQueryUtil;
import com.alibabacloud.intellij.cosy.util.SwingUtil;
import com.alibabacloud.intellij.cosy.util.ThemeUtil;
import com.alibabacloud.intellij.cosy.util.ThreadUtil;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class GenerateContentForm
implements BaseComponent,
Disposable {
    private static Logger log = Logger.getInstance(GenerateContentForm.class);
    private static final int EDITOR_MAX_HEIGHT = 320;
    private static final int COSY_GENERATE_TIMEOUT = 20;
    private static final ScheduledExecutorService SCHEDULED_EXECUTOR = Executors.newSingleThreadScheduledExecutor();
    private JPanel basePanel;
    private JBScrollPane scrollPane;
    private JPanel expandPanel;
    private JLabel expandLabel;
    private JPanel flowPanel;
    private Project project;
    private GenerateAnswerPanel answerPanel;
    private GenerateInput initInput;
    private MessageBusConnection messageBusConnection;
    private CosyService cosyService;
    private JComponent mainComponent;
    private AskInputPanel inputPanel;
    private CodeWithExt questionCodeWithExt;
    private List<SuggestPrompt> suggestValueList;
    private JBList<SuggestPrompt> promptItemList;
    private JBPopup promptSuggestPopup;
    private ListWithFilter<SuggestPrompt> listComponent;
    private JScrollBar listComponentScrollBar;
    private PopupChooserBuilder<SuggestPrompt> chooserBuilder;
    private int lastPopupHeight = 0;
    private AtomicBoolean manualScroll;

    public GenerateContentForm(Project project, String requestId, JComponent mainComponent) {
        this.project = project;
        this.$$$setupUI$$$();
        this.initInput = ChatTaskUtil.getInitInput(project);
        this.mainComponent = mainComponent;
        this.cosyService = new CosyServiceImpl();
        this.manualScroll = new AtomicBoolean(false);
        this.basePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setupTextArea(this.initInput);
        this.flowPanel.setLayout((LayoutManager)new VerticalFlowLayout(2, 0, 8, true, false));
        this.flowPanel.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 12));
        this.flowPanel.setBackground((Color)CosyColor.CHAT_QUESTION_BG_COLOR);
        this.scrollPane.addMouseWheelListener(e -> {
            if (this.inputPanel != null) {
                this.inputPanel.invalidate();
                this.inputPanel.repaint();
            }
            if (this.scrollPane.getVerticalScrollBar().isVisible()) {
                this.manualScroll.getAndSet(!SwingUtil.isScrollBarAtBottom((JScrollPane)this.scrollPane));
            }
        });
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        SwingManager.INSTANCE.registerComponent(project, "CHAT_MAIN_VERTICAL_SCROLLBAR_KEY", (Component)this.scrollPane);
        this.messageBusConnection = this.project.getMessageBus().connect();
        this.messageBusConnection.subscribe(GenerateStreamPushNotifier.GENERATE_STREAM_PUSH_NOTIFICATION, this::pushGenerate);
        this.messageBusConnection.subscribe(GenerateStreamStopNotifier.GENERATE_STREAM_STOP_NOTIFICATION, this::stopGenerate);
        this.messageBusConnection.subscribe(GenerateStreamPauseNotifier.GENERATE_STREAM_PAUSE_NOTIFICATION, this::pauseGenerate);
        this.messageBusConnection.subscribe(GenerateStepCallbackNotifier.GENERATE_PROCESS_STEP_CALLBACK_NOTIFICATION, this::processStepCallback);
        this.messageBusConnection.subscribe(AuthLoginNotifier.AUTH_LOGIN_NOTIFICATION, this::notifyLoginAuth);
        this.messageBusConnection.subscribe(AuthLogoutNotifier.AUTH_LOGOUT_NOTIFICATION, this::notifyLogoutAuth);
        this.messageBusConnection.subscribe(AuthStateChangeNotifier.AUTH_CHANGE_NOTIFICATION, this::notifyChangeAuth);
        this.messageBusConnection.subscribe(SuggestPromptNotifier.SUGGEST_PROMPT_NOTIFICATION, this::suggestPrompts);
        this.messageBusConnection.subscribe(AnyGenerateNotifier.ANY_GENERATE_NOTIFICATION, this::anyGenerate);
        this.messageBusConnection.subscribe(LingmaCodeDiffNotifier.LINGMA_CODE_DIFF, this::showDiff);
        this.messageBusConnection.subscribe(LingmaCodeNewFileNotifier.LINGMA_CODE_NEW_FILE, this::newFile);
        this.messageBusConnection.subscribe(LingmaOpenToolWindowNotifier.LINGMA_OPEN_TOOL_WINDOW_NOTIFIER_TOPIC, this::handleOpenToolWindow);
        SwingUtil.foreachChildComponent(this.basePanel, cp -> {
            if (cp instanceof JPanel && !(cp instanceof RoundRectPanel) && !(cp instanceof AskInputPanel) && !(cp instanceof InputTagsPanel)) {
                cp.setBackground(ColorUtil.getToolWindowBackgroundColor());
            }
        });
        this.messageBusConnection.subscribe(GenerateAskNotifier.GENERATE_ASK_NOTIFIER, this::triggerAsk);
        if (this.initInput != null) {
            if (this.initInput.getChatTask() != null) {
                this.triggerAsk(this.initInput, requestId);
            } else if (!Boolean.FALSE.equals(CosyCacheKeys.NEED_INIT_WELCOME_WINDOW.get((UserDataHolder)project))) {
                SwingUtilities.invokeLater(() -> this.showWelcomeInfoPanel(true));
                CosyCacheKeys.NEED_INIT_WELCOME_WINDOW.set((UserDataHolder)project, (Object)Boolean.TRUE);
            }
        }
        this.initSuggestPromptChooser();
        this.addInputPanelListener();
        BackgroundAdaptUtil.monitorMarkdownPaneColor(this.flowPanel);
        this.inputPanel.updateLayout();
    }

    private void drawClearContextLine() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, ColorUtil.getEditorBackgroundColor()), "Context Cleared", 2, 0, null, ColorUtil.getAuxiliaryForegroundColor()));
        this.flowPanel.add(panel);
    }

    private void clearChat(String sessionId, String requestId) {
        this.inputPanel.clearTags();
        this.manualScroll.getAndSet(false);
        this.drawClearContextLine();
        this.moveScrollToBottom();
        ChatSystemEventParam param = ChatSystemEventParam.builder().sessionId(sessionId).requestId(requestId).systemEvent(ChatSystemEventEnum.SESSION_HISTORY_CLEAR.getName()).build();
        ThreadUtil.execute(() -> this.cosyService.chatSystemEvent(this.project, param));
        AuthStatus status = LoginUtil.getAuthStatusCacheFirst(this.project);
        this.inputPanel.setState(status);
        this.archiveChatHistory();
        ChatHistory chatHistory = this.initInput.getChatHistory();
        this.initInput = ChatTaskUtil.getInitInput(this.project);
        this.initInput.getChatContext().setSessionId(sessionId);
        this.initInput.setChatHistory(chatHistory);
        this.flowPanel.grabFocus();
    }

    private void archiveChatHistory() {
        List<AskAnswer> toArchive = this.initInput.getChatHistory().getAskAnswerList();
        if (CollectionUtils.isNotEmpty(toArchive)) {
            if (this.initInput.getChatHistory().getArchivedAskAnswerList() == null) {
                this.initInput.getChatHistory().setArchivedAskAnswerList(new ArrayList<AskAnswer>());
            }
            this.initInput.getChatHistory().getArchivedAskAnswerList().addAll(toArchive);
            this.initInput.getChatHistory().setAskAnswerList(new ArrayList<AskAnswer>());
        }
    }

    private void addInputPanelListener() {
        this.inputPanel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                String text;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (StringUtils.isBlank((CharSequence)(text = GenerateContentForm.this.inputPanel.textArea.getText()))) {
                    return;
                }
                KeyStroke stroke = KeyStroke.getKeyStrokeForEvent(e);
                int keyCode = ShortcutConstants.UP_SHORTCUTS.contains(stroke) ? 38 : (ShortcutConstants.DOWN_SHORTCUTS.contains(stroke) ? 40 : e.getKeyCode());
                switch (keyCode) {
                    case 40: {
                        ScrollingUtil.moveDown(GenerateContentForm.this.promptItemList, (int)e.getModifiersEx());
                        break;
                    }
                    case 38: {
                        ScrollingUtil.moveUp(GenerateContentForm.this.promptItemList, (int)e.getModifiersEx());
                        break;
                    }
                    case 33: {
                        ScrollingUtil.movePageUp(GenerateContentForm.this.promptItemList);
                        break;
                    }
                    case 34: {
                        ScrollingUtil.movePageDown(GenerateContentForm.this.promptItemList);
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 8) {
                    if ("".equals(GenerateContentForm.this.inputPanel.textArea.getText())) {
                        --GenerateContentForm.this.inputPanel.inputFieldEmptyCount;
                        if (GenerateContentForm.this.inputPanel.inputFieldEmptyCount == 0) {
                            GenerateContentForm.this.inputPanel.removeLastTag();
                            GenerateContentForm.this.setTextAreaPlaceholder();
                            GenerateContentForm.this.inputPanel.inputFieldEmptyCount = 1;
                            GenerateContentForm.this.inputPanel.updateLayout();
                        }
                    } else if (GenerateContentForm.this.inputPanel.textArea.getCaretPosition() == 0) {
                        if (GenerateContentForm.this.inputPanel.pressBackSpaceCountWhenDelTag == 0) {
                            GenerateContentForm.this.inputPanel.removeLastTag();
                            GenerateContentForm.this.setTextAreaPlaceholder();
                            GenerateContentForm.this.inputPanel.updateLayout();
                        } else {
                            --GenerateContentForm.this.inputPanel.pressBackSpaceCountWhenDelTag;
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/alibabacloud/intellij/cosy/ui/search/generate/GenerateContentForm$1", "keyPressed"));
            }
        });
    }

    private void setTextAreaPlaceholder() {
        if (CollectionUtils.isEmpty(this.inputPanel.getTags())) {
            boolean isFirstRoundChat;
            boolean bl = isFirstRoundChat = this.initInput.getChatHistory() != null && CollectionUtils.isEmpty(this.initInput.getChatHistory().getAskAnswerList());
            if (BooleanUtils.isTrue((Boolean)isFirstRoundChat)) {
                this.inputPanel.textArea.setPlaceholder(CosyBundle.message("chat.input.placeholder.normal", new Object[0]));
            } else {
                this.inputPanel.textArea.setPlaceholder(CosyBundle.message("chat.input.placeholder.normal.continue", new Object[0]));
            }
        }
    }

    private void newFile(String content, String markdownLanguage, CodeWithExt questionCodeWithExt, Boolean isTestcase) {
        String ext = LanguageUtil.guessExtensionByMarkdownLanguage(markdownLanguage);
        if (StringUtils.isBlank((CharSequence)ext) && questionCodeWithExt != null) {
            ext = questionCodeWithExt.getExt();
        }
        String sourceFilePath = null;
        if (questionCodeWithExt != null) {
            sourceFilePath = questionCodeWithExt.getFilePath();
        }
        NewFileAction newFileAction = new NewFileAction(this.project, content, isTestcase, ext, sourceFilePath);
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)this.getComponent());
        newFileAction.actionPerformed(new AnActionEvent(null, dataContext, "EditorPopup", new Presentation(), ActionManager.getInstance(), 0));
    }

    private void showDiff(String answerCode, String markdownLanguage, CodeWithExt questionCodeWithExt) {
        String ext = LanguageUtil.guessExtensionByMarkdownLanguage(markdownLanguage);
        if (StringUtils.isBlank((CharSequence)ext) && questionCodeWithExt != null) {
            ext = questionCodeWithExt.getExt();
        }
        String sourceFilePath = null;
        if (questionCodeWithExt != null) {
            sourceFilePath = questionCodeWithExt.getFilePath();
        }
        ShowDiffAction showDiffAction = new ShowDiffAction(this.project, questionCodeWithExt.getContent(), answerCode, ext, sourceFilePath);
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)this.getComponent());
        showDiffAction.actionPerformed(new AnActionEvent(null, dataContext, "EditorPopup", new Presentation(), ActionManager.getInstance(), 0));
    }

    private void initSuggestPromptChooser() {
        this.chooserBuilder = (PopupChooserBuilder)JBPopupFactory.getInstance().createPopupChooserBuilder(new ArrayList());
        this.promptItemList = (JBList)this.chooserBuilder.getChooserComponent();
        this.promptItemList.setBackground(ColorUtil.getListBackground());
        this.chooserBuilder.setRequestFocus(false);
        this.chooserBuilder.setMovable(false);
        this.chooserBuilder.setRenderer((ListCellRenderer)new InputSuggestPromptListCellRender(this.inputPanel, this));
        this.promptItemList.getEmptyText().setText("");
        this.chooserBuilder.setVisibleRowCount(11);
        this.chooserBuilder.setItemChosenCallback((Consumer)new Consumer<Object>(){

            public void consume(Object object) {
                if (object instanceof SuggestPrompt) {
                    SuggestPrompt suggestPrompt = (SuggestPrompt)object;
                    GenerateContentForm.this.triggerChooserSuggestPromptSelection(suggestPrompt);
                    GenerateContentForm.this.inputPanel.clearTextArea();
                }
            }
        });
    }

    private void triggerChooserSuggestPromptSelection(SuggestPrompt suggestPrompt) {
        if (suggestPrompt.getActionCommand() != null) {
            String command = suggestPrompt.getActionCommand();
            if (command.startsWith("action:")) {
                String actionId = command.substring("action:".length());
                if (ActionConstants.TRIGGER_SELECTION_CODE_ACTION_LIST.contains(actionId)) {
                    this.inputPanel.addTag(ChatAskTag.ofTask(suggestPrompt.getId(), suggestPrompt.getText()));
                } else if ("TriggerCosyClearHistoryAction".equals(actionId)) {
                    this.clearChat(this.initInput.getChatContext().getSessionId(), UUID.randomUUID().toString());
                } else if ("TriggerCosyHelpAction".equals(actionId)) {
                    this.showHelpAnswer();
                }
            }
        } else if (suggestPrompt != null) {
            this.inputPanel.addTag(ChatAskTag.buildTag(suggestPrompt.getId(), suggestPrompt.getText()));
        }
        this.promptItemList.setModel((ListModel)new CollectionListModel(new ArrayList()));
        this.promptSuggestPopup.cancel();
    }

    private void handleOpenToolWindow() {
        this.inputPanel.setTextFocus();
    }

    private void showWelcomeInfoPanel() {
        this.showWelcomeInfoPanel(false);
    }

    private void showWelcomeInfoPanel(boolean startup) {
        this.flowPanel.removeAll();
        String message = null;
        AuthStatus status = null;
        status = startup ? LoginUtil.getAuthStatus(this.project) : LoginUtil.getAuthStatusCacheFirst(this.project);
        if (status.getStatus() == null) {
            status.setStatus(AuthStateEnum.NOT_LOGIN.getValue());
        }
        message = AuthStateEnum.LOGIN.getValue() == status.getStatus().intValue() ? (status.getWhitelist() != null && AuthWhitelistStatusEnum.PASS.getValue() == status.getWhitelist().intValue() ? CosyBundle.messageVpc("message.chat.quick.ask", new Object[0]) : (status.getWhitelist() != null && AuthWhitelistStatusEnum.NO_LICENCE.getValue() == status.getWhitelist().intValue() && StringUtils.isNotBlank((CharSequence)status.getOrgId()) ? CosyBundle.messageVpc("message.chat.login.require.licence.access", new Object[0]) : (StringUtils.isNotBlank((CharSequence)status.getOrgId()) ? String.format(CosyBundle.messageVpc("message.chat.login.require.org.access", new Object[0]), status.getName(), status.getOrgName()) : String.format(CosyBundle.messageVpc("message.chat.login.require.access", new Object[0]), status.getName())))) : (AuthStateEnum.NETWORK_ERROR.getValue() == status.getStatus().intValue() ? CosyBundle.message("message.chat.quick.network.error", new Object[0]) : (AuthStateEnum.IP_BANNED_ERROR.getValue() == status.getStatus().intValue() ? CosyBundle.message("message.chat.login.ip.whitelist.error", new Object[0]) : (AuthStateEnum.APP_DISABLED_ERROR.getValue() == status.getStatus().intValue() ? CosyBundle.message("message.chat.login.app.disabled.error", new Object[0]) : CosyBundle.message("message.chat.not.login", new Object[0]))));
        SystemMessageCard card = new SystemMessageCard(this.project, message);
        this.flowPanel.add(card);
        this.inputPanel.setState(status);
        ((WelcomeBgPanel)this.flowPanel).setShowTooltips(true);
        this.flowPanel.invalidate();
        this.flowPanel.validate();
        this.flowPanel.repaint();
        this.initInput = ChatTaskUtil.getInitInput(this.project);
        TelemetryService.getInstance().telemetrySessionId(this.project, TrackEventTypeEnum.CHAT_NEW_SESSION, UUID.randomUUID().toString(), this.initInput.getChatContext().getSessionId());
    }

    private void hideWelcomeInfoPanel() {
        for (Component component : this.flowPanel.getComponents()) {
            if (!(component instanceof SystemMessageCard)) continue;
            this.flowPanel.remove(component);
        }
        this.inputPanel.setIsHistoryEmpty(false);
        ((WelcomeBgPanel)this.flowPanel).setShowTooltips(false);
    }

    private void anyGenerate(SearchContext context, GenerateInput input, String requestId) {
        if (input.getChatContext() == null) {
            log.warn("generate context is null");
            return;
        }
        ((LingmaTabChangeNotifier)this.project.getMessageBus().syncPublisher(LingmaTabChangeNotifier.CHANGE_MAIN_TAB_NOTIFICATION)).changeTab("chat");
        if (CollectionUtils.isNotEmpty(this.initInput.getChatHistory().getAskAnswerList())) {
            this.clearChat(this.initInput.getChatContext().getSessionId(), UUID.randomUUID().toString());
        }
        this.recordSelectionCode(this.project);
        if (CollectionUtils.isEmpty(input.getTags())) {
            String text = InputConstants.CHAT_TASK_QUERY_MAP.get(input.getChatTask());
            if (text != null) {
                this.inputPanel.resetRecentQueryIndex();
                RecentQueryUtil.addRecentQuery(this.project, text, null);
            }
        } else {
            String text = input.getChatAskInput().getText();
            this.inputPanel.resetRecentQueryIndex();
            RecentQueryUtil.addRecentQuery(this.project, text, input.getTags());
        }
        this.triggerAsk(input, requestId);
    }

    private void suggestPrompts(List<SuggestPrompt> suggestPrompts) {
        if (!this.inputPanel.textArea.isFocusOwner()) {
            return;
        }
        if (this.promptSuggestPopup != null && CollectionUtils.isEmpty(suggestPrompts)) {
            this.promptSuggestPopup.cancel();
            return;
        }
        if (CollectionUtils.isEmpty(suggestPrompts)) {
            return;
        }
        if (PopUtil.isPopUsable(this.promptSuggestPopup)) {
            this.promptItemList.setModel((ListModel)new CollectionListModel(suggestPrompts));
            this.promptItemList.setSelectedIndex(0);
            ScrollingUtil.ensureIndexIsVisible(this.promptItemList, (int)0, (int)1);
            this.promptItemList.getEmptyText().setText("");
            this.adjustJbPopSize();
            Point inputPanelLocation = this.inputPanel.inputPanel.getLocationOnScreen();
            int currentHeight = (int)this.promptSuggestPopup.getContent().getPreferredSize().getHeight();
            if (this.lastPopupHeight != currentHeight) {
                this.promptSuggestPopup.setLocation(new Point(inputPanelLocation.x, inputPanelLocation.y - currentHeight - 10 - 8));
                this.lastPopupHeight = currentHeight;
            }
            return;
        }
        if (this.promptSuggestPopup != null) {
            this.promptSuggestPopup.cancel();
        }
        this.promptItemList.setModel((ListModel)new CollectionListModel(suggestPrompts));
        this.promptSuggestPopup = this.chooserBuilder.createPopup();
        this.promptItemList.setSelectedIndex(0);
        this.promptItemList.getEmptyText().setText("");
        this.listComponent = (ListWithFilter)((JPanel)this.promptSuggestPopup.getContent().getComponent(0)).getComponent(0);
        this.listComponent.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.listComponentScrollBar = this.listComponent.getScrollPane().getHorizontalScrollBar();
        this.adjustJbPopSize();
        Point inputPanelLocation = this.inputPanel.inputPanel.getLocationOnScreen();
        int currentHeight = (int)this.promptSuggestPopup.getContent().getPreferredSize().getHeight();
        this.promptSuggestPopup.showInScreenCoordinates((Component)this.inputPanel, new Point(inputPanelLocation.x, inputPanelLocation.y - currentHeight - 10 - 8));
        this.lastPopupHeight = currentHeight;
    }

    private void adjustJbPopSize() {
        int width = Math.max(this.inputPanel.getSize().width, this.inputPanel.getPreferredSize().width);
        Dimension dimension = new Dimension(width, this.listComponent.getPreferredSize().height);
        dimension.height += this.listComponentScrollBar.getPreferredSize().height;
        this.promptSuggestPopup.setSize(dimension);
    }

    private void triggerAsk(GenerateInput input, String requestId) {
        if (this.project != null && input != null) {
            boolean containsCode;
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.project).getToolWindow("Code Search");
            if (toolWindow == null) {
                return;
            }
            if (!toolWindow.isVisible()) {
                SearchToolWindowFactory.showToolWindow(this.project);
            }
            if (StringUtils.isEmpty((CharSequence)this.initInput.getChatTask()) && StringUtils.isNotEmpty((CharSequence)input.getChatTask())) {
                this.initInput.setChatTask(input.getChatTask());
            }
            String displayText = input.getQuestion();
            boolean isFirstRoundChat = input.getChatHistory() != null && CollectionUtils.isEmpty(input.getChatHistory().getAskAnswerList());
            boolean bl = containsCode = input.getChatContext() != null && StringUtils.isNotBlank((CharSequence)input.getChatContext().getSourceCode()) && StringUtils.isNotBlank((CharSequence)input.getChatContext().getFilePath());
            if (isFirstRoundChat && containsCode) {
                this.questionCodeWithExt = CodeWithExt.builder().content(input.getChatContext().getSourceCode()).filePath(input.getChatContext().getFilePath()).ext(FileUtil.getPathExt(input.getChatContext().getFilePath())).build();
                StringBuilder sb = new StringBuilder(displayText);
                sb.append("\n").append("```").append(FileUtil.getPathExt(input.getChatContext().getFilePath())).append("\n").append(input.getChatContext().getSourceCode()).append("\n```");
                displayText = sb.toString();
            }
            this.prepareAndAsynchronousChat(input, input.getQuestion(), displayText, requestId);
        }
    }

    public boolean isFirstRoundChatProcessing() {
        boolean noChatHistory = this.initInput.getChatHistory() == null;
        boolean hasNotAsked = this.initInput.getChatHistory() != null && CollectionUtils.isEmpty(this.initInput.getChatHistory().getAskAnswerList());
        boolean askNotAnswered = this.initInput.getChatHistory() != null && CollectionUtils.isNotEmpty(this.initInput.getChatHistory().getAskAnswerList()) && this.initInput.getChatHistory().getAskAnswerList().size() == 1;
        return noChatHistory || hasNotAsked || askNotAnswered;
    }

    public boolean isFirstRoundChatFinished() {
        return this.initInput.getChatHistory() != null && CollectionUtils.isNotEmpty(this.initInput.getChatHistory().getAskAnswerList()) && this.initInput.getChatHistory().getAskAnswerList().size() == 1 && this.initInput.getChatHistory().getAskAnswerList().get(0).getAnswer() != null;
    }

    public String getFirstRoundTask() {
        return this.initInput.getChatTask();
    }

    public void prepareAnswer(GenerateInput input, String chatTask, String displayText) {
        if (this.answerPanel != null) {
            this.answerPanel.hideBottomPanel();
        }
        ChatAskInput chatAskInput = input.getChatAskInput();
        this.answerPanel = new GenerateAnswerPanel(this.project, this, this.basePanel, chatTask, chatAskInput);
        String extraTextFormChatContext = this.getExtraTextFormChatContext(input, displayText);
        this.flowPanel.add(new ChatQuestionForm(this.project, this.basePanel, extraTextFormChatContext, null, chatAskInput).getComponent());
        this.flowPanel.add(this.answerPanel.getComponent());
        this.moveScrollToBottom();
    }

    private String getExtraTextFormChatContext(GenerateInput input, String originDisplayText) {
        if (input == null || input.getChatAskInput() == null) {
            return originDisplayText;
        }
        Object chatContextObj = ChatContextDtoBuilderFactory.getChatContextDtoBuilder(input.getChatTask()).build(input, originDisplayText);
        if (chatContextObj == null) {
            return originDisplayText;
        }
        String code = null;
        if (chatContextObj instanceof TestcaseGenerationDto) {
            code = ((TestcaseGenerationDto)chatContextObj).getSelectionCode();
        } else if (chatContextObj instanceof CodeRelatedDto) {
            code = ((CodeRelatedDto)chatContextObj).getCode();
        }
        StringBuilder textBuilder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)code)) {
            textBuilder.append("```\n");
            textBuilder.append(code);
            textBuilder.append("```\n");
        }
        return textBuilder.toString();
    }

    private void pushGenerate(String requestId, String sessionId, String value, Boolean overwrite, Boolean refresh) {
        if (this.answerPanel == null) {
            log.warn("Answer panel is not ready when pushGenerate");
            return;
        }
        if (this.answerPanel.getRequestId() == null || this.answerPanel.getSessionId() == null) {
            this.answerPanel.setRequestId(requestId);
            this.answerPanel.setSessionId(sessionId);
        }
        if (!this.answerPanel.getRequestId().equals(requestId)) {
            return;
        }
        if (overwrite.booleanValue()) {
            this.answerPanel.clearText();
            this.answerPanel.hideGenerateStatePanel();
        } else if (BooleanUtils.isTrue((Boolean)refresh)) {
            this.answerPanel.clearText();
        }
        this.answerPanel.appendText(value);
        this.moveScrollToBottom();
        this.answerPanel.getComponent().invalidate();
        this.answerPanel.getComponent().repaint();
        this.moveScrollToBottom();
    }

    private void pauseGenerate(String requestId, String sessionId) {
        this.answerPanel.hideGenerateStatePanel();
        if (!Cosy.INSTANCE.checkCosy(this.project, true)) {
            this.answerPanel.hideBottomPanel();
            this.moveScrollToBottom();
            this.enableSendButton();
            return;
        }
        ChatReplyRequestParam chatReplyRequestParam = ChatReplyRequestParam.builder().requestId(requestId).sessionId(sessionId).build();
        ChatReplyListResult chatReplyListResult = this.cosyService.chatReplyList(this.project, chatReplyRequestParam);
        if (chatReplyListResult != null && Boolean.TRUE.equals(chatReplyListResult.getIsSuccess())) {
            this.answerPanel.showQuickPanel(this.initInput, chatReplyListResult.getDisplayTasks());
        }
        this.enableSendButton();
    }

    private void processStepCallback(String requestId, String sessionId, ChatStep chatStep) {
        if (this.answerPanel == null) {
            log.warn("Answer panel is not ready when processStepCallback");
            return;
        }
        if (this.answerPanel.getRequestId() == null || this.answerPanel.getSessionId() == null) {
            this.answerPanel.setRequestId(requestId);
            this.answerPanel.setSessionId(sessionId);
        }
        if (!this.answerPanel.getRequestId().equals(requestId)) {
            return;
        }
        this.scheduleChatTimeout(requestId, this.initInput);
        this.answerPanel.addOrUpdateStep(chatStep);
        this.moveScrollToBottom();
    }

    private void stopGenerate(String requestId, String sessionId, Integer statusCode, String reason) {
        if (statusCode != null && statusCode == 200) {
            ChatReplyRequestParam chatReplyRequestParam = ChatReplyRequestParam.builder().requestId(requestId).sessionId(sessionId).build();
            this.recordAnswerToHistory(this.answerPanel.getAnswerText());
            if (StringUtils.isBlank((CharSequence)this.answerPanel.getAnswerText())) {
                this.pushGenerate(requestId, sessionId, I18NConstant.CHAT_ANSWER_DONT_KNOW, true, false);
                this.answerPanel.hideBottomPanel();
            } else {
                if (!Cosy.INSTANCE.checkCosy(this.project, true)) {
                    return;
                }
                ChatReplyListResult chatReplyListResult = this.cosyService.chatReplyList(this.project, chatReplyRequestParam);
                GenerateInput input = this.initInput;
                input.getChatContext().setSessionId(sessionId);
                if (chatReplyListResult != null && CollectionUtils.isNotEmpty(chatReplyListResult.getDisplayTasks())) {
                    this.answerPanel.showQuickPanel(input, chatReplyListResult.getDisplayTasks());
                } else {
                    this.showRetryQuickAsk();
                }
            }
        } else {
            log.warn("Abnormal finish chat, code=" + (Serializable)(statusCode == null ? "null" : statusCode) + ", reason=" + reason);
            if (statusCode != null && statusCode == 429) {
                Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_ANSWER_LIST)).remove(requestId);
                this.pushGenerate(requestId, sessionId, I18NConstant.CHAT_TOO_MANY_REQUESTS, true, false);
            } else if (statusCode != null && statusCode == 408) {
                this.pushGenerate(requestId, sessionId, "", false, false);
            } else if (statusCode != null && statusCode == 500) {
                Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_ANSWER_LIST)).remove(requestId);
                this.pushGenerate(requestId, sessionId, I18NConstant.CHAT_INTERNAL_ERROR, true, false);
            } else {
                Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_ANSWER_LIST)).remove(requestId);
                this.pushGenerate(requestId, sessionId, this.convertErrorMessage(requestId, reason), true, false);
            }
            if (statusCode != null && statusCode == 418) {
                this.answerPanel.hideBottomPanel();
            } else {
                this.showRetryQuickAsk();
            }
        }
        this.enableSendButton();
    }

    private String convertErrorMessage(String requestId, String reason) {
        if (reason == null) {
            return "";
        }
        CosySseErrorMessage cosySseErrorMessage = null;
        try {
            cosySseErrorMessage = (CosySseErrorMessage)JSON.parseObject((String)reason, CosySseErrorMessage.class);
        }
        catch (Exception e) {
            log.warn("reason cannot be parsed to CosySseErrorMessage");
        }
        if (cosySseErrorMessage == null) {
            return I18NConstant.CHAT_ANSWER_ABNORMAL + reason;
        }
        if (cosySseErrorMessage.getCode() == null) {
            return I18NConstant.CHAT_ANSWER_ABNORMAL + "request_id=" + requestId;
        }
        switch (cosySseErrorMessage.getCode()) {
            case "101": {
                return I18NConstant.AUTH_SIGNATURE_INVALID;
            }
            case "102": {
                return I18NConstant.AUTH_TIMESTAMP_OUTDATED;
            }
            case "103": {
                return I18NConstant.AUTH_DUPLICATE_REQUEST;
            }
            case "104": {
                return this.getNoAccessRightText(LoginUtil.getAuthStatusCacheFirst(this.project));
            }
            case "105": {
                return I18NConstant.AUTH_LOGIN_OUTDATED;
            }
            case "107": {
                return CosyBundle.message("message.chat.answer.login.ip.whitelist.error", new Object[0]);
            }
            case "108": {
                return CosyBundle.message("message.chat.answer.login.require.licence.access", new Object[0]);
            }
            case "109": {
                return CosyBundle.message("message.chat.answer.login.app.disabled.error", new Object[0]);
            }
            case "418": {
                return I18NConstant.INTENTION_INVALID;
            }
        }
        return I18NConstant.CHAT_ANSWER_ABNORMAL + "code=" + cosySseErrorMessage.getCode() + ", request_id=" + requestId;
    }

    private void showRetryQuickAsk() {
        ArrayList<DisplayTask> displayTasks = new ArrayList<DisplayTask>();
        displayTasks.add(DisplayTask.builder().chatTask(ChatTaskEnum.REPLY_TASK.getName()).displayText(I18NConstant.CHAT_ERROR_RETRY_TIPS).displayEnText(I18NConstant.CHAT_ERROR_RETRY_TIPS).prompt("<COSY::RETRY>").build());
        this.answerPanel.showQuickPanel(this.initInput, displayTasks);
    }

    private void showFirstTimeRetryQuickAsk(GenerateInput input, DisplayTask displayTask) {
        List<DisplayTask> displayTasks = Collections.singletonList(displayTask);
        this.answerPanel.showQuickPanel(input, displayTasks);
    }

    private void hideQuickAsk() {
    }

    public void dispose() {
        if (this.messageBusConnection != null) {
            this.messageBusConnection.disconnect();
            this.messageBusConnection = null;
        }
    }

    private void setupTextArea(GenerateInput input) {
        this.inputPanel.addEnterKeyListener(text -> {
            List taskTagList;
            List<ChatAskTag> tags = this.inputPanel.getTags();
            if (StringUtils.isBlank((CharSequence)text) && CollectionUtils.isEmpty(tags)) {
                this.inputPanel.clearTextArea();
                this.inputPanel.clearTags();
                return;
            }
            if (PopUtil.isPopUsable(this.promptSuggestPopup) && this.promptItemList != null && this.promptItemList.getSelectedValue() != null) {
                SuggestPrompt suggestPrompt = (SuggestPrompt)this.promptItemList.getSelectedValue();
                this.inputPanel.clearTextArea();
                this.triggerChooserSuggestPromptSelection(suggestPrompt);
                return;
            }
            if (CollectionUtils.isEmpty(tags)) {
                this.inputPanel.filterTagsFromText(text, null, null, null);
                if (CollectionUtils.isNotEmpty(this.inputPanel.getTags())) {
                    return;
                }
            }
            if (!this.inputPanel.isSendEnabled()) {
                log.info("send button is not enabled");
                NotificationFactory.showToast((JComponent)this.inputPanel.returnLabel, MessageType.INFO, CosyBundle.message("notifications.send.button.answering", new Object[0]));
                return;
            }
            this.inputPanel.clearTextArea();
            String actionId = null;
            if (CollectionUtils.isNotEmpty(tags) && CollectionUtils.isNotEmpty(taskTagList = tags.stream().filter(tag -> tag.getType().equals("task")).collect(Collectors.toList()))) {
                actionId = InputConstants.TASK_SLASH_ACTION_MAP.get(((ChatAskTag)taskTagList.get(0)).getText());
            }
            if (StringUtils.isEmpty(actionId)) {
                this.triggerFreeInput(this.initInput, text);
                return;
            }
            String finalActionId = actionId;
            ChatAskInput chatAskInput = new ChatAskInput(text, new ArrayList<ChatAskTag>(tags));
            SwingUtilities.invokeLater(() -> {
                ActionTriggerHelper.triggerSelectionAction(this.project, finalActionId, TriggerPlaceEnum.ASK_INPUT_PANEL.getName(), chatAskInput);
                this.inputPanel.clearTags();
            });
        });
    }

    private void triggerFreeInput(GenerateInput input, String text) {
        boolean containsCode;
        List<ChatAskTag> chatAskTags;
        if (StringUtils.isBlank((CharSequence)text)) {
            chatAskTags = this.inputPanel.getTags();
            if (CollectionUtils.isEmpty(chatAskTags)) {
                return;
            }
            List tagsAllowTextNull = chatAskTags.stream().filter(chatAskTag -> "task".equals(chatAskTag.getType()) || AgentTagEnum.LINGMA.getId().equals(chatAskTag.getId())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(tagsAllowTextNull)) {
                return;
            }
        }
        chatAskTags = this.inputPanel.getTags();
        List agentTask = chatAskTags.stream().filter(chatAskTag -> "agent".equals(chatAskTag.getType())).collect(Collectors.toList());
        List scopeTask = chatAskTags.stream().filter(chatAskTag -> "scope".equals(chatAskTag.getType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(agentTask) && CollectionUtils.isEmpty(scopeTask)) {
            String actionId;
            SuggestPrompt suggestPrompt;
            String actionId2;
            if (StringUtils.isNotBlank((CharSequence)text) && InputConstants.WELCOMING_SUGGEST_PROMPT_MAP.containsKey(text.substring(1)) && InputConstants.WELCOMING_SUGGEST_PROMPT_MAP.get(text.substring(1)).getActionCommand().startsWith("action:") && ActionConstants.TRIGGER_SELECTION_CODE_ACTION_LIST.contains(actionId2 = (suggestPrompt = InputConstants.WELCOMING_SUGGEST_PROMPT_MAP.get(text.substring(1))).getActionCommand().substring("action:".length()))) {
                this.inputPanel.addTag(ChatAskTag.ofTask(suggestPrompt.getId(), suggestPrompt.getText()));
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)text) && InputConstants.CONTEXT_SUGGEST_PROMPT_MAP.containsKey(text.substring(1)) && InputConstants.CONTEXT_SUGGEST_PROMPT_MAP.get(text.substring(1)).getActionCommand().startsWith("action:") && "TriggerCosyClearHistoryAction".equals(actionId = InputConstants.CONTEXT_SUGGEST_PROMPT_MAP.get(text.substring(1)).getActionCommand().substring("action:".length()))) {
                this.clearChat(this.initInput.getChatContext().getSessionId(), UUID.randomUUID().toString());
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)text) && InputConstants.WELCOMING_HELP_MAP.containsKey(text.substring(1)) && InputConstants.WELCOMING_HELP_MAP.get(text.substring(1)).getActionCommand().startsWith("action:") && "TriggerCosyHelpAction".equals(actionId = InputConstants.WELCOMING_HELP_MAP.get(text.substring(1)).getActionCommand().substring("action:".length()))) {
                this.showHelpAnswer();
                this.inputPanel.resetRecentQueryIndex();
                RecentQueryUtil.addRecentQuery(this.project, "/help", input.getTags());
                return;
            }
        }
        input.setChatTask(ChatTaskEnum.FREE_INPUT.name());
        ChatAskInput chatAskInput = new ChatAskInput();
        chatAskInput.setTags(this.inputPanel.getTags());
        input.setChatAskInput(chatAskInput);
        this.inputPanel.resetRecentQueryIndex();
        RecentQueryUtil.addRecentQuery(this.project, text, input.getTags());
        if (CollectionUtils.isNotEmpty(this.inputPanel.getTags())) {
            List tagsNotNeedClear = this.inputPanel.getTags().stream().filter(chatAskTag -> AgentTagEnum.WORKSPACE.getId().equals(chatAskTag.getId()) || ScopeTagEnum.TEAM_DOCS.getId().equals(chatAskTag.getId())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(tagsNotNeedClear)) {
                this.inputPanel.clearTags();
            }
        } else {
            this.inputPanel.clearTags();
        }
        String code = this.checkSelectionCodeInclusion(this.project);
        if (code != null) {
            input.getChatContext().setSourceCode(code);
            StringBuilder sb = new StringBuilder();
            String language = input.getChatContext().getFileLanguage();
            sb.append(text).append("\n```").append(language != null ? language : "").append("\n").append(input.getChatContext().getSourceCode()).append("\n```");
            text = sb.toString();
        }
        input.setQuestion(text);
        SimpleTextDto simpleTextDto = new SimpleTextDto();
        simpleTextDto.setText(text);
        input.setQuestionObject(simpleTextDto);
        chatAskInput.setText(text);
        boolean isFirstRoundChat = input.getChatHistory() != null && CollectionUtils.isEmpty(input.getChatHistory().getAskAnswerList());
        boolean bl = containsCode = input.getChatContext() != null && StringUtils.isNotBlank((CharSequence)input.getChatContext().getSourceCode()) && StringUtils.isNotBlank((CharSequence)input.getChatContext().getFilePath());
        if (isFirstRoundChat && containsCode) {
            this.questionCodeWithExt = CodeWithExt.builder().content(input.getChatContext().getSourceCode()).filePath(input.getChatContext().getFilePath()).ext(FileUtil.getPathExt(input.getChatContext().getFilePath())).build();
        }
        String requestId = UUID.randomUUID().toString();
        TelemetryService.getInstance().telemetryChatTask(this.project, TrackEventTypeEnum.CHAT_FREE_INPUT, requestId, input.getChatContext().getSessionId(), ChatTaskEnum.FREE_INPUT.getName(), input);
        this.prepareAndAsynchronousChat(input, text, text, requestId);
    }

    private String checkSelectionCodeInclusion(Project project) {
        Map map = (Map)ApplicationManager.getApplication().getUserData(CosyKey.PROJECT_FREE_INPUT_SELECTION_CODE_MAP);
        String lastSelectionCode = "";
        if (map != null && map.get(project.getName()) != null) {
            lastSelectionCode = (String)map.get(project.getName());
        }
        String code = this.recordSelectionCode(project);
        if (lastSelectionCode != null && lastSelectionCode.equals(code)) {
            return null;
        }
        return code;
    }

    private String recordSelectionCode(Project project) {
        Editor editor = EditorUtil.getSelectedEditorSafely(project);
        if (editor != null && editor.getSelectionModel().getSelectedText() != null) {
            SelectionModel selectionModel = editor.getSelectionModel();
            String code = selectionModel.getSelectedText();
            if (StringUtils.isEmpty((CharSequence)code)) {
                return null;
            }
            String projectName = project.getName();
            HashMap<String, String> map = (HashMap<String, String>)ApplicationManager.getApplication().getUserData(CosyKey.PROJECT_FREE_INPUT_SELECTION_CODE_MAP);
            if (map == null) {
                map = new HashMap<String, String>();
                map.put(projectName, code);
                ApplicationManager.getApplication().putUserData(CosyKey.PROJECT_FREE_INPUT_SELECTION_CODE_MAP, map);
            } else if (!map.containsKey(projectName)) {
                map.put(projectName, code);
            } else {
                map.put(projectName, code);
            }
            return code;
        }
        return null;
    }

    public void prepareAndAsynchronousChat(GenerateInput input, String prompt, String questionText, String requestId) {
        boolean isReply = ChatTaskUtil.isReply(input);
        String chatTask = ChatTaskUtil.getQuickAskChatTask(input);
        this.prepareAnswer(input, chatTask, questionText);
        this.asynchronousChat(input, isReply, chatTask, prompt, questionText, requestId);
    }

    public void asynchronousChat(GenerateInput input, boolean isReply, String chatTask, String prompt, String questionText, String requestId) {
        AskAnswer askAnswer;
        if (input == null || input.getChatContext() == null) {
            return;
        }
        input.setQuestion(prompt);
        Object dto = null;
        if (chatTask != null) {
            dto = ChatContextDtoBuilderFactory.getChatContextDtoBuilder(chatTask).build(input, questionText);
        }
        if (dto == null) {
            log.error("Chat context dto cannot build. Generate input = " + JSON.toJSONString((Object)input));
            return;
        }
        this.manualScroll.getAndSet(false);
        this.hideWelcomeInfoPanel();
        log.debug("Chat context = " + JSON.toJSONString((Object)dto));
        questionText = this.fillChatAskInputToQuestText(input, questionText);
        ChatAskParam chatAskParam = ChatAskParam.builder().chatTask(chatTask).chatContext(dto).requestId(requestId).isReply(isReply).source(1).sessionId(input.getChatContext().getSessionId() == null ? this.initInput.getChatContext().getSessionId() : input.getChatContext().getSessionId()).codeLanguage(input.getChatContext().getFileLanguage()).questionText(questionText).stream(Boolean.TRUE).build();
        if (this.initInput.getChatHistory() == null) {
            this.initInput.setChatHistory(new ChatHistory(new ArrayList<AskAnswer>(), new ArrayList<AskAnswer>()));
        }
        if ((askAnswer = this.recordAskToHistory(requestId, chatTask, input.getQuestion(), dto)) != null) {
            chatAskParam.setChatContext(askAnswer.getQuestionObject());
            chatAskParam.setChatTask(askAnswer.getChatTask());
        }
        this.answerPanel.clearText();
        this.flowPanel.add(this.answerPanel.getComponent());
        this.answerPanel.setRequestId(requestId);
        this.answerPanel.setSessionId(chatAskParam.getSessionId());
        final ChatAskParam finalChatAskParam = chatAskParam;
        new Task.Backgroundable(this.project, I18NConstant.GENERATE_TIP){
            private boolean success;
            {
                super(project, title);
                this.success = false;
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                GenerateContentForm.this.chatAsk(finalChatAskParam);
                this.success = true;
            }

            public void onFinished() {
                if (this.success) {
                    GenerateContentForm.this.answerPanel.revalidate();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/alibabacloud/intellij/cosy/ui/search/generate/GenerateContentForm$3", "run"));
            }
        }.queue();
        this.scheduleChatTimeout(requestId, input);
        if (!ChatTaskEnum.CHAT_HELP.getName().equals(chatAskParam.getChatTask())) {
            String placeHolderByTag = ChatAskTagUtil.getPlaceholderByTag(this.inputPanel.getTags());
            if (StringUtils.isNotBlank((CharSequence)placeHolderByTag)) {
                this.inputPanel.textArea.setPlaceholder(placeHolderByTag);
            } else {
                this.inputPanel.textArea.setPlaceholder(CosyBundle.message("chat.input.placeholder.normal.continue", new Object[0]));
            }
            this.disableSendButton();
        }
    }

    private void scheduleChatTimeout(String requestId, GenerateInput input) {
        SCHEDULED_EXECUTOR.schedule(() -> {
            if (this.answerPanel != null) {
                if (this.answerPanel.getRequestId() != null && !this.answerPanel.getRequestId().equals(requestId)) {
                    log.info("Answer panel request id not equals, skip timeout");
                    return;
                }
                Long timestamp = (Long)Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_ANSWERING)).get(requestId);
                Project project = (Project)Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).get(requestId);
                if (project != null && timestamp != null && System.currentTimeMillis() - timestamp > 20000L) {
                    log.info("Plugin chat timeout after 20seconds. sessionId=" + this.answerPanel.getSessionId() + ", requestId=" + this.answerPanel.getRequestId());
                    ApplicationManager.getApplication().invokeLater(() -> this.cosyService.chatStop(project, ChatStopParam.builder().sessionId(this.answerPanel.getSessionId()).requestId(this.answerPanel.getRequestId()).build()));
                    Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).remove(requestId);
                    Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_ANSWER_LIST)).remove(requestId);
                    Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_ANSWERING)).remove(requestId);
                    this.pushGenerate(requestId, input.getChatContext().getSessionId(), I18NConstant.CHAT_ANSWER_TIMEOUT, true, false);
                    if (this.initInput.getChatHistory().getAskAnswerList() == null || this.initInput.getChatHistory().getAskAnswerList().size() == 1) {
                        this.initInput.getChatHistory().setAskAnswerList(new ArrayList<AskAnswer>());
                        this.showFirstTimeRetryQuickAsk(input, DisplayTask.builder().displayText(I18NConstant.CHAT_ERROR_RETRY_TIPS).displayEnText(I18NConstant.CHAT_ERROR_RETRY_TIPS).prompt(input.getQuestion()).build());
                    } else {
                        this.showRetryQuickAsk();
                    }
                    this.enableSendButton();
                }
            }
        }, 20L, TimeUnit.SECONDS);
    }

    private String fillChatAskInputToQuestText(GenerateInput input, String questionText) {
        String extraTextFormChatContext;
        if (input.getChatAskInput() == null) {
            return questionText;
        }
        StringBuilder displayTextBuilder = new StringBuilder();
        ChatAskInput chatAskInput = input.getChatAskInput();
        if (CollectionUtils.isNotEmpty(chatAskInput.getTags())) {
            StringBuilder tagStrBuilder = new StringBuilder();
            for (ChatAskTag tag : input.getTags()) {
                if (tagStrBuilder.length() > 0) {
                    tagStrBuilder.append(" ");
                }
                tagStrBuilder.append(tag.getText());
            }
            tagStrBuilder.append(" ");
            displayTextBuilder.append((CharSequence)tagStrBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)chatAskInput.getText())) {
            displayTextBuilder.append(chatAskInput.getText());
        }
        if (StringUtils.isNotBlank((CharSequence)(extraTextFormChatContext = this.getExtraTextFormChatContext(input, questionText)))) {
            displayTextBuilder.append(extraTextFormChatContext);
        }
        return displayTextBuilder.toString();
    }

    private AskAnswer recordAskToHistory(String requestId, String chatTask, String question, Object questionObject) {
        List<AskAnswer> askAnswerList = this.initInput.getChatHistory().getAskAnswerList();
        if ("<COSY::RETRY>".equals(question) && !askAnswerList.isEmpty()) {
            int toRemove = askAnswerList.size() - 1;
            AskAnswer lastAskAnswer = askAnswerList.remove(toRemove);
            chatTask = ChatTaskEnum.RETRY_TASK.getName();
            question = lastAskAnswer.getQuestion();
            questionObject = lastAskAnswer.getQuestionObject();
        }
        AskAnswer askAnswer = AskAnswer.builder().requestId(requestId).chatTask(chatTask).question(question).questionObject(questionObject).like(0).build();
        if (!askAnswerList.isEmpty() && askAnswerList.get(askAnswerList.size() - 1).getAnswer() == null) {
            askAnswerList.remove(askAnswerList.size() - 1);
        }
        askAnswerList.add(askAnswer);
        return askAnswer;
    }

    private void recordAnswerToHistory(String answer) {
        List<AskAnswer> askAnswerList = this.initInput.getChatHistory().getAskAnswerList();
        if (askAnswerList.isEmpty()) {
            log.warn("askAnswerList size is 0");
            return;
        }
        askAnswerList.get(askAnswerList.size() - 1).setAnswer(answer);
    }

    private void chatAsk(ChatAskParam chatAskParam) {
        if (ChatTaskEnum.CHAT_HELP.getName().equals(chatAskParam.getChatTask())) {
            String helpTemplate = ThemeUtil.loadHelpContent();
            this.pushGenerate(chatAskParam.getRequestId(), chatAskParam.getSessionId(), helpTemplate, true, false);
            this.answerPanel.hideBottomPanel();
            return;
        }
        if (!Cosy.INSTANCE.checkCosy(this.project, true)) {
            ApplicationManager.getApplication().invokeLater(() -> {
                this.pushGenerate(chatAskParam.getRequestId(), chatAskParam.getSessionId(), I18NConstant.COSY_RESTARTING, true, false);
                this.initInput.getChatHistory().setAskAnswerList(new ArrayList<AskAnswer>());
                this.showFirstTimeRetryQuickAsk(this.initInput, DisplayTask.builder().displayText(I18NConstant.CHAT_ERROR_RETRY_TIPS).displayEnText(I18NConstant.CHAT_ERROR_RETRY_TIPS).prompt(this.initInput.getQuestion()).build());
                this.enableSendButton();
            });
            return;
        }
        AuthStatus status = LoginUtil.getAuthStatus(this.project);
        if (status != null && !status.isAllow()) {
            if (this.isNotLogin(status)) {
                log.warn("Not login when chatting, show welcome panel");
                this.showWelcomeInfoPanel(false);
                if (!UserAuthService.getInstance().requireLogin(this.project)) {
                    return;
                }
            }
            String message = this.generateAuthMessage(status);
            log.warn("Login status not allowed");
            if (StringUtils.isNotBlank((CharSequence)message)) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.pushGenerate(chatAskParam.getRequestId(), chatAskParam.getSessionId(), message, true, false);
                    this.showRetryQuickAsk();
                    this.enableSendButton();
                });
            }
            return;
        }
        this.answerPanel.registerStopButton();
        ChatAskResult chatAskResult = this.cosyService.chatAsk(this.project, chatAskParam);
        if (chatAskResult != null) {
            log.info(String.format("chat result = %s", chatAskResult.getIsSuccess()));
        }
    }

    private boolean isNotLogin(AuthStatus status) {
        return status != null && (status.getStatus() == null || status.getStatus().intValue() == AuthStateEnum.NOT_LOGIN.getValue() || status.getStatus().intValue() == AuthStateEnum.LOGIN_EXPIRED.getValue() || StringUtils.isEmpty((CharSequence)status.getName()));
    }

    private String generateAuthMessage(AuthStatus status) {
        String message = "";
        if (status == null) {
            return I18NConstant.LOGIN_MSG_GET_FAILED;
        }
        if (status.getStatus() == null) {
            return I18NConstant.LOGIN_MSG_REQUIRE_LOGIN;
        }
        CosyCacheKeys.KEY_AUTH_STATUS.set((UserDataHolder)ApplicationManager.getApplication(), (Object)status);
        if (status.getStatus().intValue() == AuthStateEnum.NETWORK_ERROR.getValue()) {
            return CosyBundle.message("message.chat.answer.quick.network.error", new Object[0]);
        }
        if (status.getStatus().intValue() == AuthStateEnum.IP_BANNED_ERROR.getValue()) {
            return CosyBundle.messageVpc("message.chat.answer.login.ip.whitelist.error", new Object[0]);
        }
        if (status.getStatus().intValue() == AuthStateEnum.APP_DISABLED_ERROR.getValue()) {
            return CosyBundle.messageVpc("message.chat.answer.login.app.disabled.error", new Object[0]);
        }
        if (status.getStatus().intValue() != AuthStateEnum.LOGIN.getValue()) {
            return I18NConstant.LOGIN_MSG_REQUIRE_LOGIN;
        }
        message = this.getNoAccessRightText(status);
        if (StringUtils.isBlank((CharSequence)message)) {
            return CosyBundle.message("notifications.auth.whitelist.unknown", new Object[0]);
        }
        return message;
    }

    private String getNoAccessRightText(AuthStatus status) {
        String message = CosyBundle.message("notifications.auth.whitelist.unknown", new Object[0]);
        if (status == null || status.getWhitelist() == null) {
            return message;
        }
        if (status.getWhitelist().intValue() == AuthWhitelistStatusEnum.NO_LICENCE.getValue()) {
            message = CosyBundle.message("message.chat.answer.login.require.licence.access", new Object[0]);
        } else if (status.getWhitelist().intValue() != AuthWhitelistStatusEnum.PASS.getValue()) {
            message = StringUtils.isNotBlank((CharSequence)status.getOrgId()) ? String.format(CosyBundle.messageVpc("message.chat.answer.login.require.org.access", new Object[0]), status.getName(), status.getOrgName()) : String.format(CosyBundle.message("message.chat.answer.login.require.access", new Object[0]), status.getName());
        }
        return message;
    }

    private void showHelpAnswer() {
        this.inputPanel.clearTags();
        ApplicationManager.getApplication().invokeLater(() -> {
            ChatContext chatContext = ChatContext.builder().fileLanguage(FileUtil.getLanguageFileType(this.project)).filePath("").sessionId(this.initInput.getChatContext().getSessionId()).range(null).methodContent(null).docContent(null).sourceCode(null).inputComplete(false).build();
            GenerateInput genInput = new GenerateInput(I18NConstant.CHAT_HELP_QUESTION, ChatTaskEnum.CHAT_HELP.getName(), chatContext);
            ChatAskInput chatAskInput = new ChatAskInput();
            chatAskInput.setTags(Arrays.asList(ChatAskTag.ofTask(ChatTaskEnum.CHAT_HELP.getName(), "/help")));
            genInput.setChatAskInput(chatAskInput);
            this.triggerAsk(genInput, UUID.randomUUID().toString());
        });
    }

    private void disableInputPanel() {
        if (this.inputPanel == null) {
            return;
        }
        this.inputPanel.disableInputPanel();
    }

    private void disableSendButton() {
        this.inputPanel.disableSendButton();
    }

    private void enableInputPanel() {
        this.inputPanel.enableInputPanel();
    }

    private void enableSendButton() {
        this.inputPanel.enableSendButton();
    }

    public void initFlowPanel() {
        this.clearProjectToRequest(this.project);
        this.enableInputPanel();
        this.enableSendButton();
        this.showWelcomeInfoPanel();
        this.inputPanel.clearTextArea();
        this.inputPanel.clearTags();
    }

    private void clearProjectToRequest(Project project) {
        if (!CosyKey.PROJECT_TO_REQUEST.isEmpty() && !CosyKey.PROJECT_TO_REQUEST.containsKey(project.getName())) {
            Set<String> requestIdSet = CosyKey.PROJECT_TO_REQUEST.get(project.getName());
            if (requestIdSet == null) {
                CosyKey.PROJECT_TO_REQUEST.put(project.getName(), new HashSet());
                return;
            }
            for (String requestId : requestIdSet) {
                if (ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT) == null || !Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).containsKey(requestId)) continue;
                Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).remove(requestId);
                Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_ANSWER_LIST)).remove(requestId);
                Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_ANSWERING)).remove(requestId);
            }
        }
    }

    public void moveScrollToBottom() {
        if (this.manualScroll.get()) {
            return;
        }
        this.flowPanel.validate();
        this.scrollPane.validate();
        this.scrollPane.getVerticalScrollBar().setValue(this.scrollPane.getVerticalScrollBar().getMaximum());
    }

    public ListWithFilter getListComponent() {
        return this.listComponent;
    }

    private void notifyLoginAuth(AuthStatus status) {
        this.showWelcomeInfoPanel();
        if (status.isAllow()) {
            this.enableInputPanel();
            this.enableSendButton();
        }
    }

    private void notifyLogoutAuth(AuthStatus status) {
        this.showWelcomeInfoPanel();
        if (!status.isAllow()) {
            this.disableInputPanel();
        }
    }

    private void notifyChangeAuth(AuthStatus status) {
        if (status.isAllow()) {
            this.enableInputPanel();
            this.enableSendButton();
        }
        boolean showedMsg = false;
        for (Component component : this.flowPanel.getComponents()) {
            if (!(component instanceof SystemMessageCard)) continue;
            showedMsg = true;
        }
        if (showedMsg) {
            this.showWelcomeInfoPanel();
        } else {
            GrantAuthorNotification.notifyNeedLogin(this.project, true);
        }
    }

    public void recoverSession(ChatSession chatSession) {
        this.clearProjectToRequest(this.project);
        this.flowPanel.removeAll();
        this.initInput = ChatTaskUtil.getInitInput(this.project);
        ChatHistory chatHistory = new ChatHistory();
        ArrayList<AskAnswer> askAnswerList = new ArrayList<AskAnswer>();
        ArrayList<AskAnswer> toArchive = new ArrayList<AskAnswer>();
        ((WelcomeBgPanel)this.flowPanel).setShowTooltips(false);
        for (ChatRecord chatRecord : chatSession.getChatRecords()) {
            Object codeChunkObj;
            ChatReferenceChunk chunk;
            JSONObject jsonObj;
            if (ChatSystemEventEnum.SESSION_HISTORY_CLEAR.getName().equalsIgnoreCase(chatRecord.getChatTask())) {
                this.drawClearContextLine();
                toArchive.addAll(askAnswerList);
                askAnswerList = new ArrayList();
                this.inputPanel.setIsHistoryEmpty(true);
                continue;
            }
            ChatAskInput chatAskInput = ChatSessionUtil.getChatAskInputFromRecord(chatRecord, this.project);
            String extraText = ChatSessionUtil.getExtraTextFromRecord(chatRecord);
            this.flowPanel.add(new ChatQuestionForm(this.project, this.basePanel, extraText, new Date(chatRecord.getGmtCreate()), chatAskInput).getComponent());
            this.initInput.setChatTask(chatRecord.getChatTask());
            GenerateAnswerPanel answerPanel = new GenerateAnswerPanel(this.project, this, this.basePanel, chatRecord.getChatTask(), chatAskInput);
            answerPanel.setSessionId(chatRecord.getSessionId());
            answerPanel.setRequestId(chatRecord.getRequestId());
            String extra = chatRecord.getExtra();
            if (StringUtils.isNotEmpty((CharSequence)extra) && (jsonObj = JSON.parseObject((String)extra)) != null && (chunk = (ChatReferenceChunk)JSON.parseObject((String)JSON.toJSONString((Object)(codeChunkObj = jsonObj.get((Object)ChatStageParseKey.CODE_CHUNK.getKey()))), ChatReferenceChunk.class)) != null && CollectionUtils.isNotEmpty(chunk.getChunks())) {
                DefaultListModel<ChatReferenceItem> listModel = new DefaultListModel<ChatReferenceItem>();
                for (ChatReferenceItem item : chunk.getChunks()) {
                    listModel.addElement(item);
                }
                answerPanel.showReferencePanelForRecoverSession(listModel);
            }
            answerPanel.appendText(chatRecord.getAnswer());
            answerPanel.hideBottomPanel();
            answerPanel.renderLike(chatRecord.getLikeStatus());
            this.flowPanel.add(answerPanel.getComponent());
            this.inputPanel.setIsHistoryEmpty(false);
            askAnswerList.add(AskAnswer.builder().chatTask(chatRecord.getChatTask()).questionObject(chatRecord.getChatContext()).question(chatRecord.getQuestion()).answer(chatRecord.getAnswer()).like(chatRecord.getLikeStatus()).build());
        }
        this.moveScrollToBottom();
        this.flowPanel.invalidate();
        this.flowPanel.validate();
        this.flowPanel.repaint();
        chatHistory.setArchivedAskAnswerList(toArchive);
        chatHistory.setAskAnswerList(askAnswerList);
        this.initInput.setChatHistory(chatHistory);
        ChatContext chatContext = ChatContext.builder().sessionId(chatSession.getSessionId()).fileLanguage(FileUtil.getLanguageFileType(this.project)).localeLanguage(Locale.getDefault().getLanguage()).build();
        this.initInput.setChatContext(chatContext);
        TelemetryService.getInstance().telemetrySessionId(this.project, TrackEventTypeEnum.CHAT_RECOVER_SESSION, UUID.randomUUID().toString(), this.initInput.getChatContext().getSessionId());
    }

    @Override
    public int getPreferredWidth() {
        return 0;
    }

    @Override
    public int getPreferredHeight() {
        return 0;
    }

    @Override
    public JComponent getComponent() {
        return this.basePanel;
    }

    private void createUIComponents() {
        this.basePanel = new JPanel(new BorderLayout());
        this.inputPanel = new AskInputPanel(this.project);
        this.flowPanel = new WelcomeBgPanel();
    }

    @Generated
    public void setBasePanel(JPanel basePanel) {
        this.basePanel = basePanel;
    }

    @Generated
    public void setScrollPane(JBScrollPane scrollPane) {
        this.scrollPane = scrollPane;
    }

    @Generated
    public void setExpandPanel(JPanel expandPanel) {
        this.expandPanel = expandPanel;
    }

    @Generated
    public void setExpandLabel(JLabel expandLabel) {
        this.expandLabel = expandLabel;
    }

    @Generated
    public void setFlowPanel(JPanel flowPanel) {
        this.flowPanel = flowPanel;
    }

    @Generated
    public void setProject(Project project) {
        this.project = project;
    }

    @Generated
    public void setAnswerPanel(GenerateAnswerPanel answerPanel) {
        this.answerPanel = answerPanel;
    }

    @Generated
    public void setInitInput(GenerateInput initInput) {
        this.initInput = initInput;
    }

    @Generated
    public void setMessageBusConnection(MessageBusConnection messageBusConnection) {
        this.messageBusConnection = messageBusConnection;
    }

    @Generated
    public void setCosyService(CosyService cosyService) {
        this.cosyService = cosyService;
    }

    @Generated
    public void setMainComponent(JComponent mainComponent) {
        this.mainComponent = mainComponent;
    }

    @Generated
    public void setInputPanel(AskInputPanel inputPanel) {
        this.inputPanel = inputPanel;
    }

    @Generated
    public void setQuestionCodeWithExt(CodeWithExt questionCodeWithExt) {
        this.questionCodeWithExt = questionCodeWithExt;
    }

    @Generated
    public void setSuggestValueList(List<SuggestPrompt> suggestValueList) {
        this.suggestValueList = suggestValueList;
    }

    @Generated
    public void setPromptItemList(JBList<SuggestPrompt> promptItemList) {
        this.promptItemList = promptItemList;
    }

    @Generated
    public void setPromptSuggestPopup(JBPopup promptSuggestPopup) {
        this.promptSuggestPopup = promptSuggestPopup;
    }

    @Generated
    public void setListComponent(ListWithFilter<SuggestPrompt> listComponent) {
        this.listComponent = listComponent;
    }

    @Generated
    public void setListComponentScrollBar(JScrollBar listComponentScrollBar) {
        this.listComponentScrollBar = listComponentScrollBar;
    }

    @Generated
    public void setChooserBuilder(PopupChooserBuilder<SuggestPrompt> chooserBuilder) {
        this.chooserBuilder = chooserBuilder;
    }

    @Generated
    public void setLastPopupHeight(int lastPopupHeight) {
        this.lastPopupHeight = lastPopupHeight;
    }

    @Generated
    public void setManualScroll(AtomicBoolean manualScroll) {
        this.manualScroll = manualScroll;
    }

    @Generated
    public JPanel getBasePanel() {
        return this.basePanel;
    }

    @Generated
    public JBScrollPane getScrollPane() {
        return this.scrollPane;
    }

    @Generated
    public JPanel getExpandPanel() {
        return this.expandPanel;
    }

    @Generated
    public JLabel getExpandLabel() {
        return this.expandLabel;
    }

    @Generated
    public JPanel getFlowPanel() {
        return this.flowPanel;
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public GenerateAnswerPanel getAnswerPanel() {
        return this.answerPanel;
    }

    @Generated
    public GenerateInput getInitInput() {
        return this.initInput;
    }

    @Generated
    public MessageBusConnection getMessageBusConnection() {
        return this.messageBusConnection;
    }

    @Generated
    public CosyService getCosyService() {
        return this.cosyService;
    }

    @Generated
    public JComponent getMainComponent() {
        return this.mainComponent;
    }

    @Generated
    public CodeWithExt getQuestionCodeWithExt() {
        return this.questionCodeWithExt;
    }

    @Generated
    public List<SuggestPrompt> getSuggestValueList() {
        return this.suggestValueList;
    }

    @Generated
    public JBList<SuggestPrompt> getPromptItemList() {
        return this.promptItemList;
    }

    @Generated
    public JBPopup getPromptSuggestPopup() {
        return this.promptSuggestPopup;
    }

    @Generated
    public JScrollBar getListComponentScrollBar() {
        return this.listComponentScrollBar;
    }

    @Generated
    public PopupChooserBuilder<SuggestPrompt> getChooserBuilder() {
        return this.chooserBuilder;
    }

    @Generated
    public int getLastPopupHeight() {
        return this.lastPopupHeight;
    }

    @Generated
    public AtomicBoolean getManualScroll() {
        return this.manualScroll;
    }

    @Generated
    public AskInputPanel getInputPanel() {
        return this.inputPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBScrollPane jBScrollPane;
        this.createUIComponents();
        JPanel jPanel = this.basePanel;
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.scrollPane = jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        jPanel.add((Component)jBScrollPane, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jBScrollPane.setViewportView(jPanel2);
        JPanel jPanel3 = this.flowPanel;
        jPanel2.add((Component)jPanel3, "Center");
        AskInputPanel askInputPanel = this.inputPanel;
        jPanel.add((Component)askInputPanel, "South");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.basePanel;
    }
}

