/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.generate;

import com.alibabacloud.intellij.cosy.chat.enums.AgentTagEnum;
import com.alibabacloud.intellij.cosy.chat.model.ChatAskInput;
import com.alibabacloud.intellij.cosy.chat.model.ChatLikeParam;
import com.alibabacloud.intellij.cosy.chat.model.ChatStopParam;
import com.alibabacloud.intellij.cosy.chat.model.task.DisplayTask;
import com.alibabacloud.intellij.cosy.constants.CosyKey;
import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ChatStep;
import com.alibabacloud.intellij.cosy.layout.RightFlowLayout;
import com.alibabacloud.intellij.cosy.layout.WrapForKeywordLayout;
import com.alibabacloud.intellij.cosy.search.enums.TrackEventTypeEnum;
import com.alibabacloud.intellij.cosy.service.CosyService;
import com.alibabacloud.intellij.cosy.service.TelemetryService;
import com.alibabacloud.intellij.cosy.service.impl.CosyServiceImpl;
import com.alibabacloud.intellij.cosy.ui.search.I18NConstant;
import com.alibabacloud.intellij.cosy.ui.search.color.CosyColor;
import com.alibabacloud.intellij.cosy.ui.search.component.DisplayLabel;
import com.alibabacloud.intellij.cosy.ui.search.component.DynamicPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.RefreshColorComponent;
import com.alibabacloud.intellij.cosy.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.ToolbarLabel;
import com.alibabacloud.intellij.cosy.ui.search.component.chat.ChatReferencePanel;
import com.alibabacloud.intellij.cosy.ui.search.component.chat.ChatStagePanel;
import com.alibabacloud.intellij.cosy.ui.search.component.markdown.MarkdownStreamPanel;
import com.alibabacloud.intellij.cosy.ui.search.enums.ChatStageParseKey;
import com.alibabacloud.intellij.cosy.ui.search.enums.ChatStepEnum;
import com.alibabacloud.intellij.cosy.ui.search.generate.BadFeedbackDialog;
import com.alibabacloud.intellij.cosy.ui.search.generate.GenerateContentForm;
import com.alibabacloud.intellij.cosy.ui.search.generate.QuickAskPanel;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatReferenceItem;
import com.alibabacloud.intellij.cosy.ui.search.model.GenerateInput;
import com.alibabacloud.intellij.cosy.ui.search.topic.GenerateStreamPauseNotifier;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.SwingUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import icons.LingmaIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;

public class GenerateAnswerPanel {
    private static final Logger log = Logger.getInstance(GenerateAnswerPanel.class);
    private static final int MIN_BOTTOM_HEIGHT = 40;
    private JLabel cosyLabel;
    private JPanel basePanel;
    private JPanel mdPanel;
    private JPanel titlePanel;
    private JPanel titleToolBarPanel;
    private JLabel goodLabel;
    private JLabel badLabel;
    private JPanel bottomPanel;
    private JLabel workspaceLabel;
    private JPanel generatingPanel;
    private QuickAskPanel quickAskPanel;
    private String requestId;
    private String sessionId;
    private final String chatTask;
    private Project project;
    private CosyService cosyService;
    private MarkdownStreamPanel markdownPanel;
    private JPanel contentPanel;
    private ChatStagePanel chatStagePanel;
    private ChatReferencePanel chatReferencePanel;
    private JComponent parentComponent;
    private GenerateContentForm generateContentForm;
    private DisplayLabel stopBtn;
    private MessageBusConnection messageBusConnection;

    public GenerateAnswerPanel(final Project project, GenerateContentForm generateContentForm, JComponent parentComponent, final String chatTask, ChatAskInput chatAskInput) {
        List workspaceTagList;
        this.parentComponent = parentComponent;
        this.generateContentForm = generateContentForm;
        this.chatTask = chatTask;
        this.$$$setupUI$$$();
        this.basePanel.setBorder((Border)JBUI.Borders.empty());
        this.cosyLabel.setAlignmentX(5.0f);
        this.cosyLabel.setIcon(LingmaIcons.Logo20Icon);
        this.cosyLabel.setText(I18NConstant.COSY_PLUGIN_NAME);
        if (chatAskInput != null && CollectionUtils.isNotEmpty(chatAskInput.getTags()) && CollectionUtils.isNotEmpty(workspaceTagList = chatAskInput.getTags().stream().filter(tag -> AgentTagEnum.WORKSPACE.getId().equals(tag.getId())).collect(Collectors.toList()))) {
            this.workspaceLabel.setText("@workspace");
            this.workspaceLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
        }
        this.titleToolBarPanel.setBorder((Border)JBUI.Borders.emptyTop((int)8));
        this.titleToolBarPanel.setLayout(new RightFlowLayout(2, 16, 0));
        this.titlePanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)12));
        this.contentPanel = new JPanel(new BorderLayout());
        this.mdPanel.add((Component)this.contentPanel, "Center");
        this.markdownPanel = new MarkdownStreamPanel(project, parentComponent, this);
        this.markdownPanel.setBorder((Border)JBUI.Borders.emptyBottom((int)8));
        this.contentPanel.add((Component)this.markdownPanel, "Center");
        this.cosyService = new CosyServiceImpl();
        this.project = project;
        this.configBottomPanel();
        this.basePanel.setBackground(ColorUtil.getChatCardBackgroundColor());
        SwingUtil.foreachChildComponent(this.basePanel, cp -> {
            if (cp != this.basePanel && cp instanceof JPanel) {
                cp.setOpaque(false);
                cp.setBackground(ColorUtil.getChatCardChildBackgroundColor());
            }
        });
        this.showGenerateStatePanel();
        this.goodLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (GenerateAnswerPanel.this.getRequestId() != null && GenerateAnswerPanel.this.getSessionId() != null && GenerateAnswerPanel.this.goodLabel.isEnabled()) {
                    log.info("Like to request id " + GenerateAnswerPanel.this.getRequestId());
                    ChatLikeParam chatLikeParam = ChatLikeParam.builder().sessionId(GenerateAnswerPanel.this.getSessionId()).requestId(GenerateAnswerPanel.this.getRequestId()).like(1).build();
                    ((ToolbarLabel)GenerateAnswerPanel.this.goodLabel).invalid();
                    ((ToolbarLabel)GenerateAnswerPanel.this.badLabel).invalid();
                    if (!Cosy.INSTANCE.checkCosy(project, true)) {
                        return;
                    }
                    GenerateAnswerPanel.this.cosyService.chatLike(project, chatLikeParam);
                    TelemetryService.getInstance().telemetrySessionId(project, TrackEventTypeEnum.CHAT_ANSWER_CODE_LIKE, GenerateAnswerPanel.this.getRequestId(), GenerateAnswerPanel.this.getSessionId());
                }
            }
        });
        this.badLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (GenerateAnswerPanel.this.getRequestId() != null && GenerateAnswerPanel.this.getSessionId() != null && GenerateAnswerPanel.this.badLabel.isEnabled()) {
                    log.info("Dislike to request id " + GenerateAnswerPanel.this.getRequestId());
                    ChatLikeParam chatLikeParam = ChatLikeParam.builder().sessionId(GenerateAnswerPanel.this.getSessionId()).requestId(GenerateAnswerPanel.this.getRequestId()).like(-1).build();
                    ((ToolbarLabel)GenerateAnswerPanel.this.badLabel).invalid();
                    ((ToolbarLabel)GenerateAnswerPanel.this.goodLabel).invalid();
                    if (!Cosy.INSTANCE.checkCosy(project, true)) {
                        return;
                    }
                    GenerateAnswerPanel.this.cosyService.chatLike(project, chatLikeParam);
                    TelemetryService.getInstance().telemetrySessionId(project, TrackEventTypeEnum.CHAT_ANSWER_CODE_DISLIKE, GenerateAnswerPanel.this.getRequestId(), GenerateAnswerPanel.this.getSessionId());
                    BadFeedbackDialog badFeedbackDialog = new BadFeedbackDialog(GenerateAnswerPanel.this.getRequestId(), GenerateAnswerPanel.this.getSessionId(), project, chatTask, GenerateAnswerPanel.this.titleToolBarPanel);
                    badFeedbackDialog.show();
                }
            }
        });
    }

    public void showReferencePanel() {
        ListModel listModel = (ListModel)this.chatStagePanel.getContext().getContext(ChatStageParseKey.CODE_CHUNK.getKey());
        if (listModel == null || listModel.getSize() == 0) {
            return;
        }
        if (this.chatReferencePanel == null) {
            this.chatReferencePanel = new ChatReferencePanel(this.project, listModel);
        }
        this.contentPanel.add((Component)this.chatReferencePanel, "North");
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
    }

    public void showReferencePanelForRecoverSession(ListModel<ChatReferenceItem> listModel) {
        if (this.chatStagePanel == null) {
            this.chatStagePanel = new ChatStagePanel(this.project);
            this.contentPanel.add((Component)this.chatStagePanel, "North");
        }
        if (this.chatReferencePanel == null) {
            this.chatReferencePanel = new ChatReferencePanel(this.project, listModel);
        }
        this.contentPanel.add((Component)this.chatReferencePanel, "North");
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
    }

    public void addOrUpdateStep(ChatStep stepItem) {
        if (ChatStepEnum.START.getKey().equals(stepItem.getStep())) {
            this.chatStagePanel = new ChatStagePanel(this.project);
            this.contentPanel.add((Component)this.chatStagePanel, "North");
        } else if (ChatStepEnum.END.getKey().equals(stepItem.getStep())) {
            this.showReferencePanel();
            if (this.chatStagePanel != null) {
                this.contentPanel.remove(this.chatStagePanel);
            }
        } else if (this.chatStagePanel != null) {
            this.chatStagePanel.addOrUpdateStep(stepItem);
        }
        if (this.chatStagePanel != null) {
            this.chatStagePanel.revalidate();
            this.chatStagePanel.repaint();
        }
    }

    public GenerateContentForm getGenerateContentForm() {
        return this.generateContentForm;
    }

    private void configBottomPanel() {
        Color toolWindowBackground = ColorUtil.getToolWindowBackgroundColor();
        this.bottomPanel.setBorder(JBUI.Borders.customLine((Color)toolWindowBackground, (int)2, (int)0, (int)0, (int)0));
    }

    public void showGenerateStatePanel() {
        if (this.generatingPanel == null) {
            this.generatingPanel = new JPanel();
            this.generatingPanel.setBorder((Border)JBUI.Borders.empty());
            this.generatingPanel.setLayout(new BorderLayout());
            Color toolWindowBackground = ColorUtil.getToolWindowBackgroundColor();
            this.generatingPanel.setPreferredSize(new Dimension(-1, 40));
            JLabel generatingLabel = new JLabel(CosyBundle.message("chat.answer.btn.generating", new Object[0]), LingmaIcons.LoadingIcon, 10);
            generatingLabel.setFont(generatingLabel.getFont().deriveFont(14.0f));
            generatingLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            this.generatingPanel.add((Component)generatingLabel, "West");
            JPanel bottomRightPanel = new JPanel(new WrapForKeywordLayout(0, 8));
            bottomRightPanel.setBorder((Border)JBUI.Borders.empty());
            bottomRightPanel.setBackground(toolWindowBackground);
            this.generatingPanel.add((Component)bottomRightPanel, "East");
            this.stopBtn = new DisplayLabel(CosyBundle.message("chat.answer.btn.stop", new Object[0]), LingmaIcons.PauseIcon, ColorUtil.getToolWindowBackgroundColor(), null);
            this.stopBtn.setCursor(Cursor.getPredefinedCursor(12));
            this.stopBtn.addLabelMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    GenerateAnswerPanel.this.stopBtn.setBackground(ColorUtil.getEditorBackgroundColor());
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    GenerateAnswerPanel.this.stopBtn.setBackground(ColorUtil.getToolWindowBackgroundColor());
                }
            });
            bottomRightPanel.add(this.stopBtn);
            this.generatingPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)12));
            SwingUtil.foreachChildComponent(this.generatingPanel, cp -> {
                if (!(cp instanceof DisplayLabel) && cp instanceof JPanel) {
                    cp.setOpaque(false);
                    cp.setBackground(ColorUtil.getChatCardChildBackgroundColor());
                }
            });
        }
        this.bottomPanel.removeAll();
        this.bottomPanel.add((Component)this.generatingPanel, "Center");
    }

    public void registerStopButton() {
        MouseListener[] listeners;
        if (this.stopBtn == null) {
            log.warn("Stop button is null when registering stop button.");
            return;
        }
        for (MouseListener listener : listeners = this.stopBtn.getMouseListeners()) {
            this.stopBtn.removeLabelMouseListener(listener);
        }
        this.stopBtn.addLabelMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ApplicationManager.getApplication().invokeLater(() -> GenerateAnswerPanel.this.cosyService.chatStop(GenerateAnswerPanel.this.project, ChatStopParam.builder().sessionId(GenerateAnswerPanel.this.sessionId).requestId(GenerateAnswerPanel.this.requestId).build()));
                Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).remove(GenerateAnswerPanel.this.requestId);
                Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_ANSWERING)).remove(GenerateAnswerPanel.this.requestId);
                TelemetryService.getInstance().telemetrySessionId(GenerateAnswerPanel.this.project, TrackEventTypeEnum.CHAT_GENERATE_STOP, GenerateAnswerPanel.this.requestId, GenerateAnswerPanel.this.sessionId);
                try {
                    SwingUtilities.invokeLater(() -> ((GenerateStreamPauseNotifier)GenerateAnswerPanel.this.project.getMessageBus().syncPublisher(GenerateStreamPauseNotifier.GENERATE_STREAM_PAUSE_NOTIFICATION)).pause(GenerateAnswerPanel.this.requestId, GenerateAnswerPanel.this.sessionId));
                }
                catch (Exception ex) {
                    log.error("Pause message sent error: ", (Throwable)ex);
                }
            }
        });
    }

    public void hideGenerateStatePanel() {
        this.stopBtn = null;
        this.generatingPanel = null;
        this.bottomPanel.removeAll();
    }

    public void showQuickPanel(GenerateInput input, List<DisplayTask> functionsList) {
        if (this.quickAskPanel == null) {
            this.quickAskPanel = new QuickAskPanel(this.project, this.generateContentForm, input, functionsList);
            this.quickAskPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)4));
        }
        this.bottomPanel.removeAll();
        this.bottomPanel.add((Component)this.quickAskPanel, "Center");
        this.bottomPanel.invalidate();
        this.bottomPanel.repaint();
        this.generateContentForm.moveScrollToBottom();
    }

    public String getAnswerText() {
        return this.markdownPanel.getText();
    }

    public void clearText() {
        this.markdownPanel.clear();
    }

    public void revalidate() {
        this.markdownPanel.revalidate();
    }

    public void appendText(String value) {
        this.markdownPanel.append(value);
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public JComponent getComponent() {
        return this.basePanel;
    }

    private void createUIComponents() {
        this.basePanel = new RoundRectPanel(){

            @Override
            public void refreshColor(EditorColorsScheme scheme, Color themeColor) {
                SwingUtil.foreachChildComponent(GenerateAnswerPanel.this.basePanel, cp -> {
                    if (cp instanceof JPanel && !(cp instanceof RefreshColorComponent)) {
                        cp.setBackground(ColorUtil.getChatCardBackgroundColor());
                    }
                });
            }
        };
        this.titlePanel = new DynamicPanel(40, (Color)CosyColor.BEST_ANSWER_BACKGROUND_COLOR);
        this.titlePanel.setBorder((Border)JBUI.Borders.empty());
        this.goodLabel = new ToolbarLabel(LingmaIcons.LikeIcon, null, LingmaIcons.LikeBlueIcon);
        this.badLabel = new ToolbarLabel(LingmaIcons.UnlikeIcon, null, LingmaIcons.UnlikeBlueIcon);
        this.bottomPanel = new JPanel(new BorderLayout()){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (dimension.height < 40 && GenerateAnswerPanel.this.bottomPanel.getComponentCount() > 0) {
                    dimension.height = 40;
                }
                return dimension;
            }
        };
    }

    public void hideBottomPanel() {
        this.bottomPanel.removeAll();
        this.bottomPanel.setBorder(null);
        this.bottomPanel.setPreferredSize(new Dimension(-1, 0));
        this.quickAskPanel = null;
        this.stopBtn = null;
        this.basePanel.invalidate();
        this.basePanel.repaint();
    }

    public void renderLike(int likeStatus) {
        if (likeStatus == 0) {
            return;
        }
        if (likeStatus > 0) {
            ((ToolbarLabel)this.goodLabel).renderSelect();
        } else {
            ((ToolbarLabel)this.badLabel).renderSelect();
        }
        ((ToolbarLabel)this.goodLabel).invalid();
        ((ToolbarLabel)this.badLabel).invalid();
    }

    @Generated
    public String getRequestId() {
        return this.requestId;
    }

    @Generated
    public String getSessionId() {
        return this.sessionId;
    }

    @Generated
    public String getChatTask() {
        return this.chatTask;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JLabel jLabel;
        JPanel jPanel2;
        JLabel jLabel2;
        this.createUIComponents();
        JPanel jPanel3 = this.basePanel;
        jPanel3.setLayout(new BorderLayout(0, 0));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel4, "Center");
        JPanel jPanel5 = this.titlePanel;
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel5, "North");
        this.cosyLabel = jLabel2 = new JLabel();
        jLabel2.setIconTextGap(5);
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messageBundle").getString("cosy.plugin.name"));
        jPanel5.add((Component)jLabel2, "West");
        this.titleToolBarPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 16, 3));
        jPanel5.add((Component)jPanel2, "East");
        JLabel jLabel3 = this.goodLabel;
        jLabel3.setText("");
        Component component = jPanel2.add(jLabel3);
        JLabel jLabel4 = this.badLabel;
        jLabel4.setText("");
        Component component2 = jPanel2.add(jLabel4);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 10, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, "Center");
        this.workspaceLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel6.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mdPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, "Center");
        JPanel jPanel7 = this.bottomPanel;
        jPanel3.add((Component)jPanel7, "South");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.basePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

