/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.generate;

import com.alibabacloud.intellij.cosy.chat.model.ChatAskInput;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.cosy.ui.BaseComponent;
import com.alibabacloud.intellij.cosy.ui.search.component.AvatarLabel;
import com.alibabacloud.intellij.cosy.ui.search.component.DynamicPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.RefreshColorComponent;
import com.alibabacloud.intellij.cosy.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.markdown.MarkdownStreamPanel;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.CosyDateUtil;
import com.alibabacloud.intellij.cosy.util.LoginUtil;
import com.alibabacloud.intellij.cosy.util.SwingUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.apache.commons.lang3.StringUtils;

public class ChatQuestionForm
implements BaseComponent {
    private static Logger LOG = Logger.getInstance(ChatQuestionForm.class);
    private static final int CODE_BLOCK_MAX_HEIGHT = 400;
    private JPanel basePanel;
    private JPanel headerPanel;
    private JPanel contentPanel;
    private JPanel headerToolbarPanel;
    private JLabel userInfoLabel;
    private JLabel timeLabel;
    private MarkdownStreamPanel questionText;
    private String value;

    public ChatQuestionForm(Project project, JComponent parentComponent, String value, Date questionTime, ChatAskInput chatAskInput) {
        this.value = value;
        this.$$$setupUI$$$();
        this.questionText = new MarkdownStreamPanel(project, parentComponent, null, 400);
        this.contentPanel.add((Component)this.questionText, "Center");
        if (chatAskInput != null) {
            if (chatAskInput.getTags() != null) {
                this.questionText.setTags(chatAskInput.getTags());
            }
            if (StringUtils.isNotBlank((CharSequence)chatAskInput.getText())) {
                this.questionText.append(chatAskInput.getText());
                this.questionText.append("\n");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)value)) {
            this.questionText.append(value);
        }
        AuthStatus authStatus = LoginUtil.getAuthStatusCacheFirst(project);
        ((AvatarLabel)this.userInfoLabel).setStatus(authStatus);
        Date date = new Date();
        if (questionTime != null) {
            date = questionTime;
        }
        this.timeLabel.setText(CosyDateUtil.getAskTime(date));
        this.timeLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
        this.basePanel.setBackground(ColorUtil.getChatCardBackgroundColor());
        SwingUtil.foreachChildComponent(this.basePanel, cp -> {
            Boolean isCodePane = (Boolean)cp.getClientProperty("codePane");
            if (isCodePane != null && isCodePane.booleanValue()) {
                return;
            }
            if (cp != this.basePanel && cp instanceof JPanel && !(cp instanceof RoundRectPanel)) {
                cp.setOpaque(false);
                cp.setBackground(ColorUtil.getChatCardChildBackgroundColor());
            }
        });
        this.basePanel.setBorder((Border)JBUI.Borders.emptyBottom((int)10));
        this.headerPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)12));
    }

    @Override
    public int getPreferredWidth() {
        return 0;
    }

    @Override
    public int getPreferredHeight() {
        return 0;
    }

    @Override
    public JComponent getComponent() {
        return this.basePanel;
    }

    private void createUIComponents() {
        this.basePanel = new RoundRectPanel(){

            @Override
            public void refreshColor(EditorColorsScheme scheme, Color themeColor) {
                SwingUtil.foreachChildComponent(ChatQuestionForm.this.basePanel, cp -> {
                    if (cp instanceof JPanel && !(cp instanceof RefreshColorComponent)) {
                        cp.setBackground(ColorUtil.getChatCardBackgroundColor());
                    }
                });
            }
        };
        this.basePanel.setBackground(ColorUtil.getChatCardBackgroundColor());
        this.headerPanel = new DynamicPanel(40, ColorUtil.getChatCardBackgroundColor());
        this.headerPanel.setBorder((Border)JBUI.Borders.empty());
        this.userInfoLabel = new AvatarLabel(null, 20);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JLabel jLabel;
        JPanel jPanel2;
        this.createUIComponents();
        JPanel jPanel3 = this.basePanel;
        jPanel3.setLayout(new BorderLayout(0, 0));
        JPanel jPanel4 = this.headerPanel;
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel4, "North");
        JLabel jLabel2 = this.userInfoLabel;
        jLabel2.setText("Label");
        jPanel4.add((Component)jLabel2, "West");
        this.headerToolbarPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, "East");
        this.timeLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel2.add((Component)jLabel, "Center");
        this.contentPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, "Center");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.basePanel;
    }
}

