/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.generate;

import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.core.CosyStartupAdapter;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ChatSession;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.ListChatHistoryParams;
import com.alibabacloud.intellij.cosy.ui.search.form.LingmaEmptyForm;
import com.alibabacloud.intellij.cosy.ui.search.generate.ChatHistoryCell;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.ProjectUtils;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class ChatHistoryPanel
extends JPanel {
    private static final int MAX_HISTORY_COUNT = 50;
    Project project;
    JPanel contentPanel;
    JPanel headerPanel;
    JPanel listPanel;
    LingmaEmptyForm emptyPanel;
    JScrollPane jbScrollPane;
    JLabel clearLabel;
    MostCountLimitCell mostCountLimitCell;

    public ChatHistoryPanel(Project project) {
        this.project = project;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setupHeader();
        this.setupContent();
    }

    public void setupHeader() {
        this.headerPanel = new JPanel();
        this.headerPanel.setLayout(new BorderLayout());
        this.headerPanel.setBorder((Border)JBUI.Borders.emptyBottom((int)12));
        this.add((Component)this.headerPanel, "North");
        JLabel label = new JLabel(CosyBundle.message("chat.history.label.title", new Object[0]));
        label.setFont(label.getFont().deriveFont(0, 14.0f));
        this.headerPanel.add((Component)label, "West");
        this.clearLabel = new JLabel(CosyBundle.message("chat.history.label.clear", new Object[0]));
        this.clearLabel.setForeground(ColorUtil.getLinkForegroundColor());
        this.clearLabel.setFont(this.clearLabel.getFont().deriveFont(0, 14.0f));
        this.clearLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.headerPanel.add((Component)this.clearLabel, "East");
        this.clearLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ChatHistoryPanel.this.clearHistories();
            }
        });
    }

    public void setupContent() {
        this.emptyPanel = new LingmaEmptyForm();
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BorderLayout());
        this.add((Component)this.contentPanel, "Center");
        this.listPanel = new JPanel();
        this.listPanel.setLayout((LayoutManager)new VerticalFlowLayout(0, 8));
        this.jbScrollPane = new JBScrollPane((Component)this.listPanel);
        this.jbScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jbScrollPane.getVerticalScrollBar().setUnitIncrement(30);
        this.jbScrollPane.setHorizontalScrollBarPolicy(31);
        this.jbScrollPane.setVerticalScrollBarPolicy(20);
        this.contentPanel.add((Component)this.jbScrollPane, "Center");
        this.mostCountLimitCell = new MostCountLimitCell();
    }

    public void fetchHistories() {
        this.stateLoading();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.project, CosyBundle.message("chat.history.loading.progress.text", new Object[0])){

            public void run(@NotNull ProgressIndicator progressIndicator) {
                CosyStartupAdapter startupListener;
                if (progressIndicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (Cosy.INSTANCE.checkCosy(ChatHistoryPanel.this.project, true, Collections.singletonList(startupListener = new CosyStartupAdapter(){

                    @Override
                    public void onStartup() {
                        ChatHistoryPanel.this.requestHistory();
                    }
                }))) {
                    ChatHistoryPanel.this.requestHistory();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/alibabacloud/intellij/cosy/ui/search/generate/ChatHistoryPanel$2", "run"));
            }
        });
    }

    private void stateLoading() {
        this.listPanel.removeAll();
        this.contentPanel.invalidate();
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
    }

    private void requestHistory() {
        if (Cosy.INSTANCE.getLanguageService(this.project) == null) {
            return;
        }
        List<ChatSession> records = Cosy.INSTANCE.getLanguageService(this.project).listAllSessions(new ListChatHistoryParams(ProjectUtils.getProjectBaseDir(this.project)), 5000L);
        if (records == null || records.isEmpty()) {
            this.stateEmpty();
            return;
        }
        SwingUtilities.invokeLater(() -> {
            ChatHistoryCell.ChatHistoryCellEventListener eventListener = new ChatHistoryCell.ChatHistoryCellEventListener(){

                @Override
                public void onDeleted() {
                    ChatHistoryPanel.this.checkListState();
                }
            };
            for (int i = 0; i < records.size(); ++i) {
                ChatSession record = (ChatSession)records.get(i);
                this.listPanel.add(new ChatHistoryCell(this.project, this, record, eventListener));
                if (i == 49) break;
            }
            if (records.size() >= 50) {
                this.listPanel.add(this.mostCountLimitCell);
            }
            this.contentPanel.removeAll();
            this.contentPanel.add((Component)this.jbScrollPane, "Center");
            this.clearLabel.setEnabled(true);
            this.contentPanel.invalidate();
            this.contentPanel.revalidate();
            this.contentPanel.repaint();
        });
    }

    private void checkListState() {
        int historyCount = 0;
        boolean existMaxTips = false;
        for (int i = 0; i < this.listPanel.getComponentCount(); ++i) {
            Component component = this.listPanel.getComponent(i);
            if (component instanceof ChatHistoryCell) {
                ++historyCount;
                continue;
            }
            if (!(component instanceof MostCountLimitCell)) continue;
            existMaxTips = true;
        }
        if (historyCount >= 50 && !existMaxTips) {
            this.listPanel.add(this.mostCountLimitCell);
        } else if (historyCount == 0) {
            this.stateEmpty();
        } else if (existMaxTips) {
            this.listPanel.remove(this.mostCountLimitCell);
        }
        this.listPanel.revalidate();
        this.listPanel.repaint();
    }

    private void clearHistories() {
        if (Cosy.INSTANCE.getLanguageService(this.project).clearAllSessions()) {
            this.listPanel.removeAll();
            this.stateEmpty();
        }
    }

    public void deleteRecord(ChatHistoryCell cell) {
        this.listPanel.remove(cell);
    }

    private void stateEmpty() {
        this.clearLabel.setEnabled(false);
        this.contentPanel.removeAll();
        this.contentPanel.add((Component)this.emptyPanel.getComponent(), "Center");
        this.contentPanel.invalidate();
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
    }

    static class MostCountLimitCell
    extends JPanel {
        public MostCountLimitCell() {
            this.setLayout(new BorderLayout());
            JLabel label = new JLabel(CosyBundle.message("chat.history.label.most.recent", new Object[0]), null, 0);
            this.add((Component)label, "Center");
        }
    }
}

