/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.generate;

import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.core.CosyStartupAdapter;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ChatSession;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.DelChatSessionParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.GetChatSessionParams;
import com.alibabacloud.intellij.cosy.search.util.StringCheckUtil;
import com.alibabacloud.intellij.cosy.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.cosy.ui.search.generate.ChatHistoryPanel;
import com.alibabacloud.intellij.cosy.ui.search.topic.LingmaSessionRecoverNotifier;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.CosyDateUtil;
import com.alibabacloud.intellij.cosy.util.SwingUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import icons.LingmaIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;

public class ChatHistoryCell
extends RoundRectPanel {
    private static final Logger LOG = Logger.getInstance(ChatHistoryCell.class);
    private static final int DEFAULT_HEIGHT = 70;
    private static final int MAX_PROJECT_NAME_LENGTH = 16;
    private static final int MAX_SESSION_TITLE_LENGTH = 40;
    private static final int MAX_HISTORY_TOOLTIP_LENGTH = 512;
    Project project;
    ChatSession record;
    JLabel sessionTitleLabel;
    JLabel projectNameLabel;
    JLabel gmtModifiedLabel;
    JLabel deleteLabel;
    ChatHistoryPanel historyPanel;
    ChatHistoryCellEventListener eventListener;

    public ChatHistoryCell(final Project project, final ChatHistoryPanel historyPanel, final ChatSession record, final ChatHistoryCellEventListener eventListener) {
        this.project = project;
        this.record = record;
        this.historyPanel = historyPanel;
        this.eventListener = eventListener;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setCursor(Cursor.getPredefinedCursor(12));
        String sessionTitle = record.getSessionTitle();
        String projectName = record.getProjectName();
        this.sessionTitleLabel = new JLabel(this.keepLength(sessionTitle, 40));
        this.sessionTitleLabel.setToolTipText(this.wrapTooltip(sessionTitle));
        this.sessionTitleLabel.setVerticalAlignment(1);
        this.sessionTitleLabel.setForeground(ColorUtil.getTextForegroundColor());
        this.sessionTitleLabel.setFont(new Font("Monospaced", 0, 13));
        this.projectNameLabel = new JLabel(this.keepLength(projectName, 16));
        this.projectNameLabel.setToolTipText(projectName);
        this.projectNameLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
        this.projectNameLabel.setFont(new Font("Monospaced", 0, 12));
        Date showDate = new Date(record.getGmtModified());
        this.gmtModifiedLabel = new JLabel(CosyDateUtil.getAskTime(showDate));
        this.gmtModifiedLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
        this.gmtModifiedLabel.setFont(new Font("Monospaced", 0, 12));
        this.deleteLabel = new JLabel(LingmaIcons.DeleteGreyIcon);
        this.deleteLabel.setVerticalAlignment(1);
        this.deleteLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ChatHistoryCell.this.deleteLabel.setIcon(LingmaIcons.DeleteRedIcon);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ChatHistoryCell.this.deleteLabel.setIcon(LingmaIcons.DeleteGreyIcon);
            }
        });
        JPanel headerPanel = new JPanel();
        headerPanel.setLayout(new BorderLayout());
        headerPanel.add((Component)this.sessionTitleLabel, "West");
        headerPanel.add((Component)this.deleteLabel, "East");
        this.add((Component)headerPanel, "Center");
        JPanel footerPanel = new JPanel();
        footerPanel.setLayout(new BorderLayout());
        footerPanel.add((Component)this.gmtModifiedLabel, "West");
        footerPanel.add((Component)this.projectNameLabel, "East");
        this.add((Component)footerPanel, "South");
        SwingUtil.foreachChildComponent(this, cp -> {
            if (cp instanceof JPanel) {
                Color color = ColorUtil.getChatCardBackgroundColor();
                cp.setBackground(color);
            }
            cp.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    ChatHistoryCell.this.deleteLabel.setVisible(true);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ChatHistoryCell.this.deleteLabel.setVisible(false);
                }
            });
            if (cp != this.deleteLabel) {
                cp.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            LOG.info("click chat history cell:" + record);
                            CosyStartupAdapter startupListener = new CosyStartupAdapter(){

                                @Override
                                public void onStartup() {
                                    ChatHistoryCell.this.requestSession();
                                }
                            };
                            if (Cosy.INSTANCE.checkCosy(project, true, Collections.singletonList(startupListener))) {
                                ChatHistoryCell.this.requestSession();
                            }
                        });
                    }
                });
            }
        });
        this.deleteLabel.setVisible(false);
        this.deleteLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (Cosy.INSTANCE.checkCosy(project)) {
                    DelChatSessionParams params = new DelChatSessionParams(record.getSessionId());
                    if (Cosy.INSTANCE.getLanguageService(project).deleteSessionById(params)) {
                        historyPanel.deleteRecord(ChatHistoryCell.this);
                        eventListener.onDeleted();
                        historyPanel.invalidate();
                        historyPanel.revalidate();
                        historyPanel.repaint();
                    }
                }
            }
        });
    }

    private void requestSession() {
        GetChatSessionParams params = new GetChatSessionParams(this.record.getSessionId());
        ChatSession session = Cosy.INSTANCE.getLanguageService(this.project).getSessionById(params, 5000L);
        if (session != null) {
            ((LingmaSessionRecoverNotifier)this.project.getMessageBus().syncPublisher(LingmaSessionRecoverNotifier.SESSION_RECOVER_NOTIFICATION)).recoverSession(session);
        }
    }

    private String wrapTooltip(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        if (((String)str).length() > 512) {
            str = ((String)str).substring(0, 512) + "\n...";
        }
        str = StringUtil.escapeXmlEntities((String)str);
        str = ((String)str).replace(" ", "&nbsp;");
        str = ((String)str).replace("\t", "&nbsp;&nbsp;");
        str = ((String)str).replace("\r\n", "<br/>");
        str = ((String)str).replace("\n", "<br/>");
        return "<html><body>" + (String)str + "</body></html>";
    }

    private String keepLength(String str, int maxLength) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        float length = 0.0f;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            length = StringCheckUtil.isChineseChar(c) ? (length += 2.0f) : (length += 1.0f);
            if (length > (float)maxLength) break;
            sb.append(c);
        }
        Object result = sb.toString().trim();
        if (sb.length() < str.length()) {
            result = (String)result + "...";
        }
        return result;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.height = 70;
        return dimension;
    }

    public static abstract class ChatHistoryCellEventListener {
        public void onDeleted() {
        }
    }
}

