/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.generate;

import com.alibabacloud.intellij.cosy.chat.enums.AgentTagEnum;
import com.alibabacloud.intellij.cosy.constants.InputConstants;
import com.alibabacloud.intellij.cosy.constants.ShortcutConstants;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStateEnum;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthWhitelistStatusEnum;
import com.alibabacloud.intellij.cosy.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.cosy.ui.search.component.AutoHeightTextArea;
import com.alibabacloud.intellij.cosy.ui.search.component.DisplayIcon;
import com.alibabacloud.intellij.cosy.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.cosy.ui.search.generate.InputTagsPanel;
import com.alibabacloud.intellij.cosy.ui.search.listener.InputTextAreaCursorDisableListener;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatAskTag;
import com.alibabacloud.intellij.cosy.ui.search.model.SuggestPrompt;
import com.alibabacloud.intellij.cosy.ui.search.topic.SuggestPromptNotifier;
import com.alibabacloud.intellij.cosy.util.ChatAskTagUtil;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.RecentQueryUtil;
import com.alibabacloud.intellij.cosy.util.StringUtils;
import com.alibabacloud.intellij.cosy.util.SuggestPromptUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import icons.LingmaIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class AskInputPanel
extends JPanel {
    private static Logger log = Logger.getInstance(AskInputPanel.class);
    private static final int MAX_TEXTFIELD_HEIGHT = 300;
    private static final int SEND_PANEL_WIDTH = 32;
    private static final int MIN_TEXTFIELD_HEIGHT = 20;
    private static final int CHANGE_EMPTY_CHECK_COUNT = 2;
    public static final int INIT_EMPTY_CHECK_COUNT = 1;
    public int inputFieldEmptyCount = 1;
    public int pressBackSpaceCountWhenDelTag = 0;
    AutoHeightTextArea textArea;
    JPanel basePanel;
    public JLabel returnLabel;
    JPanel rightPanel;
    RoundRectPanel inputPanel;
    InputTagsPanel inputTagsPanel;
    Project project;
    JBScrollPane jbScrollPane;
    JLayeredPane layeredPane;
    private int rightPanelTopOffset = 0;
    boolean isEditing;
    Map<String, Integer> recentQueryIndexMap = new HashMap<String, Integer>();
    boolean isSendEnabled = true;
    AtomicBoolean isHistoryEmpty = new AtomicBoolean(false);

    public AskInputPanel(final Project project) {
        this.project = project;
        this.isEditing = false;
        this.isSendEnabled = true;
        this.setLayout(new BorderLayout());
        this.setBorder(JBUI.Borders.customLine((Color)ColorUtil.getEditorBackgroundColor(), (int)1, (int)0, (int)0, (int)0));
        this.basePanel = new JPanel(new BorderLayout());
        this.basePanel.setBorder((Border)JBUI.Borders.empty((int)10, (int)12));
        this.add((Component)this.basePanel, "Center");
        this.inputPanel = new RoundRectPanel(new BorderLayout()){

            @Override
            public void setBackground(Color bg) {
                super.setBackground(ColorUtil.getEditorBackgroundColor());
            }

            @Override
            public void refreshColor(EditorColorsScheme scheme, Color themeColor) {
                this.setBackground(ColorUtil.getEditorBackgroundColor());
            }
        };
        this.inputPanel.setBorder((Border)JBUI.Borders.empty((int)8, (int)8, (int)8, (int)2));
        this.inputPanel.setBackground(ColorUtil.getEditorBackgroundColor());
        this.basePanel.add((Component)this.inputPanel, "Center");
        this.layeredPane = new JLayeredPane(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                Dimension tagsPanelSize = AskInputPanel.this.inputTagsPanel.getPreferredSize();
                dim.height = Math.max(dim.height, Math.min(tagsPanelSize.height, 300));
                dim.height = Math.max(dim.height, 20);
                return dim;
            }

            @Override
            public void doLayout() {
                super.doLayout();
                AskInputPanel.this.updateLayout();
            }
        };
        this.inputPanel.add((Component)this.layeredPane, "Center");
        this.textArea = new AutoHeightTextArea(project, this, "", -1);
        this.textArea.setFont((Font)JBUI.Fonts.label((float)14.0f));
        this.textArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AskInputPanel.this.inputPanel.setBorderColor(JBUI.CurrentTheme.Focus.focusColor());
                AskInputPanel.this.inputPanel.invalidate();
                AskInputPanel.this.inputPanel.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                AskInputPanel.this.inputPanel.setBorderColor(null);
                AskInputPanel.this.inputPanel.invalidate();
                AskInputPanel.this.inputPanel.repaint();
            }
        });
        this.inputTagsPanel = new InputTagsPanel();
        this.inputTagsPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)0, (int)0, (int)32));
        this.inputTagsPanel.add((Component)((Object)this.textArea));
        this.jbScrollPane = new JBScrollPane(10){

            public Dimension getPreferredSize() {
                Dimension parentSize = AskInputPanel.this.layeredPane.getSize();
                Dimension textDim = AskInputPanel.this.textArea.getPreferredSize();
                return new Dimension(parentSize.width - 32, Math.min(textDim.height, 300));
            }
        };
        this.jbScrollPane.setViewportView((Component)this.inputTagsPanel);
        this.jbScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jbScrollPane.setHorizontalScrollBarPolicy(31);
        this.jbScrollPane.setVerticalScrollBarPolicy(21);
        this.layeredPane.add((Component)this.jbScrollPane, JLayeredPane.DEFAULT_LAYER);
        this.rightPanel = new JPanel(new BorderLayout());
        this.rightPanel.setOpaque(false);
        this.rightPanel.setBackground(ColorUtil.getEditorBackgroundColor());
        this.layeredPane.add((Component)this.rightPanel, JLayeredPane.PALETTE_LAYER);
        this.returnLabel = new DisplayIcon(LingmaIcons.SendActiveIcon);
        this.rightPanel.add((Component)this.returnLabel, "Center");
        this.returnLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AskInputPanel.this.doSendMessage();
            }
        });
        this.textArea.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                AskInputPanel.this.checkTextValid();
                if (!"".equals(AskInputPanel.this.textArea.getText())) {
                    AskInputPanel.this.inputFieldEmptyCount = 2;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/alibabacloud/intellij/cosy/ui/search/generate/AskInputPanel$6", "textChanged"));
            }
        });
        this.textArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AskInputPanel.this.pressBackSpaceCountWhenDelTag = 0;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (e.getOffset() == 0) {
                    AskInputPanel.this.pressBackSpaceCountWhenDelTag = 1;
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AskInputPanel.this.pressBackSpaceCountWhenDelTag = 0;
            }
        });
        this.textArea.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                int dot = e.getDot();
                if (dot != 0) {
                    AskInputPanel.this.pressBackSpaceCountWhenDelTag = 0;
                }
            }
        });
        if (this.textArea.getDocument() instanceof AbstractDocument) {
            ((AbstractDocument)this.textArea.getDocument()).setDocumentFilter(new DocumentFilter(){

                @Override
                public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attr) throws BadLocationException {
                    String newText = StringUtils.removeEmojis(text);
                    super.insertString(fb, offset, newText, attr);
                }

                @Override
                public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                    String newText = StringUtils.removeEmojis(text);
                    super.replace(fb, offset, length, newText, attrs);
                }
            });
        }
        this.textArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (ShortcutConstants.UP_DOWN_RELATED_KEYCODES.contains(keyCode)) {
                    return;
                }
                ArrayList<SuggestPrompt> suggestPrompts = new ArrayList<SuggestPrompt>();
                List<ChatAskTag> tagList = AskInputPanel.this.inputTagsPanel.getTags();
                ArrayList<ChatAskTag> agentTagList = new ArrayList();
                List<Object> lingmaTagList = new ArrayList();
                ArrayList<ChatAskTag> scopeTagList = new ArrayList();
                List<ChatAskTag> taskTagList = new ArrayList<ChatAskTag>();
                if (CollectionUtils.isNotEmpty(tagList)) {
                    agentTagList = tagList.stream().filter(tag -> tag.getType().equals("agent")).collect(Collectors.toList());
                    scopeTagList = tagList.stream().filter(tag -> tag.getType().equals("scope")).collect(Collectors.toList());
                    taskTagList = tagList.stream().filter(tag -> "task".equals(tag.getType())).collect(Collectors.toList());
                    lingmaTagList = tagList.stream().filter(tag -> AgentTagEnum.LINGMA.getId().equals(tag.getId())).collect(Collectors.toList());
                }
                if (AskInputPanel.this.textArea.getText().startsWith("@")) {
                    if (CollectionUtils.isEmpty(agentTagList) && CollectionUtils.isEmpty(scopeTagList) && CollectionUtils.isEmpty(taskTagList)) {
                        String prefix = AskInputPanel.this.textArea.getText().substring(1);
                        LinkedHashMap<String, SuggestPrompt> currentSuggestPromptMap = new LinkedHashMap<String, SuggestPrompt>();
                        currentSuggestPromptMap.putAll(SuggestPromptUtil.getAgentSuggestPrompt(project));
                        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)prefix)) {
                            suggestPrompts = new ArrayList(currentSuggestPromptMap.values());
                        } else {
                            for (Map.Entry entry : currentSuggestPromptMap.entrySet()) {
                                if (!((String)entry.getKey()).startsWith(prefix)) continue;
                                suggestPrompts.add((SuggestPrompt)entry.getValue());
                            }
                        }
                    }
                } else if (AskInputPanel.this.textArea.getText().startsWith("#")) {
                    if (CollectionUtils.isEmpty(taskTagList) && CollectionUtils.isEmpty(scopeTagList) && CollectionUtils.isEmpty(lingmaTagList)) {
                        String prefix = AskInputPanel.this.textArea.getText().substring(1);
                        LinkedHashMap<String, SuggestPrompt> currentSuggestPromptMap = new LinkedHashMap<String, SuggestPrompt>();
                        currentSuggestPromptMap.putAll(SuggestPromptUtil.getScopeSuggestPrompt(project));
                        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)prefix)) {
                            suggestPrompts = new ArrayList(currentSuggestPromptMap.values());
                        } else {
                            for (Map.Entry entry : currentSuggestPromptMap.entrySet()) {
                                if (!((String)entry.getKey()).startsWith(prefix)) continue;
                                suggestPrompts.add((SuggestPrompt)entry.getValue());
                            }
                        }
                    }
                } else if (AskInputPanel.this.textArea.getText().startsWith("/") && CollectionUtils.isEmpty(agentTagList) && CollectionUtils.isEmpty(scopeTagList) && CollectionUtils.isEmpty(taskTagList)) {
                    String prefix = AskInputPanel.this.textArea.getText().substring(1);
                    LinkedHashMap<String, SuggestPrompt> currentSuggestPromptMap = new LinkedHashMap<String, SuggestPrompt>();
                    if (AskInputPanel.this.isHistoryEmpty.get()) {
                        currentSuggestPromptMap.putAll(InputConstants.WELCOMING_HELP_MAP);
                        currentSuggestPromptMap.putAll(InputConstants.WELCOMING_SUGGEST_PROMPT_MAP);
                        currentSuggestPromptMap.putAll(SuggestPromptUtil.getAgentSuggestPrompt(project));
                        currentSuggestPromptMap.putAll(SuggestPromptUtil.getScopeSuggestPrompt(project));
                    } else {
                        currentSuggestPromptMap.putAll(InputConstants.WELCOMING_SUGGEST_PROMPT_MAP);
                        currentSuggestPromptMap.putAll(SuggestPromptUtil.getAgentSuggestPrompt(project));
                        currentSuggestPromptMap.putAll(SuggestPromptUtil.getScopeSuggestPrompt(project));
                        currentSuggestPromptMap.putAll(InputConstants.CONTEXT_SUGGEST_PROMPT_MAP);
                    }
                    if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)prefix)) {
                        suggestPrompts = new ArrayList(currentSuggestPromptMap.values());
                    } else {
                        for (Map.Entry entry : currentSuggestPromptMap.entrySet()) {
                            if (!((String)entry.getKey()).startsWith(prefix)) continue;
                            suggestPrompts.add((SuggestPrompt)entry.getValue());
                        }
                    }
                }
                if (CollectionUtils.isEmpty(suggestPrompts)) {
                    AskInputPanel.this.filterTagsFromText(AskInputPanel.this.textArea.getText(), agentTagList, scopeTagList, taskTagList);
                }
                ((SuggestPromptNotifier)project.getMessageBus().syncPublisher(SuggestPromptNotifier.SUGGEST_PROMPT_NOTIFICATION)).suggest(suggestPrompts);
                AskInputPanel.this.isEditing = !AskInputPanel.this.textArea.getText().isEmpty() && CollectionUtils.isEmpty(AskInputPanel.this.inputTagsPanel.getTags());
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 38 || e.getKeyCode() == 40) {
                    String recentQueryKey;
                    if (AskInputPanel.this.isEditing && !AskInputPanel.this.textArea.getText().isEmpty()) {
                        return;
                    }
                    if (CosyPersistentSetting.getInstance().getState() == null || CosyPersistentSetting.getInstance().getState().getRecentQueries() == null) {
                        log.info("Recent queries not exists.");
                        return;
                    }
                    Map<String, List<String>> recentQueryMap = CosyPersistentSetting.getInstance().getState().getRecentQueries();
                    List<String> recentQueries = recentQueryMap.get(recentQueryKey = RecentQueryUtil.constructRecentQueryKey(project, AskInputPanel.this.inputTagsPanel.getTags()));
                    if (recentQueries == null) {
                        return;
                    }
                    Integer recentQueryIndex = AskInputPanel.this.recentQueryIndexMap.get(recentQueryKey);
                    if (recentQueryIndex == null) {
                        recentQueryIndex = -1;
                    }
                    if (e.getKeyCode() == 38) {
                        if (recentQueryIndex < 0 || recentQueryIndex >= recentQueries.size()) {
                            recentQueryIndex = recentQueries.size() - 1;
                        } else if (recentQueryIndex > 0) {
                            Integer n = recentQueryIndex;
                            Integer n2 = recentQueryIndex = Integer.valueOf(recentQueryIndex - 1);
                        }
                    } else if (e.getKeyCode() == 40) {
                        if (recentQueryIndex < 0 || recentQueryIndex > recentQueries.size()) {
                            recentQueryIndex = 0;
                        } else if (recentQueryIndex <= recentQueries.size() - 1) {
                            Integer n = recentQueryIndex;
                            Integer n3 = recentQueryIndex = Integer.valueOf(recentQueryIndex + 1);
                        }
                    }
                    AskInputPanel.this.recentQueryIndexMap.put(recentQueryKey, recentQueryIndex);
                    if (recentQueryIndex < 0 || recentQueryIndex >= recentQueries.size()) {
                        AskInputPanel.this.textArea.setText("");
                        return;
                    }
                    AskInputPanel.this.textArea.setText(recentQueries.get(recentQueryIndex));
                    AskInputPanel.this.isEditing = false;
                }
            }
        });
        this.textArea.addOnShowPlaceHolderListener(new AutoHeightTextArea.OnShowPlaceHolderListener(){

            @Override
            public void onShowPlaceHolder() {
                AskInputPanel.this.checkSendButtonState();
            }

            @Override
            public void onHiddenPlaceHolder() {
                AskInputPanel.this.checkSendButtonState();
            }
        });
        this.checkSendButtonState();
    }

    public void resetRecentQueryIndex() {
        this.recentQueryIndexMap.clear();
    }

    public void doSendMessage() {
        if (this.textArea.isEnabled() && this.returnLabel.isEnabled() && this.isSendEnabled) {
            this.textArea.doSendMessage();
            this.clearTextArea();
        }
    }

    public void clearTextArea() {
        this.textArea.clearTextArea();
    }

    public void filterTagsFromText(String text, List<ChatAskTag> agentTags, List<ChatAskTag> scopeTags, List<ChatAskTag> taskTags) {
        List<Object> lingmaTags = new ArrayList();
        if (CollectionUtils.isNotEmpty(agentTags)) {
            lingmaTags = agentTags.stream().filter(tag -> AgentTagEnum.LINGMA.getId().equals(tag.getId())).collect(Collectors.toList());
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)text)) {
            return;
        }
        String originalText = text;
        if (!(text.startsWith("@") || text.startsWith("#") || text.startsWith("/"))) {
            return;
        }
        if (text.startsWith("@") && CollectionUtils.isEmpty(agentTags) && CollectionUtils.isEmpty(scopeTags) && CollectionUtils.isEmpty(taskTags)) {
            text = this.doFilterTagFromText(text, InputConstants.AGENT_TAG_LIST);
            agentTags = this.inputTagsPanel.getTags().stream().filter(tag -> tag.getType().equals("agent")).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(agentTags)) {
                lingmaTags = agentTags.stream().filter(tag -> AgentTagEnum.LINGMA.getId().equals(tag.getId())).collect(Collectors.toList());
            }
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)text)) {
            this.textArea.setText(text);
            return;
        }
        if (text.startsWith("#") && CollectionUtils.isEmpty(lingmaTags) && CollectionUtils.isEmpty(scopeTags) && CollectionUtils.isEmpty(taskTags)) {
            text = this.doFilterTagFromText(text, InputConstants.SCOPE_TAG_LIST);
            scopeTags = this.inputTagsPanel.getTags().stream().filter(tag -> tag.getType().equals("task")).collect(Collectors.toList());
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)text)) {
            this.textArea.setText(text);
            return;
        }
        if (text.startsWith("/") && CollectionUtils.isEmpty(agentTags) && CollectionUtils.isEmpty(scopeTags) && CollectionUtils.isEmpty(taskTags)) {
            text = this.doFilterTagFromText(text, InputConstants.TASK_TAG_LIST);
        }
        if (!originalText.equals(text)) {
            this.textArea.setText(text);
        }
    }

    private String doFilterTagFromText(String text, List<String> tagsList) {
        for (String tag : tagsList) {
            SuggestPrompt suggestPrompt;
            if (tag.length() < 2 || !text.startsWith(tag) || (suggestPrompt = SuggestPromptUtil.getAllSuggestPromptOfTag(this.project).get(tag.substring(1))) == null) continue;
            this.addTag(ChatAskTag.buildTag(suggestPrompt.getId(), tag));
            text = text.substring(tag.length());
            if (text == null) break;
            text = text.trim();
            break;
        }
        return text;
    }

    public void updateLayout() {
        Dimension layerSize = this.layeredPane.getSize();
        int layerWidth = layerSize.width;
        Dimension inputTagSize = this.inputTagsPanel.getPreferredSize();
        int inputTagHeight = inputTagSize.height;
        this.inputTagsPanel.setBounds(0, -this.jbScrollPane.getVerticalScrollBar().getValue(), layerWidth, inputTagHeight);
        int height = Math.min(inputTagHeight, 300);
        height = Math.max(height, 20);
        this.jbScrollPane.setBounds(0, 0, layerWidth, height);
        int rightTop = 0;
        int rightHeight = this.rightPanel.getPreferredSize().height;
        if (rightHeight > this.jbScrollPane.getSize().height) {
            rightTop = (this.jbScrollPane.getSize().height - rightHeight) / 2;
            if (this.rightPanelTopOffset == 0) {
                this.rightPanelTopOffset = rightTop;
            }
        } else {
            rightTop = this.jbScrollPane.getSize().height - rightHeight - 2;
        }
        this.rightPanel.setBounds(layerWidth - 32, rightTop, rightHeight, rightHeight);
        if (inputTagHeight > 300) {
            this.jbScrollPane.setVerticalScrollBarPolicy(20);
        } else {
            this.jbScrollPane.setVerticalScrollBarPolicy(21);
        }
        this.revalidate();
        this.repaint();
    }

    public void setState(AuthStatus status) {
        if (status.getStatus() != null && AuthStateEnum.LOGIN.getValue() == status.getStatus().intValue()) {
            if (status.getWhitelist() == null) {
                status.setWhitelist(AuthWhitelistStatusEnum.UNKNOWN.getValue());
            }
            if (status.getWhitelist().intValue() == AuthWhitelistStatusEnum.PASS.getValue()) {
                this.textArea.setEnabled(true);
                this.textArea.setCursor(Cursor.getPredefinedCursor(2));
                this.textArea.setPlaceholder(CosyBundle.message("chat.input.placeholder.normal", new Object[0]));
                this.setIsHistoryEmpty(true);
            } else {
                this.textArea.setEnabled(false);
                this.textArea.setCursor(Cursor.getPredefinedCursor(0));
                this.textArea.setPlaceholder(CosyBundle.message("chat.input.placeholder.require.access", new Object[0]));
            }
        } else {
            this.textArea.setText("");
            this.textArea.setEnabled(false);
            this.textArea.setCursor(Cursor.getPredefinedCursor(0));
            this.textArea.setPlaceholder(CosyBundle.message("chat.input.placeholder.require.login", new Object[0]));
        }
    }

    private void checkTextValid() {
        if (this.textArea.getDocument().getLength() > 25000) {
            SwingUtilities.invokeLater(() -> {
                String text = this.textArea.getText();
                String content = text.substring(0, 25000);
                this.textArea.setText(content);
                this.textArea.invalidate();
                this.updateLayout();
            });
        } else {
            this.updateLayout();
        }
        this.checkSendButtonState();
    }

    private void checkSendButtonState() {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.textArea.getText())) {
            this.checkSendButtonStateByTags();
        } else {
            this.returnLabel.setIcon(LingmaIcons.SendActiveIcon);
            this.returnLabel.setEnabled(true);
        }
    }

    private void checkSendButtonStateByTags() {
        List<ChatAskTag> chatAskTags = this.getTags();
        List<Object> tagsAllowTextNull = new ArrayList();
        if (CollectionUtils.isNotEmpty(chatAskTags)) {
            tagsAllowTextNull = chatAskTags.stream().filter(chatAskTag -> "task".equals(chatAskTag.getType()) || AgentTagEnum.LINGMA.getId().equals(chatAskTag.getId())).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(tagsAllowTextNull)) {
            this.returnLabel.setIcon(LingmaIcons.SendDisabledIcon);
            this.returnLabel.setEnabled(false);
        } else {
            this.returnLabel.setIcon(LingmaIcons.SendActiveIcon);
            this.returnLabel.setEnabled(true);
        }
    }

    public void disableInputPanel() {
        this.addMouseMotionListener(new InputTextAreaCursorDisableListener(this.textArea));
        this.textArea.setEditable(false);
        this.textArea.setEnabled(false);
        this.textArea.setCursor(Cursor.getPredefinedCursor(0));
        this.returnLabel.setIcon(LingmaIcons.SendDisabledIcon);
    }

    public void disableSendInputPanel() {
        this.returnLabel.setIcon(LingmaIcons.SendDisabledIcon);
    }

    public void enableInputPanel() {
        MouseMotionListener[] listeners;
        for (MouseMotionListener listener : listeners = this.getMouseMotionListeners()) {
            if (!(listener instanceof InputTextAreaCursorDisableListener)) continue;
            this.removeMouseMotionListener(listener);
        }
        this.textArea.setEditable(true);
        this.textArea.enablePlaceHolder();
        this.textArea.setEnabled(true);
        this.textArea.setCursor(Cursor.getPredefinedCursor(2));
        this.returnLabel.setIcon(LingmaIcons.SendActiveIcon);
    }

    public void disableSendButton() {
        this.returnLabel.setIcon(LingmaIcons.SendDisabledIcon);
        this.isSendEnabled = false;
    }

    public void enableSendButton() {
        this.returnLabel.setIcon(LingmaIcons.SendActiveIcon);
        this.isSendEnabled = true;
    }

    public void setText(String text) {
        if (this.textArea != null) {
            this.textArea.setText(text);
        }
    }

    public void setTextFocus() {
        if (this.textArea != null && this.textArea.isEnabled() && this.textArea.isEditable()) {
            this.textArea.requestFocusInWindow();
            this.textArea.grabFocus();
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new FocusEvent((Component)((Object)this.textArea), 1004));
        }
    }

    public void addTag(ChatAskTag tag) {
        if (this.inputTagsPanel != null) {
            this.inputTagsPanel.addTag(tag);
            List<ChatAskTag> tags = this.inputTagsPanel.getTags();
            String placeHolder = ChatAskTagUtil.getPlaceholderByTag(tags);
            this.textArea.setPlaceholder(placeHolder);
        }
    }

    public List<ChatAskTag> getTags() {
        if (this.inputTagsPanel != null) {
            return this.inputTagsPanel.getTags();
        }
        return List.of();
    }

    public void clearTags() {
        if (this.inputTagsPanel != null) {
            this.inputTagsPanel.removeTags();
        }
    }

    public void removeLastTag() {
        if (CollectionUtils.isNotEmpty(this.inputTagsPanel.getTags())) {
            String recentQueryKey = RecentQueryUtil.constructRecentQueryKey(this.project, this.inputTagsPanel.getTags());
            this.recentQueryIndexMap.remove(recentQueryKey);
        }
        this.inputTagsPanel.removeLast();
    }

    public void setTextFocusLost() {
        if (this.textArea != null) {
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new FocusEvent((Component)((Object)this.textArea), 1005));
        }
    }

    @Override
    public void addKeyListener(KeyListener listener) {
        if (this.textArea != null) {
            this.textArea.addKeyListener(listener);
        }
    }

    public void addEnterKeyListener(AutoHeightTextArea.EnterKeyListener listener) {
        if (this.textArea != null) {
            this.textArea.addEnterKeyListener(listener);
        }
    }

    public void setIsHistoryEmpty(boolean isHistoryEmpty) {
        this.isHistoryEmpty.set(isHistoryEmpty);
    }

    public boolean isSendEnabled() {
        return this.isSendEnabled;
    }

    public void setSendEnabled(boolean sendEnabled) {
        this.isSendEnabled = sendEnabled;
    }
}

