/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.form;

import com.alibabacloud.intellij.cosy.core.lsp.model.model.CodeDocContentDetail;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.CodeDocOverviewDetail;
import com.alibabacloud.intellij.cosy.search.util.JsoupUtil;
import com.alibabacloud.intellij.cosy.ui.BaseComponent;
import com.alibabacloud.intellij.cosy.ui.search.I18NConstant;
import com.alibabacloud.intellij.cosy.ui.search.color.CosyColor;
import com.alibabacloud.intellij.cosy.ui.search.component.MarkdownPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.TagListPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.TitleTextPane;
import com.alibabacloud.intellij.cosy.ui.search.component.VoteAcceptPanel;
import com.alibabacloud.intellij.cosy.ui.search.form.AnswerCell;
import com.alibabacloud.intellij.cosy.ui.search.topic.QaActionNotifier;
import com.alibabacloud.intellij.cosy.util.SwingUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.Content;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.HtmlPanel;
import com.intellij.util.ui.JBUI;
import icons.CommonIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class QAContentForm
implements BaseComponent {
    private static final int TITLE_CUT_PADDING = 62;
    private static final int MAX_LINE = 3;
    private static final String ELLIPSIS = "\n//...";
    private static final int PADDING = 38;
    private JPanel basePanel;
    private JLabel iconLabel;
    private JPanel labelPane;
    private JTextPane titleTextPane;
    private JPanel titlePane;
    private JBScrollPane scrollPane;
    private VoteAcceptPanel votePane;
    private JPanel descriptionPane;
    private JPanel stackAnswerPane;
    private JPanel questionPane;
    private JPanel infoPanel;
    private JPanel flowPane;
    private JPanel northPane;
    private JPanel centerPane;
    private JLabel licenseLabel;
    private JLabel expandLabel;
    private JPanel mdPane;
    private JLabel browserLabel;
    private JPanel topPanel;
    private JPanel returnPanel;
    private JLabel returnLabel;
    private JLabel sourceLable;
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private static final int FOLD_HEIGHT = 200;
    private static final int MAX_TEXT_LENGTH = 200;
    private JBPopup popup;
    private static Logger log = Logger.getInstance(QAContentForm.class);

    public QAContentForm(final Project project, final CodeDocOverviewDetail codeDocOverviewDetail, List<CodeDocContentDetail> contentDetailList, final JComponent mainComponent) {
        this.$$$setupUI$$$();
        this.topPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, (Color)CosyColor.DESCRIPTION_BORDER_COLOR));
        this.northPane.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, (Color)CosyColor.DESCRIPTION_BORDER_COLOR));
        this.descriptionPane.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, (Color)CosyColor.DESCRIPTION_BORDER_COLOR));
        this.titleTextPane.setOpaque(false);
        final String title = codeDocOverviewDetail.getTitle();
        this.titleTextPane.setToolTipText(title);
        ((TitleTextPane)this.titleTextPane).initUI(title);
        this.iconLabel.setIcon(CommonIcons.stackOverflowIcon);
        this.iconLabel.setText(null);
        Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR);
        if (color == null) {
            this.returnLabel.setIcon(CommonIcons.returnIcon);
        } else {
            this.returnLabel.setIcon(CommonIcons.lightReturnIcon);
        }
        this.sourceLable.setText(codeDocOverviewDetail.getSource());
        this.returnLabel.setCursor(new Cursor(12));
        this.sourceLable.setCursor(new Cursor(12));
        this.returnLabel.setOpaque(true);
        this.returnLabel.setBackground((Color)new JBColor(new Color(0xDFDFDF), new Color(-11644332, true)));
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Code Search");
                assert (toolWindow != null);
                if (toolWindow.getContentManager().findContent(I18NConstant.MAIN_CONTENT_NAME) != null) {
                    Content content = toolWindow.getContentManager().findContent(I18NConstant.MAIN_CONTENT_NAME);
                    content.setComponent(mainComponent);
                    toolWindow.getContentManager().setSelectedContent(content);
                }
            }
        };
        this.returnLabel.addMouseListener(mouseAdapter);
        this.sourceLable.addMouseListener(mouseAdapter);
        this.browserLabel.setForeground((Color)JBColor.BLUE);
        this.browserLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.browserLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ((QaActionNotifier)project.getMessageBus().syncPublisher(QaActionNotifier.SEARCH_QA_CLICK)).qaSearchClick(codeDocOverviewDetail, "click_browser");
                BrowserUtil.browse((String)codeDocOverviewDetail.getLink());
            }
        });
        String tags = codeDocOverviewDetail.getTags();
        ((TagListPanel)this.labelPane).updateComponent(project, tags, 0);
        final MarkdownPanel markdownPanel = new MarkdownPanel(project, this.questionPane, codeDocOverviewDetail.getSourceContent());
        JComponent tempComponent = this.getFirstComponent(markdownPanel, project);
        this.expandLabel.setIcon(CommonIcons.arrowDownIcon);
        this.expandLabel.setHorizontalTextPosition(2);
        this.expandLabel.setForeground((Color)CosyColor.EXPAND_COLOR);
        this.expandLabel.setCursor(new Cursor(12));
        if (markdownPanel.getComponents().length == 1 && this.getFirstComponentLength(markdownPanel) <= 200) {
            this.mdPane.add((Component)markdownPanel, "Center");
            this.expandLabel.setVisible(false);
        } else {
            this.mdPane.add((Component)tempComponent, "Center");
        }
        this.expandLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                QAContentForm.this.mdPane.removeAll();
                QAContentForm.this.mdPane.add((Component)markdownPanel, "Center");
                QAContentForm.this.expandLabel.setVisible(false);
                QAContentForm.this.mdPane.revalidate();
                QAContentForm.this.mdPane.repaint();
            }
        });
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Code Search");
        if (toolWindow != null) {
            final JComponent component = toolWindow.getContentManager().getComponent();
            component.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    ((TitleTextPane)QAContentForm.this.titleTextPane).initUI(component, title, (int)(62.0 + QAContentForm.this.iconLabel.getPreferredSize().getWidth()));
                    ((TagListPanel)QAContentForm.this.labelPane).updateLayout();
                }
            });
        }
        this.votePane.setVoteCount(codeDocOverviewDetail.getLikeCount());
        this.votePane.setAnswerCount(codeDocOverviewDetail.getCommentCount());
        this.votePane.setDatetime(sdf.format(codeDocOverviewDetail.getCreateDate()));
        this.votePane.setLayoutStyle(2);
        this.votePane.initUI();
        if (color == null) {
            this.licenseLabel.setIcon(CommonIcons.lightFileIcon);
        } else {
            this.licenseLabel.setIcon(CommonIcons.fileIcon);
        }
        this.licenseLabel.setToolTipText(I18NConstant.DATA_LICENSE_TEXT);
        this.licenseLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.licenseLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                QAContentForm.this.popupLicense(codeDocOverviewDetail);
                ((QaActionNotifier)project.getMessageBus().syncPublisher(QaActionNotifier.SEARCH_QA_CLICK)).qaSearchClick(codeDocOverviewDetail, "qa_content_license_click");
            }
        });
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(30);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                JScrollBar sBar = QAContentForm.this.scrollPane.getVerticalScrollBar();
                if (sBar.getValue() > 0) {
                    ((QaActionNotifier)project.getMessageBus().syncPublisher(QaActionNotifier.SEARCH_QA_CLICK)).qaSearchClick(codeDocOverviewDetail, "qa_content_scroll");
                    QAContentForm.this.scrollPane.getVerticalScrollBar().removeAdjustmentListener(this);
                }
            }
        });
        this.stackAnswerPane.setLayout((LayoutManager)new VerticalFlowLayout(0, 10));
        for (CodeDocContentDetail codeDocContentDetail : contentDetailList) {
            this.stackAnswerPane.add(new AnswerCell(project, codeDocContentDetail).getComponent());
        }
    }

    public int getFirstComponentLength(MarkdownPanel markdownPanel) {
        Component component = markdownPanel.getComponent(0);
        if (component instanceof HtmlPanel) {
            return ((HtmlPanel)component).getDocument().getLength();
        }
        JScrollPane jScrollPane = (JScrollPane)component;
        EditorTextField editorTextField = (EditorTextField)jScrollPane.getViewport().getView();
        return editorTextField.getDocument().getTextLength();
    }

    private JComponent getFirstComponent(MarkdownPanel markdownPanel, Project project) {
        Document tempDocument;
        if (markdownPanel.getComponent(0) instanceof HtmlPanel) {
            HtmlPanel firstPane = (HtmlPanel)markdownPanel.getComponent(0);
            final String htmlText = JsoupUtil.truncateHTML(firstPane.getText(), 200);
            HtmlPanel tempPane = new HtmlPanel(){

                @NotNull
                protected String getBody() {
                    String string = htmlText;
                    if (string == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/alibabacloud/intellij/cosy/ui/search/form/QAContentForm$7", "getBody"));
                }
            };
            tempPane.setBody(htmlText);
            tempPane.setBorder((Border)JBUI.Borders.empty((int)8, (int)0));
            return tempPane;
        }
        JScrollPane jScrollPane = (JScrollPane)markdownPanel.getComponent(0);
        EditorTextField firstPane = (EditorTextField)jScrollPane.getViewport().getView();
        if (firstPane.getDocument().getLineCount() < 3) {
            tempDocument = EditorFactory.getInstance().createDocument((CharSequence)firstPane.getText());
        } else {
            Object text = firstPane.getDocument().getText(new TextRange(0, firstPane.getDocument().getLineEndOffset(3)));
            text = (String)text + ELLIPSIS;
            tempDocument = EditorFactory.getInstance().createDocument((CharSequence)text);
        }
        EditorTextField tempEditorTextField = new EditorTextField(tempDocument, project, (FileType)JavaFileType.INSTANCE, true, false);
        Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR);
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        if (color == null) {
            tempEditorTextField.setBackground(editorColorsScheme.getDefaultBackground());
        } else {
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Code Search");
            assert (toolWindow != null);
            tempEditorTextField.setBackground(toolWindow.getComponent().getBackground());
        }
        tempEditorTextField.setRequestFocusEnabled(false);
        tempEditorTextField.ensureWillComputePreferredSize();
        tempEditorTextField.setFont(editorColorsScheme.getFont(EditorFontType.PLAIN));
        tempEditorTextField.setHorizontalSizeReferent((JComponent)tempEditorTextField);
        return tempEditorTextField;
    }

    private void popupLicense(CodeDocOverviewDetail codeDocOverviewDetail) {
        if (this.popup != null && this.popup.isVisible()) {
            this.popup.cancel();
            this.popup = null;
        } else {
            this.popup = SwingUtil.createLicensePopup(codeDocOverviewDetail.getLicense());
            this.popup.showUnderneathOf((Component)this.licenseLabel);
        }
    }

    @Override
    public int getPreferredWidth() {
        return 0;
    }

    @Override
    public int getPreferredHeight() {
        return 0;
    }

    @Override
    public JComponent getComponent() {
        return this.basePanel;
    }

    private void createUIComponents() {
        this.scrollPane = new JBScrollPane(10);
        this.labelPane = new TagListPanel(5);
        this.titleTextPane = new TitleTextPane();
    }

    @Generated
    public void setBasePanel(JPanel basePanel) {
        this.basePanel = basePanel;
    }

    @Generated
    public void setIconLabel(JLabel iconLabel) {
        this.iconLabel = iconLabel;
    }

    @Generated
    public void setLabelPane(JPanel labelPane) {
        this.labelPane = labelPane;
    }

    @Generated
    public void setTitleTextPane(JTextPane titleTextPane) {
        this.titleTextPane = titleTextPane;
    }

    @Generated
    public void setTitlePane(JPanel titlePane) {
        this.titlePane = titlePane;
    }

    @Generated
    public void setScrollPane(JBScrollPane scrollPane) {
        this.scrollPane = scrollPane;
    }

    @Generated
    public void setVotePane(VoteAcceptPanel votePane) {
        this.votePane = votePane;
    }

    @Generated
    public void setDescriptionPane(JPanel descriptionPane) {
        this.descriptionPane = descriptionPane;
    }

    @Generated
    public void setStackAnswerPane(JPanel stackAnswerPane) {
        this.stackAnswerPane = stackAnswerPane;
    }

    @Generated
    public void setQuestionPane(JPanel questionPane) {
        this.questionPane = questionPane;
    }

    @Generated
    public void setInfoPanel(JPanel infoPanel) {
        this.infoPanel = infoPanel;
    }

    @Generated
    public void setFlowPane(JPanel flowPane) {
        this.flowPane = flowPane;
    }

    @Generated
    public void setNorthPane(JPanel northPane) {
        this.northPane = northPane;
    }

    @Generated
    public void setCenterPane(JPanel centerPane) {
        this.centerPane = centerPane;
    }

    @Generated
    public void setLicenseLabel(JLabel licenseLabel) {
        this.licenseLabel = licenseLabel;
    }

    @Generated
    public void setExpandLabel(JLabel expandLabel) {
        this.expandLabel = expandLabel;
    }

    @Generated
    public void setMdPane(JPanel mdPane) {
        this.mdPane = mdPane;
    }

    @Generated
    public void setBrowserLabel(JLabel browserLabel) {
        this.browserLabel = browserLabel;
    }

    @Generated
    public void setTopPanel(JPanel topPanel) {
        this.topPanel = topPanel;
    }

    @Generated
    public void setReturnPanel(JPanel returnPanel) {
        this.returnPanel = returnPanel;
    }

    @Generated
    public void setReturnLabel(JLabel returnLabel) {
        this.returnLabel = returnLabel;
    }

    @Generated
    public void setSourceLable(JLabel sourceLable) {
        this.sourceLable = sourceLable;
    }

    @Generated
    public void setPopup(JBPopup popup) {
        this.popup = popup;
    }

    @Generated
    public JPanel getBasePanel() {
        return this.basePanel;
    }

    @Generated
    public JLabel getIconLabel() {
        return this.iconLabel;
    }

    @Generated
    public JPanel getLabelPane() {
        return this.labelPane;
    }

    @Generated
    public JTextPane getTitleTextPane() {
        return this.titleTextPane;
    }

    @Generated
    public JPanel getTitlePane() {
        return this.titlePane;
    }

    @Generated
    public JBScrollPane getScrollPane() {
        return this.scrollPane;
    }

    @Generated
    public VoteAcceptPanel getVotePane() {
        return this.votePane;
    }

    @Generated
    public JPanel getDescriptionPane() {
        return this.descriptionPane;
    }

    @Generated
    public JPanel getStackAnswerPane() {
        return this.stackAnswerPane;
    }

    @Generated
    public JPanel getQuestionPane() {
        return this.questionPane;
    }

    @Generated
    public JPanel getInfoPanel() {
        return this.infoPanel;
    }

    @Generated
    public JPanel getFlowPane() {
        return this.flowPane;
    }

    @Generated
    public JPanel getNorthPane() {
        return this.northPane;
    }

    @Generated
    public JPanel getCenterPane() {
        return this.centerPane;
    }

    @Generated
    public JLabel getLicenseLabel() {
        return this.licenseLabel;
    }

    @Generated
    public JLabel getExpandLabel() {
        return this.expandLabel;
    }

    @Generated
    public JPanel getMdPane() {
        return this.mdPane;
    }

    @Generated
    public JLabel getBrowserLabel() {
        return this.browserLabel;
    }

    @Generated
    public JPanel getTopPanel() {
        return this.topPanel;
    }

    @Generated
    public JPanel getReturnPanel() {
        return this.returnPanel;
    }

    @Generated
    public JLabel getReturnLabel() {
        return this.returnLabel;
    }

    @Generated
    public JLabel getSourceLable() {
        return this.sourceLable;
    }

    @Generated
    public JBPopup getPopup() {
        return this.popup;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JPanel jPanel;
        JPanel jPanel2;
        JLabel jLabel2;
        VoteAcceptPanel voteAcceptPanel;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        JPanel jPanel6;
        JPanel jPanel7;
        JLabel jLabel3;
        JPanel jPanel8;
        JPanel jPanel9;
        JLabel jLabel4;
        JLabel jLabel5;
        JLabel jLabel6;
        JPanel jPanel10;
        JPanel jPanel11;
        JPanel jPanel12;
        this.createUIComponents();
        this.basePanel = jPanel12 = new JPanel();
        jPanel12.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.topPanel = jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(5, 10, 10, 10), -1, -1, false, false));
        jPanel12.add((Component)jPanel11, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.returnPanel = jPanel10 = new JPanel();
        jPanel10.setLayout(new BorderLayout(5, 0));
        jPanel11.add((Component)jPanel10, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.sourceLable = jLabel6 = new JLabel();
        jLabel6.setText("");
        jPanel10.add((Component)jLabel6, "Center");
        this.returnLabel = jLabel5 = new JLabel();
        Font font = this.$$$getFont$$$(null, 1, -1, jLabel5.getFont());
        if (font != null) {
            jLabel5.setFont(font);
        }
        jLabel5.setHorizontalAlignment(0);
        jLabel5.setText("");
        jPanel10.add((Component)jLabel5, "West");
        Spacer spacer = new Spacer();
        jPanel11.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.browserLabel = jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messageBundle").getString("browser.open.label"));
        jPanel11.add((Component)jLabel4, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new BorderLayout(0, 0));
        jPanel12.add((Component)jPanel13, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.northPane = jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(16, 10, 5, 10), -1, 12, false, false));
        jPanel13.add((Component)jPanel9, "North");
        this.titlePane = jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout(10, 0));
        jPanel9.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JTextPane jTextPane = this.titleTextPane;
        jPanel8.add((Component)jTextPane, "Center");
        this.iconLabel = jLabel3 = new JLabel();
        jLabel3.setText("");
        jPanel8.add((Component)jLabel3, "West");
        this.flowPane = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.add((Component)jPanel7, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel7.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel14 = this.labelPane;
        jPanel7.add((Component)jPanel14, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = this.scrollPane;
        jPanel13.add((Component)jBScrollPane, "Center");
        this.centerPane = jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(0, 0));
        jBScrollPane.setViewportView(jPanel6);
        this.stackAnswerPane = jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(1, 5, 5));
        jPanel6.add((Component)jPanel5, "Center");
        this.questionPane = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(12, 10, 12, 10), -1, 5, false, false));
        jPanel6.add((Component)jPanel4, "North");
        this.infoPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.votePane = voteAcceptPanel = new VoteAcceptPanel();
        jPanel3.add((Component)voteAcceptPanel, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        this.licenseLabel = jLabel2 = new JLabel();
        jLabel2.setText("");
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.descriptionPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 5, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mdPane = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.expandLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messageBundle").getString("expand.description.panel"));
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel12.add((Component)spacer4, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.basePanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        Font font3 = new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
        boolean bl = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font font4 = bl ? new Font(font3.getFamily(), font3.getStyle(), font3.getSize()) : new StyleContext().getFont(font3.getFamily(), font3.getStyle(), font3.getSize());
        return font4 instanceof FontUIResource ? font4 : new FontUIResource(font4);
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

