/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.form;

import com.alibabacloud.intellij.cosy.common.CosySetting;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.CodeDocOverviewDetail;
import com.alibabacloud.intellij.cosy.search.enums.DocumentOpenModeEnum;
import com.alibabacloud.intellij.cosy.search.util.StringCheckUtil;
import com.alibabacloud.intellij.cosy.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.cosy.ui.search.CosyJBTableCell;
import com.alibabacloud.intellij.cosy.ui.search.I18NConstant;
import com.alibabacloud.intellij.cosy.ui.search.SearchResultPanel;
import com.alibabacloud.intellij.cosy.ui.search.SwingManager;
import com.alibabacloud.intellij.cosy.ui.search.color.CosyColor;
import com.alibabacloud.intellij.cosy.ui.search.component.DescriptionPopup;
import com.alibabacloud.intellij.cosy.ui.search.component.TagListPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.TitleTextPane;
import com.alibabacloud.intellij.cosy.ui.search.form.BlogContentForm;
import com.alibabacloud.intellij.cosy.ui.search.topic.QaActionNotifier;
import com.alibabacloud.intellij.cosy.util.IconUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import icons.CommonIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import org.apache.commons.lang3.StringUtils;

public class DocListCell
implements CosyJBTableCell {
    private JPanel contentPane;
    private JPanel headerPanel;
    private TitleTextPane titlePane;
    private JPanel iconPanel;
    private JLabel iconLabel;
    private JPanel flowPane;
    private TagListPanel labelPane;
    private JPanel infoPanel;
    private JLabel sourceLabel;
    private JLabel timeLabel;
    private static final int TAG_LIST_HGAP = 5;
    private static final int TITLE_CUT_PADDING = 100;
    Project project;
    CodeDocOverviewDetail codeDocOverviewDetail;
    DescriptionPopup descriptionPopup;
    private final JBCefBrowser jbCefBrowser;

    public DocListCell(CodeDocOverviewDetail codeDocOverviewDetail, Project project, SearchResultPanel searchResultPanel, DescriptionPopup descriptionPopup, JBCefBrowser jbCefBrowser) {
        this.project = project;
        this.codeDocOverviewDetail = codeDocOverviewDetail;
        this.descriptionPopup = descriptionPopup;
        this.jbCefBrowser = jbCefBrowser;
        this.$$$setupUI$$$();
        final String title = codeDocOverviewDetail.getTitle();
        if (CommonIcons.ICON_MAP.containsKey(codeDocOverviewDetail.getSource())) {
            this.iconLabel.setIcon(CommonIcons.ICON_MAP.get(codeDocOverviewDetail.getSource()));
        } else if (CommonIcons.DEFAULT_ICON_SOURCE_SET.contains(codeDocOverviewDetail.getSource())) {
            Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR);
            if (color == null) {
                this.iconLabel.setIcon(CommonIcons.defaultIcon);
            } else {
                this.iconLabel.setIcon(CommonIcons.lightDefaultIcon);
            }
        } else {
            this.loadIcon();
        }
        final Component resizeComponent = SwingManager.INSTANCE.getComponent(project, "MAIN_PANEL_KEY", this.contentPane);
        resizeComponent.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                DocListCell.this.titlePane.initUI((JComponent)resizeComponent, title, 100 + DocListCell.this.iconLabel.getPreferredSize().width);
                DocListCell.this.labelPane.updateLayout();
            }
        });
        this.contentPane.setBorder(JBUI.Borders.customLine((Color)CosyColor.QA_BORDER_COLOR, (int)0, (int)0, (int)2, (int)0));
        this.initContent(title, searchResultPanel, codeDocOverviewDetail);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        this.timeLabel.setText(sdf.format(codeDocOverviewDetail.getCreateDate()));
        this.timeLabel.setForeground((Color)CosyColor.GRAY_TXT_COLOR);
        this.sourceLabel.setText(codeDocOverviewDetail.getSource());
        this.sourceLabel.setForeground((Color)CosyColor.GRAY_TXT_COLOR);
        String tags = codeDocOverviewDetail.getTags();
        if (StringUtils.isBlank((CharSequence)tags)) {
            this.labelPane.setVisible(false);
        } else {
            this.labelPane.updateComponent(project, tags, 0);
        }
        this.initUIEvent(searchResultPanel);
    }

    public void loadIcon() {
        new SwingWorker<Icon, Void>(){

            @Override
            protected Icon doInBackground() {
                Icon icon = IconUtil.getIcon(DocListCell.this.codeDocOverviewDetail.getIconLink());
                if (icon == null) {
                    CommonIcons.DEFAULT_ICON_SOURCE_SET.add(DocListCell.this.codeDocOverviewDetail.getSource());
                }
                return icon;
            }

            @Override
            protected void done() {
                DocListCell.this.iconLabel.setIcon((Icon)this.get());
                DocListCell.this.iconLabel.repaint();
                DocListCell.this.iconLabel.revalidate();
            }
        }.execute();
    }

    private void initContent(String title, SearchResultPanel searchResultPanel, CodeDocOverviewDetail codeDocOverviewDetail) {
        Component cutWidthComponent = SwingManager.INSTANCE.getComponent(this.project, "MAIN_PANEL_KEY", searchResultPanel.getBasePanel());
        this.titlePane.setToolTipText(title);
        this.titlePane.setBackground(searchResultPanel.getBasePanel().getBackground());
        this.titlePane.setCursor(Cursor.getPredefinedCursor(12));
        this.titlePane.initUI((JComponent)cutWidthComponent, title, 100 + this.iconLabel.getPreferredSize().width);
    }

    private void initUIEvent(SearchResultPanel searchResultPanel) {
        this.registerHoverEvent(this.contentPane, searchResultPanel);
        this.registerHoverEvent(this.iconLabel, searchResultPanel);
        this.registerHoverEvent(this.labelPane, searchResultPanel);
        this.registerHoverEvent(this.infoPanel, searchResultPanel);
        this.registerHoverEvent(this.titlePane, searchResultPanel);
        this.registerHoverEvent(this.flowPane, searchResultPanel);
        this.registerHoverEvent(this.timeLabel, searchResultPanel);
        this.registerHoverEvent(this.iconPanel, searchResultPanel);
        this.registerHoverEvent(this.sourceLabel, searchResultPanel);
        this.registerHoverEvent(this.headerPanel, searchResultPanel);
        this.registerClickEvent(this.contentPane, this.codeDocOverviewDetail);
        this.registerClickEvent(this.iconLabel, this.codeDocOverviewDetail);
        this.registerClickEvent(this.labelPane, this.codeDocOverviewDetail);
        this.registerClickEvent(this.infoPanel, this.codeDocOverviewDetail);
        this.registerClickEvent(this.titlePane, this.codeDocOverviewDetail);
        this.registerClickEvent(this.flowPane, this.codeDocOverviewDetail);
        this.registerClickEvent(this.timeLabel, this.codeDocOverviewDetail);
        this.registerClickEvent(this.iconPanel, this.codeDocOverviewDetail);
        this.registerClickEvent(this.sourceLabel, this.codeDocOverviewDetail);
        this.registerClickEvent(this.headerPanel, this.codeDocOverviewDetail);
    }

    public void registerHoverEvent(JComponent component, final SearchResultPanel searchResultPanel) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                DocListCell.this.contentPane.setBackground((Color)CosyColor.HOVER_CELL_BG_COLOR);
                DocListCell.this.iconLabel.setBackground((Color)CosyColor.HOVER_CELL_BG_COLOR);
                DocListCell.this.labelPane.setBackground((Color)CosyColor.HOVER_CELL_BG_COLOR);
                DocListCell.this.iconPanel.setBackground((Color)CosyColor.HOVER_CELL_BG_COLOR);
                DocListCell.this.infoPanel.setBackground((Color)CosyColor.HOVER_CELL_BG_COLOR);
                DocListCell.this.titlePane.setBackground((Color)CosyColor.HOVER_CELL_BG_COLOR);
                DocListCell.this.flowPane.setBackground((Color)CosyColor.HOVER_CELL_BG_COLOR);
                DocListCell.this.timeLabel.setBackground((Color)CosyColor.HOVER_CELL_BG_COLOR);
                DocListCell.this.headerPanel.setBackground((Color)CosyColor.HOVER_CELL_BG_COLOR);
                DocListCell.this.sourceLabel.setBackground((Color)CosyColor.HOVER_CELL_BG_COLOR);
                DocListCell.this.descriptionPopup.createPopup(DocListCell.this.contentPane, DocListCell.this.clearDescription(DocListCell.this.codeDocOverviewDetail.getDescription()));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                DocListCell.this.contentPane.setBackground(searchResultPanel.getBasePanel().getBackground());
                DocListCell.this.iconLabel.setBackground(searchResultPanel.getBasePanel().getBackground());
                DocListCell.this.iconPanel.setBackground(searchResultPanel.getBasePanel().getBackground());
                DocListCell.this.labelPane.setBackground(searchResultPanel.getBasePanel().getBackground());
                DocListCell.this.infoPanel.setBackground(searchResultPanel.getBasePanel().getBackground());
                DocListCell.this.titlePane.setBackground(searchResultPanel.getBasePanel().getBackground());
                DocListCell.this.flowPane.setBackground(searchResultPanel.getBasePanel().getBackground());
                DocListCell.this.timeLabel.setBackground(searchResultPanel.getBasePanel().getBackground());
                DocListCell.this.sourceLabel.setBackground(searchResultPanel.getBasePanel().getBackground());
                DocListCell.this.headerPanel.setBackground(searchResultPanel.getBasePanel().getBackground());
                DocListCell.this.descriptionPopup.tryClosePopup(DocListCell.this.contentPane, e.getLocationOnScreen());
            }
        });
    }

    public void registerClickEvent(JComponent component, final CodeDocOverviewDetail codeDocOverviewDetail) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DocListCell.this.descriptionPopup.closePopup();
                CosySetting setting = CosyPersistentSetting.getInstance().getState();
                if (!JBCefApp.isSupported()) {
                    BrowserUtil.browse((String)codeDocOverviewDetail.getLink());
                    ((QaActionNotifier)DocListCell.this.project.getMessageBus().syncPublisher(QaActionNotifier.SEARCH_QA_CLICK)).qaSearchClick(codeDocOverviewDetail, "click_content");
                    return;
                }
                if (DocListCell.this.jbCefBrowser != null && (setting == null || DocumentOpenModeEnum.OPEN_IN_IDEA.equals((Object)setting.getDefaultDocumentOpenMode()))) {
                    ToolWindow toolWindow = ToolWindowManager.getInstance((Project)DocListCell.this.project).getToolWindow("Code Search");
                    if (toolWindow == null) {
                        return;
                    }
                    if (toolWindow.getContentManager().findContent(I18NConstant.MAIN_CONTENT_NAME) != null) {
                        Content content = toolWindow.getContentManager().findContent(I18NConstant.MAIN_CONTENT_NAME);
                        JComponent mainComponent = content.getComponent();
                        BlogContentForm blogContentForm = new BlogContentForm(DocListCell.this.project, codeDocOverviewDetail, mainComponent, DocListCell.this.jbCefBrowser);
                        content.setComponent(blogContentForm.getComponent());
                        toolWindow.getContentManager().setSelectedContent(content);
                    }
                } else {
                    BrowserUtil.browse((String)codeDocOverviewDetail.getLink());
                }
                ((QaActionNotifier)DocListCell.this.project.getMessageBus().syncPublisher(QaActionNotifier.SEARCH_QA_CLICK)).qaSearchClick(codeDocOverviewDetail, "click_content");
            }
        });
    }

    private String clearDescription(String description) {
        return StringCheckUtil.removeMultiSpace(description);
    }

    @Override
    public int getPreferredWidth() {
        return 0;
    }

    @Override
    public int getPreferredHeight() {
        return this.contentPane.getPreferredSize().height;
    }

    @Override
    public Component getComponent() {
        return this.contentPane;
    }

    private void createUIComponents() {
        this.labelPane = new TagListPanel(5);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel;
        JPanel jPanel2;
        JLabel jLabel3;
        JPanel jPanel3;
        TitleTextPane titleTextPane;
        JPanel jPanel4;
        JPanel jPanel5;
        this.createUIComponents();
        this.contentPane = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(12, 10, 8, 10), -1, 12, false, false));
        this.headerPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(10, 0));
        jPanel5.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.titlePane = titleTextPane = new TitleTextPane();
        jPanel4.add((Component)titleTextPane, "Center");
        this.iconPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, "West");
        this.iconLabel = jLabel3 = new JLabel();
        jLabel3.setText("");
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.flowPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        TagListPanel tagListPanel = this.labelPane;
        jPanel2.add((Component)tagListPanel, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.infoPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.sourceLabel = jLabel2 = new JLabel();
        jLabel2.setText("Label");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.timeLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

