/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.form;

import com.alibabacloud.intellij.cosy.core.lsp.model.model.CodeDocOverviewDetail;
import com.alibabacloud.intellij.cosy.search.asyn.JSThreadFactory;
import com.alibabacloud.intellij.cosy.search.ui.ColorProgressBarUI;
import com.alibabacloud.intellij.cosy.search.util.WelcomePanelUtil;
import com.alibabacloud.intellij.cosy.ui.search.I18NConstant;
import com.alibabacloud.intellij.cosy.ui.search.color.CosyColor;
import com.alibabacloud.intellij.cosy.ui.search.enums.SourceEnum;
import com.alibabacloud.intellij.cosy.ui.search.form.BlogErrorForm;
import com.alibabacloud.intellij.cosy.ui.search.topic.QaActionNotifier;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.HtmlPanel;
import icons.CommonIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.ProgressBarUI;
import javax.swing.text.StyleContext;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.cef.network.CefRequest;
import org.jetbrains.annotations.NotNull;

public class BlogContentForm {
    private static final Logger log = Logger.getInstance(BlogContentForm.class);
    private JBCefBrowser myJBrowser;
    private CefLoadHandlerAdapter cefLoadHandlerAdapter;
    private JPanel topPanel;
    private JLabel returnLabel;
    private JLabel browserLabel;
    private JPanel htmlPanel;
    private JPanel basePanel;
    private JProgressBar progressBar;
    private JLabel sourceLabel;
    private JPanel progressPane;
    private static final String COMMON_SCRIPT_PATH = "/js/common.js";
    private static final Map<String, String> sourceProcessScript = new HashMap<String, String>();
    private int loadCount = 0;

    public BlogContentForm(final Project project, CodeDocOverviewDetail codeDocOverviewDetail, final JComponent mainComponent, JBCefBrowser jbcefBrowser) {
        this.$$$setupUI$$$();
        final String url = codeDocOverviewDetail.getLink();
        this.sourceLabel.setText(codeDocOverviewDetail.getSource());
        this.myJBrowser = jbcefBrowser;
        this.myJBrowser.loadURL(codeDocOverviewDetail.getLink());
        this.progressBar.setUI((ProgressBarUI)((Object)new ColorProgressBarUI()));
        Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR);
        if (color == null) {
            this.returnLabel.setIcon(CommonIcons.returnIcon);
        } else {
            this.returnLabel.setIcon(CommonIcons.lightReturnIcon);
        }
        this.returnLabel.setCursor(new Cursor(12));
        this.sourceLabel.setCursor(new Cursor(12));
        this.returnLabel.setOpaque(true);
        this.returnLabel.setBackground(CosyColor.NORMAL_BG_COLOR);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BlogContentForm.this.myJBrowser.loadHTML("");
                ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Code Search");
                if (toolWindow != null) {
                    Content content = toolWindow.getContentManager().findContent(I18NConstant.MAIN_CONTENT_NAME);
                    content.setComponent(mainComponent);
                    toolWindow.getContentManager().setSelectedContent(content);
                }
                BlogContentForm.this.myJBrowser.getJBCefClient().removeLoadHandler((CefLoadHandler)BlogContentForm.this.cefLoadHandlerAdapter, BlogContentForm.this.myJBrowser.getCefBrowser());
                BlogContentForm.this.myJBrowser = null;
            }
        };
        this.returnLabel.addMouseListener(mouseAdapter);
        this.sourceLabel.addMouseListener(mouseAdapter);
        this.browserLabel.setForeground((Color)JBColor.BLUE);
        this.browserLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.browserLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BrowserUtil.browse((String)url);
            }
        });
        this.addBrowserHandle(codeDocOverviewDetail, project);
        this.htmlPanel.add((Component)this.myJBrowser.getComponent(), "Center");
    }

    public void addBrowserHandle(final CodeDocOverviewDetail codeDocOverviewDetail, final Project project) {
        this.cefLoadHandlerAdapter = new CefLoadHandlerAdapter(){

            public void onLoadingStateChange(CefBrowser browser, boolean isLoading, boolean canGoBack, boolean canGoForward) {
            }

            public void onLoadStart(CefBrowser browser, CefFrame frame, CefRequest.TransitionType transitionType) {
                ++BlogContentForm.this.loadCount;
            }

            public void onLoadEnd(CefBrowser browser, CefFrame frame, int httpStatusCode) {
                BlogContentForm.this.progressPane.remove(BlogContentForm.this.progressBar);
                BlogContentForm.this.progressPane.revalidate();
                BlogContentForm.this.progressPane.repaint();
                String scriptPath = sourceProcessScript.get(codeDocOverviewDetail.getSource());
                if (scriptPath != null) {
                    JSThreadFactory.INSTANCE.execute(() -> {
                        try {
                            String fileContent = BlogContentForm.this.buildScript(scriptPath);
                            browser.executeJavaScript(fileContent, browser.getURL(), 0);
                        }
                        catch (IOException e) {
                            log.error("fail to execute script, Cause " + e.getMessage(), (Throwable)e);
                        }
                    });
                }
            }

            public void onLoadError(CefBrowser browser, CefFrame frame, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
                String errorAction = "web_error:" + errorCode.getCode() + "," + errorText;
                if (failedUrl.equals(codeDocOverviewDetail.getLink())) {
                    ((QaActionNotifier)project.getMessageBus().syncPublisher(QaActionNotifier.SEARCH_QA_CLICK)).qaSearchClick(codeDocOverviewDetail, errorAction);
                }
                if (codeDocOverviewDetail.getSnapshot() != null && codeDocOverviewDetail.getSnapshot().booleanValue()) {
                    HtmlPanel snapShotPane = new HtmlPanel(){

                        @NotNull
                        protected String getBody() {
                            String string = codeDocOverviewDetail.getSourceContent();
                            if (string == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return string;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/alibabacloud/intellij/cosy/ui/search/form/BlogContentForm$3$1", "getBody"));
                        }
                    };
                    snapShotPane.setBody(codeDocOverviewDetail.getSourceContent());
                    JBScrollPane jbScrollPane = new JBScrollPane(10);
                    jbScrollPane.setViewportView((Component)snapShotPane);
                    jbScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                    jbScrollPane.setHorizontalScrollBarPolicy(31);
                    jbScrollPane.setVerticalScrollBarPolicy(20);
                    BlogContentForm.this.htmlPanel.removeAll();
                    BlogContentForm.this.htmlPanel.add((Component)jbScrollPane, "Center");
                    BlogContentForm.this.htmlPanel.repaint();
                    BlogContentForm.this.htmlPanel.revalidate();
                    return;
                }
                if (Objects.equals(failedUrl, codeDocOverviewDetail.getLink())) {
                    BlogContentForm.this.htmlPanel.removeAll();
                    BlogContentForm.this.htmlPanel.add((Component)new BlogErrorForm(failedUrl).getComponent(), "Center");
                    BlogContentForm.this.htmlPanel.revalidate();
                    BlogContentForm.this.htmlPanel.repaint();
                }
            }
        };
        this.myJBrowser.getJBCefClient().addLoadHandler((CefLoadHandler)this.cefLoadHandlerAdapter, this.myJBrowser.getCefBrowser());
    }

    private String buildScript(String sourceScript) throws IOException {
        String commmonScriptContent = new String(Objects.requireNonNull(WelcomePanelUtil.class.getResourceAsStream(COMMON_SCRIPT_PATH)).readAllBytes());
        String scriptContent = new String(Objects.requireNonNull(WelcomePanelUtil.class.getResourceAsStream(sourceScript)).readAllBytes());
        StringBuilder sb = new StringBuilder();
        sb.append("var loadCount=").append(this.loadCount).append(";\n");
        sb.append(scriptContent);
        sb.append(commmonScriptContent);
        return sb.toString();
    }

    public JComponent getComponent() {
        return this.basePanel;
    }

    static {
        sourceProcessScript.put(SourceEnum.CSDN.getSource(), "/js/csdn.js");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JProgressBar jProgressBar;
        JPanel jPanel2;
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        JPanel jPanel3;
        JPanel jPanel4;
        this.basePanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        this.topPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(5, 10, 0, 10), -1, 10, false, false));
        jPanel4.add((Component)jPanel3, "North");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(5, -1));
        jPanel3.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.sourceLabel = jLabel3 = new JLabel();
        jLabel3.setText("");
        jPanel5.add((Component)jLabel3, "Center");
        this.returnLabel = jLabel2 = new JLabel();
        Font font = this.$$$getFont$$$(null, 1, -1, jLabel2.getFont());
        if (font != null) {
            jLabel2.setFont(font);
        }
        jLabel2.setHorizontalAlignment(0);
        jLabel2.setText("");
        jPanel5.add((Component)jLabel2, "West");
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.browserLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messageBundle").getString("browser.open.label"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.progressPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.progressBar = jProgressBar = new JProgressBar();
        jProgressBar.setIndeterminate(true);
        jPanel2.add((Component)jProgressBar, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 0, null, null, null));
        this.htmlPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, "Center");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.basePanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        Font font3 = new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
        boolean bl = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font font4 = bl ? new Font(font3.getFamily(), font3.getStyle(), font3.getSize()) : new StyleContext().getFont(font3.getFamily(), font3.getStyle(), font3.getSize());
        return font4 instanceof FontUIResource ? font4 : new FontUIResource(font4);
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

