/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component.markdown;

import com.alibabacloud.intellij.cosy.ui.search.component.RefreshColorComponent;
import com.alibabacloud.intellij.cosy.ui.search.component.markdown.ChatTagsComponent;
import com.alibabacloud.intellij.cosy.ui.search.component.markdown.CodeMarkdownHighlightComponent;
import com.alibabacloud.intellij.cosy.ui.search.component.markdown.MarkdownBlock;
import com.alibabacloud.intellij.cosy.ui.search.component.markdown.MarkdownComponent;
import com.alibabacloud.intellij.cosy.ui.search.component.markdown.TextMarkdownComponent;
import com.alibabacloud.intellij.cosy.ui.search.generate.GenerateAnswerPanel;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatAskTag;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import java.awt.Color;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class MarkdownStreamPanel
extends JPanel
implements RefreshColorComponent {
    private static final String SOFT_PLACEHOLDER = "&[0-9a-z]{2,8};|&#[0-9]{1,7};";
    protected static final Pattern CODE_MATCHER = Pattern.compile("```([\\w#+]*\n*)?(.*?)`{2,3}|`{2,3}([\\w#+]+\n*)?(.*)", 32);
    private final Project project;
    private final JComponent parentComponent;
    private final GenerateAnswerPanel generateAnswerPanel;
    List<MarkdownBlock> blocks;
    List<ChatAskTag> tags;
    ChatTagsComponent tagsComponent;
    private int height;
    private int limitCodeBlockHeight;
    private StringBuilder buffer = new StringBuilder();

    public MarkdownStreamPanel(Project project, JComponent parentComponent, GenerateAnswerPanel generateAnswerPanel) {
        this(project, parentComponent, generateAnswerPanel, 0);
    }

    public MarkdownStreamPanel(Project project, JComponent parentComponent, GenerateAnswerPanel generateAnswerPanel, int limitCodeBlockHeight) {
        this.project = project;
        this.setLayout((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        this.parentComponent = parentComponent;
        this.generateAnswerPanel = generateAnswerPanel;
        this.limitCodeBlockHeight = limitCodeBlockHeight;
    }

    public String getText() {
        StringBuffer stringBuffer = new StringBuffer();
        for (MarkdownBlock block : this.blocks) {
            stringBuffer.append(block.getContent());
        }
        return stringBuffer.toString();
    }

    public synchronized void setTags(List<ChatAskTag> tags) {
        this.tags = tags;
        this.renderComponent();
    }

    public synchronized void append(String markdown) {
        this.buffer.append(markdown);
        List<MarkdownBlock> incrBlocks = this.parseBlock(this.buffer.toString());
        if (incrBlocks.isEmpty()) {
            return;
        }
        if (this.blocks == null || this.blocks.isEmpty()) {
            this.blocks = incrBlocks;
        } else {
            MarkdownBlock newBlock;
            for (int i = 0; i < Math.min(this.blocks.size(), incrBlocks.size()); ++i) {
                MarkdownBlock oldBlock = this.blocks.get(i);
                newBlock = incrBlocks.get(i);
                if (oldBlock.getIdentifier().equals(newBlock.getIdentifier())) continue;
                oldBlock.setNeedUpdate(true);
                oldBlock.update(newBlock.getContent(), newBlock.getLanguage());
            }
            for (int j = i; j < incrBlocks.size(); ++j) {
                newBlock = incrBlocks.get(j);
                newBlock.setNeedUpdate(true);
                this.blocks.add(newBlock);
            }
        }
        this.renderComponent();
    }

    private void renderComponent() {
        this.renderTags();
        if (this.blocks != null && !this.blocks.isEmpty()) {
            if (this.tagsComponent != null) {
                this.tagsComponent.addBottomMargin();
            }
            this.renderBlocks();
        }
        this.revalidate();
    }

    private void renderBlocks() {
        MarkdownBlock lastBlock = null;
        for (int i = 0; i < this.blocks.size(); ++i) {
            MarkdownBlock block = this.blocks.get(i);
            if (block.getComponent() != null && !block.isNeedUpdate()) {
                lastBlock = block;
                continue;
            }
            if (block.getComponent() == null) {
                MarkdownComponent component = null;
                if ("content".equals(block.getType())) {
                    component = new TextMarkdownComponent(this.project, block.getContent(), i, this.blocks.size());
                } else if ("code".equals(block.getType())) {
                    component = new CodeMarkdownHighlightComponent(this.project, block.getContent(), block.getLanguage(), this.parentComponent, this.generateAnswerPanel, this.limitCodeBlockHeight);
                }
                if (component != null) {
                    this.add(component.getComponent());
                    block.setComponent(component);
                    if (lastBlock != null) {
                        if (lastBlock.getComponent() instanceof CodeMarkdownHighlightComponent) {
                            CodeMarkdownHighlightComponent codeComponent = (CodeMarkdownHighlightComponent)lastBlock.getComponent();
                            codeComponent.scrollLeft();
                        } else if (lastBlock.getComponent() instanceof TextMarkdownComponent) {
                            TextMarkdownComponent textComponent = (TextMarkdownComponent)lastBlock.getComponent();
                            textComponent.addBottomMargin();
                        }
                    }
                }
            } else {
                block.getComponent().updateText(block.getContent(), block.getLanguage());
            }
            block.setNeedUpdate(false);
            lastBlock = block;
        }
    }

    private void renderTags() {
        if (this.tags == null || this.tags.isEmpty()) {
            return;
        }
        if (this.tagsComponent == null) {
            this.tagsComponent = new ChatTagsComponent(this.tags);
            this.add(this.tagsComponent.getComponent(), 0);
        }
    }

    private List<MarkdownBlock> parseBlock(String markdown) {
        ArrayList<MarkdownBlock> result = new ArrayList<MarkdownBlock>();
        StringBuilder sb = new StringBuilder();
        Matcher m = CODE_MATCHER.matcher(markdown);
        while (m.find()) {
            MarkdownBlock codeBlock;
            String content = m.group(2);
            String language = m.group(1);
            if (content != null) {
                codeBlock = new MarkdownBlock(content, "code", language);
            } else {
                content = m.group(4);
                language = m.group(3);
                codeBlock = new MarkdownBlock(content, "code", false, language);
            }
            m.appendReplacement(sb, "");
            if (!"".equals(sb.toString().trim())) {
                MarkdownBlock textBlock = new MarkdownBlock(sb.toString(), "content");
                result.add(textBlock);
            }
            result.add(codeBlock);
            sb.setLength(0);
        }
        m.appendTail(sb);
        if (!"".equals(sb.toString().trim())) {
            MarkdownBlock textBlock = new MarkdownBlock(sb.toString(), "content", false);
            result.add(textBlock);
        }
        return result;
    }

    public void enableBottomMarginForText() {
        if (this.blocks == null || this.blocks.isEmpty()) {
            return;
        }
        MarkdownBlock lastBlock = this.blocks.get(this.blocks.size() - 1);
        if (lastBlock.getComponent() instanceof TextMarkdownComponent) {
            TextMarkdownComponent textComponent = (TextMarkdownComponent)lastBlock.getComponent();
            textComponent.addBottomMargin();
        }
    }

    public void clear() {
        if (this.blocks != null && !this.blocks.isEmpty()) {
            this.blocks.clear();
        } else {
            this.blocks = new ArrayList<MarkdownBlock>();
        }
        this.buffer = new StringBuilder();
        this.removeAll();
        this.revalidate();
    }

    @Override
    public void refreshColor(EditorColorsScheme scheme, Color themeColor) {
        for (MarkdownBlock block : this.blocks) {
            MarkdownComponent component;
            if (block.getComponent() == null || !((component = block.getComponent()) instanceof TextMarkdownComponent)) continue;
            ((TextMarkdownComponent)component).refreshColor(scheme, themeColor);
        }
        this.revalidate();
    }
}

