/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component.markdown;

import com.alibabacloud.intellij.cosy.ui.search.component.markdown.MarkdownComponent;
import com.alibabacloud.intellij.cosy.util.Md5Util;
import lombok.Generated;

public class MarkdownBlock {
    public static final String TEXT_BLOCK = "content";
    public static final String CODE_BLOCK = "code";
    private String identifier;
    private String content;
    private String type;
    private String language;
    private boolean completed;
    private MarkdownComponent component;
    private boolean needUpdate = true;

    public MarkdownBlock(String content, String type) {
        this.content = content;
        this.type = type;
        this.completed = true;
        this.identifier = Md5Util.encode(content.getBytes());
    }

    public MarkdownBlock(String content, String type, boolean completed) {
        this.content = content;
        this.type = type;
        this.completed = completed;
        this.identifier = Md5Util.encode(content.getBytes());
    }

    public MarkdownBlock(String content, String type, String language) {
        this.content = content;
        this.type = type;
        this.completed = true;
        this.language = language == null ? null : language.trim();
        this.identifier = Md5Util.encode(content.getBytes());
    }

    public MarkdownBlock(String content, String type, boolean completed, String language) {
        this.content = content;
        this.type = type;
        this.completed = completed;
        this.language = language == null ? null : language.trim();
        this.identifier = Md5Util.encode(content.getBytes());
    }

    public void update(String content, String language) {
        this.content = content;
        this.identifier = Md5Util.encode(content.getBytes());
        this.language = language;
    }

    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getLanguage() {
        return this.language;
    }

    @Generated
    public boolean isCompleted() {
        return this.completed;
    }

    @Generated
    public MarkdownComponent getComponent() {
        return this.component;
    }

    @Generated
    public boolean isNeedUpdate() {
        return this.needUpdate;
    }

    @Generated
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setLanguage(String language) {
        this.language = language;
    }

    @Generated
    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    @Generated
    public void setComponent(MarkdownComponent component) {
        this.component = component;
    }

    @Generated
    public void setNeedUpdate(boolean needUpdate) {
        this.needUpdate = needUpdate;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MarkdownBlock)) {
            return false;
        }
        MarkdownBlock other = (MarkdownBlock)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        if (this.isCompleted() != other.isCompleted()) {
            return false;
        }
        MarkdownComponent this$component = this.getComponent();
        MarkdownComponent other$component = other.getComponent();
        if (this$component == null ? other$component != null : !this$component.equals(other$component)) {
            return false;
        }
        return this.isNeedUpdate() == other.isNeedUpdate();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MarkdownBlock;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        result = result * 59 + (this.isCompleted() ? 79 : 97);
        MarkdownComponent $component = this.getComponent();
        result = result * 59 + ($component == null ? 43 : $component.hashCode());
        result = result * 59 + (this.isNeedUpdate() ? 79 : 97);
        return result;
    }

    @Generated
    public String toString() {
        return "MarkdownBlock(identifier=" + this.getIdentifier() + ", content=" + this.getContent() + ", type=" + this.getType() + ", language=" + this.getLanguage() + ", completed=" + this.isCompleted() + ", component=" + this.getComponent() + ", needUpdate=" + this.isNeedUpdate() + ")";
    }
}

