/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component.markdown;

import com.alibabacloud.intellij.cosy.chat.enums.ChatTaskEnum;
import com.alibabacloud.intellij.cosy.common.CosyCacheKeys;
import com.alibabacloud.intellij.cosy.layout.RightFlowLayout;
import com.alibabacloud.intellij.cosy.search.enums.TrackEventTypeEnum;
import com.alibabacloud.intellij.cosy.service.TelemetryService;
import com.alibabacloud.intellij.cosy.service.model.TextChangeContext;
import com.alibabacloud.intellij.cosy.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.cosy.ui.search.SwingManager;
import com.alibabacloud.intellij.cosy.ui.search.component.CodeTextPane;
import com.alibabacloud.intellij.cosy.ui.search.component.DisplayIcon;
import com.alibabacloud.intellij.cosy.ui.search.component.markdown.Code2HtmlConverter;
import com.alibabacloud.intellij.cosy.ui.search.component.markdown.MarkdownComponent;
import com.alibabacloud.intellij.cosy.ui.search.component.markdown.PrismCode2HtmlConverter;
import com.alibabacloud.intellij.cosy.ui.search.generate.GenerateAnswerPanel;
import com.alibabacloud.intellij.cosy.ui.search.generate.GenerateContentForm;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.model.CodeWithExt;
import com.alibabacloud.intellij.cosy.ui.search.topic.LingmaCodeDiffNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.LingmaCodeNewFileNotifier;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.DocumentUtils;
import com.alibabacloud.intellij.cosy.util.EditorUtil;
import com.alibabacloud.intellij.cosy.util.LanguageUtil;
import com.alibabacloud.intellij.cosy.util.StringUtils;
import com.alibabacloud.intellij.cosy.util.SwingUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import icons.LingmaIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import lombok.Generated;

public class CodeMarkdownHighlightComponent
implements MarkdownComponent {
    public static final String CODE_PANE_PROPERTIES_KEY = "codePane";
    private static final int HGAP = 24;
    private static final int TOOLBAR_HEIGHT = 32;
    private static final int SCROLL_HEIGHT_PADDING = 4;
    private Project project;
    private String chatTask;
    private String requestId;
    private String sessionId;
    private CodeTextPane editorTextField;
    JScrollPane jbScrollPane;
    private JComponent parentComponent;
    private GenerateAnswerPanel generateAnswerPanel;
    private JPanel basePane;
    private JLayeredPane layeredPane;
    private ToolbarPane fixedToolbarPane;
    private ToolbarPane floatToolbarPane;
    private boolean showFloatToolbar;
    Dimension parentComponentSize;
    private static Code2HtmlConverter converter = new PrismCode2HtmlConverter();
    private static Set<String> DIFF_TASK_SET = new HashSet<String>(){
        {
            this.add(ChatTaskEnum.CODE_GENERATE_COMMENT.getName());
            this.add(ChatTaskEnum.OPTIMIZE_CODE.getName());
        }
    };
    private int limitCodeBlockHeight = 0;

    public CodeMarkdownHighlightComponent(Project project, String content, String language, JComponent parentComponent, GenerateAnswerPanel generateAnswerPanel) {
        this(project, content, language, parentComponent, generateAnswerPanel, 0);
    }

    public CodeMarkdownHighlightComponent(Project project, String content, String language, final JComponent parentComponent, GenerateAnswerPanel generateAnswerPanel, final int limitCodeBlockHeight) {
        this.project = project;
        this.parentComponent = parentComponent;
        this.generateAnswerPanel = generateAnswerPanel;
        this.chatTask = this.generateAnswerPanel == null ? null : this.generateAnswerPanel.getChatTask();
        this.requestId = this.generateAnswerPanel == null ? null : this.generateAnswerPanel.getRequestId();
        this.sessionId = this.generateAnswerPanel == null ? null : this.generateAnswerPanel.getSessionId();
        this.basePane = new JPanel(new BorderLayout());
        this.layeredPane = new JLayeredPane();
        this.limitCodeBlockHeight = limitCodeBlockHeight;
        this.editorTextField = new CodeTextPane(project, content, language, this.chatTask, this.requestId, this.sessionId);
        this.basePane.putClientProperty(CODE_PANE_PROPERTIES_KEY, true);
        this.parentComponentSize = parentComponent.getSize();
        this.jbScrollPane = new JBScrollPane(10){

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                Dimension parentSize = parentComponent.getSize();
                int height = size.height + 4;
                if (limitCodeBlockHeight > 0 && height > limitCodeBlockHeight) {
                    height = limitCodeBlockHeight;
                }
                return new Dimension(parentSize.width - 24, height);
            }
        };
        this.jbScrollPane.setViewportView(this.editorTextField);
        this.jbScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jbScrollPane.setHorizontalScrollBarPolicy(30);
        Dimension editSize = this.editorTextField.getPreferredSize();
        if (limitCodeBlockHeight > 0 && editSize.height > limitCodeBlockHeight) {
            this.jbScrollPane.setVerticalScrollBarPolicy(20);
        } else {
            this.jbScrollPane.setVerticalScrollBarPolicy(21);
        }
        this.editorTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    CodeMarkdownHighlightComponent.this.editorTextField.copy();
                    NotificationFactory.showToast((JComponent)CodeMarkdownHighlightComponent.this.editorTextField, LingmaIcons.AcceptIcon, CosyBundle.message("notifications.code.btn.copied", new Object[0]));
                }
            }
        });
        this.layeredPane.add((Component)this.jbScrollPane, JLayeredPane.DEFAULT_LAYER);
        if (generateAnswerPanel != null) {
            this.initToolbar(language);
            this.initFloatToolbar(language);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)content)) {
            this.updateText(content, language);
        }
        this.basePane.add((Component)this.layeredPane, "Center");
        SwingUtil.setComponentBackgroudColor(this.basePane, ColorUtil.getEditorBackgroundColor(), new Class[0]);
        this.basePane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                CodeMarkdownHighlightComponent.this.updateLayerLocation();
                CodeMarkdownHighlightComponent.this.basePane.revalidate();
                CodeMarkdownHighlightComponent.this.basePane.repaint();
            }
        });
    }

    private void initFloatToolbar(String language) {
        this.floatToolbarPane = new ToolbarPane(this.project, language, this.generateAnswerPanel == null ? null : this.generateAnswerPanel.getGenerateContentForm().getQuestionCodeWithExt(), this.chatTask);
        SwingUtil.setComponentBackgroudColor(this.floatToolbarPane.getToolbarPane(), ColorUtil.getEditorBackgroundColor(), new Class[0]);
        this.editorTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                CodeMarkdownHighlightComponent.this.showFloatToolbar(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Rectangle rectangle;
                if (CodeMarkdownHighlightComponent.this.showFloatToolbar && !(rectangle = new Rectangle(CodeMarkdownHighlightComponent.this.floatToolbarPane.getToolbarPane().getLocationOnScreen(), CodeMarkdownHighlightComponent.this.floatToolbarPane.getToolbarPane().getSize())).contains(e.getLocationOnScreen())) {
                    CodeMarkdownHighlightComponent.this.hideFloatToolbar();
                }
            }
        });
        JBScrollPane scrollPane = (JBScrollPane)SwingManager.INSTANCE.getComponent(this.project, "CHAT_MAIN_VERTICAL_SCROLLBAR_KEY");
        scrollPane.addMouseWheelListener(e -> {
            if (this.showFloatToolbar) {
                if (!this.editorTextField.isShowing() || !this.isShowFloatToolbar(e, scrollPane)) {
                    this.hideFloatToolbar();
                } else {
                    Dimension size = this.fixedToolbarPane.getToolbarPane().getSize();
                    this.floatToolbarPane.getToolbarPane().setBounds(0, scrollPane.getLocationOnScreen().y - this.editorTextField.getLocationOnScreen().y, size.width, size.height);
                    this.layeredPane.revalidate();
                    this.layeredPane.repaint();
                }
            } else {
                this.showFloatToolbar(e);
            }
        });
    }

    private void hideFloatToolbar() {
        if (!this.showFloatToolbar) {
            return;
        }
        this.layeredPane.remove(this.floatToolbarPane.getToolbarPane());
        this.layeredPane.revalidate();
        this.layeredPane.repaint();
        this.showFloatToolbar = false;
    }

    private void showFloatToolbar(MouseEvent e) {
        if (this.showFloatToolbar || !this.editorTextField.isShowing()) {
            return;
        }
        JBScrollPane scrollPane = (JBScrollPane)SwingManager.INSTANCE.getComponent(this.project, "CHAT_MAIN_VERTICAL_SCROLLBAR_KEY");
        if (!this.isShowFloatToolbar(e, scrollPane)) {
            return;
        }
        this.showFloatToolbar = true;
        this.layeredPane.add((Component)this.floatToolbarPane.getToolbarPane(), JLayeredPane.POPUP_LAYER);
        Dimension size = this.fixedToolbarPane.getToolbarPane().getSize();
        this.floatToolbarPane.getToolbarPane().setBounds(0, scrollPane.getLocationOnScreen().y - this.editorTextField.getLocationOnScreen().y, size.width, size.height);
        this.layeredPane.revalidate();
        this.layeredPane.repaint();
    }

    private boolean isShowFloatToolbar(MouseEvent e, JBScrollPane scrollPane) {
        if (this.editorTextField.getLocationOnScreen().y - scrollPane.getLocationOnScreen().y > -2 || this.editorTextField.getLocationOnScreen().y + this.editorTextField.getHeight() - scrollPane.getLocationOnScreen().y < 0) {
            return false;
        }
        Dimension editorDimensions = this.editorTextField.getSize();
        Dimension size = new Dimension(editorDimensions.width, editorDimensions.height - scrollPane.getLocationOnScreen().y + this.editorTextField.getLocationOnScreen().y);
        Rectangle rectangle = new Rectangle(scrollPane.getLocationOnScreen(), size);
        return rectangle.contains(e.getLocationOnScreen());
    }

    private void initToolbar(String language) {
        this.fixedToolbarPane = new ToolbarPane(this.project, language, this.generateAnswerPanel == null ? null : this.generateAnswerPanel.getGenerateContentForm().getQuestionCodeWithExt(), this.chatTask);
        this.basePane.add((Component)this.fixedToolbarPane.toolbarPane, "North");
        this.fixedToolbarPane.toolbarPane.setVisible(false);
    }

    private boolean needTestcaseNewFileButton() {
        if (this.generateAnswerPanel == null || this.generateAnswerPanel.getGenerateContentForm() == null) {
            return false;
        }
        GenerateContentForm form = this.generateAnswerPanel.getGenerateContentForm();
        return form.isFirstRoundChatProcessing() && ChatTaskEnum.GENERATE_TESTCASE.getName().equals(form.getFirstRoundTask());
    }

    private boolean needDiffButton() {
        if (this.generateAnswerPanel == null || this.generateAnswerPanel.getGenerateContentForm() == null) {
            return false;
        }
        GenerateContentForm form = this.generateAnswerPanel.getGenerateContentForm();
        return form.isFirstRoundChatProcessing() && DIFF_TASK_SET.contains(form.getFirstRoundTask());
    }

    private boolean needFullLineInsert() {
        return this.isCommentGenerate();
    }

    private boolean isCommentGenerate() {
        if (this.generateAnswerPanel == null || this.generateAnswerPanel.getGenerateContentForm() == null) {
            return false;
        }
        GenerateContentForm form = this.generateAnswerPanel.getGenerateContentForm();
        return ChatTaskEnum.CODE_GENERATE_COMMENT.getName().equals(form.getFirstRoundTask());
    }

    @Override
    public void updateText(String text, String language) {
        if (this.fixedToolbarPane != null) {
            if (this.fixedToolbarPane.langLabel != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)language)) {
                this.fixedToolbarPane.updateLanguage(language);
            }
            if (this.fixedToolbarPane.toolbarPane != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)text)) {
                this.fixedToolbarPane.toolbarPane.setVisible(true);
            }
        }
        if (this.floatToolbarPane != null && this.floatToolbarPane.langLabel != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)language)) {
            this.floatToolbarPane.updateLanguage(language);
        }
        this.editorTextField.setLanguage(language);
        this.editorTextField.setText(text);
        Dimension parentSize = this.parentComponentSize;
        Dimension editSize = this.editorTextField.getPreferredSize();
        this.editorTextField.setSize(editSize);
        int height = editSize.height + 4;
        if (this.limitCodeBlockHeight > 0 && height > this.limitCodeBlockHeight) {
            height = this.limitCodeBlockHeight;
            this.jbScrollPane.setVerticalScrollBarPolicy(20);
        }
        this.jbScrollPane.setPreferredSize(new Dimension(parentSize.width - 24, height));
        this.layeredPane.setPreferredSize(new Dimension(parentSize.width - 24, height));
        this.jbScrollPane.setBounds(0, 0, parentSize.width - 24, height);
        this.layeredPane.revalidate();
    }

    private void updateLayerLocation() {
        Dimension parentSize;
        Dimension editSize = this.editorTextField.getPreferredSize();
        this.parentComponentSize = parentSize = this.parentComponent.getSize();
        int height = editSize.height + 4;
        if (this.limitCodeBlockHeight > 0 && height > this.limitCodeBlockHeight) {
            height = this.limitCodeBlockHeight;
            this.jbScrollPane.setVerticalScrollBarPolicy(20);
        }
        this.jbScrollPane.setBounds(0, 0, parentSize.width - 24, height);
    }

    public void scrollLeft() {
        SwingUtilities.invokeLater(() -> this.jbScrollPane.getHorizontalScrollBar().setValue(0));
    }

    @Override
    public Component getComponent() {
        return this.basePane;
    }

    class ToolbarPane {
        private JPanel toolbarPane;
        private JLabel langLabel;
        private Boolean isTestcase;
        private String chatTask;
        private String language;
        private CodeWithExt questionWithExt;

        public ToolbarPane(final Project project, String language, final CodeWithExt questionWithExt, final String chatTask) {
            this.language = language;
            this.chatTask = chatTask;
            this.toolbarPane = new JPanel();
            this.toolbarPane.setBackground(CodeMarkdownHighlightComponent.this.editorTextField.getBackground());
            this.toolbarPane.setBorder((Border)JBUI.Borders.empty((int)0, (int)12));
            this.toolbarPane.setLayout(new BorderLayout());
            this.toolbarPane.setPreferredSize(new Dimension(-1, 32));
            Color toolWindowBackground = ColorUtil.getToolWindowBackgroundColor();
            JPanel toolbarBasePane = new JPanel();
            toolbarBasePane.setBorder(JBUI.Borders.customLine((Color)toolWindowBackground, (int)0, (int)0, (int)2, (int)0));
            toolbarBasePane.setLayout(new BorderLayout());
            this.toolbarPane.add((Component)toolbarBasePane, "Center");
            this.langLabel = new JLabel(StringUtils.upperFirstLetter(language));
            this.langLabel.setFont(this.langLabel.getFont().deriveFont(14.0f));
            toolbarBasePane.add((Component)this.langLabel, "West");
            JPanel actionPane = new JPanel();
            actionPane.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
            actionPane.setLayout(new RightFlowLayout(2, 16, 0));
            DisplayIcon insertLabel = new DisplayIcon(LingmaIcons.InsertBlueIcon);
            insertLabel.setToolTipText(CosyBundle.message("markdown.code.toolbar.insert", new Object[0]));
            insertLabel.setFont(insertLabel.getFont().deriveFont(14.0f));
            insertLabel.setCursor(Cursor.getPredefinedCursor(12));
            insertLabel.setForeground(ColorUtil.getLinkForegroundColor());
            insertLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    TelemetryService.getInstance().telemetryChatCodeAccept(project, TrackEventTypeEnum.CHAT_CODE_INSERT, CodeMarkdownHighlightComponent.this.requestId, CodeMarkdownHighlightComponent.this.sessionId, chatTask, CodeMarkdownHighlightComponent.this.editorTextField.getText());
                    WriteCommandAction.runWriteCommandAction((Project)project, (String)"Chat Insert Code", (String)"TONGYI", () -> {
                        Editor editor;
                        String text = CodeMarkdownHighlightComponent.this.editorTextField.getText();
                        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)text) && (editor = EditorUtil.getSelectedEditorSafely(project)) != null && editor.getDocument().isWritable()) {
                            int start = editor.getSelectionModel().getSelectionStart();
                            int end = editor.getSelectionModel().getSelectionEnd();
                            Integer startLineNumber = null;
                            if (editor.getSelectionModel().hasSelection() && start < end) {
                                if (CodeMarkdownHighlightComponent.this.needFullLineInsert()) {
                                    VisualPosition visualStartPosition = editor.getSelectionModel().getSelectionStartPosition();
                                    VisualPosition visualEndPosition = editor.getSelectionModel().getSelectionEndPosition();
                                    if (visualStartPosition != null && visualEndPosition != null) {
                                        start = editor.getDocument().getLineStartOffset(editor.visualToLogicalPosition((VisualPosition)visualStartPosition).line);
                                        end = editor.getDocument().getLineEndOffset(editor.visualToLogicalPosition((VisualPosition)visualEndPosition).line);
                                    }
                                    String textToReplace = editor.getDocument().getText(new TextRange(start, end));
                                    text = StringUtils.makeIndentationConsistent(textToReplace, text);
                                }
                                startLineNumber = editor.getDocument().getLineNumber(start);
                                text = DocumentUtils.filterDocumentSlashR(editor.getDocument(), text);
                                editor.getDocument().replaceString(start, end, (CharSequence)text);
                            } else {
                                int caret = editor.getCaretModel().getOffset();
                                startLineNumber = editor.getDocument().getLineNumber(caret);
                                text = DocumentUtils.filterDocumentSlashR(editor.getDocument(), text);
                                editor.getDocument().insertString(caret, (CharSequence)text);
                            }
                            String filePath = EditorUtil.getEditorFilePath(editor);
                            TelemetryService.getInstance().telemetryTextChange(new TextChangeContext(editor.getProject(), filePath, text, startLineNumber, true, LanguageUtil.getLanguageByFilePath(filePath), "chat"));
                        }
                    }, (PsiFile[])new PsiFile[0]);
                }
            });
            actionPane.add(insertLabel);
            final DisplayIcon copyLabel = new DisplayIcon(LingmaIcons.CopyBlueIcon);
            copyLabel.setToolTipText(CosyBundle.message("markdown.code.toolbar.copy", new Object[0]));
            copyLabel.setFont(copyLabel.getFont().deriveFont(14.0f));
            copyLabel.setForeground(ColorUtil.getLinkForegroundColor());
            copyLabel.setCursor(Cursor.getPredefinedCursor(12));
            copyLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    TelemetryService.getInstance().telemetryChatCodeAccept(project, TrackEventTypeEnum.CHAT_CODE_COPY, CodeMarkdownHighlightComponent.this.requestId, CodeMarkdownHighlightComponent.this.sessionId, chatTask, CodeMarkdownHighlightComponent.this.editorTextField.getText());
                    StringSelection selection = new StringSelection(CodeMarkdownHighlightComponent.this.editorTextField.getText());
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(selection, selection);
                    NotificationFactory.showToast((JComponent)copyLabel, LingmaIcons.AcceptIcon, CosyBundle.message("notifications.code.btn.copied", new Object[0]));
                    CosyCacheKeys.KEY_COPY_PASTE.set((UserDataHolder)ApplicationManager.getApplication(), (Object)CodeMarkdownHighlightComponent.this.editorTextField.getText());
                }
            });
            actionPane.add(copyLabel);
            this.questionWithExt = questionWithExt;
            if (CodeMarkdownHighlightComponent.this.needDiffButton()) {
                DisplayIcon diffLabel = new DisplayIcon(LingmaIcons.DiffBlueIcon);
                diffLabel.setToolTipText(CosyBundle.message("markdown.code.toolbar.diff", new Object[0]));
                diffLabel.setFont(diffLabel.getFont().deriveFont(14.0f));
                diffLabel.setCursor(Cursor.getPredefinedCursor(12));
                diffLabel.setForeground(ColorUtil.getLinkForegroundColor());
                diffLabel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        TelemetryService.getInstance().telemetryChatCodeAccept(project, TrackEventTypeEnum.CHAT_CODE_DIFF, CodeMarkdownHighlightComponent.this.requestId, CodeMarkdownHighlightComponent.this.sessionId, chatTask, CodeMarkdownHighlightComponent.this.editorTextField.getText());
                        ((LingmaCodeDiffNotifier)project.getMessageBus().syncPublisher(LingmaCodeDiffNotifier.LINGMA_CODE_DIFF)).codeDiff(CodeMarkdownHighlightComponent.this.editorTextField.getText(), ToolbarPane.this.language, questionWithExt);
                    }
                });
                actionPane.add(diffLabel);
            }
            DisplayIcon newLabel = new DisplayIcon(LingmaIcons.NewBlueIcon);
            newLabel.setToolTipText(CosyBundle.message("markdown.code.toolbar.newFile", new Object[0]));
            newLabel.setFont(newLabel.getFont().deriveFont(14.0f));
            newLabel.setCursor(Cursor.getPredefinedCursor(12));
            newLabel.setForeground(ColorUtil.getLinkForegroundColor());
            this.isTestcase = CodeMarkdownHighlightComponent.this.needTestcaseNewFileButton();
            newLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    TelemetryService.getInstance().telemetryChatCodeAccept(project, TrackEventTypeEnum.CHAT_CODE_NEWFILE, CodeMarkdownHighlightComponent.this.requestId, CodeMarkdownHighlightComponent.this.sessionId, chatTask, CodeMarkdownHighlightComponent.this.editorTextField.getText());
                    TelemetryService.getInstance().telemetryTextChange(new TextChangeContext(project, null, CodeMarkdownHighlightComponent.this.editorTextField.getText(), 0, true, ToolbarPane.this.language, "chat"));
                    ((LingmaCodeNewFileNotifier)project.getMessageBus().syncPublisher(LingmaCodeNewFileNotifier.LINGMA_CODE_NEW_FILE)).newFile(CodeMarkdownHighlightComponent.this.editorTextField.getText(), ToolbarPane.this.language, questionWithExt, ToolbarPane.this.isTestcase);
                }
            });
            actionPane.add(newLabel);
            toolbarBasePane.add((Component)actionPane, "East");
        }

        public void updateLanguage(String language) {
            this.language = language;
            this.langLabel.setText(StringUtils.upperFirstLetter(language));
        }

        @Generated
        public JPanel getToolbarPane() {
            return this.toolbarPane;
        }

        @Generated
        public JLabel getLangLabel() {
            return this.langLabel;
        }

        @Generated
        public Boolean getIsTestcase() {
            return this.isTestcase;
        }

        @Generated
        public String getChatTask() {
            return this.chatTask;
        }

        @Generated
        public String getLanguage() {
            return this.language;
        }

        @Generated
        public CodeWithExt getQuestionWithExt() {
            return this.questionWithExt;
        }
    }
}

