/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component.inputfield;

import com.alibabacloud.intellij.cosy.search.enums.SearchActionTypeEnum;
import com.alibabacloud.intellij.cosy.search.enums.SearchValueTypeEnum;
import com.alibabacloud.intellij.cosy.search.result.SearchContext;
import com.alibabacloud.intellij.cosy.search.result.SearchValue;
import com.alibabacloud.intellij.cosy.ui.search.enums.OperationEnum;
import com.alibabacloud.intellij.cosy.ui.search.topic.AnySearchNotifier;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class SearchKeyword
extends JPanel {
    private static final int CORNER_RADIUS = 5;
    private JLabel conditionDescriptionLabel;
    private JLabel closeLabel;
    private static final JBColor BG_NLP_LABEL_COLOR = new JBColor(new Color(0xEBEBEB), new Color(868927688, true));
    private static final JBColor BG_API_LABEL_COLOR = new JBColor(new Color(11656183), new Color(1280344727, true));
    private static final JBColor TEXT_NLP_LABEL_COLOR = new JBColor(new Color(0x575757), new Color(13487823));
    private static final JBColor TEXT_API_LABEL_COLOR = new JBColor(new Color(746913), new Color(7254734));
    private SearchValue searchValue;
    private int index;

    private void initialize(SearchValue searchValue) {
        this.closeLabel = new CloseLinkLabel(searchValue.getType());
        this.closeLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)3));
        this.conditionDescriptionLabel = new JLabel();
        this.conditionDescriptionLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)5, (int)0, (int)4));
        this.setLayout(new BorderLayout());
        this.add((Component)this.conditionDescriptionLabel, "Center");
        this.add((Component)this.closeLabel, "East");
        this.setOpaque(true);
        if (SearchValueTypeEnum.NLP.getType().equals(searchValue.getType())) {
            this.setBackground((Color)BG_NLP_LABEL_COLOR);
        } else {
            this.setBackground((Color)BG_API_LABEL_COLOR);
        }
        if (SearchValueTypeEnum.NLP.getType().equals(searchValue.getType())) {
            this.conditionDescriptionLabel.setForeground((Color)TEXT_NLP_LABEL_COLOR);
            this.closeLabel.setForeground((Color)TEXT_NLP_LABEL_COLOR);
        } else {
            this.conditionDescriptionLabel.setForeground((Color)TEXT_API_LABEL_COLOR);
            this.closeLabel.setForeground((Color)TEXT_API_LABEL_COLOR);
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Component component = e.getComponent();
                if (!component.hasFocus()) {
                    component.requestFocusInWindow();
                }
                component.setCursor(Cursor.getPredefinedCursor(12));
            }
        });
    }

    public SearchKeyword(final SearchValue searchValue, final Project paramProject) {
        this.initialize(searchValue);
        this.searchValue = searchValue;
        if (searchValue.getNiceName().length() > 45) {
            this.conditionDescriptionLabel.setText(searchValue.getNiceName().substring(0, 45) + "...");
        } else {
            this.conditionDescriptionLabel.setText(searchValue.getNiceName());
        }
        this.conditionDescriptionLabel.setToolTipText(searchValue.getPack());
        this.closeLabel.setCursor(new Cursor(12));
        this.closeLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SearchContext context = new SearchContext(OperationEnum.DELETE.text, SearchActionTypeEnum.DELETE_LABEL_TRIGGER.getType());
                ((AnySearchNotifier)paramProject.getMessageBus().syncPublisher(AnySearchNotifier.ANY_SEARCH_NOTIFICATION)).anySearch(context, searchValue);
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension((int)dimension.getWidth(), 31);
    }

    public SearchValue getSearchValue() {
        return this.searchValue;
    }

    public void addContentMouseListener(MouseListener listener) {
        this.conditionDescriptionLabel.addMouseListener(listener);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Dimension arcs = new Dimension(5, 5);
        int width = this.getWidth();
        int height = this.getHeight();
        Graphics2D graphics = (Graphics2D)g;
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setPaint(this.getBackground());
        graphics.fillRoundRect(0, 0, width - 1, height - 1, arcs.width, arcs.height);
        this.paintChildren(graphics);
        graphics.dispose();
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    static class CloseLinkLabel
    extends JLabel {
        private static final JBColor SPLIT_NLP_COLOR = new JBColor(new Color(0xDBDBDB), new Color(2830388));
        private static final JBColor SPLIT_API_COLOR = new JBColor(new Color(11, 101, 161, 51), new Color(2830388));
        String type;

        public CloseLinkLabel(String type) {
            this.type = type;
        }

        @Override
        public Dimension getPreferredSize() {
            Container parent = SwingUtilities.getUnwrappedParent(this);
            Dimension size = parent.getSize();
            return new Dimension(size.height - 4, size.height);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            int height = 31;
            int lineHeight = (int)((double)height * 0.2);
            Graphics2D g2 = (Graphics2D)g;
            if (SearchValueTypeEnum.NLP.getType().equals(this.type)) {
                g2.setColor((Color)SPLIT_NLP_COLOR);
            } else {
                g2.setColor((Color)SPLIT_API_COLOR);
            }
            g2.setStroke(new BasicStroke(2.0f));
            g2.drawLine(0, lineHeight, 0, height - lineHeight);
            g2.setColor(this.getForeground());
            Dimension size = this.getPreferredSize();
            int width = size.width;
            int iconWidth = width / 3;
            int x = (width - iconWidth) / 2;
            int y = (size.height - iconWidth) / 2;
            g2.drawLine(x, y, x + iconWidth, y + iconWidth);
            g2.drawLine(x + iconWidth, y, x, y + iconWidth);
            g2.dispose();
        }
    }
}

