/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component.chat;

import com.alibabacloud.intellij.cosy.core.lsp.model.model.ChatStep;
import com.alibabacloud.intellij.cosy.ui.search.component.chat.ChatReferenceParser;
import com.alibabacloud.intellij.cosy.ui.search.component.chat.ChatStageContext;
import com.alibabacloud.intellij.cosy.ui.search.component.chat.ChatStageItem;
import com.alibabacloud.intellij.cosy.ui.search.component.chat.ChatStageParser;
import com.alibabacloud.intellij.cosy.ui.search.enums.ChatStepEnum;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.util.ui.JBUI;
import java.awt.LayoutManager;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.border.Border;
import lombok.Generated;

public class ChatStagePanel
extends JPanel {
    private static final int VERTICAL_GAP = 12;
    static Map<String, ChatStageParser> resultParsers = Map.of(ChatStepEnum.DETERMINING_CODEBASE.getKey(), new ChatReferenceParser());
    LinkedHashMap<String, ChatStageItem> stageItems = new LinkedHashMap();
    Project project;
    ChatStageContext context;

    public ChatStagePanel(Project project) {
        this.project = project;
        this.context = new ChatStageContext(project);
        this.setBorder((Border)JBUI.Borders.empty((int)0, (int)12));
        this.setLayout((LayoutManager)new VerticalFlowLayout(0, 0, 12, true, false));
        this.setBackground(ColorUtil.getChatCardChildBackgroundColor());
    }

    public void addOrUpdateStep(ChatStep stepItem) {
        ChatStageItem item = this.stageItems.get(stepItem.getStep());
        if (item == null) {
            item = new ChatStageItem(stepItem);
            this.stageItems.put(stepItem.getStep(), item);
            this.add(item);
        } else {
            item.setItem(stepItem);
        }
        ChatStageParser parser = resultParsers.get(stepItem.getStep());
        if (parser != null) {
            parser.parse(this.context, stepItem);
        }
    }

    @Generated
    public ChatStageContext getContext() {
        return this.context;
    }
}

