/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component.chat;

import com.alibabacloud.intellij.cosy.core.lsp.model.model.ChatStep;
import com.alibabacloud.intellij.cosy.ui.search.enums.ChatStepStatusEnum;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import icons.LingmaIcons;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ChatStageItem
extends JPanel {
    private static final int MARGIN = 8;
    ChatStep stepItem;
    JLabel textLabel;
    JLabel statusLabel;
    private static final int COSY_GENERATE_TIMEOUT = 20;
    private static final ScheduledExecutorService SCHEDULED_EXECUTOR = Executors.newSingleThreadScheduledExecutor();

    public ChatStageItem(ChatStep stepItem) {
        this.stepItem = stepItem;
        this.setup();
    }

    public void setup() {
        this.textLabel = new JLabel(this.stepItem.getDescription());
        this.textLabel.setFont(this.textLabel.getFont().deriveFont(13.0f));
        this.statusLabel = new JLabel();
        this.setItem(this.stepItem);
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.statusLabel);
        this.add(Box.createHorizontalStrut(8));
        this.add(this.textLabel);
        this.setBackground(ColorUtil.getChatCardChildBackgroundColor());
    }

    public void setItem(ChatStep stepItem) {
        this.stepItem = stepItem;
        if (ChatStepStatusEnum.DOING.getKey().equals(stepItem.getStatus())) {
            this.statusLabel.setIcon(LingmaIcons.StatusBarLoadingIcon);
            this.scheduleStepTimeout(this.statusLabel);
        } else if (ChatStepStatusEnum.DONE.getKey().equals(stepItem.getStatus())) {
            this.statusLabel.setIcon(LingmaIcons.SuccessGreenIcon);
        } else if (ChatStepStatusEnum.ERROR.getKey().equals(stepItem.getStatus())) {
            this.statusLabel.setIcon(LingmaIcons.ErrorRedIcon);
        }
    }

    private void scheduleStepTimeout(JLabel statusLabel) {
        SCHEDULED_EXECUTOR.schedule(() -> {
            if (statusLabel != null && LingmaIcons.StatusBarLoadingIcon.equals(statusLabel.getIcon())) {
                statusLabel.setIcon(LingmaIcons.ErrorRedIcon);
            }
        }, 20L, TimeUnit.SECONDS);
    }
}

