/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component.chat;

import com.alibabacloud.intellij.cosy.chat.model.LineRange;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatReferenceItem;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.EditorUtil;
import com.alibabacloud.intellij.cosy.util.FontUtil;
import com.alibabacloud.intellij.cosy.util.ProjectUtils;
import com.alibabacloud.intellij.cosy.util.StringUtils;
import com.alibabacloud.intellij.cosy.util.SwingUtil;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import icons.LingmaIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;

public class ChatReferencePanel
extends JPanel {
    private static final int MAX_DISPLAY_LIST_HEIGHT = 250;
    private static final int MAX_FILE_NAME_LENGTH = 25;
    private JPanel headerPanel;
    private JLabel titleLabel;
    private JPanel contentPanel;
    private JList<ChatReferenceItem> list;
    private JBScrollPane jbScrollPane;
    private Project project;

    public ChatReferencePanel(final Project project, ListModel<ChatReferenceItem> referenceItems) {
        super(new BorderLayout());
        this.project = project;
        this.headerPanel = new JPanel(new BorderLayout());
        this.headerPanel.setOpaque(false);
        this.titleLabel = new JLabel(CosyBundle.message("chat.workspace.used.reference.text", new Object[0]) + " \u00b7 " + referenceItems.getSize(), LingmaIcons.ArrowrightEmptyGreyIcon, 2);
        this.titleLabel.setHorizontalTextPosition(2);
        this.titleLabel.setIconTextGap(4);
        this.titleLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)12));
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(12.0f));
        this.titleLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
        this.headerPanel.add((Component)this.titleLabel, "West");
        this.headerPanel.setBorder((Border)JBUI.Borders.emptyBottom((int)8));
        this.add((Component)this.headerPanel, "North");
        this.titleLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.titleLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ChatReferencePanel.this.contentPanel.isVisible()) {
                    ChatReferencePanel.this.contentPanel.setVisible(false);
                    ChatReferencePanel.this.titleLabel.setIcon(LingmaIcons.ArrowrightEmptyGreyIcon);
                } else {
                    ChatReferencePanel.this.contentPanel.setVisible(true);
                    ChatReferencePanel.this.titleLabel.setIcon(LingmaIcons.ArrowdownEmptyGreyIcon);
                }
            }
        });
        this.contentPanel = new JPanel(new BorderLayout());
        this.contentPanel.setBorder((Border)JBUI.Borders.emptyBottom((int)8));
        this.add((Component)this.contentPanel, "Center");
        this.contentPanel.setBackground(ColorUtil.getEditorBackgroundColor());
        this.contentPanel.setVisible(false);
        this.list = new JBList();
        this.list.setBorder((Border)JBUI.Borders.empty());
        this.list.setModel(referenceItems);
        final ChartReferenceItemPanel itemPanel = new ChartReferenceItemPanel(project);
        this.list.setCellRenderer(new ListCellRenderer<ChatReferenceItem>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends ChatReferenceItem> list, ChatReferenceItem value, int index, boolean isSelected, boolean cellHasFocus) {
                itemPanel.setData(list, value, isSelected);
                return itemPanel;
            }
        });
        this.list.setBackground(ColorUtil.getEditorBackgroundColor());
        this.list.setBorder((Border)JBUI.Borders.empty((int)8, (int)0));
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ChatReferenceItem item = ChatReferencePanel.this.list.getSelectedValue();
                if (item != null) {
                    EditorUtil.openEditorFile(project, item.getFilePath(), new LineRange(item.getStartLine(), item.getEndLine()), ChatReferencePanel.this.list);
                }
            }
        });
        this.jbScrollPane = new JBScrollPane(){

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                if (size.height > 250) {
                    size.height = 250;
                }
                return size;
            }
        };
        this.jbScrollPane.setViewportView(this.list);
        this.jbScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jbScrollPane.setHorizontalScrollBarPolicy(31);
        this.jbScrollPane.setVerticalScrollBarPolicy(20);
        this.contentPanel.add((Component)this.jbScrollPane, "Center");
        SwingUtil.foreachChildComponent(this, cp -> {
            if (cp instanceof JPanel) {
                cp.setBackground(ColorUtil.getChatCardChildBackgroundColor());
            }
        });
    }

    public void setReferenceItems(ListModel<ChatReferenceItem> referenceItems) {
        if (this.list == null) {
            return;
        }
        this.list.setModel(referenceItems);
        this.titleLabel.setText(CosyBundle.message("chat.workspace.used.reference.text", new Object[0]) + " \u00b7 " + referenceItems.getSize());
    }

    static class ChartReferenceItemPanel
    extends JPanel {
        private static final int FIXED_HEIGHT = 22;
        JLabel fileNameLabel;
        JLabel rangeLabel;
        JLabel dirPathLabel;
        JPanel leftPanel;
        private Project project;

        public ChartReferenceItemPanel(Project project) {
            super(new BorderLayout());
            this.project = project;
            this.leftPanel = new JPanel();
            this.leftPanel.setOpaque(false);
            this.leftPanel.setLayout(new BoxLayout(this.leftPanel, 0));
            this.fileNameLabel = new JLabel("", null, 2);
            this.fileNameLabel.setFont(this.fileNameLabel.getFont().deriveFont(13.0f));
            this.rangeLabel = new JLabel();
            this.rangeLabel.setFont(this.fileNameLabel.getFont().deriveFont(12.0f));
            this.rangeLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            this.leftPanel.add(this.fileNameLabel);
            this.leftPanel.add(Box.createHorizontalStrut(8));
            this.leftPanel.add(this.rangeLabel);
            this.dirPathLabel = new JLabel();
            this.dirPathLabel.setHorizontalAlignment(4);
            this.dirPathLabel.setFont(this.dirPathLabel.getFont().deriveFont(12.0f));
            this.dirPathLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            Box box = Box.createHorizontalBox();
            box.add(this.leftPanel);
            box.add(Box.createHorizontalGlue());
            box.add(this.dirPathLabel);
            this.add((Component)box, "Center");
            this.setBorder((Border)JBUI.Borders.empty((int)0, (int)12));
        }

        public void setData(JList<? extends ChatReferenceItem> list, ChatReferenceItem item, boolean isSelected) {
            String fileName = item.getFileName();
            if (fileName.length() > 25) {
                fileName = StringUtils.truncateMiddle(fileName, 25);
            }
            this.fileNameLabel.setText(fileName);
            this.fileNameLabel.setIcon(item.getIcon());
            this.fileNameLabel.setIconTextGap(8);
            if (item.getStartLine() != null && item.getEndLine() != null) {
                if (item.getStartLine().equals(item.getEndLine())) {
                    this.rangeLabel.setText(item.getStartLine().toString());
                } else {
                    this.rangeLabel.setText(item.getStartLine() + "-" + item.getEndLine());
                }
            }
            File file = new File(item.getFilePath());
            String dirPath = file.getParent();
            String projectBasePath = ProjectUtils.getProjectBaseDir(this.project);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)projectBasePath) && dirPath.startsWith(projectBasePath)) {
                dirPath = dirPath.substring(projectBasePath.length());
                dirPath = org.apache.commons.lang3.StringUtils.stripStart((String)dirPath, (String)File.separator);
            }
            Dimension panelSize = list.getSize();
            if (panelSize.width > 0) {
                int maxWidth = panelSize.width - 24;
                maxWidth = maxWidth - this.leftPanel.getPreferredSize().width - 16;
                dirPath = FontUtil.getStringAdaptiveWidth(this.dirPathLabel, dirPath, maxWidth, true);
            }
            this.dirPathLabel.setText(dirPath);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
            } else {
                this.setBackground(list.getBackground());
            }
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            return new Dimension(dim.width, 22);
        }
    }
}

