/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component;

import com.alibabacloud.intellij.cosy.common.CosyConfig;
import com.alibabacloud.intellij.cosy.ui.search.I18NConstant;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.CosyKeymapUtil;
import com.alibabacloud.intellij.cosy.util.FontUtil;
import com.alibabacloud.intellij.cosy.util.RenderUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import icons.LingmaIcons;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import lombok.Generated;

public class WelcomeBgPanel
extends JPanel {
    private static final int SHORTCUT_SIZE = 22;
    private static final int SHORTCUT_CHAR_MARGIN = 10;
    private static final int SHORTCUT_ROW_MARGIN = 32;
    private static final int RENDER_START_Y_OFFSET = 123;
    ImageIcon darkIconImage;
    ImageIcon lightIconImage;
    Font textAreaFont;
    Font textAreaLargeFont;
    JPanel paintPanel;
    JTextArea textArea = new JTextArea("\u667a\u80fd\u52a9\u624b/AI assistant chat");
    FontMetrics metrics;
    FontMetrics largeMetrics;
    String[] chatShortcut;
    String[] searchShortcut;
    String chatText;
    String searchText;
    String titleText;
    boolean showTooltips = true;

    public WelcomeBgPanel() {
        this.textAreaFont = JBUI.Fonts.label().deriveFont(14.0f);
        this.textAreaLargeFont = JBUI.Fonts.label().deriveFont(20.0f);
        this.metrics = FontUtil.fontMetrics(this.textArea, this.textAreaFont);
        this.largeMetrics = FontUtil.fontMetrics(this.textArea, this.textAreaLargeFont);
        this.chatShortcut = this.getShortcutTexts("TriggerCosySelectionChatAction");
        if (CosyConfig.IDE_NAME.contains("IDEA")) {
            this.searchShortcut = this.getShortcutTexts("CosyCodeSearchAction");
        }
        this.chatText = CosyBundle.message("main.backgroud.toolips.text.chat", new Object[0]);
        this.searchText = CosyBundle.message("main.backgroud.toolips.text.search", new Object[0]);
        this.titleText = I18NConstant.COSY_PLUGIN_NAME;
    }

    @Override
    public void scrollRectToVisible(Rectangle aRect) {
    }

    private String[] getShortcutTexts(String actionId) {
        List<String> shortcutTexts = CosyKeymapUtil.getShortcutTextList(actionId);
        if (shortcutTexts == null || shortcutTexts.isEmpty()) {
            return null;
        }
        return shortcutTexts.toArray(new String[0]);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.showTooltips) {
            return;
        }
        GraphicsUtil.setupFractionalMetrics((Graphics)g);
        GraphicsUtil.setupAntialiasing((Graphics)g);
        g.setColor(ColorUtil.getInactiveForegroundColor());
        g.setFont(this.textAreaFont);
        Dimension size = this.getSize();
        int yOffset = 123;
        g.setFont(this.textAreaLargeFont);
        LingmaIcons.TongyiPanelTipsIcon.paintIcon(this, g, (size.width - LingmaIcons.TongyiPanelTipsIcon.getIconWidth()) / 2, yOffset);
        Rectangle2D titleRect = this.largeMetrics.getStringBounds(this.titleText, g);
        g.drawString(this.titleText, (int)(((double)size.width - titleRect.getWidth()) / 2.0), yOffset += LingmaIcons.TongyiPanelTipsIcon.getIconHeight() + 32);
        yOffset += 18;
        g.setFont(this.textAreaFont);
        Rectangle chatRect = this.calculateShortcutRect(g, this.chatText, this.chatShortcut);
        Rectangle searchRect = this.searchShortcut == null ? chatRect : this.calculateShortcutRect(g, this.chatText, this.searchShortcut);
        Rectangle2D chatTextRect = this.metrics.getStringBounds(this.chatText, g);
        Rectangle2D searchTextRect = this.metrics.getStringBounds(this.searchText, g);
        int xOffset = (int)(((double)size.width - Math.max(chatRect.getWidth(), searchRect.getWidth())) / 2.0);
        if (this.chatShortcut != null) {
            this.drawShortcut(g, xOffset, yOffset, this.chatText, this.chatShortcut);
        }
        if (this.searchShortcut != null) {
            this.drawShortcut(g, xOffset + ((int)chatTextRect.getWidth() - (int)searchTextRect.getWidth()), yOffset + 32, this.searchText, this.searchShortcut);
        }
    }

    private Rectangle calculateShortcutRect(Graphics g, String text, String[] shortcut) {
        Rectangle2D textRect = this.metrics.getStringBounds(text, g);
        int totalWidth = (int)textRect.getWidth();
        if (shortcut != null) {
            for (int i = 0; i < shortcut.length; ++i) {
                String shortcutKey = shortcut[i];
                if (shortcutKey.length() == 1) {
                    totalWidth += 32;
                    continue;
                }
                Rectangle2D shortcutRect = this.metrics.getStringBounds(shortcutKey, g);
                totalWidth += (int)shortcutRect.getWidth() + 10;
            }
        }
        int totalHeight = Math.max((int)textRect.getHeight(), 22);
        return new Rectangle(0, 0, totalWidth, totalHeight);
    }

    private Rectangle drawShortcut(Graphics g, int xOffset, int yOffset, String title, String[] shortcut) {
        Rectangle2D textRect = RenderUtil.drawText(g, this.metrics, title, xOffset, yOffset);
        int totalWidth = (int)textRect.getWidth();
        int textWidth = (int)textRect.getWidth();
        int textX = xOffset + textWidth;
        for (int i = 0; i < shortcut.length; ++i) {
            String shortcutKey = shortcut[i];
            g.setColor(ColorUtil.getListHoverBackground());
            int shortcutWidth = 22;
            if (shortcutKey.length() > 1) {
                Rectangle2D shortcutRect = this.metrics.getStringBounds(shortcutKey, g);
                shortcutWidth = (int)shortcutRect.getWidth() + 8;
            }
            g.fillRoundRect(textX += 10, yOffset, shortcutWidth, 22, 8, 8);
            g.setColor(ColorUtil.getInactiveForegroundColor());
            Rectangle2D shortcutKeyRect = this.metrics.getStringBounds(shortcutKey, g);
            int offsetWidth = (int)(((double)shortcutWidth - shortcutKeyRect.getWidth()) / 2.0);
            int offsetHeight = (int)((22.0 - shortcutKeyRect.getHeight()) / 2.0);
            g.drawString(shortcutKey, textX + offsetWidth, yOffset + offsetHeight + (int)shortcutKeyRect.getHeight() - 2);
            totalWidth += shortcutWidth + 10;
            textX += shortcutWidth;
        }
        int totalHeight = Math.max((int)textRect.getHeight(), 22);
        return new Rectangle(xOffset, yOffset, totalWidth, totalHeight);
    }

    public void updateThemeSchema() {
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public void setShowTooltips(boolean showTooltips) {
        this.showTooltips = showTooltips;
        this.invalidate();
        this.validate();
        this.repaint();
    }

    @Generated
    public boolean isShowTooltips() {
        return this.showTooltips;
    }
}

