/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component;

import com.alibabacloud.intellij.cosy.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.markdown.WrappedHtmlEditorKit;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.SwingUtil;
import com.alibabacloud.intellij.cosy.util.ThemeUtil;
import com.alibabacloud.intellij.cosy.util.UrlUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.JBUI;
import icons.LingmaIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class SystemMessageCard
extends RoundRectPanel {
    private static final Logger LOGGER = Logger.getInstance(SystemMessageCard.class);
    JPanel headerPanel;
    JLabel titleLabel;
    JTextPane contentPane;
    private Font originalFont;
    private Color originalColor;
    private Project project;
    private String originalText;

    public SystemMessageCard(final Project project, String text) {
        this.setLayout(new BorderLayout());
        this.project = project;
        this.originalText = text;
        this.setBorder((Border)JBUI.Borders.empty((int)0, (int)12, (int)12, (int)12));
        this.headerPanel = new JPanel();
        this.headerPanel.setLayout(new BorderLayout());
        this.headerPanel.setPreferredSize(new Dimension(-1, 40));
        this.titleLabel = new JLabel(CosyBundle.message("cosy.plugin.name", new Object[0]), LingmaIcons.Logo20Icon, 10);
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1, 14.0f));
        this.headerPanel.add((Component)this.titleLabel, "West");
        this.add((Component)this.headerPanel, "North");
        this.contentPane = new JTextPane();
        this.contentPane.setEditable(false);
        this.contentPane.setBorder((Border)JBUI.Borders.empty());
        this.contentPane.setCursor(Cursor.getPredefinedCursor(2));
        this.contentPane.setFont(this.contentPane.getFont().deriveFont(13.0f));
        this.originalFont = this.contentPane.getFont();
        this.originalColor = ColorUtil.getTextPaneForegroundColor();
        this.contentPane.setEditorKit(new WrappedHtmlEditorKit());
        this.contentPane.setText(this.buildText(text));
        this.contentPane.setOpaque(false);
        this.contentPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    UrlUtil.performHyperlink(project, e, SystemMessageCard.this);
                }
            }
        });
        this.add((Component)this.contentPane, "Center");
        SwingUtil.foreachChildComponent(this, cp -> {
            if (cp instanceof JPanel) {
                Color color = ColorUtil.getChatCardBackgroundColor();
                cp.setBackground(color);
            }
        });
    }

    @Override
    public void refreshColor(EditorColorsScheme scheme, Color themeColor) {
        this.originalColor = ColorUtil.getTextPaneForegroundColor();
        this.contentPane.setText(this.buildText(this.originalText));
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    private String buildText(String text) {
        return ThemeUtil.getMarkdownContent(this.originalColor, this.originalFont, text);
    }
}

