/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component;

import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.util.FileUtil;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestPanel;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffEditableWindow
extends DialogWrapper {
    DiffContent afterChangeContent;
    VirtualFile afterFile;
    Project project;
    VirtualFile beforeFile;
    String targetContent;
    Collection<DiffButtonAction> actions;

    public DiffEditableWindow(@NotNull Project project, VirtualFile beforeFile, String targetContent, List<DiffButtonAction> actions) {
        if (project == null) {
            DiffEditableWindow.$$$reportNull$$$0(0);
        }
        super(project, true);
        this.project = project;
        this.targetContent = targetContent;
        this.beforeFile = beforeFile;
        this.actions = actions;
        this.init();
    }

    @NotNull
    protected @NotNull Action @NotNull [] createActions() {
        ArrayList<DiffButtonAction> list = new ArrayList<DiffButtonAction>();
        if (this.actions != null && !this.actions.isEmpty()) {
            for (DiffButtonAction action : this.actions) {
                action.setWindow(this);
                list.add(action);
            }
        }
        Action[] actionArray = list.toArray(new Action[0]);
        if (actionArray == null) {
            DiffEditableWindow.$$$reportNull$$$0(1);
        }
        return actionArray;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        FileEditorManager.getInstance((Project)this.project).openFile(this.beforeFile, true, true);
        DiffContentFactory diffContentFactory = DiffContentFactory.getInstance();
        LanguageFileType fileType = null;
        if (StringUtils.isNotBlank((CharSequence)this.beforeFile.getExtension())) {
            fileType = FileTypeRegistry.getInstance().getFileTypeByExtension(this.beforeFile.getExtension());
        }
        if (fileType == null || fileType instanceof UnknownFileType) {
            fileType = FileTypes.PLAIN_TEXT;
        }
        this.afterFile = FileUtil.buildVirtualFile("temp", (FileType)fileType, this.targetContent, true);
        DiffContent beforeChangeContent = diffContentFactory.create(this.project, this.beforeFile);
        this.afterChangeContent = diffContentFactory.create(this.project, this.afterFile);
        beforeChangeContent.putUserData(DiffUserDataKeys.FORCE_READ_ONLY, (Object)true);
        this.afterChangeContent.putUserData(DiffUserDataKeys.FORCE_READ_ONLY, (Object)false);
        SimpleDiffRequest diffRequest = new SimpleDiffRequest(CosyBundle.message("chat.diffview.label.title", new Object[0]), beforeChangeContent, this.afterChangeContent, CosyBundle.message("chat.diffview.diff.before.title", new Object[0]), CosyBundle.message("chat.diffview.diff.after.title", new Object[0]));
        JPanel bottomPanel = new JPanel(new BorderLayout());
        DiffRequestPanel diffRequestPanel = DiffManager.getInstance().createRequestPanel(this.project, Disposer.newDisposable(), null);
        diffRequestPanel.setRequest((DiffRequest)diffRequest);
        diffRequestPanel.putContextHints(DiffUserDataKeysEx.BOTTOM_PANEL, (Object)bottomPanel);
        return diffRequestPanel.getComponent();
    }

    public String getContent() {
        if (this.afterChangeContent instanceof DocumentContent) {
            DocumentContent content = (DocumentContent)this.afterChangeContent;
            return content.getDocument().getText();
        }
        return this.targetContent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/alibabacloud/intellij/cosy/ui/search/component/DiffEditableWindow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/alibabacloud/intellij/cosy/ui/search/component/DiffEditableWindow";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class DiffButtonAction
    extends AbstractAction {
        DiffEditableWindow window;

        public DiffButtonAction() {
        }

        public DiffButtonAction(String name) {
            super(name);
        }

        public DiffButtonAction(String name, Icon icon) {
            super(name, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.doAction();
            if (this.window != null) {
                this.window.close(0);
            }
        }

        public abstract void doAction();

        public DiffEditableWindow getWindow() {
            return this.window;
        }

        public void setWindow(DiffEditableWindow window) {
            this.window = window;
        }
    }

    public static class DiffCancelAction
    extends DiffButtonAction {
        public DiffCancelAction() {
        }

        public DiffCancelAction(String name) {
            super(name);
        }

        public DiffCancelAction(String name, Icon icon) {
            super(name, icon);
        }

        @Override
        public void doAction() {
        }
    }

    public static abstract class DiffAcceptAction
    extends DiffButtonAction {
        public DiffAcceptAction() {
        }

        public DiffAcceptAction(String name) {
            super(name);
        }

        public DiffAcceptAction(String name, Icon icon) {
            super(name, icon);
        }

        @Override
        public void doAction() {
            String content = this.window.getContent();
            this.doAccept(content);
        }

        public abstract void doAccept(String var1);
    }
}

