/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component;

import com.alibabacloud.intellij.cosy.search.asyn.Debouncer;
import com.alibabacloud.intellij.cosy.ui.search.color.CosyColor;
import com.alibabacloud.intellij.cosy.util.PopupUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;

public class DescriptionPopup {
    private static final Logger log = Logger.getInstance(DescriptionPopup.class);
    private static final int DESC_POPUP_WIDTH = 280;
    private static final int OFFSET = 10;
    private static final int DESC_POPUP_X_OFFSET = 290;
    private static final long POPUP_DELAY_MILLIS = 200L;
    private static final String KEYWORD_HIGHLIGHT_COLOR = "#" + ColorUtil.toHex((Color)CosyColor.TEXT_HIGHLIGHT_COLOR);
    private static final String HIGHLIGHT_CSS_STYLE = "em { color: " + KEYWORD_HIGHLIGHT_COLOR + "; }";
    private static List<String> externalStyleRules = Arrays.asList(HIGHLIGHT_CSS_STYLE, "p { font-size: 13pt; }", "div { font-size: 13pt; }", "td { font-size: 13pt; }", "body { font-size: 13pt; }", "code { font-size: 13pt; }", "a { font-size: 13pt; }");
    JBPopup descPopup;
    JComponent currentTargetPanel;
    Debouncer debouncer = new Debouncer();

    public synchronized void createPopup(JComponent targetPanel, String content) {
        if (this.currentTargetPanel != null && this.currentTargetPanel != targetPanel && this.descPopup != null && (!this.descPopup.isDisposed() || this.descPopup.isVisible())) {
            this.descPopup.cancel();
            this.descPopup.dispose();
            this.descPopup = null;
        }
        if (this.descPopup == null || this.descPopup.isDisposed() || !this.descPopup.isVisible()) {
            this.debouncer.debounce(() -> ApplicationManager.getApplication().invokeLater(() -> {
                if (this.descPopup != null) {
                    this.descPopup.cancel();
                }
                if (targetPanel.isValid() && targetPanel.isShowing()) {
                    try {
                        this.descPopup = PopupUtil.createDescriptionPopup(content, 280, externalStyleRules, new MouseAdapter(){

                            @Override
                            public void mouseExited(MouseEvent e) {
                                if (DescriptionPopup.this.descPopup != null) {
                                    DescriptionPopup.this.descPopup.cancel();
                                    DescriptionPopup.this.descPopup = null;
                                }
                            }
                        });
                        Point point = targetPanel.getLocationOnScreen();
                        this.descPopup.showInScreenCoordinates((Component)targetPanel, new Point(point.x - 290, point.y));
                        this.currentTargetPanel = targetPanel;
                    }
                    catch (Exception e) {
                        log.warn("fail to popup description, Cause " + e.getMessage());
                    }
                }
            }), 200L, TimeUnit.MILLISECONDS);
        }
    }

    public synchronized void tryClosePopup(JComponent targetPanel, Point mousePoint) {
        if (this.descPopup != null && (!this.descPopup.isDisposed() || this.descPopup.isVisible())) {
            Point point = targetPanel.getLocationOnScreen();
            Rectangle bounds = new Rectangle(point.x - 10, point.y, targetPanel.getSize().width + 10, targetPanel.getSize().height);
            Point popupPoint = this.descPopup.getLocationOnScreen();
            Rectangle popBounds = new Rectangle(popupPoint.x, popupPoint.y, this.descPopup.getSize().width + 10, this.descPopup.getSize().height);
            if (!bounds.contains(mousePoint) && !popBounds.contains(mousePoint)) {
                this.descPopup.cancel();
                this.descPopup.dispose();
                this.descPopup = null;
            }
        }
    }

    public void closePopup() {
        if (this.descPopup != null && (!this.descPopup.isDisposed() || this.descPopup.isVisible())) {
            this.descPopup.cancel();
            this.descPopup.dispose();
            this.descPopup = null;
        }
    }
}

