/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component;

import com.intellij.ui.JBColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.basic.BasicSliderUI;

public class CosySliderUI
extends BasicSliderUI {
    private static final BasicStroke LINE_STROKE = new BasicStroke(1.0f, 1, 1);
    private static final Color LINE_COLOR = new JBColor(new Color(5197649), new Color(0x69696B));
    private static final Color THUMB_COLOR = new JBColor(new Color(16754746), new Color(16754746));

    public CosySliderUI(JSlider b) {
        super(b);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paint(g, c);
    }

    @Override
    protected Dimension getThumbSize() {
        return new Dimension(12, 16);
    }

    @Override
    public void paintTrack(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Stroke old = g2d.getStroke();
        g2d.setStroke(LINE_STROKE);
        g2d.setPaint(LINE_COLOR);
        if (this.slider.getOrientation() == 0) {
            g2d.drawLine(this.trackRect.x, this.trackRect.y + this.trackRect.height / 2, this.trackRect.x + this.trackRect.width, this.trackRect.y + this.trackRect.height / 2);
        } else {
            g2d.drawLine(this.trackRect.x + this.trackRect.width / 2, this.trackRect.y, this.trackRect.x + this.trackRect.width / 2, this.trackRect.y + this.trackRect.height);
        }
        g2d.setStroke(old);
    }

    @Override
    public void paintThumb(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        int x1 = this.thumbRect.x + 2;
        int x2 = this.thumbRect.x + this.thumbRect.width - 2;
        int width = this.thumbRect.width - 4;
        int topY = this.thumbRect.y + this.thumbRect.height / 2 - this.thumbRect.width / 3;
        GeneralPath shape = new GeneralPath(0);
        shape.moveTo(x1, topY);
        shape.lineTo(x2, topY);
        shape.lineTo((x1 + x2) / 2, topY + width);
        shape.closePath();
        g2d.setPaint(THUMB_COLOR);
        g2d.fill(shape);
        Stroke old = g2d.getStroke();
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.setPaint(THUMB_COLOR);
        g2d.draw(shape);
        g2d.setStroke(old);
    }
}

